/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video;

import com.igormaznitsa.zxpoly.components.video.VirtualKeyboardRender;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import javax.imageio.ImageIO;

public final class VirtualKeyboardDecoration {
    private static final String PATH = "/com/igormaznitsa/zxpoly/keyboard/";
    private final BufferedImage keyBoardImage;
    private final Rectangle[] keyCoords;
    private final String id;

    VirtualKeyboardDecoration(String id) throws IOException {
        this.id = id;
        Properties properties = new Properties();
        String propertiesResource = PATH + id + ".properties";
        try (InputStream stream = Objects.requireNonNull(VirtualKeyboardDecoration.class.getResourceAsStream(propertiesResource), "Can't find " + propertiesResource);){
            properties.load(stream);
        }
        String imageResource = PATH + Objects.requireNonNull(properties.getProperty("image"), "Can't find image property in " + propertiesResource);
        try (InputStream imageIn = Objects.requireNonNull(VirtualKeyboardRender.class.getResourceAsStream(imageResource), "Can't find " + imageResource);){
            this.keyBoardImage = ImageIO.read(imageIn);
        }
        this.keyCoords = new Rectangle[64];
        this.keyCoords[0] = VirtualKeyboardDecoration.find("key.CS", properties);
        this.keyCoords[1] = VirtualKeyboardDecoration.find("key.Z", properties);
        this.keyCoords[2] = VirtualKeyboardDecoration.find("key.X", properties);
        this.keyCoords[3] = VirtualKeyboardDecoration.find("key.C", properties);
        this.keyCoords[4] = VirtualKeyboardDecoration.find("key.V", properties);
        this.keyCoords[8] = VirtualKeyboardDecoration.find("key.A", properties);
        this.keyCoords[9] = VirtualKeyboardDecoration.find("key.S", properties);
        this.keyCoords[10] = VirtualKeyboardDecoration.find("key.D", properties);
        this.keyCoords[11] = VirtualKeyboardDecoration.find("key.F", properties);
        this.keyCoords[12] = VirtualKeyboardDecoration.find("key.G", properties);
        this.keyCoords[16] = VirtualKeyboardDecoration.find("key.Q", properties);
        this.keyCoords[17] = VirtualKeyboardDecoration.find("key.W", properties);
        this.keyCoords[18] = VirtualKeyboardDecoration.find("key.E", properties);
        this.keyCoords[19] = VirtualKeyboardDecoration.find("key.R", properties);
        this.keyCoords[20] = VirtualKeyboardDecoration.find("key.T", properties);
        this.keyCoords[24] = VirtualKeyboardDecoration.find("key.1", properties);
        this.keyCoords[25] = VirtualKeyboardDecoration.find("key.2", properties);
        this.keyCoords[26] = VirtualKeyboardDecoration.find("key.3", properties);
        this.keyCoords[27] = VirtualKeyboardDecoration.find("key.4", properties);
        this.keyCoords[28] = VirtualKeyboardDecoration.find("key.5", properties);
        this.keyCoords[32] = VirtualKeyboardDecoration.find("key.0", properties);
        this.keyCoords[33] = VirtualKeyboardDecoration.find("key.9", properties);
        this.keyCoords[34] = VirtualKeyboardDecoration.find("key.8", properties);
        this.keyCoords[35] = VirtualKeyboardDecoration.find("key.7", properties);
        this.keyCoords[36] = VirtualKeyboardDecoration.find("key.6", properties);
        this.keyCoords[40] = VirtualKeyboardDecoration.find("key.P", properties);
        this.keyCoords[41] = VirtualKeyboardDecoration.find("key.O", properties);
        this.keyCoords[42] = VirtualKeyboardDecoration.find("key.I", properties);
        this.keyCoords[43] = VirtualKeyboardDecoration.find("key.U", properties);
        this.keyCoords[44] = VirtualKeyboardDecoration.find("key.Y", properties);
        this.keyCoords[48] = VirtualKeyboardDecoration.find("key.EN", properties);
        this.keyCoords[49] = VirtualKeyboardDecoration.find("key.L", properties);
        this.keyCoords[50] = VirtualKeyboardDecoration.find("key.K", properties);
        this.keyCoords[51] = VirtualKeyboardDecoration.find("key.J", properties);
        this.keyCoords[52] = VirtualKeyboardDecoration.find("key.H", properties);
        this.keyCoords[56] = VirtualKeyboardDecoration.find("key.SP", properties);
        this.keyCoords[57] = VirtualKeyboardDecoration.find("key.SS", properties);
        this.keyCoords[58] = VirtualKeyboardDecoration.find("key.M", properties);
        this.keyCoords[59] = VirtualKeyboardDecoration.find("key.N", properties);
        this.keyCoords[60] = VirtualKeyboardDecoration.find("key.B", properties);
        Rectangle zero = new Rectangle(0, 0, 0, 0);
        for (int i = 0; i < this.keyCoords.length; ++i) {
            if (this.keyCoords[i] != null) continue;
            this.keyCoords[i] = zero;
        }
    }

    private static Rectangle find(String key, Properties properties) {
        String coords = Objects.requireNonNull(properties.getProperty(key), "Can't find key: " + key);
        String[] splitted = coords.split("\\,");
        if (splitted.length != 4) {
            throw new IllegalArgumentException("Wrong '" + key + "' key coordinates: " + coords);
        }
        try {
            return new Rectangle(Integer.parseInt(splitted[0].trim()), Integer.parseInt(splitted[1].trim()), Integer.parseInt(splitted[2].trim()), Integer.parseInt(splitted[3].trim()));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Wrong number in key '" + key + "' coordinates: " + coords);
        }
    }

    public String getId() {
        return this.id;
    }

    public int findPressedKeyBits(Point point) {
        for (int i = 0; i < this.keyCoords.length; ++i) {
            if (!this.keyCoords[i].contains(point)) continue;
            return i;
        }
        return -1;
    }

    public int getWidth() {
        return this.keyBoardImage.getWidth();
    }

    public int getHeight() {
        return this.keyBoardImage.getHeight();
    }

    public BufferedImage getImage() {
        return this.keyBoardImage;
    }

    public Rectangle getKeyRectangleForBitIndex(int bitIndex) {
        return this.keyCoords[bitIndex];
    }
}

