/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video.tvfilters;

import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilter;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilterAmberCrt;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilterBlackWhite;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilterGaussian;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilterGrayscale;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilterGreenCrt;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilterOldTv;
import java.awt.Color;
import java.util.stream.Stream;

public enum TvFilterChain {
    NONE("None", new TvFilter[0]),
    GRAYSCALE("Grayscale", new TvFilter[]{TvFilterGrayscale.getInstance()}),
    BLACKWHITE("Black & White", new TvFilter[]{TvFilterBlackWhite.getInstance()}),
    OLDTV("Old TV Color", new TvFilter[]{TvFilterOldTv.getInstance()}),
    AMBERCRT("Old TV Amber", new TvFilter[]{TvFilterAmberCrt.getInstance()}),
    GREENCRT("Old TV Green", new TvFilter[]{TvFilterGreenCrt.getInstance()}),
    GAUSSIAN_BLUR("Gaussian blur", new TvFilter[]{TvFilterGaussian.getInstance()});

    private final String text;
    private final TvFilter[] filterChain;

    private TvFilterChain(String text, TvFilter[] chain) {
        this.text = text;
        this.filterChain = chain;
    }

    public String getText() {
        return this.text;
    }

    public boolean isEmpty() {
        return this.filterChain.length == 0;
    }

    public Color applyBorderColor(Color borderColor) {
        if (this.filterChain.length == 0) {
            return borderColor;
        }
        Color result = borderColor;
        for (TvFilter f : this.filterChain) {
            result = f.applyBorderColor(result);
        }
        return result;
    }

    public boolean isGifCompatible() {
        return Stream.of(this.filterChain).allMatch(TvFilter::isGifCompatible);
    }

    public TvFilter[] getFilterChain() {
        return this.filterChain;
    }

    public int[] findPalette() {
        int[] result = null;
        for (TvFilter f : this.filterChain) {
            result = f.makePalette();
        }
        return result == null ? VideoController.PALETTE_SPEC256 : result;
    }
}

