/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video.tvfilters;

import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;

public class TvFilterOldTv
implements TvFilter {
    private static final TvFilterOldTv INSTANCE = new TvFilterOldTv();

    TvFilterOldTv() {
    }

    private static int rgb2y(int r, int g, int b) {
        return 2449 * r + 4809 * g + 934 * b + 1024 >> 11;
    }

    private static int rgb2u(int r, int g, int b) {
        return 4096 * b - 1383 * r - 2713 * g + 1024 >> 11;
    }

    private static int rgb2v(int r, int g, int b) {
        return 4096 * r - 3430 * g - 666 * b + 1024 >> 11;
    }

    private static int yuv2rgb(int y, int u, int v) {
        int r = Math.min(255, Math.abs(8192 * y + 11485 * v + 16384) >> 15);
        int g = Math.min(255, Math.abs(8192 * y - 2819 * u - 5850 * v + 16384) >> 15);
        int b = Math.min(255, Math.abs(8192 * y + 14516 * u + 16384) >> 15);
        return r << 16 | g << 8 | b;
    }

    public static TvFilterOldTv getInstance() {
        return INSTANCE;
    }

    @Override
    public BufferedImage apply(BufferedImage srcImageArgb512x384, float zoom, int argbBorder, boolean firstInChain) {
        int[] argbBuffer;
        BufferedImage image;
        if (firstInChain) {
            image = SHARED_BUFFER;
            argbBuffer = SHARED_BUFFER_RASTER;
            System.arraycopy(((DataBufferInt)srcImageArgb512x384.getRaster().getDataBuffer()).getData(), 0, argbBuffer, 0, argbBuffer.length);
        } else {
            image = srcImageArgb512x384;
            argbBuffer = ((DataBufferInt)srcImageArgb512x384.getRaster().getDataBuffer()).getData();
        }
        int brdrR = argbBorder >> 16 & 0xFF;
        int brdrG = argbBorder >> 8 & 0xFF;
        int brdrB = argbBorder & 0xFF;
        int borderY = TvFilterOldTv.rgb2y(brdrR, brdrG, brdrB);
        int borderU = TvFilterOldTv.rgb2u(brdrR, brdrG, brdrB);
        int borderV = TvFilterOldTv.rgb2v(brdrR, brdrG, brdrB);
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            int pu = borderU;
            int pv = borderV;
            int py = borderY;
            boolean yodd = (y & 1) != 0;
            for (int x = 0; x < width; ++x) {
                boolean xodd = (x & 1) != 0;
                int pos = offset + x;
                int argb = argbBuffer[pos];
                int r = argb >>> 16 & 0xFF;
                int g = argb >>> 8 & 0xFF;
                int b = argb & 0xFF;
                int yc = TvFilterOldTv.rgb2y(r, g, b);
                int uc = TvFilterOldTv.rgb2u(r, g, b);
                int vc = TvFilterOldTv.rgb2v(r, g, b);
                if (yodd) {
                    yc = Math.round(0.87f * (float)yc);
                }
                yc = (yc + py) / 2;
                int resultRgb = xodd ? TvFilterOldTv.yuv2rgb(yc, (pu + uc) / 2, (pv + vc) / 2) : TvFilterOldTv.yuv2rgb(yc, uc, vc);
                pu = (pu + uc * 2) / 3;
                pv = (pv + vc * 2) / 3;
                py = yc;
                argbBuffer[pos] = resultRgb | argb & 0xFF000000;
            }
        }
        return image;
    }

    @Override
    public byte[] apply(boolean forceCopy, byte[] rgbArray512x384, int argbBorder) {
        byte[] rgbBuffer = forceCopy ? Arrays.copyOf(rgbArray512x384, rgbArray512x384.length) : rgbArray512x384;
        int brdrR = argbBorder >> 16 & 0xFF;
        int brdrG = argbBorder >> 8 & 0xFF;
        int brdrB = argbBorder & 0xFF;
        int borderY = TvFilterOldTv.rgb2y(brdrR, brdrG, brdrB);
        int borderU = TvFilterOldTv.rgb2u(brdrR, brdrG, brdrB);
        int borderV = TvFilterOldTv.rgb2v(brdrR, brdrG, brdrB);
        for (int y = 0; y < 384; ++y) {
            int offset = y * 512 * 3;
            int pu = borderU;
            int pv = borderV;
            int py = borderY;
            boolean yodd = (y & 1) != 0;
            for (int x = 0; x < 512; ++x) {
                boolean xodd = (x & 1) != 0;
                int pos = offset + x * 3;
                int r = rgbBuffer[pos] & 0xFF;
                int g = rgbBuffer[pos + 1] & 0xFF;
                int b = rgbBuffer[pos + 2] & 0xFF;
                int yc = TvFilterOldTv.rgb2y(r, g, b);
                int uc = TvFilterOldTv.rgb2u(r, g, b);
                int vc = TvFilterOldTv.rgb2v(r, g, b);
                if (yodd) {
                    yc = Math.round(0.87f * (float)yc);
                }
                yc = (yc + py) / 2;
                int resultRgb = xodd ? TvFilterOldTv.yuv2rgb(yc, (pu + uc) / 2, (pv + vc) / 2) : TvFilterOldTv.yuv2rgb(yc, uc, vc);
                pu = (pu + uc * 2) / 3;
                pv = (pv + vc * 2) / 3;
                py = yc;
                rgbBuffer[pos] = (byte)(resultRgb >> 16);
                rgbBuffer[pos + 1] = (byte)(resultRgb >> 8);
                rgbBuffer[pos + 2] = (byte)resultRgb;
            }
        }
        return rgbBuffer;
    }
}

