/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.RomData;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.formats.Snapshot;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public class FormatPRom
extends Snapshot {
    @Override
    public void loadFromArray(File srcFile, Motherboard board, VideoController vc, byte[] array) throws IOException {
        byte[] data;
        if (srcFile.length() > 262144L) {
            throw new IOException("Too big PROM file");
        }
        try (FileInputStream inputStream = new FileInputStream(srcFile);){
            data = IOUtils.readFully((InputStream)inputStream, (int)srcFile.length());
        }
        ArrayList<RomData> roms = new ArrayList<RomData>();
        for (int index = 0; index < 4 && index * 16384 < data.length; ++index) {
            int pos = index * 16384;
            byte[] portion = new byte[Math.min(16384, data.length - pos)];
            System.arraycopy(data, pos, portion, 0, portion.length);
            roms.add(new RomData(srcFile.getName() + "#" + index, portion));
            LOGGER.info("PROM part " + index + " length " + portion.length + " bytes");
        }
        for (int i = 0; i < 4; ++i) {
            RomData romData = (RomData)roms.get(i % roms.size());
            LOGGER.info("set PROM for module " + i + ": " + romData.getSource());
            board.getModules()[i].setRomData(romData);
        }
        board.setBoardMode(BoardMode.ZXPOLY, true);
    }

    @Override
    public boolean canMakeSnapshotForBoardMode(BoardMode mode) {
        return false;
    }

    @Override
    public String getExtension() {
        return "prom";
    }

    @Override
    public byte[] saveToArray(Motherboard board, VideoController vc) throws IOException {
        throw new IOException("Unsupported board mode: " + String.valueOf((Object)board.getBoardMode()));
    }

    @Override
    public String getName() {
        return "ZX-Poly ROM snapshot";
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".prom"));
    }

    @Override
    public String getDescription() {
        return "ZX-Poly ROM image (*.prom)";
    }
}

