/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.z80.Z80;
import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.formats.Snapshot;
import com.igormaznitsa.zxpoly.formats.ZXPParser;
import com.igormaznitsa.zxpoly.formats.ZxEmlSnapshotFormat;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class FormatZXP
extends Snapshot {
    @Override
    public String getExtension() {
        return "zxp";
    }

    @Override
    public boolean canMakeSnapshotForBoardMode(BoardMode mode) {
        return mode == BoardMode.ZXPOLY;
    }

    @Override
    public byte[] saveToArray(Motherboard board, VideoController vc) throws IOException {
        ZxEmlSnapshotFormat snapshot = new ZxEmlSnapshotFormat();
        for (int cpu = 0; cpu < 4; ++cpu) {
            ZxPolyModule module = board.getModules()[cpu];
            Z80 z80 = module.getCpu();
            snapshot.getREG_PC()[cpu] = (short)z80.getRegister(11);
            snapshot.getREG_SP()[cpu] = (short)z80.getRegister(10);
            snapshot.getREG_AF()[cpu] = (short)z80.getRegisterPair(0, false);
            snapshot.getREG_AF_ALT()[cpu] = (short)z80.getRegisterPair(0, true);
            snapshot.getREG_BC()[cpu] = (short)z80.getRegisterPair(2, false);
            snapshot.getREG_BC_ALT()[cpu] = (short)z80.getRegisterPair(2, true);
            snapshot.getREG_DE()[cpu] = (short)z80.getRegisterPair(4, false);
            snapshot.getREG_DE_ALT()[cpu] = (short)z80.getRegisterPair(4, true);
            snapshot.getREG_HL()[cpu] = (short)z80.getRegisterPair(6, false);
            snapshot.getREG_HL_ALT()[cpu] = (short)z80.getRegisterPair(6, true);
            snapshot.getREG_IX()[cpu] = (short)z80.getRegister(8);
            snapshot.getREG_IY()[cpu] = (short)z80.getRegister(9);
            snapshot.getREG_IR()[cpu] = (short)(z80.getRegister(12) << 8 | z80.getRegister(13));
            snapshot.getIFF()[cpu] = z80.isIFF1();
            snapshot.getIFF2()[cpu] = z80.isIFF2();
            snapshot.getREG_IM()[cpu] = (byte)z80.getIM();
            module.fillArrayByPortValues(snapshot.getModulePorts(cpu));
            ZXPParser.PAGES memory = snapshot.getPAGES()[cpu];
            for (ZXPParser.PAGES.PAGE p : memory.getPAGE()) {
                int pageOffset = p.getINDEX() * 16384;
                for (int addr = 0; addr < 16384; ++addr) {
                    p.getDATA()[addr] = (byte)module.readHeap(pageOffset + addr);
                }
            }
        }
        snapshot.setPORT3D00((char)board.get3D00());
        snapshot.setPORTFE((char)vc.getPortFE());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (JBBPBitOutputStream out = new JBBPBitOutputStream(bos);){
            snapshot.write(out);
        }
        return bos.toByteArray();
    }

    @Override
    public void loadFromArray(File srcFile, Motherboard board, VideoController vc, byte[] array) throws IOException {
        ZxEmlSnapshotFormat snapshot = new ZxEmlSnapshotFormat(array);
        this.doZxPoly(board);
        for (int cpu = 0; cpu < 4; ++cpu) {
            ZxPolyModule module = board.getModules()[cpu];
            Z80 z80 = module.getCpu();
            z80.setRegister(11, snapshot.getREG_PC()[cpu]);
            z80.setRegister(10, snapshot.getREG_SP()[cpu]);
            z80.setRegisterPair(0, snapshot.getREG_AF()[cpu], false);
            z80.setRegisterPair(0, snapshot.getREG_AF_ALT()[cpu], true);
            z80.setRegisterPair(2, snapshot.getREG_BC()[cpu], false);
            z80.setRegisterPair(2, snapshot.getREG_BC_ALT()[cpu], true);
            z80.setRegisterPair(4, snapshot.getREG_DE()[cpu], false);
            z80.setRegisterPair(4, snapshot.getREG_DE_ALT()[cpu], true);
            z80.setRegisterPair(6, snapshot.getREG_HL()[cpu], false);
            z80.setRegisterPair(6, snapshot.getREG_HL_ALT()[cpu], true);
            z80.setRegister(8, snapshot.getREG_IX()[cpu]);
            z80.setRegister(9, snapshot.getREG_IY()[cpu]);
            z80.setRegister(13, snapshot.getREG_IR()[cpu] & 0xFF);
            z80.setRegister(12, snapshot.getREG_IR()[cpu] >> 8 & 0xFF);
            z80.setIFF(snapshot.getIFF()[cpu], snapshot.getIFF2()[cpu]);
            z80.setIM(snapshot.getREG_IM()[cpu]);
            module.fillPortByValues(snapshot.getModulePorts(cpu)[0], snapshot.getModulePorts(cpu)[1], snapshot.getModulePorts(cpu)[2], snapshot.getModulePorts(cpu)[3], snapshot.getModulePorts(cpu)[4]);
            ZXPParser.PAGES memory = snapshot.getPAGES()[cpu];
            for (ZXPParser.PAGES.PAGE p : memory.getPAGE()) {
                module.writeHeapPage(p.getINDEX(), p.getDATA());
            }
        }
        board.set3D00(snapshot.getPORT3D00(), true);
        vc.setBorderColor(snapshot.getPORTFE() & 7);
    }

    @Override
    public String getName() {
        return "ZXPoly-Z80 snapshot";
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".zxp"));
    }

    @Override
    public String getDescription() {
        return "ZXPoly-Z80 Snapshot (*.zxp)";
    }
}

