/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.zxpoly.components.RomData;
import com.igormaznitsa.zxpoly.formats.SNAParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;

public class Spec256Arch {
    static final Pattern GFn_PATTERN = Pattern.compile("^.*\\.gf(x|[0-7])$");
    private static final int GFX_PAGE_SIZE = 131072;
    private static final Pattern ROM_ABC_PATTERN = Pattern.compile("^.*\\.gf([ab])$");
    private static final Pattern ROM_ROMNUM_PATTERN = Pattern.compile("^(?:.*/)?rom([01])\\.gfx$");
    private static final Pattern BKG_PATTERN = Pattern.compile("^.*\\.b([0-9]{2})$");
    private static final Pattern PALETTE_PATTERN = Pattern.compile("^.*\\.p(al|[0-9]{2})$");
    private static final Pattern SNA_NAME_PATTERN = Pattern.compile("([^/]*).sna$", 2);
    private final SNAParser parsedSna;
    private final byte[] xorData;
    private final List<Spec256GfxOrigPage> gfxRoms;
    private final List<Spec256GfxOrigPage> gfxRamPages;
    private final List<Spec256Bkg> backgrounds;
    private final List<Spec256Palette> palettes;
    private final Properties properties;
    private final boolean mode128;
    private final String sha256;
    private final String snaName;

    public Spec256Arch() {
        this.parsedSna = null;
        this.xorData = null;
        this.gfxRoms = null;
        this.gfxRamPages = null;
        this.backgrounds = null;
        this.palettes = null;
        this.properties = null;
        this.mode128 = false;
        this.sha256 = null;
        this.snaName = null;
    }

    public Spec256Arch(RomData romData, byte[] zipArchive) throws IOException {
        FoundSna foundSna = Spec256Arch.findSna(zipArchive);
        if (foundSna == null) {
            throw new IllegalArgumentException("Archive doesn't contain SNA file");
        }
        SNAParser parsedSna = foundSna.parsed;
        String parsedSnaName = foundSna.name;
        try (ZipFile zipFile = new ZipFile(new SeekableInMemoryByteChannel(zipArchive));){
            Enumeration<ZipArchiveEntry> iterator = zipFile.getEntries();
            ArrayList<Spec256Bkg> listBackgrounds = new ArrayList<Spec256Bkg>();
            ArrayList<Spec256Palette> listPalettes = new ArrayList<Spec256Palette>();
            ArrayList<Spec256GfxOrigPage> romPages = new ArrayList<Spec256GfxOrigPage>();
            ArrayList<Spec256GfxOrigPage> ramPages = new ArrayList<Spec256GfxOrigPage>();
            Properties properties = new Properties();
            byte[] xorData = null;
            byte[] foundGfxSnapshot = null;
            while (iterator.hasMoreElements()) {
                byte[] data;
                byte[] read;
                ZipArchiveEntry entry = iterator.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName().replace('\\', '/').toLowerCase(Locale.ENGLISH);
                if (name.endsWith(".xor")) {
                    xorData = Spec256Arch.readData(zipFile, entry);
                    continue;
                }
                if (name.endsWith(".cfg")) {
                    properties.load(new ByteArrayInputStream(Spec256Arch.readData(zipFile, entry)));
                    continue;
                }
                Matcher matcher = ROM_ABC_PATTERN.matcher(name);
                if (matcher.find()) {
                    int romPageIndex = Character.toLowerCase(matcher.group(1).charAt(0)) - 97;
                    read = Spec256Arch.readData(zipFile, entry);
                    if (read.length <= 0) continue;
                    romPages.add(new Spec256GfxOrigPage(romPageIndex, romData.makeCopyPage(romPageIndex), Arrays.copyOf(read, 131072)));
                    continue;
                }
                matcher = ROM_ROMNUM_PATTERN.matcher(name);
                if (matcher.find()) {
                    byte[] read2 = Spec256Arch.readData(zipFile, entry);
                    if (read2.length <= 0) continue;
                    int romPageIndex = switch (Integer.parseInt(matcher.group(1))) {
                        case 0 -> 1;
                        case 1 -> 0;
                        default -> throw new Error("Detected unexpected ROM page index: " + matcher.group(1));
                    };
                    romPages.add(new Spec256GfxOrigPage(romPageIndex, romData.makeCopyPage(romPageIndex), Arrays.copyOf(read2, 131072)));
                    continue;
                }
                matcher = GFn_PATTERN.matcher(name);
                if (matcher.find()) {
                    String suffix = matcher.group(1);
                    read = Spec256Arch.readData(zipFile, entry);
                    if ("x".equals(suffix)) {
                        if (read.length != 393216) {
                            throw new IOException("Unexpected size of GFX block: " + read.length);
                        }
                        foundGfxSnapshot = read;
                        continue;
                    }
                    if (read.length != 131072) {
                        throw new IOException("Unexpected size of GFn block: " + read.length);
                    }
                    int pageIndex = Integer.parseInt(suffix);
                    ramPages.add(new Spec256GfxOrigPage(pageIndex, Spec256Arch.findRam(pageIndex, parsedSna), read));
                    continue;
                }
                matcher = BKG_PATTERN.matcher(name);
                if (matcher.find()) {
                    int index = Integer.parseInt(matcher.group(1));
                    data = Spec256Arch.readData(zipFile, entry);
                    listBackgrounds.add(new Spec256Bkg(index, data, 320, 200));
                    continue;
                }
                matcher = PALETTE_PATTERN.matcher(name);
                if (!matcher.find()) continue;
                String suffix = matcher.group(1);
                data = Spec256Arch.readData(zipFile, entry);
                if ("al".equals(suffix)) {
                    listPalettes.add(-1, new Spec256Palette(-1, data));
                    continue;
                }
                int index = Integer.parseInt(suffix);
                listPalettes.add(index, new Spec256Palette(index, data));
            }
            if (parsedSna == null) {
                throw new IOException("Can't find SNA file in Spec256 archive");
            }
            if (foundGfxSnapshot == null) {
                throw new IOException("Can't find GFX file in Spec256 archive");
            }
            if (foundGfxSnapshot.length != 393216) {
                throw new IOException("Found GFX file has wrong size: " + foundGfxSnapshot.length);
            }
            this.sha256 = Spec256Arch.calcSha256(foundSna.fileBody, foundGfxSnapshot);
            this.snaName = parsedSnaName;
            this.parsedSna = parsedSna;
            this.properties = properties;
            this.palettes = Collections.unmodifiableList(listPalettes);
            this.backgrounds = Collections.unmodifiableList(listBackgrounds);
            this.xorData = xorData;
            this.mode128 = this.parsedSna.extendeddata != null;
            int topRamPageIndex = this.mode128 ? this.parsedSna.extendeddata.port7ffd & 7 : 0;
            byte[] gfxRam5 = Arrays.copyOfRange(foundGfxSnapshot, 0, 131072);
            byte[] gfxRam2 = Arrays.copyOfRange(foundGfxSnapshot, 131072, 262144);
            byte[] gfxRamTop = Arrays.copyOfRange(foundGfxSnapshot, 262144, 393216);
            if (ramPages.stream().noneMatch(x -> x.getPageIndex() == 5)) {
                ramPages.add(new Spec256GfxOrigPage(5, Spec256Arch.findRam(5, parsedSna), gfxRam5));
            }
            if (ramPages.stream().noneMatch(x -> x.getPageIndex() == 2)) {
                ramPages.add(new Spec256GfxOrigPage(2, Spec256Arch.findRam(2, parsedSna), gfxRam2));
            }
            if (ramPages.stream().noneMatch(x -> x.getPageIndex() == topRamPageIndex)) {
                ramPages.add(new Spec256GfxOrigPage(topRamPageIndex, Spec256Arch.findRam(topRamPageIndex, parsedSna), gfxRamTop));
            }
            this.gfxRamPages = Collections.unmodifiableList(ramPages);
            this.gfxRoms = Collections.unmodifiableList(romPages);
        }
    }

    private static String calcSha256(byte[] snaBody, byte[] gfxBody) {
        byte[] snaPlusGfx = new byte[snaBody.length + gfxBody.length];
        System.arraycopy(snaBody, 0, snaPlusGfx, 0, snaBody.length);
        System.arraycopy(gfxBody, 0, snaPlusGfx, snaBody.length, gfxBody.length);
        return DigestUtils.sha256Hex(snaPlusGfx);
    }

    private static FoundSna findSna(byte[] zipArchive) throws IOException {
        try (ZipFile zipFile = new ZipFile(new SeekableInMemoryByteChannel(zipArchive));){
            Enumeration<ZipArchiveEntry> iterator = zipFile.getEntries();
            while (iterator.hasMoreElements()) {
                ZipArchiveEntry entry = iterator.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName().replace('\\', '/').toLowerCase(Locale.ENGLISH);
                if (!name.endsWith(".sna")) continue;
                Matcher matcher = SNA_NAME_PATTERN.matcher(name);
                if (!matcher.find()) {
                    throw new IOException("Unexpected SNA name: " + name);
                }
                String parsedSnaName = matcher.group(1);
                byte[] snaFileBody = Spec256Arch.readData(zipFile, entry);
                FoundSna foundSna = new FoundSna(parsedSnaName, snaFileBody, new SNAParser().read(new JBBPBitInputStream(new ByteArrayInputStream(snaFileBody))));
                return foundSna;
            }
        }
        return null;
    }

    private static byte[] findRam(int pageIndex, SNAParser parsedSna) {
        if (pageIndex == 5) {
            return Arrays.copyOfRange(parsedSna.ramdump, 0, 16384);
        }
        if (pageIndex == 2) {
            return Arrays.copyOfRange(parsedSna.ramdump, 16384, 32768);
        }
        if (parsedSna.extendeddata == null) {
            if (pageIndex == 0) {
                return Arrays.copyOfRange(parsedSna.ramdump, 32768, 49152);
            }
            return new byte[16384];
        }
        int topPageIndex = parsedSna.extendeddata.port7ffd & 7;
        if (pageIndex == topPageIndex) {
            return Arrays.copyOfRange(parsedSna.ramdump, 32768, 49152);
        }
        int[] pages = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        pages[5] = -1;
        pages[2] = -1;
        pages[topPageIndex] = -1;
        int extraBankIndex = 0;
        for (int p : pages) {
            if (p < 0) continue;
            if (p == pageIndex) {
                return (byte[])parsedSna.extendeddata.extrabank[extraBankIndex].getDATA().clone();
            }
            ++extraBankIndex;
        }
        throw new IllegalArgumentException("Can't find page for index: " + pageIndex);
    }

    static byte[] readData(ZipFile file, ZipArchiveEntry entry) throws IOException {
        byte[] result = new byte[(int)entry.getSize()];
        int size = IOUtils.readFully(file.getInputStream(entry), result);
        if (size != result.length) {
            throw new IOException("Wrong read size: " + String.valueOf(entry));
        }
        return result;
    }

    public String getSnaName() {
        return this.snaName;
    }

    public String getSha256() {
        return this.sha256;
    }

    public SNAParser getParsedSna() {
        return this.parsedSna;
    }

    public byte[] getXorData() {
        return this.xorData;
    }

    public List<Spec256GfxOrigPage> getGfxRoms() {
        return this.gfxRoms;
    }

    public List<Spec256GfxOrigPage> getGfxRamPages() {
        return this.gfxRamPages;
    }

    public List<Spec256Bkg> getBackgrounds() {
        return this.backgrounds;
    }

    public List<Spec256Palette> getPalettes() {
        return this.palettes;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean is128() {
        return this.mode128;
    }

    public String toString() {
        return String.format("Spec256arch (%s,%s)", this.snaName, this.sha256);
    }

    private static class FoundSna {
        final String name;
        final byte[] fileBody;
        final SNAParser parsed;

        FoundSna(String name, byte[] fileBody, SNAParser parsed) {
            this.name = name;
            this.parsed = parsed;
            this.fileBody = fileBody;
        }
    }

    public static class Spec256GfxOrigPage
    extends Spec256GfxPage {
        private final byte[] origData;

        public Spec256GfxOrigPage(int pageIndex, byte[] origData, byte[] gfxData) {
            super(pageIndex, gfxData);
            this.origData = origData;
        }

        public Spec256GfxOrigPage(Spec256GfxOrigPage orig, byte[] newGfxData) {
            super(orig.getPageIndex(), newGfxData);
            this.origData = orig.origData;
        }

        public byte[] getOrigData() {
            return this.origData;
        }
    }

    public static class Spec256Bkg {
        private final int index;
        private final byte[] data;
        private final int width;
        private final int height;

        private Spec256Bkg(int index, byte[] data, int width, int height) {
            this.index = index;
            this.data = data;
            this.width = width;
            this.height = height;
        }

        public int getIndex() {
            return this.index;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public static class Spec256Palette {
        private final int index;
        private final byte[] data;

        private Spec256Palette(int index, byte[] data) {
            this.index = index;
            this.data = data;
        }

        public int getIndex() {
            return this.index;
        }

        public byte[] getData() {
            return this.data;
        }

        public int size() {
            return this.data.length / 3;
        }
    }

    public static class Spec256GfxPage {
        private final int pageIndex;
        private final byte[] gfxData;

        public Spec256GfxPage(int pageIndex, byte[] gfxData) {
            this.pageIndex = pageIndex;
            this.gfxData = gfxData;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        public byte[] packGfxData() {
            byte[] result = new byte[this.gfxData.length];
            for (int offset = 0; offset < this.gfxData.length; offset += 8) {
                for (int ctx = 0; ctx < 8; ++ctx) {
                    int bitMask = 1 << ctx;
                    for (int i = 0; i < 8; ++i) {
                        int n = offset + ctx;
                        result[n] = (byte)(result[n] | (byte)((this.gfxData[offset + i] & bitMask) != 0 ? 1 << i : 0));
                    }
                }
            }
            return result;
        }

        public byte[] getGfxData() {
            return this.gfxData;
        }
    }
}

