/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.formats;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.zxpoly.formats.FormatZ80;
import java.io.IOException;

public class Z80V3AParser
extends FormatZ80.AbstractZ80Snapshot {
    protected static final int _ParserFlags_ = 0;
    protected byte reg_a;
    protected byte reg_f;
    protected short reg_bc;
    protected short reg_hl;
    protected short reg_pc;
    protected short reg_sp;
    protected byte reg_ir;
    protected byte reg_r;
    protected FLAGS flags;
    protected short reg_de;
    protected short reg_bc_alt;
    protected short reg_de_alt;
    protected short reg_hl_alt;
    protected byte reg_a_alt;
    protected byte reg_f_alt;
    protected short reg_iy;
    protected short reg_ix;
    protected byte iff;
    protected byte iff2;
    protected EMULFLAGS emulflags;
    protected char headerlen;
    protected short reg_pc2;
    protected char mode;
    protected char port7ffd;
    protected char portff;
    protected byte[] miscnonzx;
    protected byte[] data;

    @Override
    public FormatZ80.AbstractZ80Snapshot read(JBBPBitInputStream In) throws IOException {
        this.reg_a = (byte)In.readByte();
        this.reg_f = (byte)In.readByte();
        this.reg_bc = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_hl = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_pc = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_sp = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_ir = (byte)In.readByte();
        this.reg_r = (byte)In.readByte();
        if (this.flags == null) {
            this.flags = new FLAGS(this);
        }
        this.flags.read(In);
        this.reg_de = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_bc_alt = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_de_alt = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_hl_alt = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_a_alt = (byte)In.readByte();
        this.reg_f_alt = (byte)In.readByte();
        this.reg_iy = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_ix = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.iff = (byte)In.readByte();
        this.iff2 = (byte)In.readByte();
        if (this.emulflags == null) {
            this.emulflags = new EMULFLAGS(this);
        }
        this.emulflags.read(In);
        this.headerlen = (char)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.reg_pc2 = (short)In.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        this.mode = (char)(In.readByte() & 0xFF);
        this.port7ffd = (char)(In.readByte() & 0xFF);
        this.portff = (char)(In.readByte() & 0xFF);
        this.miscnonzx = In.readByteArray(49, JBBPByteOrder.BIG_ENDIAN);
        this.data = In.readByteArray(-1, JBBPByteOrder.BIG_ENDIAN);
        return this;
    }

    public FormatZ80.AbstractZ80Snapshot write(JBBPBitOutputStream Out) throws IOException {
        Out.write(this.reg_a);
        Out.write(this.reg_f);
        Out.writeShort(this.reg_bc, JBBPByteOrder.LITTLE_ENDIAN);
        Out.writeShort(this.reg_hl, JBBPByteOrder.LITTLE_ENDIAN);
        Out.writeShort(this.reg_pc, JBBPByteOrder.LITTLE_ENDIAN);
        Out.writeShort(this.reg_sp, JBBPByteOrder.LITTLE_ENDIAN);
        Out.write(this.reg_ir);
        Out.write(this.reg_r);
        this.flags.write(Out);
        Out.writeShort(this.reg_de, JBBPByteOrder.LITTLE_ENDIAN);
        Out.writeShort(this.reg_bc_alt, JBBPByteOrder.LITTLE_ENDIAN);
        Out.writeShort(this.reg_de_alt, JBBPByteOrder.LITTLE_ENDIAN);
        Out.writeShort(this.reg_hl_alt, JBBPByteOrder.LITTLE_ENDIAN);
        Out.write(this.reg_a_alt);
        Out.write(this.reg_f_alt);
        Out.writeShort(this.reg_iy, JBBPByteOrder.LITTLE_ENDIAN);
        Out.writeShort(this.reg_ix, JBBPByteOrder.LITTLE_ENDIAN);
        Out.write(this.iff);
        Out.write(this.iff2);
        this.emulflags.write(Out);
        Out.writeShort(this.headerlen, JBBPByteOrder.LITTLE_ENDIAN);
        Out.writeShort(this.reg_pc2, JBBPByteOrder.LITTLE_ENDIAN);
        Out.write(this.mode);
        Out.write(this.port7ffd);
        Out.write(this.portff);
        Out.writeBytes(this.miscnonzx, 49, JBBPByteOrder.BIG_ENDIAN);
        Out.writeBytes(this.data, this.data.length, JBBPByteOrder.BIG_ENDIAN);
        return this;
    }

    public void setREG_A(byte value) {
        this.reg_a = value;
    }

    @Override
    public byte getREG_A() {
        return this.reg_a;
    }

    public void setREG_F(byte value) {
        this.reg_f = value;
    }

    @Override
    public byte getREG_F() {
        return this.reg_f;
    }

    public void setREG_BC(short value) {
        this.reg_bc = value;
    }

    @Override
    public short getREG_BC() {
        return this.reg_bc;
    }

    public void setREG_HL(short value) {
        this.reg_hl = value;
    }

    @Override
    public short getREG_HL() {
        return this.reg_hl;
    }

    public void setREG_PC(short value) {
        this.reg_pc = value;
    }

    @Override
    public short getREG_PC() {
        return this.reg_pc;
    }

    public void setREG_SP(short value) {
        this.reg_sp = value;
    }

    @Override
    public short getREG_SP() {
        return this.reg_sp;
    }

    public void setREG_IR(byte value) {
        this.reg_ir = value;
    }

    @Override
    public byte getREG_IR() {
        return this.reg_ir;
    }

    public void setREG_R(byte value) {
        this.reg_r = value;
    }

    @Override
    public byte getREG_R() {
        return this.reg_r;
    }

    @Override
    public FormatZ80.Z80Flags getFLAGS() {
        return this.flags;
    }

    public FLAGS makeFLAGS() {
        this.flags = new FLAGS(this);
        return this.flags;
    }

    public void setREG_DE(short value) {
        this.reg_de = value;
    }

    @Override
    public short getREG_DE() {
        return this.reg_de;
    }

    public void setREG_BC_ALT(short value) {
        this.reg_bc_alt = value;
    }

    @Override
    public short getREG_BC_ALT() {
        return this.reg_bc_alt;
    }

    public void setREG_DE_ALT(short value) {
        this.reg_de_alt = value;
    }

    @Override
    public short getREG_DE_ALT() {
        return this.reg_de_alt;
    }

    public void setREG_HL_ALT(short value) {
        this.reg_hl_alt = value;
    }

    @Override
    public short getREG_HL_ALT() {
        return this.reg_hl_alt;
    }

    public void setREG_A_ALT(byte value) {
        this.reg_a_alt = value;
    }

    @Override
    public byte getREG_A_ALT() {
        return this.reg_a_alt;
    }

    public void setREG_F_ALT(byte value) {
        this.reg_f_alt = value;
    }

    @Override
    public byte getREG_F_ALT() {
        return this.reg_f_alt;
    }

    public void setREG_IY(short value) {
        this.reg_iy = value;
    }

    @Override
    public short getREG_IY() {
        return this.reg_iy;
    }

    public void setREG_IX(short value) {
        this.reg_ix = value;
    }

    @Override
    public short getREG_IX() {
        return this.reg_ix;
    }

    public void setIFF(byte value) {
        this.iff = value;
    }

    @Override
    public byte getIFF() {
        return this.iff;
    }

    public void setIFF2(byte value) {
        this.iff2 = value;
    }

    @Override
    public byte getIFF2() {
        return this.iff2;
    }

    @Override
    public FormatZ80.Z80EmulFlags getEMULFLAGS() {
        return this.emulflags;
    }

    public EMULFLAGS makeEMULFLAGS() {
        this.emulflags = new EMULFLAGS(this);
        return this.emulflags;
    }

    public void setHEADERLEN(char value) {
        this.headerlen = value;
    }

    public char getHEADERLEN() {
        return this.headerlen;
    }

    public void setREG_PC2(short value) {
        this.reg_pc2 = value;
    }

    @Override
    public short getREG_PC2() {
        return this.reg_pc2;
    }

    public void setMODE(char value) {
        this.mode = value;
    }

    @Override
    public char getMODE() {
        return this.mode;
    }

    public void setPORT7FFD(char value) {
        this.port7ffd = value;
    }

    @Override
    public char getPORT7FFD() {
        return this.port7ffd;
    }

    public void setPORTFF(char value) {
        this.portff = value;
    }

    @Override
    public char getPORTFF() {
        return this.portff;
    }

    public void setMISCNONZX(byte[] value) {
        this.miscnonzx = value;
    }

    public byte[] getMISCNONZX() {
        return this.miscnonzx;
    }

    public void setDATA(byte[] value) {
        this.data = value;
    }

    @Override
    public byte[] getDATA() {
        return this.data;
    }

    public static class FLAGS
    implements FormatZ80.Z80Flags {
        protected byte reg_r_bit7;
        protected byte bordercolor;
        protected byte basic_samrom;
        protected byte compressed;
        protected byte nomeaning;
        private final Z80V3AParser _Root_;

        public FLAGS(Z80V3AParser root) {
            this._Root_ = root;
        }

        public FLAGS read(JBBPBitInputStream In) throws IOException {
            this.reg_r_bit7 = In.readBitField(JBBPBitNumber.BITS_1);
            this.bordercolor = In.readBitField(JBBPBitNumber.BITS_3);
            this.basic_samrom = In.readBitField(JBBPBitNumber.BITS_1);
            this.compressed = In.readBitField(JBBPBitNumber.BITS_1);
            this.nomeaning = In.readBitField(JBBPBitNumber.BITS_2);
            return this;
        }

        public FLAGS write(JBBPBitOutputStream Out) throws IOException {
            Out.writeBits(this.reg_r_bit7, JBBPBitNumber.BITS_1);
            Out.writeBits(this.bordercolor, JBBPBitNumber.BITS_3);
            Out.writeBits(this.basic_samrom, JBBPBitNumber.BITS_1);
            Out.writeBits(this.compressed, JBBPBitNumber.BITS_1);
            Out.writeBits(this.nomeaning, JBBPBitNumber.BITS_2);
            return this;
        }

        public void setREG_R_BIT7(byte value) {
            this.reg_r_bit7 = value;
        }

        @Override
        public byte getREG_R_BIT7() {
            return this.reg_r_bit7;
        }

        public void setBORDERCOLOR(byte value) {
            this.bordercolor = value;
        }

        @Override
        public byte getBORDERCOLOR() {
            return this.bordercolor;
        }

        public void setBASIC_SAMROM(byte value) {
            this.basic_samrom = value;
        }

        @Override
        public byte getBASIC_SAMROM() {
            return this.basic_samrom;
        }

        public void setCOMPRESSED(byte value) {
            this.compressed = value;
        }

        @Override
        public byte getCOMPRESSED() {
            return this.compressed;
        }

        public void setNOMEANING(byte value) {
            this.nomeaning = value;
        }

        @Override
        public byte getNOMEANING() {
            return this.nomeaning;
        }
    }

    public static class EMULFLAGS
    implements FormatZ80.Z80EmulFlags {
        protected byte interruptmode;
        protected byte issue2emulation;
        protected byte doubleintfreq;
        protected byte videosync;
        protected byte inputdevice;
        private final Z80V3AParser _Root_;

        public EMULFLAGS(Z80V3AParser root) {
            this._Root_ = root;
        }

        public EMULFLAGS read(JBBPBitInputStream In) throws IOException {
            this.interruptmode = In.readBitField(JBBPBitNumber.BITS_2);
            this.issue2emulation = In.readBitField(JBBPBitNumber.BITS_1);
            this.doubleintfreq = In.readBitField(JBBPBitNumber.BITS_1);
            this.videosync = In.readBitField(JBBPBitNumber.BITS_2);
            this.inputdevice = In.readBitField(JBBPBitNumber.BITS_2);
            return this;
        }

        public EMULFLAGS write(JBBPBitOutputStream Out) throws IOException {
            Out.writeBits(this.interruptmode, JBBPBitNumber.BITS_2);
            Out.writeBits(this.issue2emulation, JBBPBitNumber.BITS_1);
            Out.writeBits(this.doubleintfreq, JBBPBitNumber.BITS_1);
            Out.writeBits(this.videosync, JBBPBitNumber.BITS_2);
            Out.writeBits(this.inputdevice, JBBPBitNumber.BITS_2);
            return this;
        }

        public void setINTERRUPTMODE(byte value) {
            this.interruptmode = value;
        }

        @Override
        public byte getINTERRUPTMODE() {
            return this.interruptmode;
        }

        public void setISSUE2EMULATION(byte value) {
            this.issue2emulation = value;
        }

        @Override
        public byte getISSUE2EMULATION() {
            return this.issue2emulation;
        }

        public void setDOUBLEINTFREQ(byte value) {
            this.doubleintfreq = value;
        }

        @Override
        public byte getDOUBLEINTFREQ() {
            return this.doubleintfreq;
        }

        public void setVIDEOSYNC(byte value) {
            this.videosync = value;
        }

        @Override
        public byte getVIDEOSYNC() {
            return this.videosync;
        }

        public void setINPUTDEVICE(byte value) {
            this.inputdevice = value;
        }

        @Override
        public byte getINPUTDEVICE() {
            return this.inputdevice;
        }
    }
}

