/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.streamer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class FemtoHttpServer {
    private static final Logger LOGGER = Logger.getLogger(FemtoHttpServer.class.getName());
    private static final byte[] EOL = new byte[]{13, 10};
    private final ExecutorService executorService;
    private final InetSocketAddress socketAddress;
    private final int backlog;
    private final AtomicReference<ServerSocket> serverSocket = new AtomicReference();
    private final Map<Socket, Thread> activeConnections = new ConcurrentHashMap<Socket, Thread>();
    private final Map<String, Consumer<HttpExchange>> contexts = new ConcurrentHashMap<String, Consumer<HttpExchange>>();

    public FemtoHttpServer(ExecutorService executorService, InetSocketAddress socketAddress, int backlog) {
        this.executorService = Objects.requireNonNull(executorService);
        this.socketAddress = Objects.requireNonNull(socketAddress);
        this.backlog = backlog;
    }

    private static String readLine(InputStream in) throws IOException {
        int chr;
        StringBuilder result = new StringBuilder();
        while (!Thread.currentThread().isInterrupted() && (chr = in.read()) >= 0) {
            if (Character.isISOControl(chr)) {
                if (chr != 10) continue;
                break;
            }
            result.append((char)chr);
        }
        return result.toString();
    }

    public InetSocketAddress getAddress() {
        ServerSocket mainSocket = this.serverSocket.get();
        return mainSocket == null ? null : new InetSocketAddress(mainSocket.getInetAddress(), mainSocket.getLocalPort());
    }

    public void createContext(String prefix, Consumer<HttpExchange> handler) {
        this.contexts.put(prefix, Objects.requireNonNull(handler));
    }

    public void start() throws IOException {
        ServerSocket newServerSocket = new ServerSocket(this.socketAddress.getPort(), this.backlog, this.socketAddress.getAddress());
        newServerSocket.setReuseAddress(true);
        newServerSocket.setSoTimeout(600000);
        if (this.serverSocket.compareAndSet(null, newServerSocket)) {
            LOGGER.info("Starting HTTP server: " + String.valueOf(this.socketAddress));
            this.executorService.submit(this::mainLoop);
        }
    }

    private void mainLoop() {
        ServerSocket mainSocket = this.serverSocket.get();
        LOGGER.info("Created socket: " + String.valueOf(mainSocket.getInetAddress()) + ":" + mainSocket.getLocalPort());
        while (!Thread.currentThread().isInterrupted() && this.serverSocket.get() != null) {
            try {
                LOGGER.info("Awaiting incoming connection: " + String.valueOf(mainSocket));
                Socket socket = mainSocket.accept();
                socket.setKeepAlive(true);
                LOGGER.info("Incoming connection: " + String.valueOf(socket));
                this.executorService.submit(() -> this.processIncoming(socket));
            }
            catch (SocketTimeoutException socket) {
            }
            catch (IOException ex) {
                LOGGER.warning("Error during server socket accept: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIncoming(Socket socket) {
        block20: {
            try {
                String headerLine;
                InputStream socketInputStream = socket.getInputStream();
                OutputStream socketOutputStream = socket.getOutputStream();
                Object[] request = FemtoHttpServer.readLine(socketInputStream).split("\\s");
                if (request.length < 3) {
                    throw new IOException("Illegal request header: " + Arrays.toString(request));
                }
                String method = request[0].trim().toUpperCase(Locale.ENGLISH);
                URI path = new URI(((String)request[1]).trim());
                String version = ((String)request[2]).trim().toUpperCase(Locale.ENGLISH);
                if (!version.startsWith("HTTP/")) {
                    throw new IOException("Non-http request: " + Arrays.toString(request));
                }
                Headers requestHeaders = new Headers();
                while (!Thread.currentThread().isInterrupted() && !(headerLine = FemtoHttpServer.readLine(socketInputStream)).isEmpty()) {
                    requestHeaders.add(headerLine);
                }
                String stringPath = path.getPath();
                String foundPath = null;
                Consumer<HttpExchange> foundConsumer = null;
                for (Map.Entry<String, Consumer<HttpExchange>> ctx : this.contexts.entrySet()) {
                    if (!stringPath.startsWith(ctx.getKey()) || foundPath != null && ctx.getKey().length() < foundPath.length()) continue;
                    foundConsumer = ctx.getValue();
                    if (stringPath.equals(ctx.getKey())) {
                        foundPath = ctx.getKey();
                        break;
                    }
                    foundPath = ctx.getKey();
                }
                if (foundConsumer == null) {
                    LOGGER.warning("Can't find context for path: " + stringPath);
                    break block20;
                }
                LOGGER.info("Found '" + foundPath + "' context for path: " + stringPath);
                this.activeConnections.put(socket, Thread.currentThread());
                try {
                    HttpExchange exchange = new HttpExchange(method, path, requestHeaders, socketInputStream, socketOutputStream);
                    foundConsumer.accept(exchange);
                }
                finally {
                    this.activeConnections.remove(socket);
                }
            }
            catch (Exception ex) {
                LOGGER.warning("Error during incoming connection processing: " + ex.getMessage());
            }
            finally {
                try {
                    LOGGER.info("Closing socket: " + String.valueOf(socket));
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void stop() {
        ServerSocket mainSocket = this.serverSocket.getAndSet(null);
        if (mainSocket != null) {
            LOGGER.info("Stopping HTTP server: " + String.valueOf(this.socketAddress));
            try {
                mainSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.activeConnections.forEach((key, value) -> {
                LOGGER.info("Closing socket: " + String.valueOf(key));
                try {
                    key.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.activeConnections.clear();
        }
    }

    public int getConnectionsCount() {
        return this.activeConnections.size();
    }

    public static final class Headers {
        private final Map<String, List<String>> map = new HashMap<String, List<String>>();

        Headers() {
        }

        private static String restoreName(String name) {
            StringBuilder buffer = new StringBuilder();
            boolean nextUpperCased = true;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                buffer.append(nextUpperCased ? Character.toUpperCase(c) : c);
                nextUpperCased = c == '-';
            }
            return buffer.toString();
        }

        private static String normalizeName(String name) {
            return name.trim().toLowerCase(Locale.ENGLISH);
        }

        public int size() {
            return this.map.size();
        }

        public void clear() {
            this.map.clear();
        }

        public Set<String> allHeaders() {
            return this.map.keySet().stream().map(Headers::restoreName).collect(Collectors.toSet());
        }

        public void add(String header, String value) {
            this.map.computeIfAbsent(Headers.normalizeName(header), x -> new ArrayList()).add(Objects.requireNonNull(value));
        }

        public void add(String header, long value) {
            this.map.computeIfAbsent(Headers.normalizeName(header), x -> new ArrayList()).add(Long.toString(value));
        }

        public List<String> get(String header) {
            return this.map.getOrDefault(Headers.normalizeName(header), Collections.emptyList());
        }

        public Optional<String> getFirst(String header) {
            List<String> headerList = this.get(Headers.normalizeName(header));
            return headerList.isEmpty() ? Optional.empty() : Optional.ofNullable(headerList.get(0));
        }

        public void add(String headerLine) {
            if (headerLine == null || headerLine.isEmpty()) {
                return;
            }
            int delimiter = headerLine.indexOf(58);
            if (delimiter < 0) {
                this.add(Headers.normalizeName(headerLine), "");
            } else {
                String name = Headers.normalizeName(headerLine.substring(0, delimiter));
                String value = headerLine.substring(delimiter + 1).trim();
                this.add(name, value);
            }
        }
    }

    public static class HttpExchange {
        private final String method;
        private final URI path;
        private final Headers requestHeaders;
        private final Headers responseHeaders;
        private final InputStream inputStream;
        private final OutputStream outputStream;

        HttpExchange(String method, URI path, Headers requestHeaders, InputStream inputStream, OutputStream outputStream) {
            this.method = Objects.requireNonNull(method);
            this.path = Objects.requireNonNull(path);
            this.requestHeaders = Objects.requireNonNull(requestHeaders);
            this.responseHeaders = new Headers();
            this.inputStream = Objects.requireNonNull(inputStream);
            this.outputStream = Objects.requireNonNull(outputStream);
        }

        private static void writeLine(String line, OutputStream out) throws IOException {
            byte[] codes = line.getBytes(StandardCharsets.US_ASCII);
            out.write(codes);
            out.write(EOL);
        }

        public Headers getResponseHeaders() {
            return this.responseHeaders;
        }

        public Headers getRequestHeaders() {
            return this.requestHeaders;
        }

        public String getRequestMethod() {
            return this.method;
        }

        public URI getRequestURI() {
            return this.path;
        }

        public void sendResponseHeaders(int code, long contentLength) throws IOException {
            String reason = "Unknown";
            if (code < 600) {
                reason = "Server error";
            }
            if (code < 500) {
                reason = "Client error";
            }
            if (code < 400) {
                reason = "Redirect";
            }
            if (code < 300) {
                reason = "OK";
            }
            if (code < 200) {
                reason = "Information";
            }
            if (code < 100) {
                reason = "Special";
            }
            if (code == 101) {
                reason = "Switching Protocols";
            }
            HttpExchange.writeLine(String.format("HTTP/1.1 %d %s", code, reason), this.outputStream);
            if (contentLength >= 0L && this.responseHeaders.get("Content-Length").isEmpty()) {
                this.responseHeaders.add("Content-Length", contentLength);
            }
            for (String header : this.responseHeaders.allHeaders()) {
                for (String value : this.responseHeaders.get(header)) {
                    HttpExchange.writeLine(String.format("%s: %s", header, value), this.outputStream);
                }
            }
            HttpExchange.writeLine("", this.outputStream);
            this.outputStream.flush();
        }

        public void close() {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
            }
            finally {
                IOUtils.closeQuietly(this.inputStream);
                IOUtils.closeQuietly(this.outputStream);
            }
        }

        public InputStream getRequestBody() {
            return this.inputStream;
        }

        public OutputStream getResponseBody() {
            return this.outputStream;
        }
    }
}

