/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.streamer;

import com.igormaznitsa.zxpoly.components.sound.Beeper;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.streamer.AbstractTcpSingleThreadServer;
import com.igormaznitsa.zxpoly.streamer.FfmpegWrapper;
import com.igormaznitsa.zxpoly.streamer.HttpProcessor;
import com.igormaznitsa.zxpoly.streamer.TcpWriter;
import com.igormaznitsa.zxpoly.streamer.ZxStreamingSoundPort;
import com.igormaznitsa.zxpoly.utils.Timer;
import com.igormaznitsa.zxpoly.utils.Utils;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Logger;

public final class ZxVideoStreamer {
    public static final Logger LOGGER = Logger.getLogger(ZxVideoStreamer.class.getName());
    private final VideoController videoController;
    private final AtomicBoolean started = new AtomicBoolean();
    private final Consumer<ZxVideoStreamer> endWorkConsumer;
    private final Timer wallClock = new Timer(Duration.ofMillis(20L));
    private final byte[] rgbArray = new byte[589824];
    private volatile TcpWriter videoWriter;
    private volatile TcpWriter soundWriter;
    private volatile FfmpegWrapper ffmpegWrapper;
    private volatile ZxStreamingSoundPort soudPort;
    private volatile HttpProcessor httpProcessor;
    private volatile Beeper beeper;
    private volatile Duration delayBetweenFrameGrab;
    private volatile boolean internalEntitiesStarted;
    private final Lock locker = new ReentrantLock();

    public ZxVideoStreamer(VideoController videoController, Consumer<ZxVideoStreamer> endWorkConsumer) {
        this.endWorkConsumer = endWorkConsumer;
        this.videoController = videoController;
    }

    private void stopAllInternalEntities() {
        this.locker.lock();
        try {
            if (this.httpProcessor != null) {
                this.httpProcessor.stop();
                this.httpProcessor = null;
            }
            if (this.beeper != null) {
                this.beeper.setSourceSoundPort(null);
            }
            if (this.ffmpegWrapper != null) {
                this.ffmpegWrapper.stop();
                this.ffmpegWrapper = null;
            }
            if (this.videoWriter != null) {
                this.videoWriter.stop();
                this.videoWriter = null;
            }
            if (this.soundWriter != null) {
                this.soundWriter.stop();
                this.soundWriter = null;
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            LOGGER.info("Stopping");
            this.internalEntitiesStarted = false;
            this.stopAllInternalEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInternalEntities(InetAddress address, int port, String ffmpegPath, int frameRate) {
        this.locker.lock();
        try {
            this.videoWriter = new TcpWriter("tcp-video-writer", 2, InetAddress.getLoopbackAddress(), 0);
            this.delayBetweenFrameGrab = Duration.ofMillis((1000L + (long)(frameRate / 2)) / (long)frameRate);
            this.wallClock.next(this.delayBetweenFrameGrab);
            if (this.beeper == null) {
                this.soundWriter = null;
                this.soudPort = null;
            } else {
                this.soundWriter = new TcpWriter("tcp-sound-writer", 2, InetAddress.getLoopbackAddress(), 0);
                this.soudPort = new ZxStreamingSoundPort(this.soundWriter);
            }
            final CountDownLatch latch = new CountDownLatch(this.soundWriter == null ? 1 : 2);
            final AtomicInteger errorCounter = new AtomicInteger();
            AbstractTcpSingleThreadServer.TcpServerListener listener = new AbstractTcpSingleThreadServer.TcpServerListener(){
                final /* synthetic */ ZxVideoStreamer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onConnected(AbstractTcpSingleThreadServer writer, Socket socket) {
                    LOGGER.info(String.format("Incoming connection %s:%s", writer.getId(), socket));
                }

                @Override
                public void onEstablishing(AbstractTcpSingleThreadServer writer, ServerSocket socket, Throwable error) {
                    if (error != null) {
                        errorCounter.incrementAndGet();
                    }
                    latch.countDown();
                }

                @Override
                public void onDone(AbstractTcpSingleThreadServer source) {
                    this.this$0.internalEntitiesStarted = false;
                    this.this$0.onDone();
                }

                @Override
                public void onConnectionDone(AbstractTcpSingleThreadServer source, Socket socket) {
                    this.this$0.internalEntitiesStarted = false;
                    this.this$0.onDone();
                }
            };
            this.videoWriter.addListener(listener);
            if (this.soundWriter != null) {
                this.soundWriter.addListener(listener);
                this.soundWriter.start();
            }
            this.videoWriter.start();
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                this.stop();
                this.locker.unlock();
                return;
            }
            if (errorCounter.get() != 0) {
                this.stop();
                throw new IllegalStateException("Can't start internal server");
            }
            try {
                this.httpProcessor = new HttpProcessor("video/MP2T", InetAddress.getLoopbackAddress(), 0, address, port, server -> {
                    LOGGER.info("Internal HTTP server has been stopped");
                    this.stop();
                });
                this.httpProcessor.start();
            }
            catch (Exception ex) {
                this.stop();
                throw new IllegalStateException("Can't start internal tcp-http retranslator", ex);
            }
            FfmpegWrapper ffmpeg = new FfmpegWrapper(ffmpegPath, frameRate, "tcp://" + this.videoWriter.getServerAddress(), this.soundWriter == null ? null : "tcp://" + this.soundWriter.getServerAddress(), "tcp://" + this.httpProcessor.getTcpAddress());
            if (this.beeper != null) {
                this.beeper.setSourceSoundPort(new ZxStreamingSoundPort(this.soundWriter));
            }
            try {
                ffmpeg.start();
            }
            catch (Exception ex) {
                this.stop();
                LOGGER.warning("Can't start ffmpeg: " + ex.getMessage());
                throw new IllegalStateException(ex.getMessage(), ex);
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (!ffmpeg.isAlive()) {
                this.stop();
                throw new IllegalStateException("ffmpeg can't start");
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    public void start(Beeper beeper, String ffmpegPath, InetAddress address, int port, int frameRate) {
        if (this.started.compareAndSet(false, true)) {
            this.beeper = beeper;
            this.startInternalEntities(address, port, ffmpegPath, frameRate);
            this.internalEntitiesStarted = true;
            String link = "http://" + this.httpProcessor.getHttpAddress() + "/";
            try {
                Utils.browseLink(new URL(link));
            }
            catch (MalformedURLException ex) {
                LOGGER.warning("Can't make URL: " + link);
            }
        }
    }

    private void onDone() {
        this.stop();
        if (this.endWorkConsumer != null) {
            this.endWorkConsumer.accept(this);
        }
    }

    public void onWallclockInt() {
        if (this.internalEntitiesStarted && this.wallClock.completed()) {
            this.wallClock.next(this.delayBetweenFrameGrab);
            this.videoWriter.write(this.videoController.grabRgb(this.rgbArray));
            this.wallClock.next();
        }
    }
}

