/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.trainers;

import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.trainers.AbstractTrainer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;

public class TrainerPok
extends AbstractTrainer {
    public static final Logger LOGGER = Logger.getLogger(TrainerPok.class.getName());

    public TrainerPok() {
        super("POK file (*.pok)", "pok");
    }

    @Override
    public void apply(Component component, File file, Motherboard motherboard) {
        String s;
        String line;
        String body;
        try {
            body = FileUtils.readFileToString(file, StandardCharsets.US_ASCII);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't load file", ex);
        }
        ArrayList<PokeRecord> records = new ArrayList<PokeRecord>();
        PokeRecord currentRecord = null;
        String[] stringArray = body.split("\\r?\\n");
        int n = stringArray.length;
        for (int i = 0; i < n && !(line = (s = stringArray[i]).trim()).startsWith("Y"); ++i) {
            if (line.startsWith("N")) {
                if (currentRecord != null) {
                    records.add(currentRecord);
                }
                String text = line.substring(1);
                currentRecord = new PokeRecord(this, text);
                continue;
            }
            if (line.startsWith("M") || line.startsWith("Z")) {
                String pokeLine = line.substring(1).trim();
                if (currentRecord == null) {
                    throw new IllegalArgumentException("Unexpected poke without title: " + line);
                }
                currentRecord.addPoke(pokeLine);
                continue;
            }
            if (line.isEmpty()) continue;
            throw new IllegalArgumentException("Can't recognize line: " + line);
        }
        if (currentRecord != null) {
            records.add(currentRecord);
        }
        if (records.isEmpty()) {
            throw new IllegalArgumentException("Can't find records int POKE file");
        }
        JList<PokeRecord> listRecordsComponent = new JList<PokeRecord>(records.toArray(new PokeRecord[0]));
        listRecordsComponent.setVisibleRowCount(8);
        listRecordsComponent.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                if (index >= 0) {
                    PokeRecord record;
                    record.setSelected(!(record = (PokeRecord)list.getModel().getElementAt(index)).isSelected());
                    list.repaint();
                }
            }
        });
        listRecordsComponent.setCellRenderer(new CheckBoxListCellRenderer());
        listRecordsComponent.setSelectionMode(0);
        if (JOptionPane.showConfirmDialog(component, new JScrollPane(listRecordsComponent), "Found trainers", 2, -1) == 0) {
            records.stream().filter(PokeRecord::isSelected).flatMap(x -> x.items.stream()).forEach(poke -> {
                int data = poke.value;
                if (data == 256) {
                    JPanel panel = new JPanel(new FlowLayout(0));
                    panel.add(new JLabel(String.format("Byte value (%s):", poke.parent.title)));
                    JSpinner spinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
                    panel.add(spinner);
                    if (JOptionPane.showConfirmDialog(component, panel, String.format("%s, value for addr %d", poke.parent.title, poke.address), 2, -1) == 2) {
                        return;
                    }
                    data = (Integer)spinner.getValue();
                }
                for (ZxPolyModule module : motherboard.getModules()) {
                    if ((poke.bank & 8) == 0 && poke.address >= 49152) {
                        if (module.getModuleIndex() == 0) {
                            LOGGER.info(String.format("POKE %d:%d,%d", poke.bank, poke.address - 49152, data));
                        }
                        module.poke(poke.bank, poke.address - 49152, data);
                        continue;
                    }
                    if (module.getModuleIndex() == 0) {
                        LOGGER.info(String.format("POKE %d,%d", poke.address, data));
                    }
                    module.writeMemory(module.getCpu(), 0, poke.address, (byte)data);
                }
            });
        }
    }

    private class PokeRecord {
        private final String title;
        private final List<PokeItem> items = new ArrayList<PokeItem>();
        private boolean selected;

        PokeRecord(TrainerPok trainerPok, String title) {
            this.title = title;
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean value) {
            this.selected = value;
        }

        void addPoke(String poke) {
            int original;
            int value;
            int address;
            int bank;
            String[] splitted = poke.split("\\s");
            if (splitted.length != 4) {
                throw new IllegalArgumentException("Illegal poke string: " + poke);
            }
            try {
                bank = Integer.parseInt(splitted[0]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Can't parse bank value: " + poke);
            }
            try {
                address = Integer.parseInt(splitted[1]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Can't parse address: " + poke);
            }
            try {
                value = Integer.parseInt(splitted[2]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Can't parse value: " + poke);
            }
            try {
                original = Integer.parseInt(splitted[3]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Can't parse original value: " + poke);
            }
            this.items.add(new PokeItem(this, this, bank, address, value, original));
        }

        public String toString() {
            return this.title;
        }

        private class PokeItem {
            private final PokeRecord parent;
            private final int bank;
            private final int address;
            private final int value;
            private final int original;

            PokeItem(PokeRecord pokeRecord, PokeRecord parent, int bank, int address, int value, int orig) {
                this.parent = parent;
                this.bank = bank;
                this.address = address;
                this.value = value;
                this.original = orig;
            }
        }
    }

    private final class CheckBoxListCellRenderer
    extends JCheckBox
    implements ListCellRenderer<PokeRecord> {
        @Override
        public Component getListCellRendererComponent(JList<? extends PokeRecord> list, PokeRecord value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            this.setEnabled(list.isEnabled());
            this.setSelected(value.isSelected());
            this.setFont(list.getFont());
            this.setBackground(this.hasFocus() ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(this.hasFocus() ? list.getSelectionForeground() : list.getForeground());
            this.setText(value.toString());
            this.setBorder(this.hasFocus() ? UIManager.getBorder("List.focusSelectedCellHighlightBorder") : UIManager.getBorder("List.cellNoFocusBorder"));
            return this;
        }
    }
}

