/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.ui;

import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JPanel;

public final class CpuLoadIndicator
extends JPanel {
    private static final long serialVersionUID = -8360307819233085278L;
    private static final Stroke STROKE_INDICATOR = new BasicStroke(1.0f);
    private static final Stroke STROKE_GRID = new BasicStroke(0.3f);
    private final int gridStep;
    private final Dimension indicatorSize;
    private final BufferedImage buffer;
    private final Graphics2D bufferGraphics;
    private Color gridColor;
    private int lastY;
    private final Lock lockBufgerGraphics = new ReentrantLock();

    public CpuLoadIndicator(int width, int height, int gridStep, String text, Color foreground, Color background, Color grid) {
        this.gridStep = Math.max(gridStep, 6);
        JBBPUtils.assertNotNull(background, "Background must not be null");
        JBBPUtils.assertNotNull(foreground, "Foreground must not be null");
        super.setBackground(background);
        super.setForeground(foreground);
        this.gridColor = grid;
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.setToolTipText(text);
        this.indicatorSize = new Dimension(width, height);
        super.setSize(width, height);
        this.buffer = new BufferedImage(width, height, 1);
        this.bufferGraphics = this.buffer.createGraphics();
        this.bufferGraphics.setStroke(STROKE_INDICATOR);
        this.bufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.updateForState(0.0f);
        this.clear();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.buffer != null) {
            this.lockBufgerGraphics.lock();
            try {
                this.bufferGraphics.setColor(color);
                this.bufferGraphics.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
            }
            finally {
                this.lockBufgerGraphics.unlock();
            }
        }
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void clear() {
        this.lockBufgerGraphics.lock();
        try {
            this.lastY = this.getHeight();
            this.bufferGraphics.setColor(this.getBackground());
            this.bufferGraphics.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        }
        finally {
            this.lockBufgerGraphics.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateForState(float loading) {
        int step = this.gridStep >> 1;
        this.lockBufgerGraphics.lock();
        try {
            int w = this.buffer.getWidth();
            int h = this.buffer.getHeight();
            this.bufferGraphics.drawImage((Image)this.buffer, -step, 0, null);
            this.bufferGraphics.setColor(this.getBackground());
            this.bufferGraphics.fillRect(w - step, 0, step, h);
            this.bufferGraphics.setColor(this.getForeground());
            int startx = this.buffer.getWidth() - step;
            int curx = this.buffer.getWidth();
            int level = h - Math.round(loading * (float)(h - 4)) - 2;
            this.bufferGraphics.drawLine(startx, this.lastY, curx, level);
            this.lastY = level;
        }
        finally {
            this.lockBufgerGraphics.unlock();
        }
        this.repaint();
    }

    @Override
    public int getWidth() {
        return this.indicatorSize.width;
    }

    @Override
    public int getHeight() {
        return this.indicatorSize.height;
    }

    @Override
    public Dimension getSize() {
        return this.indicatorSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.indicatorSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.indicatorSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.indicatorSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.lockBufgerGraphics.lock();
        try {
            g2.drawImage((Image)this.buffer, 0, 0, null);
        }
        finally {
            this.lockBufgerGraphics.unlock();
        }
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.gridColor != null) {
            g2.setStroke(STROKE_GRID);
            g2.setColor(this.gridColor);
            for (int y = this.getHeight() - this.gridStep; y > 0; y -= this.gridStep) {
                g2.drawLine(0, y, w, y);
            }
            for (int x = 0; x < w; x += this.gridStep) {
                g2.drawLine(x, 0, x, h);
            }
        }
    }
}

