/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.ui;

import com.igormaznitsa.zxpoly.utils.AppOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Locale;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class JFilePathTextField
extends JPanel {
    private static final FileFilter FILE_FILTER_ROM = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".rom");
        }

        @Override
        public String getDescription() {
            return "ROM file (*.rom)";
        }
    };
    private final JTextField textField;

    public JFilePathTextField() {
        super(new GridBagLayout());
        this.setBorder(null);
        this.textField = new JTextField();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1000.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.textField, gbc);
        LabelButton buttonSelect = new LabelButton(" \u2026 ", "Select file", e -> this.selectPath());
        LabelButton buttonClear = new LabelButton(" X ", "Clear selection", e -> this.textField.setText(""));
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        JPanel panel = new JPanel(new GridLayout(1, 2, 4, 0));
        panel.add(buttonClear);
        panel.add(buttonSelect);
        this.add((Component)panel, gbc);
    }

    @Override
    public void setToolTipText(String text) {
        this.textField.setToolTipText(text);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.textField.getPreferredSize();
    }

    public void setColumns(int columns) {
        this.textField.setColumns(columns);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text == null ? "" : text);
    }

    private void selectPath() {
        File file;
        File folder;
        String path = this.textField.getText();
        if (path.isBlank()) {
            folder = AppOptions.getInstance().getRomCacheFolder();
        } else {
            try {
                File file2 = new File(path);
                folder = file2.isFile() ? file2.getParentFile() : AppOptions.getInstance().getRomCacheFolder();
            }
            catch (Exception ex) {
                folder = AppOptions.getInstance().getRomCacheFolder();
            }
        }
        JFileChooser fileChooser = new JFileChooser(folder);
        fileChooser.setDialogTitle("Select custom bootstrap ROM file");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter(FILE_FILTER_ROM);
        fileChooser.setFileFilter(FILE_FILTER_ROM);
        if (fileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0 && (file = fileChooser.getSelectedFile()).isFile()) {
            this.textField.setText(file.getAbsolutePath());
        }
    }

    private static final class LabelButton
    extends JLabel {
        LabelButton(String text, String tooltip, final Consumer<LabelButton> listener) {
            super(text);
            this.setToolTipText(tooltip);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setOpaque(true);
            this.setBackground(UIManager.getColor("Button.background"));
            this.setForeground(UIManager.getColor("Button.foreground"));
            this.setFocusable(false);
            this.setBorder(BorderFactory.createBevelBorder(0));
            this.setFont(this.getFont().deriveFont(1));
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ LabelButton this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.this$0.setBorder(BorderFactory.createBevelBorder(1));
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.this$0.setBorder(BorderFactory.createBevelBorder(0));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.this$0.setBorder(BorderFactory.createBevelBorder(0));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    listener.accept(this.this$0);
                }
            });
        }
    }
}

