/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.ui;

import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.sound.VolumeProfile;
import com.igormaznitsa.zxpoly.components.video.BorderWidth;
import com.igormaznitsa.zxpoly.components.video.VirtualKeyboardLook;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import com.igormaznitsa.zxpoly.ui.CustomIntSlider;
import com.igormaznitsa.zxpoly.ui.JFilePathTextField;
import com.igormaznitsa.zxpoly.ui.KeyCodeChooser;
import com.igormaznitsa.zxpoly.utils.AppOptions;
import com.igormaznitsa.zxpoly.utils.RomSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class OptionsPanel
extends JTabbedPane {
    private static final Logger LOGGER = Logger.getLogger(OptionsPanel.class.getName());
    private JCheckBox checkCovoxFb;
    private JCheckBox checkUlaPlus;
    private JCheckBox checkTurboSound;
    private JCheckBox checkZx128ByDefault;
    private JCheckBox checkKempstonMouseAllowed;
    private JCheckBox checkOldTvFilter;
    private JLabel labelInterlacedScan;
    private JLabel labelSyncPaint;
    private JLabel labelOldTvFilter;
    private JLabel labelCovoxFb;
    private JLabel labelUlaPlus;
    private JLabel labelVolumeProfile;
    private JLabel labelSoundSchemeACB;
    private JLabel labelTurboSound;
    private JLabel labelZx128ByDefault;
    private JLabel labelKempstonMouseAllowed;
    private JLabel labelVirtualKbdApart;
    private JLabel labelVirtualKbdLook;
    private JLabel labelCustomRomPath;
    private JLabel labelMacroCursorKeys;
    private JLabel labelTimingProfile;
    private JLabel labelTryLessResources;
    private JLabel labelBorderWidth;
    private JLabel labelEmulateFFport;
    private JCheckBox checkboxActivateLowPassFilter;
    private CustomIntSlider sliderLowPassFilterValue;
    private JCheckBox checkGrabSound;
    private JCheckBox checkTryLessResources;
    private JCheckBox checkInterlacedScan;
    private JCheckBox checkSoundSchemeACB;
    private JCheckBox checkSyncPaint;
    private JCheckBox checkVkbdApart;
    private JCheckBox checkAutoiCsForCursorKeys;
    private JCheckBox checkEmulateFFport;
    private JComboBox<String> comboNetAdddr;
    private JComboBox<String> comboRomSource;
    private JComboBox<VirtualKeyboardLook> comboKeyboardLook;
    private JComboBox<VolumeProfile> comboVolumeProfile;
    private JComboBox<TimingProfile> comboTimingProfile;
    private JComboBox<BorderWidth> comboBorderWidth;
    private JLabel labelFfMpegPath;
    private JLabel labelNetInterface;
    private JLabel labelPort;
    private JLabel labelSound;
    private JLabel labelRomSource;
    private JLabel labelIntFrame;
    private JLabel labelFrameRate;
    private JSpinner spinnerFramesPerSec;
    private JSpinner spinnerIntFrame;
    private JSpinner spinnerPort;
    private JTextField textFfmpegPath;
    private JFilePathTextField textCustomRomPath;
    private KeyCodeChooser keySelectorKempstonLeft;
    private KeyCodeChooser keySelectorKempstonRight;
    private KeyCodeChooser keySelectorKempstonUp;
    private KeyCodeChooser keySelectorKempstonDown;
    private KeyCodeChooser keySelectorKempstonFire;
    private KeyCodeChooser keySelectorProtekJoystickLeft;
    private KeyCodeChooser keySelectorProtekJoystickRight;
    private KeyCodeChooser keySelectorProtekJoystickUp;
    private KeyCodeChooser keySelectorProtekJoystickDown;
    private KeyCodeChooser keySelectorProtekJoystickFire;

    public OptionsPanel(DataContainer dataContainer) {
        this.initComponents();
        this.comboRomSource.removeAllItems();
        Arrays.stream(RomSource.values()).filter(x -> x != RomSource.UNKNOWN).forEach(x -> this.comboRomSource.addItem(x.getTitle()));
        ArrayList<String> addressList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface next = interfaces.nextElement();
                Enumeration<InetAddress> addresses = next.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    addressList.add(addr.getHostAddress());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Can't form network adapter address list for error: " + ex.getMessage());
        }
        Collections.sort(addressList);
        String loopBackAddress = InetAddress.getLoopbackAddress().getHostAddress();
        if (!addressList.contains(loopBackAddress)) {
            addressList.add(0, loopBackAddress);
        }
        this.comboNetAdddr.removeAllItems();
        addressList.forEach(x -> this.comboNetAdddr.addItem((String)x));
        this.fillByDataContainer(dataContainer == null ? new DataContainer() : dataContainer);
        this.comboRomSource.addActionListener(e -> {
            if (RomSource.TEST.getTitle().equals(this.comboRomSource.getSelectedItem())) {
                this.checkZx128ByDefault.setSelected(false);
            }
        });
    }

    private void fillByDataContainer(DataContainer data) {
        this.sliderLowPassFilterValue.setValue(data.lpfValue);
        if (data.lpfActive) {
            this.sliderLowPassFilterValue.setEnabled(true);
            this.checkboxActivateLowPassFilter.setSelected(true);
        } else {
            this.sliderLowPassFilterValue.setEnabled(false);
            this.checkboxActivateLowPassFilter.setSelected(false);
        }
        this.comboTimingProfile.setSelectedItem((Object)data.timingProfile);
        this.checkEmulateFFport.setSelected(data.emulateFFport);
        this.checkInterlacedScan.setSelected(data.interlacedScan);
        this.checkTryLessResources.setSelected(data.tryLessResources);
        this.checkSyncPaint.setSelected(data.syncPaint);
        this.checkOldTvFilter.setSelected(data.oldTvFilter);
        this.textCustomRomPath.setText(data.customRomPath);
        this.checkSoundSchemeACB.setSelected(data.soundSchemeAcb);
        this.checkGrabSound.setSelected(data.grabSound);
        this.checkVkbdApart.setSelected(data.vkdApart);
        this.checkCovoxFb.setSelected(data.covoxFb);
        this.checkUlaPlus.setSelected(data.ulaPlus);
        this.checkZx128ByDefault.setSelected(data.zx128byDefault);
        this.checkTurboSound.setSelected(data.turboSound);
        this.checkKempstonMouseAllowed.setSelected(data.kempstonMouseAllowed);
        this.spinnerPort.setValue(data.port);
        this.spinnerIntFrame.setValue(data.intPerFrame);
        this.textFfmpegPath.setText(data.ffmpegPath);
        this.comboNetAdddr.setSelectedItem(data.inetAddress);
        this.spinnerFramesPerSec.setValue(data.frameRate);
        this.comboRomSource.setSelectedItem(RomSource.findForLink(data.activeRom, RomSource.TEST).getTitle());
        this.comboKeyboardLook.setSelectedItem((Object)data.keyboardLook);
        this.comboVolumeProfile.setSelectedItem((Object)data.volumeProfile);
        this.comboBorderWidth.setSelectedItem((Object)data.borderWidth);
        this.checkAutoiCsForCursorKeys.setSelected(data.autoCsForCursorKeys);
        this.keySelectorKempstonFire.setKey(data.kempstonKeyFire);
        this.keySelectorKempstonRight.setKey(data.kempstonKeyRight);
        this.keySelectorKempstonLeft.setKey(data.kempstonKeyLeft);
        this.keySelectorKempstonUp.setKey(data.kempstonKeyUp);
        this.keySelectorKempstonDown.setKey(data.kempstonKeyDown);
        this.keySelectorProtekJoystickUp.setKey(data.protekJoystickKeyUp);
        this.keySelectorProtekJoystickFire.setKey(data.protekJoystickKeyFire);
        this.keySelectorProtekJoystickRight.setKey(data.protekJoystickKeyRight);
        this.keySelectorProtekJoystickLeft.setKey(data.protekJoystickKeyLeft);
        this.keySelectorProtekJoystickDown.setKey(data.protekJoystickKeyDown);
    }

    private void initComponents() {
        this.labelInterlacedScan = new JLabel();
        this.labelOldTvFilter = new JLabel();
        this.labelTimingProfile = new JLabel();
        this.labelTryLessResources = new JLabel();
        this.labelBorderWidth = new JLabel();
        this.checkInterlacedScan = new JCheckBox();
        this.labelFfMpegPath = new JLabel();
        this.labelNetInterface = new JLabel();
        this.textFfmpegPath = new JTextField();
        this.comboNetAdddr = new JComboBox();
        this.labelPort = new JLabel();
        this.spinnerPort = new JSpinner();
        this.labelSound = new JLabel();
        this.labelVolumeProfile = new JLabel();
        this.checkGrabSound = new JCheckBox();
        this.labelSoundSchemeACB = new JLabel();
        this.checkSoundSchemeACB = new JCheckBox();
        this.labelFrameRate = new JLabel();
        this.spinnerFramesPerSec = new JSpinner();
        this.labelRomSource = new JLabel();
        this.labelIntFrame = new JLabel();
        this.labelSyncPaint = new JLabel();
        this.comboRomSource = new JComboBox();
        this.spinnerIntFrame = new JSpinner();
        this.labelCovoxFb = new JLabel();
        this.checkCovoxFb = new JCheckBox();
        this.labelUlaPlus = new JLabel();
        this.checkUlaPlus = new JCheckBox();
        this.labelTurboSound = new JLabel();
        this.checkTurboSound = new JCheckBox();
        this.labelZx128ByDefault = new JLabel();
        this.checkZx128ByDefault = new JCheckBox();
        this.labelKempstonMouseAllowed = new JLabel();
        this.labelVirtualKbdApart = new JLabel();
        this.labelVirtualKbdLook = new JLabel();
        this.labelCustomRomPath = new JLabel();
        this.labelMacroCursorKeys = new JLabel();
        this.checkKempstonMouseAllowed = new JCheckBox();
        this.checkAutoiCsForCursorKeys = new JCheckBox();
        this.checkSyncPaint = new JCheckBox();
        this.checkOldTvFilter = new JCheckBox();
        this.checkTryLessResources = new JCheckBox();
        this.checkVkbdApart = new JCheckBox();
        this.comboKeyboardLook = new JComboBox<VirtualKeyboardLook>(VirtualKeyboardLook.values());
        this.comboVolumeProfile = new JComboBox<VolumeProfile>(VolumeProfile.values());
        this.comboTimingProfile = new JComboBox<TimingProfile>(TimingProfile.values());
        this.comboBorderWidth = new JComboBox<BorderWidth>(BorderWidth.values());
        this.textCustomRomPath = new JFilePathTextField();
        this.textCustomRomPath.setToolTipText("Provided file path overrides selected ROM, if empty then inactive");
        this.labelEmulateFFport = new JLabel();
        this.checkEmulateFFport = new JCheckBox();
        this.checkboxActivateLowPassFilter = new JCheckBox();
        double divider = Math.exp(1.0) - 1.0;
        this.sliderLowPassFilterValue = new CustomIntSlider(0, 1000, d -> {
            if ((double)d == 0.0) {
                return 0.0;
            }
            return (Math.exp((double)d / 1000.0) - 1.0) / divider;
        });
        this.keySelectorKempstonDown = new KeyCodeChooser();
        this.keySelectorKempstonLeft = new KeyCodeChooser();
        this.keySelectorKempstonUp = new KeyCodeChooser();
        this.keySelectorKempstonRight = new KeyCodeChooser();
        this.keySelectorKempstonFire = new KeyCodeChooser();
        this.keySelectorProtekJoystickDown = new KeyCodeChooser();
        this.keySelectorProtekJoystickLeft = new KeyCodeChooser();
        this.keySelectorProtekJoystickRight = new KeyCodeChooser();
        this.keySelectorProtekJoystickFire = new KeyCodeChooser();
        this.keySelectorProtekJoystickUp = new KeyCodeChooser();
        this.checkboxActivateLowPassFilter.addChangeListener(e -> this.sliderLowPassFilterValue.setEnabled(this.checkboxActivateLowPassFilter.isSelected()));
        JPanel panelGeneral = new JPanel();
        JPanel panelStreaming = new JPanel();
        JPanel panelSound = new JPanel();
        JPanel panelScreen = new JPanel();
        panelScreen.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.labelIntFrame.setHorizontalAlignment(4);
        this.labelIntFrame.setText("INT/Frame:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        panelScreen.add((Component)this.labelIntFrame, gridBagConstraints);
        this.spinnerIntFrame.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        panelScreen.add((Component)this.spinnerIntFrame, gridBagConstraints);
        this.labelSyncPaint.setHorizontalAlignment(4);
        this.labelSyncPaint.setText("Sync.paint (can be slow):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        panelScreen.add((Component)this.labelSyncPaint, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        panelScreen.add((Component)this.checkSyncPaint, gridBagConstraints);
        this.labelInterlacedScan.setHorizontalAlignment(4);
        this.labelInterlacedScan.setText("Interlaced scan:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        panelScreen.add((Component)this.labelInterlacedScan, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        panelScreen.add((Component)this.checkInterlacedScan, gridBagConstraints);
        this.labelOldTvFilter.setHorizontalAlignment(4);
        this.labelOldTvFilter.setText("Default Old color TV:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        panelScreen.add((Component)this.labelOldTvFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        panelScreen.add((Component)this.checkOldTvFilter, gridBagConstraints);
        this.labelBorderWidth.setHorizontalAlignment(4);
        this.labelBorderWidth.setText("Border width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        panelScreen.add((Component)this.labelBorderWidth, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelScreen.add(this.comboBorderWidth, gridBagConstraints);
        this.labelEmulateFFport.setHorizontalAlignment(4);
        this.labelEmulateFFport.setText("Port FF emulation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        panelScreen.add((Component)this.labelEmulateFFport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelScreen.add((Component)this.checkEmulateFFport, gridBagConstraints);
        this.labelUlaPlus.setHorizontalAlignment(4);
        this.labelUlaPlus.setText("ULA Plus emulation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        panelScreen.add((Component)this.labelUlaPlus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelScreen.add((Component)this.checkUlaPlus, gridBagConstraints);
        panelSound.setLayout(new GridBagLayout());
        this.labelTurboSound.setHorizontalAlignment(4);
        this.labelTurboSound.setText("TurboSound (NedoPC):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        panelSound.add((Component)this.labelTurboSound, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelSound.add((Component)this.checkTurboSound, gridBagConstraints);
        this.labelCovoxFb.setHorizontalAlignment(4);
        this.labelCovoxFb.setText("Covox (#FB):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        panelSound.add((Component)this.labelCovoxFb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelSound.add((Component)this.checkCovoxFb, gridBagConstraints);
        this.labelSoundSchemeACB.setHorizontalAlignment(4);
        this.labelSoundSchemeACB.setText("Sound channels ACB:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        panelSound.add((Component)this.labelSoundSchemeACB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelSound.add((Component)this.checkSoundSchemeACB, gridBagConstraints);
        this.labelVolumeProfile.setHorizontalAlignment(4);
        this.labelVolumeProfile.setText("Volume profile:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        panelSound.add((Component)this.labelVolumeProfile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelSound.add(this.comboVolumeProfile, gridBagConstraints);
        JPanel panelLowPassFilter = new JPanel(new BorderLayout());
        panelLowPassFilter.setBorder(new TitledBorder("Low Pass Filter"));
        panelLowPassFilter.add((Component)this.sliderLowPassFilterValue, "Center");
        this.checkboxActivateLowPassFilter.setText("Active");
        JPanel flow = new JPanel(new FlowLayout(2));
        flow.add(this.checkboxActivateLowPassFilter);
        panelLowPassFilter.add((Component)flow, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        panelSound.add((Component)panelLowPassFilter, gridBagConstraints);
        panelStreaming.setLayout(new GridBagLayout());
        this.labelFfMpegPath.setHorizontalAlignment(4);
        this.labelFfMpegPath.setText("FFmpeg path:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        panelStreaming.add((Component)this.labelFfMpegPath, gridBagConstraints);
        this.textFfmpegPath.setColumns(24);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        panelStreaming.add((Component)this.textFfmpegPath, gridBagConstraints);
        this.labelNetInterface.setHorizontalAlignment(4);
        this.labelNetInterface.setText("Net.interface:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        panelStreaming.add((Component)this.labelNetInterface, gridBagConstraints);
        this.comboNetAdddr.setModel(new DefaultComboBoxModel());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        panelStreaming.add(this.comboNetAdddr, gridBagConstraints);
        this.labelPort.setHorizontalAlignment(4);
        this.labelPort.setText("Port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        panelStreaming.add((Component)this.labelPort, gridBagConstraints);
        this.spinnerPort.setModel(new SpinnerNumberModel(0, 0, 65535, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        panelStreaming.add((Component)this.spinnerPort, gridBagConstraints);
        this.labelSound.setHorizontalAlignment(4);
        this.labelSound.setText("Sound:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        panelStreaming.add((Component)this.labelSound, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        panelStreaming.add((Component)this.checkGrabSound, gridBagConstraints);
        this.labelFrameRate.setHorizontalAlignment(4);
        this.labelFrameRate.setText("Frame rate:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        panelStreaming.add((Component)this.labelFrameRate, gridBagConstraints);
        this.spinnerFramesPerSec.setModel(new SpinnerNumberModel(25, 1, 50, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        panelStreaming.add((Component)this.spinnerFramesPerSec, gridBagConstraints);
        panelGeneral.setLayout(new GridBagLayout());
        this.labelRomSource.setHorizontalAlignment(4);
        this.labelRomSource.setText("Initial ROM load source:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        panelGeneral.add((Component)this.labelRomSource, gridBagConstraints);
        this.comboRomSource.setModel(new DefaultComboBoxModel());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        panelGeneral.add(this.comboRomSource, gridBagConstraints);
        this.labelCustomRomPath.setHorizontalAlignment(4);
        this.labelCustomRomPath.setText("Custom ROM file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        panelGeneral.add((Component)this.labelCustomRomPath, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.textCustomRomPath.setColumns(24);
        panelGeneral.add((Component)this.textCustomRomPath, gridBagConstraints);
        this.labelZx128ByDefault.setHorizontalAlignment(4);
        this.labelZx128ByDefault.setText("Default ZX Mode:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        panelGeneral.add((Component)this.labelZx128ByDefault, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelGeneral.add((Component)this.checkZx128ByDefault, gridBagConstraints);
        this.labelKempstonMouseAllowed.setHorizontalAlignment(4);
        this.labelKempstonMouseAllowed.setText("Kempston mouse allowed:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        panelGeneral.add((Component)this.labelKempstonMouseAllowed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelGeneral.add((Component)this.checkKempstonMouseAllowed, gridBagConstraints);
        this.labelVirtualKbdApart.setHorizontalAlignment(4);
        this.labelVirtualKbdApart.setText("Virtual keyboard apart:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        panelGeneral.add((Component)this.labelVirtualKbdApart, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelGeneral.add((Component)this.checkVkbdApart, gridBagConstraints);
        this.labelVirtualKbdLook.setHorizontalAlignment(4);
        this.labelVirtualKbdLook.setText("Keyboard decoration:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        panelGeneral.add((Component)this.labelVirtualKbdLook, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelGeneral.add(this.comboKeyboardLook, gridBagConstraints);
        this.labelMacroCursorKeys.setHorizontalAlignment(4);
        this.labelMacroCursorKeys.setText("Auto-CS for cursor keys:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        panelGeneral.add((Component)this.labelMacroCursorKeys, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelGeneral.add((Component)this.checkAutoiCsForCursorKeys, gridBagConstraints);
        this.labelTimingProfile.setHorizontalAlignment(4);
        this.labelTimingProfile.setText("Timing:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        panelGeneral.add((Component)this.labelTimingProfile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelGeneral.add(this.comboTimingProfile, gridBagConstraints);
        this.labelTryLessResources.setHorizontalAlignment(4);
        this.labelTryLessResources.setText("Try use less resources:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        panelGeneral.add((Component)this.labelTryLessResources, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panelGeneral.add((Component)this.checkTryLessResources, gridBagConstraints);
        JPanel panelKempston = new JPanel(new GridBagLayout());
        panelKempston.setBorder(BorderFactory.createTitledBorder("Kempston joystick"));
        GridBagConstraints gbx = new GridBagConstraints();
        gbx.gridx = 0;
        gbx.gridy = 0;
        gbx.fill = 2;
        gbx.anchor = 17;
        JLabel kempstonLabel = new JLabel("LEFT:");
        kempstonLabel.setHorizontalAlignment(4);
        panelKempston.add((Component)kempstonLabel, gbx);
        gbx.gridx = 1;
        panelKempston.add((Component)this.keySelectorKempstonLeft, gbx);
        gbx.gridy = 1;
        gbx.gridx = 0;
        kempstonLabel = new JLabel("RIGHT:");
        kempstonLabel.setHorizontalAlignment(4);
        panelKempston.add((Component)kempstonLabel, gbx);
        gbx.gridx = 1;
        panelKempston.add((Component)this.keySelectorKempstonRight, gbx);
        gbx.gridy = 2;
        gbx.gridx = 0;
        kempstonLabel = new JLabel("DOWN:");
        kempstonLabel.setHorizontalAlignment(4);
        panelKempston.add((Component)kempstonLabel, gbx);
        gbx.gridx = 1;
        panelKempston.add((Component)this.keySelectorKempstonDown, gbx);
        gbx.gridy = 3;
        gbx.gridx = 0;
        kempstonLabel = new JLabel("UP:");
        kempstonLabel.setHorizontalAlignment(4);
        panelKempston.add((Component)kempstonLabel, gbx);
        gbx.gridx = 1;
        panelKempston.add((Component)this.keySelectorKempstonUp, gbx);
        gbx.gridy = 4;
        gbx.gridx = 0;
        kempstonLabel = new JLabel("FIRE:");
        kempstonLabel.setHorizontalAlignment(4);
        panelKempston.add((Component)kempstonLabel, gbx);
        gbx.gridx = 1;
        panelKempston.add((Component)this.keySelectorKempstonFire, gbx);
        JPanel panelCursor = new JPanel(new GridBagLayout());
        panelCursor.setBorder(BorderFactory.createTitledBorder("Protek joystick"));
        gbx.gridx = 0;
        gbx.gridy = 0;
        gbx.fill = 2;
        gbx.anchor = 17;
        JLabel cursorLabel = new JLabel("LEFT:");
        cursorLabel.setHorizontalAlignment(4);
        panelCursor.add((Component)cursorLabel, gbx);
        gbx.gridx = 1;
        panelCursor.add((Component)this.keySelectorProtekJoystickLeft, gbx);
        gbx.gridy = 1;
        gbx.gridx = 0;
        cursorLabel = new JLabel("RIGHT:");
        cursorLabel.setHorizontalAlignment(4);
        panelCursor.add((Component)cursorLabel, gbx);
        gbx.gridx = 1;
        panelCursor.add((Component)this.keySelectorProtekJoystickRight, gbx);
        gbx.gridy = 2;
        gbx.gridx = 0;
        cursorLabel = new JLabel("DOWN:");
        cursorLabel.setHorizontalAlignment(4);
        panelCursor.add((Component)cursorLabel, gbx);
        gbx.gridx = 1;
        panelCursor.add((Component)this.keySelectorProtekJoystickDown, gbx);
        gbx.gridy = 3;
        gbx.gridx = 0;
        cursorLabel = new JLabel("UP:");
        cursorLabel.setHorizontalAlignment(4);
        panelCursor.add((Component)cursorLabel, gbx);
        gbx.gridx = 1;
        panelCursor.add((Component)this.keySelectorProtekJoystickUp, gbx);
        gbx.gridy = 4;
        gbx.gridx = 0;
        cursorLabel = new JLabel("FIRE:");
        cursorLabel.setHorizontalAlignment(4);
        panelCursor.add((Component)cursorLabel, gbx);
        gbx.gridx = 1;
        panelCursor.add((Component)this.keySelectorProtekJoystickFire, gbx);
        JPanel joysticksPanel = new JPanel(new GridLayout(1, 2));
        joysticksPanel.add(panelKempston);
        joysticksPanel.add(panelCursor);
        panelGeneral.setBorder(new EmptyBorder(8, 8, 8, 8));
        panelScreen.setBorder(new EmptyBorder(8, 8, 8, 8));
        panelSound.setBorder(new EmptyBorder(8, 8, 8, 8));
        joysticksPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        panelStreaming.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.addTab("General", panelGeneral);
        this.addTab("Screen", panelScreen);
        this.addTab("Sound", panelSound);
        this.addTab("Joystick", joysticksPanel);
        this.addTab("Streaming", panelStreaming);
    }

    public DataContainer getData() {
        return new DataContainer(this);
    }

    public static final class DataContainer {
        public final String customRomPath;
        public final String ffmpegPath;
        public final String inetAddress;
        public final TimingProfile timingProfile;
        public final BorderWidth borderWidth;
        public final VirtualKeyboardLook keyboardLook;
        public final VolumeProfile volumeProfile;
        public final int port;
        public final boolean grabSound;
        public final String activeRom;
        public final int intPerFrame;
        public final int frameRate;
        public final boolean covoxFb;
        public final boolean ulaPlus;
        public final boolean turboSound;
        public final boolean kempstonMouseAllowed;
        public final boolean zx128byDefault;
        public final boolean vkdApart;
        public final boolean autoCsForCursorKeys;
        public final boolean interlacedScan;
        public final boolean tryLessResources;
        public final boolean syncPaint;
        public final boolean oldTvFilter;
        public final boolean emulateFFport;
        public final boolean lpfActive;
        public final int lpfValue;
        public final int kempstonKeyUp;
        public final int kempstonKeyDown;
        public final int kempstonKeyLeft;
        public final int kempstonKeyRight;
        public final int kempstonKeyFire;
        public final int protekJoystickKeyUp;
        public final int protekJoystickKeyDown;
        public final int protekJoystickKeyLeft;
        public final int protekJoystickKeyRight;
        public final int protekJoystickKeyFire;
        public final boolean soundSchemeAcb;

        public DataContainer() {
            String customRomPath = AppOptions.getInstance().getCustomRomPath();
            this.lpfActive = AppOptions.getInstance().isLpfActive();
            this.lpfValue = AppOptions.getInstance().getLpfValue();
            this.borderWidth = AppOptions.getInstance().getBorderWidth();
            this.syncPaint = AppOptions.getInstance().isSyncPaint();
            this.emulateFFport = AppOptions.getInstance().isAttributePortFf();
            this.timingProfile = AppOptions.getInstance().getTimingProfile();
            this.customRomPath = customRomPath == null ? "" : customRomPath;
            this.interlacedScan = AppOptions.getInstance().isInterlacedScan();
            this.tryLessResources = AppOptions.getInstance().isTryLessResources();
            this.oldTvFilter = AppOptions.getInstance().isOldColorTvOnStart();
            this.soundSchemeAcb = AppOptions.getInstance().isSoundChannelsACB();
            this.autoCsForCursorKeys = AppOptions.getInstance().getAutoCsForCursorKeys();
            this.keyboardLook = AppOptions.getInstance().getKeyboardLook();
            this.vkdApart = AppOptions.getInstance().isVkbdApart();
            this.activeRom = AppOptions.getInstance().getActiveRom();
            this.intPerFrame = AppOptions.getInstance().getIntBetweenFrames();
            this.port = AppOptions.getInstance().getPort();
            this.volumeProfile = AppOptions.getInstance().getVolumeProfile();
            this.inetAddress = AppOptions.getInstance().getAddress();
            this.grabSound = AppOptions.getInstance().isGrabSound();
            this.ffmpegPath = AppOptions.getInstance().getFfmpegPath();
            this.frameRate = AppOptions.getInstance().getFrameRate();
            this.covoxFb = AppOptions.getInstance().isCovoxFb();
            this.ulaPlus = AppOptions.getInstance().isUlaPlus();
            this.turboSound = AppOptions.getInstance().isTurboSound();
            this.kempstonMouseAllowed = AppOptions.getInstance().isKempstonMouseAllowed();
            this.zx128byDefault = AppOptions.getInstance().getDefaultBoardMode() != BoardMode.ZXPOLY;
            this.kempstonKeyDown = AppOptions.getInstance().getKempstonVkDown();
            this.kempstonKeyUp = AppOptions.getInstance().getKempstonVkUp();
            this.kempstonKeyLeft = AppOptions.getInstance().getKempstonVkLeft();
            this.kempstonKeyRight = AppOptions.getInstance().getKempstonVkRight();
            this.kempstonKeyFire = AppOptions.getInstance().getKempstonVkFire();
            this.protekJoystickKeyDown = AppOptions.getInstance().getCursorJoystickDown();
            this.protekJoystickKeyUp = AppOptions.getInstance().getProtekJoystickUp();
            this.protekJoystickKeyLeft = AppOptions.getInstance().getProtekJoystickLeft();
            this.protekJoystickKeyRight = AppOptions.getInstance().getProtekJoystickRight();
            this.protekJoystickKeyFire = AppOptions.getInstance().getProtekJoystickFire();
        }

        public DataContainer(OptionsPanel optionsPanel) {
            RomSource rom = RomSource.findForTitle(Objects.requireNonNull(optionsPanel.comboRomSource.getSelectedItem()).toString(), RomSource.TEST);
            this.keyboardLook = (VirtualKeyboardLook)((Object)optionsPanel.comboKeyboardLook.getSelectedItem());
            this.volumeProfile = (VolumeProfile)((Object)optionsPanel.comboVolumeProfile.getSelectedItem());
            this.borderWidth = (BorderWidth)((Object)optionsPanel.comboBorderWidth.getSelectedItem());
            this.customRomPath = optionsPanel.textCustomRomPath.getText();
            this.interlacedScan = optionsPanel.checkInterlacedScan.isSelected();
            this.tryLessResources = optionsPanel.checkTryLessResources.isSelected();
            this.oldTvFilter = optionsPanel.checkOldTvFilter.isSelected();
            this.lpfValue = optionsPanel.sliderLowPassFilterValue.getValue();
            this.lpfActive = optionsPanel.checkboxActivateLowPassFilter.isSelected();
            this.syncPaint = optionsPanel.checkSyncPaint.isSelected();
            this.emulateFFport = optionsPanel.checkEmulateFFport.isSelected();
            this.timingProfile = (TimingProfile)((Object)optionsPanel.comboTimingProfile.getSelectedItem());
            this.autoCsForCursorKeys = optionsPanel.checkAutoiCsForCursorKeys.isSelected();
            this.vkdApart = optionsPanel.checkVkbdApart.isSelected();
            this.activeRom = rom.getLink();
            this.intPerFrame = (Integer)optionsPanel.spinnerIntFrame.getValue();
            this.ffmpegPath = optionsPanel.textFfmpegPath.getText();
            this.port = (Integer)optionsPanel.spinnerPort.getValue();
            this.grabSound = optionsPanel.checkGrabSound.isSelected();
            this.soundSchemeAcb = optionsPanel.checkSoundSchemeACB.isSelected();
            this.inetAddress = Objects.requireNonNull(optionsPanel.comboNetAdddr.getSelectedItem()).toString();
            this.frameRate = (Integer)optionsPanel.spinnerFramesPerSec.getValue();
            this.covoxFb = optionsPanel.checkCovoxFb.isSelected();
            this.ulaPlus = optionsPanel.checkUlaPlus.isSelected();
            this.turboSound = optionsPanel.checkTurboSound.isSelected();
            this.kempstonMouseAllowed = optionsPanel.checkKempstonMouseAllowed.isSelected();
            this.zx128byDefault = rom != RomSource.TEST && optionsPanel.checkZx128ByDefault.isSelected();
            this.kempstonKeyDown = optionsPanel.keySelectorKempstonDown.getKey().orElse(-1);
            this.kempstonKeyUp = optionsPanel.keySelectorKempstonUp.getKey().orElse(-1);
            this.kempstonKeyLeft = optionsPanel.keySelectorKempstonLeft.getKey().orElse(-1);
            this.kempstonKeyRight = optionsPanel.keySelectorKempstonRight.getKey().orElse(-1);
            this.kempstonKeyFire = optionsPanel.keySelectorKempstonFire.getKey().orElse(-1);
            this.protekJoystickKeyFire = optionsPanel.keySelectorProtekJoystickFire.getKey().orElse(-1);
            this.protekJoystickKeyRight = optionsPanel.keySelectorProtekJoystickRight.getKey().orElse(-1);
            this.protekJoystickKeyLeft = optionsPanel.keySelectorProtekJoystickLeft.getKey().orElse(-1);
            this.protekJoystickKeyUp = optionsPanel.keySelectorProtekJoystickUp.getKey().orElse(-1);
            this.protekJoystickKeyDown = optionsPanel.keySelectorProtekJoystickDown.getKey().orElse(-1);
        }

        public void store() {
            AppOptions.getInstance().setLpfActive(this.lpfActive);
            AppOptions.getInstance().setLpfValue(this.lpfValue);
            AppOptions.getInstance().setSyncPaint(this.syncPaint);
            AppOptions.getInstance().setTimingProfile(this.timingProfile);
            AppOptions.getInstance().setBorderWidth(this.borderWidth);
            AppOptions.getInstance().setInterlacedScan(this.interlacedScan);
            AppOptions.getInstance().setTryLessResources(this.tryLessResources);
            AppOptions.getInstance().setOldColorTvOnStart(this.oldTvFilter);
            AppOptions.getInstance().setAutoCsForCursorKeys(this.autoCsForCursorKeys);
            AppOptions.getInstance().setCustomRomPath(this.customRomPath);
            AppOptions.getInstance().setKeyboardLook(this.keyboardLook);
            AppOptions.getInstance().setVolumeProfile(this.volumeProfile);
            AppOptions.getInstance().setVkbdApart(this.vkdApart);
            AppOptions.getInstance().setActiveRom(this.activeRom);
            AppOptions.getInstance().setFfmpegPath(this.ffmpegPath);
            AppOptions.getInstance().setGrabSound(this.grabSound);
            AppOptions.getInstance().setCovoxFb(this.covoxFb);
            AppOptions.getInstance().setUlaPlus(this.ulaPlus);
            AppOptions.getInstance().setIntBetweenFrames(this.intPerFrame);
            AppOptions.getInstance().setPort(this.port);
            AppOptions.getInstance().setAddress(this.inetAddress);
            AppOptions.getInstance().setFrameRate(this.frameRate);
            AppOptions.getInstance().setTurboSound(this.turboSound);
            AppOptions.getInstance().setAttributePortFf(this.emulateFFport);
            AppOptions.getInstance().setKempstonMouseAllowed(this.kempstonMouseAllowed);
            AppOptions.getInstance().setDefaultBoardMode(this.zx128byDefault ? BoardMode.ZX128 : BoardMode.ZXPOLY);
            AppOptions.getInstance().setKempstonVkDown(this.kempstonKeyDown);
            AppOptions.getInstance().setKempstonVkLeft(this.kempstonKeyLeft);
            AppOptions.getInstance().setKempstonVkRight(this.kempstonKeyRight);
            AppOptions.getInstance().setKempstonVkUp(this.kempstonKeyUp);
            AppOptions.getInstance().setKempstonVkFire(this.kempstonKeyFire);
            AppOptions.getInstance().setProtekJoystickDown(this.protekJoystickKeyDown);
            AppOptions.getInstance().setProtekJoystickFire(this.protekJoystickKeyFire);
            AppOptions.getInstance().setProtekJoystickLeft(this.protekJoystickKeyLeft);
            AppOptions.getInstance().setProtekJoystickRight(this.protekJoystickKeyRight);
            AppOptions.getInstance().setProtekJoystickUp(this.protekJoystickKeyUp);
            AppOptions.getInstance().setSoundChannelsACB(this.soundSchemeAcb);
            try {
                AppOptions.getInstance().flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }
}

