/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.ui;

import com.igormaznitsa.zxpoly.components.tapereader.TapeSource;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class SelectTapPosDialog
extends JDialog {
    private static final long serialVersionUID = 3974803548217613782L;
    private int selectedIndex = -1;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JScrollPane jScrollPane1;
    private JList tapBlockList;

    public SelectTapPosDialog(Frame parent, TapeSource tap) {
        super(parent, true);
        this.setTitle(tap.getName());
        tap.stopPlay();
        this.initComponents();
        this.tapBlockList.setModel(tap.getBlockListModel());
        this.tapBlockList.setSelectionMode(0);
        this.tapBlockList.setSelectedIndex(tap.getCurrentBlockIndex());
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tapBlockList = new JList();
        this.setDefaultCloseOperation(2);
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/cancel.png")));
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(this::buttonCancelActionPerformed);
        this.buttonOk.setIcon(new ImageIcon(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/ok.png")));
        this.buttonOk.setText("Ok");
        this.buttonOk.addActionListener(this::buttonOkActionPerformed);
        this.tapBlockList.setFont(new Font("Courier New", 0, 12));
        this.tapBlockList.setModel(new AbstractListModel(){
            final String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.tapBlockList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SelectTapPosDialog.this.tapBlockListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tapBlockList);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 202, Short.MAX_VALUE).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addComponent(this.jScrollPane1)).addContainerGap()));
        layout.linkSize(0, this.buttonCancel, this.buttonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 254, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk)).addContainerGap()));
        this.pack();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.selectedIndex = -1;
        this.setVisible(false);
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.selectedIndex = this.tapBlockList.getSelectedIndex();
        this.setVisible(false);
    }

    private void tapBlockListMouseClicked(MouseEvent evt) {
        int index;
        if (evt.getClickCount() > 1 && (index = this.tapBlockList.locationToIndex(evt.getPoint())) >= 0) {
            this.tapBlockList.setSelectedIndex(index);
            this.buttonOkActionPerformed(null);
        }
    }
}

