/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.stream.Stream;

public final class FilePlainPreferences
extends Preferences {
    private static final Logger LOGGER = Logger.getLogger(FilePlainPreferences.class.getName());
    private static final NumberFormat formatter = NumberFormat.getInstance(Locale.US);
    private final File file;
    private final Properties properties;
    private final String name;
    private final List<PreferenceChangeListener> preferenceChangeListeners = new CopyOnWriteArrayList<PreferenceChangeListener>();
    private final List<NodeChangeListener> nodeChangeListeners = new CopyOnWriteArrayList<NodeChangeListener>();
    private volatile boolean changed;
    private final Lock locker = new ReentrantLock();

    public FilePlainPreferences(String name, File file, boolean create) throws IOException {
        LOGGER.info("Creating file preferences " + name + " in file " + String.valueOf(file) + ", create flag is " + create);
        this.name = Objects.requireNonNull(name);
        this.properties = new Properties();
        this.file = Objects.requireNonNull(file);
        if (file.isFile()) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                this.properties.load(reader);
            }
        } else if (create) {
            File parent = file.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("Can't create folder: " + String.valueOf(parent));
            }
            if (!file.createNewFile()) {
                throw new IOException("Can't create file: " + String.valueOf(file));
            }
        } else {
            throw new FileNotFoundException("Can't find properties file: " + String.valueOf(file));
        }
    }

    private void firePreferenceChange(String key, String newValue) {
        PreferenceChangeEvent event = new PreferenceChangeEvent(this, key, newValue);
        this.preferenceChangeListeners.forEach(x -> x.preferenceChange(event));
    }

    @Override
    public void put(String key, String value) {
        this.locker.lock();
        try {
            this.properties.setProperty(key, value);
            this.changed = true;
            this.firePreferenceChange(key, value);
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key, String def) {
        this.locker.lock();
        try {
            String string = this.properties.getProperty(key, def);
            return string;
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void remove(String key) {
        this.locker.lock();
        try {
            if (this.properties.remove(key) != null) {
                this.changed = true;
                this.firePreferenceChange(key, null);
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void clear() throws BackingStoreException {
        this.locker.lock();
        try {
            String[] keys = this.keys();
            this.properties.clear();
            Stream.of(keys).forEach(k -> this.firePreferenceChange((String)k, null));
            if (keys.length != 0) {
                this.changed = true;
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void putInt(String key, int value) {
        this.locker.lock();
        try {
            this.put(key, formatter.format(value));
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String key, int def) {
        this.locker.lock();
        try {
            String value = this.properties.getProperty(key, formatter.format(def));
            try {
                int n = formatter.parse(value).intValue();
                return n;
            }
            catch (ParseException ex) {
                LOGGER.log(Level.SEVERE, "Parse exception " + key, ex);
                int n = def;
                this.locker.unlock();
                return n;
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLong(String key, long value) {
        this.locker.lock();
        try {
            this.put(key, formatter.format(value));
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String key, long def) {
        this.locker.lock();
        try {
            String value = this.properties.getProperty(key, formatter.format(def));
            try {
                long l = formatter.parse(value).longValue();
                return l;
            }
            catch (ParseException ex) {
                LOGGER.log(Level.SEVERE, "Parse exception " + key, ex);
                long l = def;
                this.locker.unlock();
                return l;
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.locker.lock();
        try {
            this.put(key, Boolean.toString(value));
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String key, boolean def) {
        this.locker.lock();
        try {
            String value = this.properties.getProperty(key, Boolean.toString(def));
            boolean bl = Boolean.parseBoolean(value.trim());
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void putFloat(String key, float value) {
        this.locker.lock();
        try {
            this.put(key, formatter.format(value));
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String key, float def) {
        this.locker.lock();
        try {
            String value = this.properties.getProperty(key, formatter.format(def));
            try {
                float f = formatter.parse(value).floatValue();
                return f;
            }
            catch (ParseException ex) {
                LOGGER.log(Level.SEVERE, "Parse exception " + key, ex);
                float f = def;
                this.locker.unlock();
                return f;
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putDouble(String key, double value) {
        this.locker.lock();
        try {
            this.put(key, formatter.format(value));
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String key, double def) {
        this.locker.lock();
        try {
            String value = this.properties.getProperty(key, formatter.format(def));
            try {
                double d = formatter.parse(value).doubleValue();
                return d;
            }
            catch (ParseException ex) {
                LOGGER.log(Level.SEVERE, "Parse exception " + key, ex);
                double d = def;
                this.locker.unlock();
                return d;
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.locker.lock();
        try {
            this.put(key, Base64.getEncoder().encodeToString(value));
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getByteArray(String key, byte[] def) {
        this.locker.lock();
        try {
            String value = this.properties.getProperty(key, key);
            if (value == null) {
                byte[] byArray = def;
                return byArray;
            }
            byte[] byArray = Base64.getDecoder().decode(value);
            return byArray;
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public String[] keys() {
        this.locker.lock();
        try {
            String[] stringArray = (String[])this.properties.keySet().toArray(String[]::new);
            return stringArray;
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public String[] childrenNames() {
        return new String[0];
    }

    @Override
    public Preferences parent() {
        return null;
    }

    @Override
    public Preferences node(String pathName) {
        return null;
    }

    @Override
    public boolean nodeExists(String pathName) {
        return false;
    }

    @Override
    public void removeNode() throws BackingStoreException {
        throw new BackingStoreException("Can't remove the root node");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String absolutePath() {
        return this.name;
    }

    @Override
    public boolean isUserNode() {
        return false;
    }

    @Override
    public String toString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws BackingStoreException {
        block10: {
            this.locker.lock();
            try {
                if (!this.changed) break block10;
                try (FileWriter writer = new FileWriter(this.file, StandardCharsets.UTF_8);){
                    this.properties.store(writer, String.format("Properties file for '%s'", this.name));
                    this.changed = false;
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "Can't save properties", ex);
                    throw new BackingStoreException(ex);
                }
            }
            finally {
                this.locker.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws BackingStoreException {
        this.locker.lock();
        try {
            try (FileReader reader = new FileReader(this.file, StandardCharsets.UTF_8);){
                this.properties.clear();
                this.properties.load(reader);
                this.changed = false;
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Can't load properties", ex);
                throw new BackingStoreException(ex);
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        this.preferenceChangeListeners.add(pcl);
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
        this.preferenceChangeListeners.remove(pcl);
    }

    @Override
    public void addNodeChangeListener(NodeChangeListener ncl) {
        this.nodeChangeListeners.add(ncl);
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener ncl) {
        this.nodeChangeListeners.remove(ncl);
    }

    @Override
    public void exportNode(OutputStream os) throws IOException {
        this.locker.lock();
        try {
            this.properties.store(os, String.format("Properties for '%s'", this.name));
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void exportSubtree(OutputStream os) {
    }
}

