/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.utils;

import java.util.Arrays;
import java.util.OptionalInt;

public final class IntMap {
    private final long[][] baskets;

    public IntMap(int capacity) {
        this.baskets = new long[capacity][];
    }

    public void put(int key, int value) {
        int basketIndex = key % this.baskets.length;
        long longKey = (long)key & 0xFFFFFFFFL;
        long[] kvPair = this.baskets[basketIndex];
        if (kvPair == null) {
            kvPair = new long[]{longKey << 32 | (long)value & 0xFFFFFFFFL};
            this.baskets[basketIndex] = kvPair;
        } else {
            boolean found = false;
            for (int i = 0; i < kvPair.length; ++i) {
                if (kvPair[i] >>> 32 != longKey) continue;
                found = true;
                kvPair[i] = longKey << 32 | (long)value & 0xFFFFFFFFL;
                break;
            }
            if (!found) {
                kvPair = Arrays.copyOf(kvPair, kvPair.length + 1);
                kvPair[kvPair.length - 1] = longKey << 32 | (long)value & 0xFFFFFFFFL;
                this.baskets[basketIndex] = kvPair;
            }
        }
    }

    public OptionalInt get(int key) {
        int basketIndex = key % this.baskets.length;
        long[] basket = this.baskets[basketIndex];
        if (basket != null) {
            long longKey = (long)key & 0xFFFFFFFFL;
            for (long kvPair : basket) {
                if (kvPair >>> 32 != longKey) continue;
                return OptionalInt.of((int)kvPair);
            }
        }
        return OptionalInt.empty();
    }

    public int size() {
        int result = 0;
        for (long[] b : this.baskets) {
            result += b == null ? 0 : b.length;
        }
        return result;
    }
}

