/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.utils;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class JHtmlLabel
extends JLabel {
    private static final long serialVersionUID = -166975925687523220L;
    private final transient List<LinkListener> linkListeners = new CopyOnWriteArrayList<LinkListener>();
    private transient List<HtmlLinkAddress> linkCache = null;
    private boolean showLinkAddressInToolTip = false;
    private int minClickCountToActivateLink = 1;

    public JHtmlLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        final JHtmlLabel theInstance = this;
        MouseAdapter mouseAdapter = new MouseAdapter(this){
            final /* synthetic */ JHtmlLabel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                String link = this.this$0.getLinkAtPosition(e.getPoint());
                if (link == null) {
                    if (this.this$0.showLinkAddressInToolTip) {
                        this.this$0.setToolTipText(null);
                    }
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                } else {
                    if (this.this$0.showLinkAddressInToolTip) {
                        this.this$0.setToolTipText(link);
                    }
                    this.this$0.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                String link;
                if (e.getClickCount() >= this.this$0.minClickCountToActivateLink && (link = this.this$0.getLinkAtPosition(e.getPoint())) != null) {
                    for (LinkListener l : this.this$0.linkListeners) {
                        l.onLinkActivated(theInstance, link);
                    }
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    public JHtmlLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public JHtmlLabel(String text) {
        this(text, null, 10);
    }

    public JHtmlLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public JHtmlLabel(Icon image) {
        this(null, image, 0);
    }

    public JHtmlLabel() {
        this("", null, 10);
    }

    public int getMinClickCountToActivateLink() {
        return this.minClickCountToActivateLink;
    }

    public void setMinClickCountToActivateLink(int clickNumber) {
        this.minClickCountToActivateLink = Math.max(1, clickNumber);
    }

    public boolean isShowLinkAddressInTooltip() {
        return this.showLinkAddressInToolTip;
    }

    public void setShowLinkAddressInTooltip(boolean flag) {
        if (this.showLinkAddressInToolTip && !flag) {
            this.setToolTipText(null);
        }
        this.showLinkAddressInToolTip = flag;
    }

    public void addLinkListener(LinkListener l) {
        this.linkListeners.add(l);
    }

    public void removeLinkListener(LinkListener l) {
        this.linkListeners.remove(l);
    }

    public void replaceMacroses(Properties properties) {
        String text = this.getText();
        for (String k : properties.stringPropertyNames()) {
            text = text.replace("${" + k + "}", properties.getProperty(k));
        }
        this.setText(text);
    }

    @Override
    public void setText(String text) {
        super.setText((String)(text.toLowerCase(Locale.ENGLISH).trim().startsWith("<html>") ? text : "<html>" + text + "</html>"));
        this.linkCache = null;
    }

    private void cacheLinkElements() {
        this.linkCache = new ArrayList<HtmlLinkAddress>();
        View view = (View)this.getClientProperty("html");
        if (view != null) {
            HTMLDocument doc = (HTMLDocument)view.getDocument();
            HTMLDocument.Iterator it = doc.getIterator(HTML.Tag.A);
            while (it.isValid()) {
                SimpleAttributeSet s = (SimpleAttributeSet)it.getAttributes();
                String link = (String)s.getAttribute(HTML.Attribute.HREF);
                if (link != null) {
                    this.linkCache.add(new HtmlLinkAddress(link, it.getStartOffset(), it.getEndOffset()));
                }
                it.next();
            }
        }
    }

    private String getLinkAtPosition(Point point) {
        if (this.linkCache == null) {
            this.cacheLinkElements();
        }
        JLabel.AccessibleJLabel accessibleJLabel = (JLabel.AccessibleJLabel)this.getAccessibleContext().getAccessibleComponent();
        int textIndex = accessibleJLabel.getIndexAtPoint(point);
        for (HtmlLinkAddress l : this.linkCache) {
            if (!l.checkPosition(textIndex)) continue;
            return l.getHREF();
        }
        return null;
    }

    private static final class HtmlLinkAddress {
        private final String address;
        private final int start;
        private final int end;

        HtmlLinkAddress(String address, int startOffset, int endOffset) {
            this.address = address;
            this.start = startOffset;
            this.end = endOffset;
        }

        String getHREF() {
            return this.address;
        }

        boolean checkPosition(int position) {
            return position >= this.start && position < this.end;
        }
    }

    public static interface LinkListener {
        public void onLinkActivated(JHtmlLabel var1, String var2);
    }
}

