/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.utils;

import java.time.Duration;
import java.util.concurrent.locks.LockSupport;

public final class Timer {
    private final long delay;
    private long start = 0L;
    private long timeout = -1L;
    private final long sleepDelay;

    public Timer(Duration delay) {
        this(delay, null);
    }

    public Timer(Duration delay, Duration sleepDelay) {
        this.delay = delay.toNanos();
        this.sleepDelay = sleepDelay == null ? -1L : sleepDelay.toNanos();
    }

    public void next(Duration delay) {
        this.start = System.nanoTime();
        this.timeout = this.start + delay.toNanos();
    }

    public void sleep() {
        long nanos;
        if (this.sleepDelay > 0L && (nanos = this.timeout - System.nanoTime()) > this.sleepDelay) {
            LockSupport.parkNanos(this.sleepDelay);
        }
    }

    public void next() {
        this.start = System.nanoTime();
        this.timeout = this.start + this.delay;
    }

    public boolean completed() {
        long current = System.nanoTime();
        return current <= this.start || current >= this.timeout;
    }
}

