/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.cmdline;

import com.igormaznitsa.zxpspritecorrector.components.VideoMode;
import com.igormaznitsa.zxpspritecorrector.utils.ZXPalette;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class SliceImageCmd {
    private static final Logger LOGGER = Logger.getLogger("Image-Slicer");

    public int process(String[] args) {
        if (args.length > 0) {
            String file = args[0];
            try {
                File imgFile = new File(file);
                BufferedImage img = this.loadARGBImage(imgFile);
                if (img.getWidth() == 256 && img.getHeight() == 192) {
                    this.processScreen256x192(imgFile, img);
                }
                if (img.getWidth() == 512 && img.getHeight() == 384) {
                    this.processScreen512x384(imgFile, img);
                }
                LOGGER.severe("Incompatible image resolution = " + img.getWidth() + "x" + img.getHeight());
                return 1;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 1;
            }
        } else {
            LOGGER.severe("Can't find file name to be sliced");
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage loadARGBImage(File file) throws IOException {
        BufferedImage result;
        BufferedImage loadedImage = ImageIO.read(file);
        if (loadedImage.getType() == 2) {
            result = loadedImage;
        } else {
            result = new BufferedImage(loadedImage.getWidth(), loadedImage.getHeight(), 2);
            Graphics2D gfx = result.createGraphics();
            try {
                gfx.drawImage((Image)loadedImage, 0, 0, null);
            }
            finally {
                gfx.dispose();
            }
        }
        return result;
    }

    public void processScreen512x384(File srcFile, BufferedImage image) throws IOException {
        LOGGER.info("Slicing image for 512x384");
        int pixelsNumber = 49152;
        int[] imgBufCpu0 = new int[49152];
        int[] imgBufCpu1 = new int[49152];
        int[] imgBufCpu2 = new int[49152];
        int[] imgBufCpu3 = new int[49152];
        byte[] dataCpu0 = new byte[6144];
        byte[] dataCpu1 = new byte[6144];
        byte[] dataCpu2 = new byte[6144];
        byte[] dataCpu3 = new byte[6144];
        int[] srcImageBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        byte[] attributesCpu0 = new byte[768];
        byte[] attributesCpu1 = new byte[768];
        byte[] attributesCpu2 = new byte[768];
        byte[] attributesCpu3 = new byte[768];
        int dstIndex = 0;
        for (int y = 0; y < 384; y += 2) {
            int yOffset = y * 512;
            for (int x = 0; x < 512; x += 2) {
                imgBufCpu0[dstIndex] = srcImageBuffer[x + yOffset];
                imgBufCpu1[dstIndex] = srcImageBuffer[x + yOffset + 1];
                imgBufCpu2[dstIndex] = srcImageBuffer[x + yOffset + 512];
                imgBufCpu3[dstIndex] = srcImageBuffer[x + yOffset + 512 + 1];
                ++dstIndex;
            }
        }
        for (int li = 0; li < 768; ++li) {
            attributesCpu0[li] = this.analyzeBlockForAttrib(li, imgBufCpu0, dataCpu0);
            attributesCpu1[li] = this.analyzeBlockForAttrib(li, imgBufCpu1, dataCpu1);
            attributesCpu2[li] = this.analyzeBlockForAttrib(li, imgBufCpu2, dataCpu2);
            attributesCpu3[li] = this.analyzeBlockForAttrib(li, imgBufCpu3, dataCpu3);
        }
        File outFolder = srcFile.getParentFile();
        FileUtils.writeByteArrayToFile(new File(outFolder, FilenameUtils.getBaseName(srcFile.getName()) + "c0.c0"), this.packZxScreen(dataCpu0, attributesCpu0));
        FileUtils.writeByteArrayToFile(new File(outFolder, FilenameUtils.getBaseName(srcFile.getName()) + "c1.c1"), this.packZxScreen(dataCpu1, attributesCpu1));
        FileUtils.writeByteArrayToFile(new File(outFolder, FilenameUtils.getBaseName(srcFile.getName()) + "c2.c2"), this.packZxScreen(dataCpu2, attributesCpu2));
        FileUtils.writeByteArrayToFile(new File(outFolder, FilenameUtils.getBaseName(srcFile.getName()) + "c3.c3"), this.packZxScreen(dataCpu3, attributesCpu3));
    }

    public byte analyzeBlockForAttrib(int attributeIndex, int[] nonInterlacedArgbArray, byte[] screenArray) {
        int i;
        int[] colorUse = new int[16];
        int attrX = attributeIndex % 32;
        int attrY = attributeIndex / 32;
        int offsetX = attrX * 8;
        int offsetY = attrY * 8;
        for (int y = 0; y < 8; ++y) {
            int pointOffset = (offsetY + y) * 256 + offsetX;
            for (int x = 0; x < 8; ++x) {
                int pixelArgb = nonInterlacedArgbArray[pointOffset + x];
                int colorIndex = (pixelArgb >>> 24 & 0xFF) < 127 ? 0 : ZXPalette.findNearestColorIndex(pixelArgb);
                nonInterlacedArgbArray[pointOffset + x] = colorIndex;
                int n = colorIndex;
                colorUse[n] = colorUse[n] + 1;
            }
        }
        int foregroundIndex = 0;
        int max = 0;
        int backgroundIndex = 0;
        for (i = 0; i < 16; ++i) {
            if (max >= colorUse[i]) continue;
            foregroundIndex = i;
            max = colorUse[i];
        }
        colorUse[foregroundIndex] = 0;
        max = 0;
        for (i = 0; i < 16; ++i) {
            if (max >= colorUse[i]) continue;
            backgroundIndex = i;
            max = colorUse[i];
        }
        int outScrArrayIndex = attrX + attrY * 8 * 32;
        for (int y = 0; y < 8; ++y) {
            int pointOffset = (offsetY + y) * 256 + offsetX;
            int bit = 1;
            boolean accum = false;
            for (int x = 0; x < 8; ++x) {
                int index = nonInterlacedArgbArray[pointOffset + x];
                if (index == foregroundIndex) {
                    accum |= bit;
                }
                bit <<= 1;
            }
            screenArray[outScrArrayIndex] = this.invertBitOrder((byte)(accum ? 1 : 0));
            outScrArrayIndex += 32;
        }
        boolean foregroundHiColor = foregroundIndex > 7;
        boolean backgroundHiColor = backgroundIndex > 7;
        boolean bright = backgroundHiColor || foregroundHiColor;
        int result = (bright ? 64 : 0) | (backgroundIndex & 7) << 3 | foregroundIndex & 7;
        return (byte)result;
    }

    public void processScreen256x192(File srcFile, BufferedImage srcArgbImage) throws IOException {
        LOGGER.info("Slicing image for 256x192x16");
        int totalPixels = 49152;
        byte[] planR = new byte[49152];
        byte[] planG = new byte[49152];
        byte[] planB = new byte[49152];
        byte[] planY = new byte[49152];
        int[] srcImageBuffer = ((DataBufferInt)srcArgbImage.getRaster().getDataBuffer()).getData();
        for (int pixelIndex = 0; pixelIndex < 49152; ++pixelIndex) {
            int argb = srcImageBuffer[pixelIndex];
            int alpha = argb >>> 24;
            if (alpha < 79) {
                planR[pixelIndex] = 0;
                planG[pixelIndex] = 0;
                planB[pixelIndex] = 0;
                planY[pixelIndex] = 0;
                continue;
            }
            int colorIndex = ZXPalette.findNearestColorIndex(argb);
            planR[pixelIndex] = (byte)(colorIndex & 2);
            planG[pixelIndex] = (byte)(colorIndex & 4);
            planB[pixelIndex] = (byte)(colorIndex & 1);
            planY[pixelIndex] = (byte)(colorIndex & 8);
        }
        File outFolder = srcFile.getParentFile();
        FileUtils.writeByteArrayToFile(new File(outFolder, FilenameUtils.getBaseName(srcFile.getName()) + "c1.c1"), this.packZxRester(planR));
        FileUtils.writeByteArrayToFile(new File(outFolder, FilenameUtils.getBaseName(srcFile.getName()) + "c0.c0"), this.packZxRester(planG));
        FileUtils.writeByteArrayToFile(new File(outFolder, FilenameUtils.getBaseName(srcFile.getName()) + "c2.c2"), this.packZxRester(planB));
        FileUtils.writeByteArrayToFile(new File(outFolder, FilenameUtils.getBaseName(srcFile.getName()) + "c3.c3"), this.packZxRester(planY));
    }

    private byte[] packZxScreen(byte[] raster, byte[] attributeArea) {
        int height = 192;
        byte[] result = new byte[6912];
        int dataY = 0;
        for (int y = 0; y < 192; ++y) {
            int offsety = VideoMode.y2zxy(y) * 32;
            for (int x = 0; x < 32; ++x) {
                result[offsety + x] = raster[dataY + x];
            }
            dataY += 32;
        }
        int addr = 6144;
        for (int i = 0; i < 768; ++i) {
            result[addr++] = attributeArea[i];
        }
        return result;
    }

    private byte[] packZxRester(byte[] pixelData) {
        int imageWidth = 256;
        int imageHeight = 192;
        int bytesPerLine = 32;
        byte[] result = new byte[6144];
        int posInSrc = 0;
        int initBit = 1;
        for (int y = 0; y < 192; ++y) {
            boolean acc = false;
            int bit = initBit;
            int posInDst = VideoMode.y2zxy(y) * 32;
            for (int x = 0; x < 256; ++x) {
                acc |= pixelData[posInSrc++] != 0 ? bit : 0;
                if ((bit <<= 1) <= 255) continue;
                result[posInDst++] = this.invertBitOrder((byte)(acc ? 1 : 0));
                bit = initBit;
                acc = false;
            }
            if (bit == initBit) continue;
            result[posInDst++] = this.invertBitOrder((byte)(acc ? 1 : 0));
        }
        return result;
    }

    private byte invertBitOrder(byte in) {
        int result = 0;
        int bit = 1;
        int bit2 = 128;
        while (bit2 != 0) {
            if ((in & bit) != 0) {
                result |= bit2;
            }
            bit2 >>>= 1;
            bit <<= 1;
        }
        return (byte)result;
    }
}

