/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;

public final class PenWidth
extends JPanel {
    private static final long serialVersionUID = -7662850701072499309L;
    private static final int ICON_WIDTH = 32;
    private static final int ICON_HEIGHT = 32;
    private final JSlider widthSlider;
    private final JLabel showLabel;
    private final BufferedImage showImage;
    private final AtomicReference<BoundedRangeModel> currentModel = new AtomicReference();
    private final ChangeListener changeListener;
    private final TitledBorder titledBorder = BorderFactory.createTitledBorder("---");

    public PenWidth() {
        this.changeListener = e -> this.drawImageForValue(((BoundedRangeModel)e.getSource()).getValue());
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.showImage = new BufferedImage(32, 32, 1);
        this.widthSlider = new JSlider();
        this.widthSlider.setMajorTickSpacing(10);
        this.widthSlider.setMinorTickSpacing(5);
        this.widthSlider.setSnapToTicks(false);
        this.showLabel = new JLabel(new ImageIcon(this.showImage));
        this.add((Component)this.showLabel, "Center");
        this.add((Component)this.widthSlider, "South");
        this.widthSlider.setSize(64, 10);
        this.widthSlider.setFocusable(false);
        this.setBorder(this.titledBorder);
        this.setSize(this.getPreferredSize());
        this.updateLookForCurrentModel();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public int getValue() {
        BoundedRangeModel model = this.currentModel.get();
        return model == null ? -1 : model.getValue();
    }

    protected void updateLookForCurrentModel() {
        BoundedRangeModel model = this.currentModel.get();
        if (model == null) {
            this.showLabel.setEnabled(false);
            this.widthSlider.setEnabled(false);
            this.drawImageForValue(-1);
        } else {
            this.showLabel.setEnabled(true);
            this.widthSlider.setEnabled(true);
            this.drawImageForValue(model.getValue());
        }
    }

    public void setModel(BoundedRangeModel model) {
        BoundedRangeModel prev = this.currentModel.getAndSet(model);
        if (prev != null) {
            prev.removeChangeListener(this.changeListener);
        }
        if (model == null) {
            this.widthSlider.setPaintTicks(false);
        } else {
            this.widthSlider.setModel(model);
            this.widthSlider.setPaintTicks(true);
            model.addChangeListener(this.changeListener);
        }
        this.updateLookForCurrentModel();
    }

    private void drawImageForValue(int newValue) {
        Graphics gfx = this.showImage.getGraphics();
        gfx.setColor(Color.white);
        gfx.fillRect(0, 0, 32, 32);
        if (newValue > 0) {
            this.titledBorder.setTitle("Width:" + newValue + " px");
            gfx.setColor(Color.black);
            gfx.fillRect((32 - newValue) / 2, (32 - newValue) / 2, newValue, newValue);
        } else {
            this.titledBorder.setTitle("Width:---");
        }
        gfx.dispose();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 110);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

