/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.components;

import com.igormaznitsa.zxpspritecorrector.utils.GfxUtils;
import com.igormaznitsa.zxpspritecorrector.utils.ZXPalette;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public final class ZXColorSelector
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = 4513035804817773772L;
    private final Image iconINK;
    private final Image iconPAINT;
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private final Dimension minSize;
    private int selectedInk = 0;
    private int selectedPaint = 15;

    public ZXColorSelector() {
        this.iconINK = GfxUtils.loadImage("ink.gif");
        this.iconPAINT = GfxUtils.loadImage("paint.gif");
        this.minSize = this.iconINK != null && this.iconPAINT != null ? new Dimension((Math.max(this.iconINK.getWidth(null), this.iconPAINT.getWidth(null)) + 5) * 8, this.iconINK.getHeight(null) + 5 + this.iconPAINT.getHeight(null)) : new Dimension(320, 40);
        this.addMouseListener(this);
    }

    public int getSelectedInk() {
        return this.selectedInk;
    }

    public int getSelectedPaint() {
        return this.selectedPaint;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minSize;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void paintComponent(Graphics gfx) {
        int fullwidth = this.getWidth();
        int fullheight = this.getHeight();
        int cellwidth = fullwidth / 8;
        int cellheight = fullheight / 2;
        if (cellwidth == 0 || cellheight == 0) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int indx = i;
            gfx.setColor(ZXPalette.COLORS[i]);
            int cellx = i * cellwidth;
            gfx.fillRect(cellx, 0, cellwidth, cellheight);
            if (indx == this.selectedInk && this.iconINK != null) {
                gfx.drawImage(this.iconINK, cellx, 0, null);
            }
            if (indx == this.selectedPaint && this.iconPAINT != null) {
                gfx.drawImage(this.iconPAINT, cellx + (cellwidth - this.iconPAINT.getWidth(null)), cellheight - this.iconPAINT.getHeight(null), null);
            }
            gfx.setColor(ZXPalette.COLORS[indx += 8]);
            gfx.fillRect(cellx, cellheight, cellwidth, cellheight);
            if (indx == this.selectedInk && this.iconINK != null) {
                gfx.drawImage(this.iconINK, cellx, cellheight, null);
            }
            if (indx != this.selectedPaint || this.iconPAINT == null) continue;
            gfx.drawImage(this.iconPAINT, cellx + (cellwidth - this.iconPAINT.getWidth(null)), cellheight + (cellheight - this.iconPAINT.getHeight(null)), null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        int cellwidth = width / 8;
        int cellheight = height / 2;
        int column = x / cellwidth;
        int row = y / cellheight;
        if (row < 0 || row > 1 || column < 0 || column > 7) {
            return;
        }
        switch (e.getButton()) {
            case 1: {
                this.selectedInk = row * 8 + column;
                this.repaint();
                this.actionListeners.forEach(p_listener -> p_listener.actionPerformed(new ActionEvent(this, 0, null)));
                break;
            }
            case 3: {
                this.selectedPaint = row * 8 + column;
                this.repaint();
                this.actionListeners.forEach(l -> l.actionPerformed(new ActionEvent(this, 0, null)));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void addActionListener(ActionListener l) {
        if (l != null) {
            this.actionListeners.add(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public void setInkIndex(int colorIndex) {
        this.selectedInk = colorIndex & 0xF;
        this.repaint();
    }

    public void setPaintIndex(int colorIndex) {
        this.selectedPaint = colorIndex & 0xF;
        this.repaint();
    }
}

