/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.components;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.utils.Function;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class ZXPolyData {
    public static final int ZXPOLY_0 = 0;
    public static final int ZXPOLY_1 = 1;
    public static final int ZXPOLY_2 = 2;
    public static final int ZXPOLY_3 = 3;
    private static final JBBPParser PARSER = JBBPParser.prepare("int pluginId;ushort infoLength;byte [infoLength] info;int length;byte [length] array;byte [length] mask;byte [length] zxpoly0;byte [length] zxpoly1;byte [length] zxpoly2;byte [length] zxpoly3;");
    private final byte[] basedata;
    private final byte[] mask;
    private final byte[][] zxpoly;
    private final AbstractFilePlugin basePlugin;
    private final Info info;

    public ZXPolyData(Info info, AbstractFilePlugin basePlugin, byte[] data, byte[] mask, byte[][] zxpolyPlanes) {
        if (data.length != mask.length) {
            throw new IllegalArgumentException("Mask array must have same size as data array: " + data.length + "!=" + mask.length);
        }
        this.basedata = (byte[])data.clone();
        this.mask = (byte[])mask.clone();
        this.zxpoly = new byte[4][];
        for (int i = 0; i < this.zxpoly.length; ++i) {
            if (this.basedata.length != zxpolyPlanes[i].length) {
                throw new IllegalArgumentException("Detected illegal size of ZXPoly plane: " + i + ", expected size " + this.basedata.length + " bytes");
            }
            this.zxpoly[i] = (byte[])zxpolyPlanes[i].clone();
        }
        this.info = info;
        this.basePlugin = basePlugin;
    }

    public ZXPolyData(Info info, AbstractFilePlugin basePlugin, byte[] array) {
        this(info, basePlugin, array, new byte[array.length], new byte[4][array.length]);
    }

    public ZXPolyData(InputStream in, List<AbstractFilePlugin> plugins) throws IOException {
        JBBPBitInputStream inStream = new JBBPBitInputStream(in);
        if (inStream.readLong(JBBPByteOrder.BIG_ENDIAN) != -6072265192773910237L) {
            throw new IOException("It is not a valid data block");
        }
        @Bin
        final class Parsed {
            int pluginId;
            byte[] info;
            byte[] array;
            byte[] mask;
            byte[] zxpoly0;
            byte[] zxpoly1;
            byte[] zxpoly2;
            byte[] zxpoly3;

            Parsed() {
            }
        }
        Parsed parsed = PARSER.parse(inStream).mapTo(new Parsed(), new Function[0]);
        this.info = new Info(new ByteArrayInputStream(parsed.info), true);
        this.basedata = parsed.array;
        this.mask = parsed.mask;
        this.zxpoly = new byte[4][];
        this.zxpoly[0] = parsed.zxpoly0;
        this.zxpoly[1] = parsed.zxpoly1;
        this.zxpoly[2] = parsed.zxpoly2;
        this.zxpoly[3] = parsed.zxpoly3;
        AbstractFilePlugin plugin = null;
        for (AbstractFilePlugin p : plugins) {
            if (parsed.pluginId != ZXPolyData.uid2int(p.getPluginUID())) continue;
            plugin = p;
            break;
        }
        if (plugin == null) {
            throw new IOException("Can't find a plugin for UID [" + parsed.pluginId + "]");
        }
        this.basePlugin = plugin;
    }

    private static int uid2int(String str) {
        if (str.length() != 4) {
            throw new IllegalArgumentException("Plugin UID must have 4 chars [" + str + "]");
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = result << 8 | str.charAt(i) & 0xFF;
        }
        return result;
    }

    public UndoBlock makeUndo(Rectangle selectedArea) {
        return new UndoBlock(selectedArea, this.mask, this.zxpoly);
    }

    public void restoreFromUndo(UndoBlock undo) {
        System.arraycopy(undo.mask, 0, this.mask, 0, undo.mask.length);
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(undo.zxpoly[i], 0, this.zxpoly[i], 0, undo.zxpoly[i].length);
        }
    }

    public byte[] getAsArray() throws IOException {
        byte[] packedInfo = this.info.save(JBBPOut.BeginBin()).End().toByteArray();
        return JBBPOut.BeginBin().Long(-6072265192773910237L).Int(ZXPolyData.uid2int(this.basePlugin.getPluginUID())).Short(packedInfo.length).Byte(packedInfo).Int(this.basedata.length).Byte(this.basedata).Byte(this.mask).Byte(this.zxpoly[0]).Byte(this.zxpoly[1]).Byte(this.zxpoly[2]).Byte(this.zxpoly[3]).End().toByteArray();
    }

    public Info getInfo() {
        return this.info;
    }

    public void setZXPolyData(int address, int mask, int zxpoly0, int zxpoly1, int zxpoly2, int zxpoly3) {
        this.zxpoly[0][address] = (byte)(zxpoly0 & mask);
        this.zxpoly[1][address] = (byte)(zxpoly1 & mask);
        this.zxpoly[2][address] = (byte)(zxpoly2 & mask);
        this.zxpoly[3][address] = (byte)(zxpoly3 & mask);
        this.mask[address] = (byte)mask;
    }

    public int getMask(int address) {
        return this.mask[address] & 0xFF;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public int getPackedZxPolyData3012(int address) {
        return (this.zxpoly[3][address] & 0xFF) << 24 | (this.zxpoly[0][address] & 0xFF) << 16 | (this.zxpoly[1][address] & 0xFF) << 8 | this.zxpoly[2][address] & 0xFF;
    }

    public int getBaseData(int address) {
        return this.basedata[address] & 0xFF;
    }

    public byte[] getBaseData() {
        return this.basedata;
    }

    public byte[] getDataForCPU(int cpuIndex) {
        byte[] result = (byte[])this.zxpoly[cpuIndex].clone();
        for (int i = 0; i < this.basedata.length; ++i) {
            byte maskdata = this.mask[i];
            byte basedata = this.basedata[i];
            result[i] = maskdata == 0 ? basedata : (byte)(basedata & ~maskdata | result[i] & maskdata);
        }
        return result;
    }

    public AbstractFilePlugin getPlugin() {
        return this.basePlugin;
    }

    public void clear() {
        Arrays.fill(this.mask, (byte)0);
        for (byte[] b : this.zxpoly) {
            Arrays.fill(b, (byte)0);
        }
    }

    public int length() {
        return this.basedata.length;
    }

    public void copyPlansFromBase() {
        for (byte[] plane : this.zxpoly) {
            System.arraycopy(this.basedata, 0, plane, 0, this.basedata.length);
        }
        Arrays.fill(this.mask, (byte)-1);
    }

    public static class UndoBlock {
        private final Rectangle selectedArea;
        private final byte[] mask;
        private final byte[][] zxpoly;

        private UndoBlock(Rectangle selectedArea, byte[] mask, byte[][] zxpoly) {
            this.selectedArea = selectedArea == null ? null : new Rectangle(selectedArea);
            this.mask = (byte[])mask.clone();
            this.zxpoly = new byte[4][];
            for (int i = 0; i < 4; ++i) {
                this.zxpoly[i] = (byte[])zxpoly[i].clone();
            }
        }

        public Rectangle getSelectedArea() {
            return this.selectedArea;
        }
    }
}

