/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.zxpspritecorrector.components.EditorComponent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class SessionData {
    private final int baseAddress;
    private final boolean showGrid;
    private final boolean showColumns;
    private final int columnNumber;
    private final boolean zxAddressing;
    private final boolean invertBase;
    private final boolean mode512x384;
    private final int zoom;
    private final EditorComponent.AttributeMode attributeMode;
    private final Properties extraProperties;

    public SessionData(int baseAddress, boolean showGrid, boolean showColumns, boolean zxAddressing, boolean invertBase, boolean mode512x384, int columnNumber, EditorComponent.AttributeMode attributeMode, int zoom) {
        this.baseAddress = baseAddress;
        this.showGrid = showGrid;
        this.showColumns = showColumns;
        this.zxAddressing = zxAddressing;
        this.invertBase = invertBase;
        this.mode512x384 = mode512x384;
        this.columnNumber = columnNumber;
        this.attributeMode = attributeMode;
        this.zoom = zoom;
        this.extraProperties = new Properties();
    }

    public SessionData(JBBPBitInputStream inStream) throws IOException {
        this.baseAddress = inStream.readInt(JBBPByteOrder.BIG_ENDIAN);
        this.showGrid = inStream.readBoolean();
        this.showColumns = inStream.readBoolean();
        this.zxAddressing = inStream.readBoolean();
        this.invertBase = inStream.readBoolean();
        this.mode512x384 = inStream.readBoolean();
        this.columnNumber = inStream.readInt(JBBPByteOrder.BIG_ENDIAN);
        this.attributeMode = EditorComponent.AttributeMode.values()[inStream.readInt(JBBPByteOrder.BIG_ENDIAN)];
        this.zoom = inStream.readInt(JBBPByteOrder.BIG_ENDIAN);
        this.extraProperties = new Properties();
        if (inStream.hasAvailableData()) {
            int extraDataLength = inStream.readInt(JBBPByteOrder.BIG_ENDIAN);
            byte[] propertyData = inStream.readByteArray(extraDataLength);
            Properties properties = new Properties();
            properties.load(new StringReader(new String(propertyData, StandardCharsets.UTF_8)));
            properties.stringPropertyNames().forEach(name -> this.extraProperties.put(name, properties.getProperty((String)name)));
        }
    }

    public SessionData(EditorComponent editor) {
        this.baseAddress = editor.getAddress();
        this.showGrid = editor.isShowGrid();
        this.showColumns = editor.isShowColumnBorders();
        this.columnNumber = editor.getColumns();
        this.zxAddressing = editor.isZXScreenMode();
        this.attributeMode = editor.getShowAttributes();
        this.invertBase = editor.isInvertShowBaseData();
        this.mode512x384 = editor.isMode512();
        this.zoom = editor.getZoom();
        this.extraProperties = new Properties();
    }

    public String getExtraProperty(String propertyName) {
        return this.extraProperties.getProperty(propertyName);
    }

    public void setExtraProperty(String propertyName, String value) {
        if (value == null) {
            this.extraProperties.remove(propertyName);
        } else {
            this.extraProperties.setProperty(propertyName, value);
        }
    }

    public int getBaseAddress() {
        return this.baseAddress;
    }

    public int getZoom() {
        return this.zoom;
    }

    public boolean isInvertBaseShow() {
        return this.invertBase;
    }

    public boolean is512Mode() {
        return this.mode512x384;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public boolean isShowColumns() {
        return this.showColumns;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean isZXAddressing() {
        return this.zxAddressing;
    }

    public EditorComponent.AttributeMode getAttributeMode() {
        return this.attributeMode;
    }

    public void fill(EditorComponent editor) {
        editor.setAddress(this.baseAddress);
        editor.setShowGrid(this.showGrid);
        editor.setShowColumnBorders(this.showColumns);
        editor.setColumns(this.columnNumber);
        editor.setZXScreenMode(this.zxAddressing);
        editor.setShowAttributes(this.attributeMode);
        editor.setZoom(this.zoom);
    }

    public byte[] makeArray() throws IOException {
        StringWriter writer = new StringWriter();
        this.extraProperties.store(writer, null);
        byte[] extraPropertiesData = writer.toString().getBytes(StandardCharsets.UTF_8);
        return JBBPOut.BeginBin().Int(this.baseAddress).Bool(this.showGrid, this.showColumns, this.zxAddressing, this.invertBase, this.mode512x384).Int(this.columnNumber, this.attributeMode.ordinal(), this.zoom).Int(extraPropertiesData.length).Byte(extraPropertiesData).End().toByteArray();
    }
}

