/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class Z80ExportDialog
extends JDialog {
    private static final long serialVersionUID = -6509497729159482088L;
    private static final VideoMode[] VIDEO_MODES = new VideoMode[]{new VideoMode("ZX 256x192 (src CPU0)", 0), new VideoMode("ZX 256x192 (src CPU1)", 1), new VideoMode("ZX 256x192 (src CPU2)", 2), new VideoMode("ZX 256x192 (src CPU3)", 3), new VideoMode("ZX-POLY 256x192", 4), new VideoMode("ZX-POLY 256x192-INKPAPER-MASK", 6), new VideoMode("ZX-POLY 512x384", 5), new VideoMode("ZX-POLY 256x192-FLASH-MASK", 7)};
    private boolean accepted;
    private int videoMode;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JComboBox comboVideoMode;
    private JLabel labelVideoMode;

    public Z80ExportDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.comboVideoMode.removeAllItems();
        for (VideoMode s : VIDEO_MODES) {
            this.comboVideoMode.addItem(s);
        }
        this.comboVideoMode.setSelectedIndex(4);
        this.setLocationRelativeTo(parent);
    }

    public int getVideoMode() {
        return this.videoMode;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    private void initComponents() {
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.labelVideoMode = new JLabel();
        this.comboVideoMode = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Options for ZX-Poly snapshot");
        this.buttonCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/igormaznitsa/zxpspritecorrector/icons/cross.png")));
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(this::buttonCancelActionPerformed);
        this.buttonOk.setIcon(new ImageIcon(this.getClass().getResource("/com/igormaznitsa/zxpspritecorrector/icons/tick.png")));
        this.buttonOk.setText("Ok");
        this.buttonOk.addActionListener(this::buttonOkActionPerformed);
        this.labelVideoMode.setText("Initial video mode:");
        this.comboVideoMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 202, Short.MAX_VALUE).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.labelVideoMode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboVideoMode, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.buttonCancel, this.buttonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelVideoMode).addComponent(this.comboVideoMode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.accepted = false;
        this.setVisible(false);
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.accepted = true;
        this.videoMode = ((VideoMode)this.comboVideoMode.getSelectedItem()).code;
        this.setVisible(false);
    }

    private static final class VideoMode {
        private final String name;
        private final int code;

        private VideoMode(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String toString() {
            return this.name;
        }
    }
}

