/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.zxpspritecorrector.SpriteCorrectorMainFrame;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.picocontainer.annotations.Inject;

public abstract class AbstractFilePlugin
extends FileFilter {
    @Inject
    protected SpriteCorrectorMainFrame spriteCorrectorMainFrame;

    protected static String prepareNameForTRD(String name, int index) {
        Object prepared = name.length() >= 8 ? name.substring(0, 7) : name + "_______".substring(0, 7 - name.length());
        return (String)prepared + index;
    }

    protected static String addNumberToFileName(String name, int number) {
        String base = FilenameUtils.getBaseName(name);
        String ext = FilenameUtils.getExtension(name);
        return base + number + "." + ext;
    }

    protected static String prepareNameForTAP(String name, int index) {
        Object prepared = name.length() >= 10 ? name.substring(0, 9) : name + "_________".substring(0, 9 - name.length());
        return (String)prepared + index;
    }

    public boolean isImportable() {
        return true;
    }

    public boolean isExportable() {
        return true;
    }

    public abstract String getToolTip(boolean var1);

    public abstract boolean doesContainInternalFileItems();

    public abstract FileFilter getImportFileFilter();

    public abstract FileFilter getExportFileFilter();

    public abstract String getPluginDescription(boolean var1);

    public String getImportingFileInfo(File file) {
        return "";
    }

    public abstract String getPluginUID();

    public abstract List<Info> getImportingContainerFileList(File var1);

    public abstract String getExtension(boolean var1);

    public abstract ReadResult readFrom(String var1, byte[] var2, int var3) throws IOException;

    public abstract void writeTo(File var1, ZXPolyData var2, SessionData var3, Object ... var4) throws IOException;

    protected boolean saveDataToFile(File file, byte[] data) throws IOException {
        if (file.isFile()) {
            switch (JOptionPane.showConfirmDialog(this.spriteCorrectorMainFrame, "Overwrite file '" + file.getAbsolutePath() + "'?", "Overwrite file", 1)) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        }
        FileUtils.writeByteArrayToFile(file, data);
        return true;
    }

    public static final class ReadResult {
        private final ZXPolyData data;
        private final SessionData session;

        public ReadResult(ZXPolyData data, SessionData session) {
            this.data = data;
            this.session = session;
        }

        public ZXPolyData getData() {
            return this.data;
        }

        public SessionData getSessionData() {
            return this.session;
        }
    }
}

