/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.utils.Function;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.FileNameDialog;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class HOBETAPlugin
extends AbstractFilePlugin {
    private static final String DESCRIPTION = "Hobeta file";
    public static final JBBPParser HOBETA_FILE_PARSER = JBBPParser.prepare("byte [8] name; byte type; <ushort start; <ushort length; skip; ubyte sectors; <ushort checksum; byte [_] data;");

    private static byte[] ensureHobetaName(String name) {
        byte[] result = new byte[8];
        Arrays.fill(result, (byte)32);
        for (int i = 0; i < Math.min(8, name.length()); ++i) {
            result[i] = (byte)name.charAt(i);
        }
        return result;
    }

    @Override
    public String getPluginUID() {
        return "HBTA";
    }

    @Override
    public String getToolTip(boolean forExport) {
        return "Single file extracted from a TR-Dos disk";
    }

    @Override
    public List<Info> getImportingContainerFileList(File file) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getImportingFileInfo(File file) {
        String string;
        Closeable in = null;
        try {
            StringBuilder result = new StringBuilder();
            Hobeta hobeta = HOBETA_FILE_PARSER.parse(new FileInputStream(file)).mapTo(new Hobeta(), new Function[0]);
            result.append("     Name:").append(hobeta.name).append("  ").append('\n');
            result.append("     Type:").append((char)hobeta.type).append("  ").append('\n');
            result.append("    Start:").append(hobeta.start).append("  ").append('\n');
            result.append("   Length:").append(hobeta.length).append(" bytes").append("  ").append('\n');
            result.append("  Sectors:").append(hobeta.sectors).append(" sectors").append("  ");
            string = result.toString();
        }
        catch (Throwable throwable) {
            try {
                JBBPUtils.closeQuietly(in);
                throw throwable;
            }
            catch (Exception ex) {
                return null;
            }
        }
        JBBPUtils.closeQuietly(in);
        return string;
    }

    @Override
    public AbstractFilePlugin.ReadResult readFrom(String name, byte[] data, int index) throws IOException {
        Hobeta parsed = HOBETA_FILE_PARSER.parse(data).mapTo(new Hobeta(), new Function[0]);
        return new AbstractFilePlugin.ReadResult(new ZXPolyData(new Info(parsed.name, (char)(parsed.type & 0xFF), parsed.start, parsed.length, 0, true, new byte[0]), this, parsed.data), null);
    }

    @Override
    public String getPluginDescription(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public void writeTo(File file, ZXPolyData data, SessionData session, Object ... extraData) throws IOException {
        File dir = file.getParentFile();
        char zxType = data.getInfo().getType();
        Object name = file.getName();
        if (FilenameUtils.getExtension((String)name).isEmpty()) {
            name = (String)name + ".$" + zxType;
        }
        String zxName = data.getInfo().getName();
        FileNameDialog nameDialog = new FileNameDialog(this.spriteCorrectorMainFrame, "Base file name is " + file.getName(), new String[]{HOBETAPlugin.addNumberToFileName((String)name, 0), HOBETAPlugin.addNumberToFileName((String)name, 1), HOBETAPlugin.addNumberToFileName((String)name, 2), HOBETAPlugin.addNumberToFileName((String)name, 3)}, new String[]{HOBETAPlugin.prepareNameForTRD(zxName, 0), HOBETAPlugin.prepareNameForTRD(zxName, 1), HOBETAPlugin.prepareNameForTRD(zxName, 2), HOBETAPlugin.prepareNameForTRD(zxName, 3)}, new char[]{zxType, zxType, zxType, zxType});
        nameDialog.setVisible(true);
        if (nameDialog.approved()) {
            File savingfile;
            String[] fileNames = nameDialog.getFileName();
            String[] zxNames = nameDialog.getZxName();
            Character[] types = nameDialog.getZxType();
            for (int i = 0; i < 4 && this.writeDataBlockAsHobeta(savingfile = new File(dir, fileNames[i]), zxNames[i], (byte)types[i].charValue(), data.getInfo().getStartAddress(), data.getDataForCPU(i)); ++i) {
            }
        }
    }

    @Override
    public FileFilter getImportFileFilter() {
        return this;
    }

    @Override
    public FileFilter getExportFileFilter() {
        return null;
    }

    @Override
    public String getExtension(boolean forExport) {
        return null;
    }

    private int makeCRC(byte[] array) {
        int crc = 0;
        for (int i = 0; i < array.length; ++i) {
            crc = crc + (array[i] & 0xFF) * 257 + i;
        }
        return crc;
    }

    @Override
    public boolean doesContainInternalFileItems() {
        return false;
    }

    private boolean writeDataBlockAsHobeta(File file, String name, byte type, int start, byte[] data) throws IOException {
        byte[] header = JBBPOut.BeginBin().ByteOrder(JBBPByteOrder.LITTLE_ENDIAN).Byte(HOBETAPlugin.ensureHobetaName(name)).Byte((int)type).Short(start).Short(data.length).ByteOrder(JBBPByteOrder.BIG_ENDIAN).Short(Math.max(1, data.length / 256 + ((data.length & 0xFF) == 0 ? 0 : 1))).End().toByteArray();
        byte[] full = JBBPOut.BeginBin().ByteOrder(JBBPByteOrder.LITTLE_ENDIAN).Byte(header).Short(this.makeCRC(header)).Byte(data).End().toByteArray();
        return this.saveDataToFile(file, full);
    }

    @Override
    public boolean accept(File pathname) {
        return pathname != null && (pathname.isDirectory() || pathname.getName().lastIndexOf(".$") == pathname.getName().length() - 3);
    }

    @Override
    public String getDescription() {
        return "Hobeta file (*.$?)";
    }

    public static final class Hobeta {
        @Bin(type=BinType.BYTE_ARRAY)
        public String name;
        @Bin(type=BinType.BYTE)
        public byte type;
        @Bin(type=BinType.USHORT)
        public int start;
        @Bin(type=BinType.USHORT)
        public int length;
        @Bin(type=BinType.UBYTE)
        public int sectors;
        @Bin(type=BinType.USHORT)
        public int checksum;
        @Bin
        public byte[] data;
    }
}

