/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.FileNameDialog;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class SCRPlugin
extends AbstractFilePlugin {
    private static final String DESCRIPTION = "ZX 256x192 screen";

    @Override
    public String getPluginUID() {
        return "SCRP";
    }

    @Override
    public String getToolTip(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public boolean doesContainInternalFileItems() {
        return false;
    }

    @Override
    public List<Info> getImportingContainerFileList(File file) {
        return null;
    }

    @Override
    public String getImportingFileInfo(File file) {
        return "  ZX-Spectrum screen  \n  256x192  ";
    }

    @Override
    public AbstractFilePlugin.ReadResult readFrom(String name, byte[] dataArray, int index) throws IOException {
        return new AbstractFilePlugin.ReadResult(new ZXPolyData(new Info(name, '$', 16384, dataArray.length, 0, true, new byte[0]), this, dataArray), null);
    }

    @Override
    public void writeTo(File file, ZXPolyData data, SessionData sessionData, Object ... extraData) throws IOException {
        FileNameDialog dialog = new FileNameDialog(this.spriteCorrectorMainFrame, "Base file name is " + file.getName(), FileNameDialog.makeFileNames(file.getName()), null, null);
        dialog.setVisible(true);
        if (dialog.approved()) {
            File newfile;
            String fileName;
            String[] fileNames = dialog.getFileName();
            for (int i = 0; i < fileNames.length && ((fileName = fileNames[i]) == null || this.saveDataToFile(newfile = new File(file.getParentFile(), fileName), data.getDataForCPU(i))); ++i) {
            }
        }
    }

    @Override
    public boolean accept(File pathname) {
        return pathname != null && (pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".scr"));
    }

    @Override
    public FileFilter getImportFileFilter() {
        return this;
    }

    @Override
    public FileFilter getExportFileFilter() {
        return this;
    }

    @Override
    public String getExtension(boolean forExport) {
        return "scr";
    }

    @Override
    public String getDescription() {
        return "ZX 256x192 screen (*.SCR)";
    }

    @Override
    public String getPluginDescription(boolean forExport) {
        return DESCRIPTION;
    }
}

