/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.jbbp.utils.Function;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import com.igormaznitsa.zxpspritecorrector.files.plugins.Z80InZXPOutPlugin;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class Spec256ZipPlugin
extends AbstractFilePlugin {
    private static final String DESCRIPTION = "Spec256 container";
    public static final int[] ARGB_PALETTE_ZXPOLY = new int[]{-16777216, -16777056, -6291456, -6291296, -16736256, -16736096, -6250496, -6250336, -16777216, -16776961, -65536, -65281, -16711936, -16711681, -256, -1};
    private static final int[] PALETTE_ARGB_SPEC256 = Spec256ZipPlugin.readSpec256RawPalette();
    private static final byte[] MAP_ZXPOLY2SPEC256INDEX = Spec256ZipPlugin.makePaletteMap(PALETTE_ARGB_SPEC256);

    private static byte[] getPhysicalCpuPage(int cpu, int page, ZXPolyData data) {
        byte[] bankData = new byte[16384];
        System.arraycopy(data.getDataForCPU(cpu), page * 16384, bankData, 0, 16384);
        return bankData;
    }

    private static byte[] getPhysicalMaskPage(int page, ZXPolyData data) {
        byte[] maskData = new byte[16384];
        System.arraycopy(data.getMask(), page * 16384, maskData, 0, 16384);
        return maskData;
    }

    private static byte[] getPhysicalBasePage(int page, ZXPolyData data) {
        byte[] baseData = new byte[16384];
        System.arraycopy(data.getBaseData(), page * 16384, baseData, 0, 16384);
        return baseData;
    }

    private static byte findClosestSpec256PaletteIndex(int argbColor, int[] argbPalette, int minIndexIncl, int maxIndexExcl) {
        int r = argbColor >>> 16 & 0xFF;
        int g = argbColor >>> 8 & 0xFF;
        int b = argbColor & 0xFF;
        double curDistance = Double.MAX_VALUE;
        int lastIndex = minIndexIncl;
        for (int i = minIndexIncl; i < maxIndexExcl; ++i) {
            int ir = argbPalette[i] >>> 16 & 0xFF;
            double dr = r - ir;
            int ig = argbPalette[i] >>> 8 & 0xFF;
            double dg = g - ig;
            int ib = argbPalette[i] & 0xFF;
            double db = b - ib;
            double distance = Math.sqrt(dr * dr + dg * dg + db * db);
            if (!(distance < curDistance)) continue;
            lastIndex = i;
            curDistance = distance;
        }
        return (byte)lastIndex;
    }

    private static byte[] makePaletteMap(int[] argbSpec256Palette) {
        byte[] result = new byte[ARGB_PALETTE_ZXPOLY.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Spec256ZipPlugin.findClosestSpec256PaletteIndex(ARGB_PALETTE_ZXPOLY[i], argbSpec256Palette, 1, 254);
        }
        return result;
    }

    private static String colorToHtml(int argb) {
        String r = Integer.toHexString(argb >>> 16 & 0xFF).toUpperCase(Locale.ENGLISH);
        String g = Integer.toHexString(argb >>> 8 & 0xFF).toUpperCase(Locale.ENGLISH);
        String b = Integer.toHexString(argb & 0xFF).toUpperCase(Locale.ENGLISH);
        return "#" + (r.length() < 2 ? "0" : "") + r + (g.length() < 2 ? "0" : "") + g + (b.length() < 2 ? "0" : "") + b;
    }

    private static String paletteAsHtml(int[] argbPalette) {
        StringBuilder result = new StringBuilder();
        result.append("<html><body><table>");
        for (int i = 0; i < argbPalette.length; ++i) {
            result.append("<tr>");
            result.append("<th><b>  ").append(i).append("  </b></th>");
            result.append("<th>").append(Spec256ZipPlugin.colorToHtml(argbPalette[i])).append("</th>");
            result.append("<th style=\"width:50%;background-color:").append(Spec256ZipPlugin.colorToHtml(argbPalette[i])).append("\">").append("                ").append("</th>");
            result.append("</tr>");
        }
        result.append("</table></body></html>");
        return result.toString();
    }

    private static int[] readSpec256RawPalette() {
        int[] nArray;
        block10: {
            InputStream in = Spec256ZipPlugin.class.getResourceAsStream("/spec256.pal");
            try {
                int[] result = new int[256];
                for (int i = 0; i < 256; ++i) {
                    int red = in.read();
                    int green = in.read();
                    int blue = in.read();
                    if (red < 0 || green < 0 || blue < 0) {
                        throw new EOFException();
                    }
                    result[i] = 0xFF000000 | red << 16 | green << 8 | blue;
                }
                nArray = result;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
            }
            in.close();
        }
        return nArray;
    }

    private static byte[] makeSpec256Data(byte cpu0, byte cpu1, byte cpu2, byte cpu3, byte baseData, byte maskData) {
        byte[] bankBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int zxPolyColorIndex;
            int bitMask = 1 << i;
            bankBytes[i] = (maskData & bitMask) == 0 ? ((baseData & bitMask) == 0 ? 0 : -1) : ((zxPolyColorIndex = ((cpu3 & bitMask) == 0 ? 0 : 8) | ((cpu0 & bitMask) == 0 ? 0 : 4) | ((cpu1 & bitMask) == 0 ? 0 : 2) | ((cpu2 & bitMask) == 0 ? 0 : 1)) == 0 ? 0 : (zxPolyColorIndex == 15 ? -1 : MAP_ZXPOLY2SPEC256INDEX[zxPolyColorIndex]));
        }
        return bankBytes;
    }

    @Override
    public boolean isImportable() {
        return false;
    }

    @Override
    public String getToolTip(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public boolean doesContainInternalFileItems() {
        return false;
    }

    @Override
    public FileFilter getImportFileFilter() {
        return this;
    }

    @Override
    public FileFilter getExportFileFilter() {
        return this;
    }

    @Override
    public String getPluginDescription(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public String getPluginUID() {
        return "S2ZP";
    }

    @Override
    public List<Info> getImportingContainerFileList(File file) {
        return Collections.emptyList();
    }

    @Override
    public String getExtension(boolean forExport) {
        return "zip";
    }

    @Override
    public AbstractFilePlugin.ReadResult readFrom(String name, byte[] data, int index) throws IOException {
        throw new IOException("Reading is unsupported");
    }

    @Override
    public void writeTo(File file, ZXPolyData data, SessionData sessionData, Object ... extraObjects) throws IOException {
        byte[] mainGfxData;
        int port7ffd;
        boolean snaIn48;
        byte[] bankIndexes;
        int banksInExtra;
        if (!(data.getPlugin() instanceof Z80InZXPOutPlugin)) {
            throw new IOException("Only imported Z80 snapshot can be exported");
        }
        byte[] extraData = data.getInfo().getExtra();
        if (extraData[0] == 0) {
            banksInExtra = 0;
            bankIndexes = new byte[]{8, 4, 5};
        } else {
            bankIndexes = new byte[extraData[0] & 0xFF];
            banksInExtra = bankIndexes.length;
            System.arraycopy(extraData, 1, bankIndexes, 0, bankIndexes.length);
        }
        byte[] z80header = Arrays.copyOfRange(extraData, banksInExtra + 1, extraData.length);
        int version = Z80InZXPOutPlugin.getVersion(z80header);
        Z80InZXPOutPlugin.Z80MainHeader mheader = Z80InZXPOutPlugin.Z80_MAINPART.parse(z80header).mapTo(new Z80InZXPOutPlugin.Z80MainHeader(), new Function[0]);
        int regPc = version == 0 ? mheader.reg_pc : (z80header[32] & 0xFF) << 8 | z80header[33] & 0xFF;
        byte[] pageIndexes = Z80InZXPOutPlugin.convertZ80BankIndexesToPages(bankIndexes, Z80InZXPOutPlugin.is48k(version, z80header), version);
        boolean orig48 = Z80InZXPOutPlugin.is48k(version, z80header);
        boolean bl = snaIn48 = orig48 && mheader.reg_sp > 16384;
        if (version == 0) {
            port7ffd = 48;
        } else {
            byte hwmode = z80header[34];
            switch (version) {
                case 1: {
                    if (hwmode == 3 || hwmode == 4) {
                        port7ffd = z80header[35] & 0xFF;
                        break;
                    }
                    port7ffd = 48;
                    break;
                }
                case 2: 
                case 3: {
                    if (hwmode == 4 || hwmode == 5 || hwmode == 6) {
                        port7ffd = z80header[35] & 0xFF;
                        break;
                    }
                    port7ffd = 48;
                    break;
                }
                default: {
                    port7ffd = 48;
                }
            }
        }
        ArrayList<GfxPage> extraGfxPages = new ArrayList<GfxPage>();
        JBBPOut mainSnapshotOut = JBBPOut.BeginBin().Byte(this.makeSnaHeaderFromZ80Header(mheader, snaIn48));
        if (snaIn48) {
            JBBPOut ram = JBBPOut.BeginBin();
            for (int page = 0; page < 3; ++page) {
                ram.Byte(Spec256ZipPlugin.getPhysicalBasePage(page, data));
            }
            byte[] ramField = ram.End().toByteArray();
            int spAddr = mheader.reg_sp;
            ramField[--spAddr - 16384] = (byte)(regPc >>> 8);
            ramField[--spAddr - 16384] = (byte)regPc;
            mainSnapshotOut.Byte(ramField);
            mainGfxData = this.makeGfx(data, 0, 1, 2);
        } else {
            if (orig48) {
                for (int page = 0; page < 3; ++page) {
                    mainSnapshotOut.Byte(Spec256ZipPlugin.getPhysicalBasePage(page, data));
                }
                mainGfxData = this.makeGfx(data, 0, 1, 2);
            } else {
                mainSnapshotOut.Byte(Spec256ZipPlugin.getPhysicalBasePage(5, data));
                mainSnapshotOut.Byte(Spec256ZipPlugin.getPhysicalBasePage(2, data));
                mainSnapshotOut.Byte(Spec256ZipPlugin.getPhysicalBasePage(port7ffd & 7, data));
                mainGfxData = this.makeGfx(data, 5, 2, port7ffd & 7);
            }
            mainSnapshotOut.Short(regPc).Byte(port7ffd).Byte(0);
            if (orig48) {
                byte[] fakePage = new byte[16384];
                for (int i = 0; i < 5; ++i) {
                    mainSnapshotOut.Byte(fakePage);
                }
            } else {
                for (int n : pageIndexes) {
                    if (n == 2 || n == 5 || n == (port7ffd & 7)) continue;
                    mainSnapshotOut.Byte(Spec256ZipPlugin.getPhysicalBasePage(n, data));
                    extraGfxPages.add(new GfxPage(n, this.makeGfx(data, n)));
                }
            }
            if (!orig48 && extraGfxPages.stream().noneMatch(x -> x.index == 0)) {
                extraGfxPages.add(new GfxPage(0, this.makeGfx(data, 0)));
            }
        }
        this.saveSpec256Zip(file, mainSnapshotOut.End().toByteArray(), mainGfxData, (Properties)extraObjects[0], extraGfxPages);
    }

    private byte[] makeGfx(ZXPolyData data, int ... pageIndexes) throws IOException {
        JBBPOut result = JBBPOut.BeginBin();
        for (int page : pageIndexes) {
            byte[] pageMask = Spec256ZipPlugin.getPhysicalMaskPage(page, data);
            byte[] baseData = Spec256ZipPlugin.getPhysicalBasePage(page, data);
            byte[] cpuData0 = Spec256ZipPlugin.getPhysicalCpuPage(0, page, data);
            byte[] cpuData1 = Spec256ZipPlugin.getPhysicalCpuPage(1, page, data);
            byte[] cpuData2 = Spec256ZipPlugin.getPhysicalCpuPage(2, page, data);
            byte[] cpuData3 = Spec256ZipPlugin.getPhysicalCpuPage(3, page, data);
            for (int offsetInPage = 0; offsetInPage < 16384; ++offsetInPage) {
                result.Byte(Spec256ZipPlugin.makeSpec256Data(cpuData0[offsetInPage], cpuData1[offsetInPage], cpuData2[offsetInPage], cpuData3[offsetInPage], baseData[offsetInPage], pageMask[offsetInPage]));
            }
        }
        return result.End().toByteArray();
    }

    private void saveSpec256Zip(File file, byte[] snaData, byte[] gfxData, Properties configProperties, List<GfxPage> gfxPages) throws IOException {
        String name = FilenameUtils.getBaseName(file.getName()).toUpperCase(Locale.ENGLISH);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));){
            ZipEntry snaEntry = new ZipEntry(name + ".SNA");
            zos.putNextEntry(snaEntry);
            zos.write(snaData);
            zos.closeEntry();
            ZipEntry gfxEntry = new ZipEntry(name + ".GFX");
            zos.putNextEntry(gfxEntry);
            zos.write(gfxData);
            zos.closeEntry();
            ZipEntry cfgEntry = new ZipEntry(name + ".CFG");
            zos.putNextEntry(cfgEntry);
            StringWriter writer = new StringWriter();
            configProperties.stringPropertyNames().forEach(propName -> writer.append((CharSequence)propName).append(String.valueOf('=')).append(configProperties.getProperty((String)propName)).append(String.valueOf('\n')));
            zos.write(writer.toString().getBytes(StandardCharsets.UTF_8));
            zos.closeEntry();
            for (GfxPage page : gfxPages) {
                ZipEntry pageEntry = new ZipEntry(name + ".GF" + page.index);
                zos.putNextEntry(pageEntry);
                zos.write(page.data);
                zos.closeEntry();
            }
            zos.finish();
        }
    }

    @Override
    public boolean accept(File f) {
        return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip");
    }

    @Override
    public String getDescription() {
        return this.getToolTip(true) + " (*.ZIP)";
    }

    private byte[] makeSnaHeaderFromZ80Header(Z80InZXPOutPlugin.Z80MainHeader z80header, boolean pcOnStack) throws IOException {
        return JBBPOut.BeginBin(JBBPByteOrder.LITTLE_ENDIAN).Byte((int)z80header.reg_ir).Short((int)z80header.reg_hl_alt).Short((int)z80header.reg_de_alt).Short((int)z80header.reg_bc_alt).Short(Z80InZXPOutPlugin.makePair(z80header.reg_a_alt, z80header.reg_f_alt)).Short((int)z80header.reg_hl).Short((int)z80header.reg_de).Short((int)z80header.reg_bc).Short((int)z80header.reg_iy).Short((int)z80header.reg_ix).Byte(z80header.iff2 == 0 ? 0 : 4).Byte((int)z80header.reg_r).Short(Z80InZXPOutPlugin.makePair(z80header.reg_a, z80header.reg_f)).Short(z80header.reg_sp - (pcOnStack ? 2 : 0)).Byte((int)z80header.emulFlags.interruptmode).Byte((int)z80header.flags.bordercolor).End().toByteArray();
    }

    private static final class GfxPage {
        private final int index;
        private final byte[] data;

        public GfxPage(int index, byte[] data) {
            this.index = index;
            this.data = data;
        }
    }
}

