/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.files.plugins;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.utils.Function;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.zxpspritecorrector.components.ZXPolyData;
import com.igormaznitsa.zxpspritecorrector.files.FileNameDialog;
import com.igormaznitsa.zxpspritecorrector.files.Info;
import com.igormaznitsa.zxpspritecorrector.files.SessionData;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class TRDPlugin
extends AbstractFilePlugin {
    private static final String DESCRIPTION = "TR-Dos disk image";
    public static final JBBPParser CATALOG_PARSER = JBBPParser.prepare("byte [8] name; ubyte type; <ushort start; <ushort length; ubyte sectors; ubyte firstSector; ubyte track;");

    @Override
    public String getPluginDescription(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public String getToolTip(boolean forExport) {
        return DESCRIPTION;
    }

    @Override
    public boolean doesContainInternalFileItems() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Info> getImportingContainerFileList(File file) {
        try {
            ArrayList<Info> result = new ArrayList<Info>();
            JBBPBitInputStream in = null;
            try {
                in = new JBBPBitInputStream(new FileInputStream(file));
                for (int i = 0; i < 128; ++i) {
                    TRDosCatalogItem item = CATALOG_PARSER.parse(in).mapTo(new TRDosCatalogItem(), new Function[0]);
                    if (item.name.charAt(0) <= '\u0001') continue;
                    result.add(new Info(item.name, item.type, item.start, item.length, -1, true, new byte[0]));
                }
            }
            catch (Throwable throwable) {
                JBBPUtils.closeQuietly(in);
                throw throwable;
            }
            JBBPUtils.closeQuietly(in);
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractFilePlugin.ReadResult readFrom(String name, byte[] data, int index) throws IOException {
        JBBPBitInputStream inStream = new JBBPBitInputStream(new ByteArrayInputStream(data), JBBPBitOrder.LSB0);
        try {
            ArrayList<TRDosCatalogItem> list = new ArrayList<TRDosCatalogItem>();
            for (int i = 0; i < 128; ++i) {
                TRDosCatalogItem item = CATALOG_PARSER.parse(inStream).mapTo(new TRDosCatalogItem(), new Function[0]);
                if (item.name.charAt(0) <= '\u0001') continue;
                list.add(item);
            }
            TRDosCatalogItem info = (TRDosCatalogItem)list.get(index);
            int offsetToFile = ((info.track << 4) + info.firstSector) * 256;
            long toskip = (long)offsetToFile - inStream.getCounter();
            long skept = inStream.skip(toskip);
            if (skept != toskip) {
                throw new IllegalStateException("Can't skip needed byte number [" + toskip + "]");
            }
            AbstractFilePlugin.ReadResult readResult = new AbstractFilePlugin.ReadResult(new ZXPolyData(new Info(info.name, info.type, info.start, info.length, offsetToFile, true, new byte[0]), this, inStream.readByteArray(info.sectors << 8)), null);
            return readResult;
        }
        finally {
            JBBPUtils.closeQuietly(inStream);
        }
    }

    @Override
    public void writeTo(File file, ZXPolyData data, SessionData session, Object ... extraData) throws IOException {
        String zxname = data.getInfo().getName();
        String[] zxFileName = new String[]{TRDPlugin.prepareNameForTRD(zxname, 0), TRDPlugin.prepareNameForTRD(zxname, 1), TRDPlugin.prepareNameForTRD(zxname, 2), TRDPlugin.prepareNameForTRD(zxname, 3)};
        char type = data.getInfo().getType();
        FileNameDialog fileNameDialog = new FileNameDialog(this.spriteCorrectorMainFrame, "TRD file " + file.getName(), null, zxFileName, new char[]{type, type, type, type});
        fileNameDialog.setVisible(true);
        if (fileNameDialog.approved()) {
            int i;
            JBBPOut out = JBBPOut.BeginBin(JBBPByteOrder.LITTLE_ENDIAN);
            String[] fnames = fileNameDialog.getZxName();
            Character[] fchars = fileNameDialog.getZxType();
            int sectorslen = (data.length() >>> 8) + ((data.length() & 0xFF) == 0 ? 0 : 1);
            int csector = 16;
            for (i = 0; i < 4; ++i) {
                out.Byte(fnames[i]).Byte((int)fchars[i].charValue()).Short(data.getInfo().getStartAddress(), data.getInfo().getLength()).Byte(sectorslen).Byte(csector & 0xF).Byte(csector >>> 4);
                csector += sectorslen;
            }
            out.Align(2048).ResetCounter();
            out.Byte(0).Skip(224).Byte(csector & 0xF, csector >>> 4, 22, 4).Short(2560 - csector).Byte(16, 0, 0).Byte("         ").Byte(0, 0).Byte("ZXPOLY D").Byte(0, 0, 0);
            out.Skip(1792);
            out.ResetCounter();
            for (i = 0; i < 4; ++i) {
                byte[] arr = data.getDataForCPU(i);
                out.Byte(arr).Align(256);
            }
            out.Align(651264);
            this.saveDataToFile(file, out.End().toByteArray());
        }
    }

    @Override
    public boolean accept(File pathname) {
        return pathname != null && (pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".trd"));
    }

    @Override
    public String getDescription() {
        return "TR-Dos disk image (*.TRD)";
    }

    @Override
    public FileFilter getImportFileFilter() {
        return this;
    }

    @Override
    public FileFilter getExportFileFilter() {
        return this;
    }

    @Override
    public String getExtension(boolean forExport) {
        return "trd";
    }

    @Override
    public String getPluginUID() {
        return "TRDP";
    }

    private static final class TRDosCatalogItem {
        @Bin(type=BinType.BYTE_ARRAY)
        String name;
        @Bin(type=BinType.UBYTE)
        char type;
        @Bin(type=BinType.USHORT)
        int start;
        @Bin(type=BinType.USHORT)
        int length;
        @Bin(type=BinType.UBYTE)
        int sectors;
        @Bin(type=BinType.UBYTE)
        int firstSector;
        @Bin(type=BinType.UBYTE)
        int track;

        private TRDosCatalogItem() {
        }
    }
}

