/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.tools;

import com.igormaznitsa.zxpspritecorrector.components.EditorComponent;
import com.igormaznitsa.zxpspritecorrector.components.ZXColorSelector;
import com.igormaznitsa.zxpspritecorrector.tools.AbstractTool;
import java.awt.Rectangle;
import org.picocontainer.annotations.Inject;

public class ToolColorizer
extends AbstractTool {
    private static final long serialVersionUID = 1486692252806983383L;
    @Inject
    private ZXColorSelector colorSelector;

    public ToolColorizer() {
        super("paint_tube.png", "Colorize pixels by current ink and paper colors");
    }

    @Override
    public boolean doesSupport512x384() {
        return false;
    }

    @Override
    public void process(EditorComponent editComponent, Rectangle area, int buttons) {
        EditorComponent.ZXGraphics gfx = editComponent.getZXGraphics();
        boolean mode512 = editComponent.isMode512();
        if ((buttons & 1) != 0) {
            int index = this.colorSelector.getSelectedInk();
            for (int x = 0; x < area.width; ++x) {
                for (int y = 0; y < area.height; ++y) {
                    int dx = x + area.x;
                    int dy = y + area.y;
                    if (!ToolColorizer.isCoordValid(dx, dy, mode512) || !gfx.isBaseBitSet(dx, dy)) continue;
                    gfx.setPoint(dx, dy, index);
                    editComponent.setChanged(true);
                }
            }
        } else if ((buttons & 4) != 0) {
            int index = this.colorSelector.getSelectedPaint();
            for (int x = 0; x < area.width; ++x) {
                for (int y = 0; y < area.height; ++y) {
                    int dx = x + area.x;
                    int dy = y + area.y;
                    if (!ToolColorizer.isCoordValid(dx, dy, mode512) || gfx.isBaseBitSet(dx, dy)) continue;
                    gfx.setPoint(dx, dy, index);
                    editComponent.setChanged(true);
                }
            }
        } else {
            return;
        }
        gfx.flush();
    }
}

