/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpspritecorrector.utils;

import java.awt.Color;
import java.awt.image.IndexColorModel;

public final class ZXPalette {
    public static final Color[] COLORS = new Color[]{new Color(0, 0, 0), new Color(0, 0, 190), new Color(190, 0, 0), new Color(190, 0, 190), new Color(0, 190, 0), new Color(0, 190, 190), new Color(190, 190, 0), new Color(190, 190, 190), new Color(16, 16, 16), new Color(0, 0, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 255, 0), new Color(255, 255, 255)};

    private ZXPalette() {
    }

    public static IndexColorModel makeIndexPalette() {
        byte[] r = new byte[COLORS.length];
        byte[] g = new byte[COLORS.length];
        byte[] b = new byte[COLORS.length];
        for (int i = 0; i < COLORS.length; ++i) {
            r[i] = (byte)COLORS[i].getRed();
            g[i] = (byte)COLORS[i].getGreen();
            b[i] = (byte)COLORS[i].getBlue();
        }
        return new IndexColorModel(4, COLORS.length, r, g, b);
    }

    public static Color extractInk(int attribute) {
        int bright = (attribute & 0x40) == 0 ? 8 : 0;
        return COLORS[bright | attribute & 7];
    }

    public static Color extractPaper(int attribute) {
        int bright = (attribute & 0x40) == 0 ? 8 : 0;
        return COLORS[bright | attribute >>> 3 & 7];
    }

    public static int calcAttributeAddressZXMode(int startScreenAddress, int screenOffset) {
        int line = screenOffset >>> 5 & 7 | screenOffset >>> 8 & 0x18;
        int column = screenOffset & 0x1F;
        int off = line >>> 3 << 8 | ((line & 7) << 5 | column);
        return startScreenAddress + 6144 + off;
    }

    public static int findNearestColorIndex(int rgb) {
        int index = -1;
        double lastDistance = Double.MAX_VALUE;
        double r = rgb >> 16 & 0xFF;
        double g = rgb >> 8 & 0xFF;
        double b = rgb & 0xFF;
        int currentIndex = 0;
        for (Color c : COLORS) {
            double rr = c.getRed();
            double gg = c.getGreen();
            double bb = c.getBlue();
            if (Double.compare(r, rr) == 0 && Double.compare(b, bb) == 0 && Double.compare(g, gg) == 0) {
                index = currentIndex;
                break;
            }
            double distance = Math.sqrt(Math.pow(rr - r, 2.0) + Math.pow(gg - g, 2.0) + Math.pow(bb - b, 2.0));
            int comparation = Double.compare(distance, lastDistance);
            if (comparation < 0) {
                index = currentIndex;
                lastDistance = distance;
            }
            ++currentIndex;
        }
        return index;
    }
}

