/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.DummyWindow;
import net.java.games.input.WinTabContext;
import net.java.games.input.WinTabDevice;
import net.java.games.util.plugins.Plugin;

public final class WinTabEnvironmentPlugin
extends ControllerEnvironment
implements Plugin {
    private static boolean supported = false;
    private final Controller[] controllers;
    private final List<WinTabDevice> active_devices = new ArrayList<WinTabDevice>();
    private final WinTabContext winTabContext;

    static void loadLibrary(String lib_name) {
        try {
            String lib_path = System.getProperty("net.java.games.input.librarypath");
            if (lib_path != null) {
                System.load(lib_path + File.separator + System.mapLibraryName(lib_name));
            } else {
                System.loadLibrary(lib_name);
            }
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            supported = false;
        }
    }

    public WinTabEnvironmentPlugin() {
        if (this.isSupported()) {
            WinTabContext winTabContext = null;
            Controller[] controllers = new Controller[]{};
            try {
                DummyWindow window = new DummyWindow();
                winTabContext = new WinTabContext(window);
                try {
                    winTabContext.open();
                    controllers = winTabContext.getControllers();
                }
                catch (Exception e) {
                    window.destroy();
                    throw e;
                }
            }
            catch (Exception e) {
                WinTabEnvironmentPlugin.log("Failed to enumerate devices: " + e.getMessage());
                e.printStackTrace();
            }
            this.controllers = controllers;
            this.winTabContext = winTabContext;
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        } else {
            this.winTabContext = null;
            this.controllers = new Controller[0];
        }
    }

    @Override
    public boolean isSupported() {
        return supported;
    }

    @Override
    public Controller[] getControllers() {
        return this.controllers;
    }

    static {
        String osName = System.getProperty("os.name", "").trim();
        if (osName.startsWith("Windows")) {
            supported = true;
            WinTabEnvironmentPlugin.loadLibrary("jinput-wintab");
        }
    }

    private final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public final void run() {
            for (int i = 0; i < WinTabEnvironmentPlugin.this.active_devices.size(); ++i) {
            }
            WinTabEnvironmentPlugin.this.winTabContext.close();
        }
    }
}

