/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.mapper;

import com.igormaznitsa.jbbp.exceptions.JBBPMapperException;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinFieldFilter;
import com.igormaznitsa.jbbp.mapper.JBBPMapperCustomFieldProcessor;
import com.igormaznitsa.jbbp.mapper.MappedFieldRecord;
import com.igormaznitsa.jbbp.model.BitEntity;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.utils.Function;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.jbbp.utils.NullableTriple;
import com.igormaznitsa.jbbp.utils.ReflectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class JBBPMapper {
    public static final String MAKE_CLASS_INSTANCE_METHOD_NAME = "newInstance";
    public static final int FLAG_IGNORE_MISSING_VALUES = 1;
    private static final Map<Class<?>, List<MappedFieldRecord>> CACHED_FIELDS = new ConcurrentHashMap();

    @SafeVarargs
    public static <T> T map(JBBPFieldStruct root, String structPath, T instance, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(root, structPath, instance, null, instantiators);
    }

    @SafeVarargs
    public static <T> T map(JBBPFieldStruct root, String structPath, T instance, int flags, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(root, structPath, instance, null, flags, instantiators);
    }

    @SafeVarargs
    public static <T> T map(JBBPFieldStruct root, String structPath, T instance, JBBPMapperCustomFieldProcessor customFieldProcessor, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(root, structPath, instance, customFieldProcessor, 0, instantiators);
    }

    @SafeVarargs
    public static <T> T map(JBBPFieldStruct root, String structPath, T instance, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags, Function<Class<?>, Object> ... instantiators) {
        JBBPUtils.assertNotNull(structPath, "Path must not be null");
        JBBPFieldStruct struct = root.findFieldForPathAndType(structPath, JBBPFieldStruct.class);
        if (struct == null) {
            throw new JBBPMapperException("Can't find a structure field for its path [" + structPath + "]", null, instance.getClass(), null, null);
        }
        return JBBPMapper.map(struct, instance, customFieldProcessor, flags, instantiators);
    }

    @SafeVarargs
    public static <T> T map(JBBPFieldStruct root, T instance, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(root, instance, null, instantiators);
    }

    @SafeVarargs
    public static <T> T map(JBBPFieldStruct root, T instance, int flags, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(root, instance, null, flags, instantiators);
    }

    @SafeVarargs
    public static <T> T map(JBBPFieldStruct rootStructure, T instance, JBBPMapperCustomFieldProcessor customFieldProcessor, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(rootStructure, instance, customFieldProcessor, 0, instantiators);
    }

    @SafeVarargs
    private static void processFieldOfMappedClass(MappedFieldRecord record, JBBPFieldStruct rootStructure, Object instance, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags, BinFieldFilter binFieldFilter, Function<Class<?>, Object> ... instantiators) {
        if (record.binAnnotation.custom()) {
            JBBPUtils.assertNotNull(customFieldProcessor, "There is a custom mapping field, in the case you must provide a custom mapping field processor");
            Object value = customFieldProcessor.prepareObjectForMapping(rootStructure, record.binAnnotation, record.mappingField);
            MappedFieldRecord.setFieldValue(instance, record.setter, record.mappingField, null, value);
        } else {
            JBBPAbstractField binField = record.fieldPath.isEmpty() ? (record.fieldName.isEmpty() ? rootStructure.findFieldForType(record.fieldType.getFieldClass()) : rootStructure.findFieldForNameAndType(record.fieldName, record.fieldType.getFieldClass())) : rootStructure.findFieldForPathAndType(record.fieldPath, record.fieldType.getFieldClass());
            if (binField == null) {
                if ((flags & 1) != 0) {
                    return;
                }
                throw new JBBPMapperException("Can't find value for mapping field [" + record.mappingField + "]", null, record.mappingClass, record.mappingField, null);
            }
            if (record.bitWideField && record.mappedBitNumber != JBBPBitNumber.BITS_8 && ((BitEntity)((Object)binField)).getBitWidth() != record.mappedBitNumber) {
                throw new JBBPMapperException("Can't map mapping field because wrong field bitness [" + record.mappedBitNumber + "!=" + ((BitEntity)((Object)binField)).getBitWidth().getBitNumber() + "]", null, record.mappingClass, record.mappingField, null);
            }
            record.proc.apply(record, rootStructure, instance, customFieldProcessor, binField, flags, binFieldFilter, instantiators);
        }
    }

    @SafeVarargs
    public static <T> T map(JBBPFieldStruct rootStructure, T instance, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(rootStructure, instance, customFieldProcessor, flags, null, instantiators);
    }

    @SafeVarargs
    public static <T> T map(JBBPFieldStruct rootStructure, T instance, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags, BinFieldFilter binFieldFilter, Function<Class<?>, Object> ... instantiators) {
        JBBPUtils.assertNotNull(rootStructure, "The Root structure must not be null");
        JBBPUtils.assertNotNull(instance, "The Mapping class instance must not be null");
        for (MappedFieldRecord record : JBBPMapper.findAffectedFields(instance, binFieldFilter)) {
            JBBPMapper.processFieldOfMappedClass(record, rootStructure, instance, customFieldProcessor, flags, binFieldFilter, instantiators);
        }
        return instance;
    }

    public static int getFieldCacheSize() {
        return CACHED_FIELDS.size();
    }

    public static void clearFieldCache() {
        CACHED_FIELDS.clear();
    }

    public static List<MappedFieldRecord> findAffectedFields(Object instance, BinFieldFilter binFieldFilter) {
        Class<?> mappingClass = instance.getClass();
        List<MappedFieldRecord> result = CACHED_FIELDS.get(mappingClass);
        if (result == null) {
            String packageName;
            result = new ArrayList<MappedFieldRecord>();
            Bin defaultAnno = mappingClass.getAnnotation(Bin.class);
            ArrayList listOfClassHierarchy = new ArrayList();
            for (Class<?> current = instance.getClass(); !(current == null || (packageName = current.getPackage().getName()).startsWith("java.") || packageName.startsWith("javax.") || packageName.startsWith("android.")); current = current.getSuperclass()) {
                listOfClassHierarchy.add(current);
            }
            for (Class clazz : listOfClassHierarchy) {
                for (Field mappingField : clazz.getDeclaredFields()) {
                    Bin mappedAnno;
                    int fieldModifiers = mappingField.getModifiers();
                    Bin fieldAnno = mappingField.getAnnotation(Bin.class);
                    if (fieldAnno == null && defaultAnno == null || mappingField.getName().indexOf(36) >= 0) continue;
                    Bin bin = mappedAnno = fieldAnno == null ? defaultAnno : fieldAnno;
                    if (fieldAnno == null) {
                        if (Modifier.isTransient(fieldModifiers) || Modifier.isStatic(fieldModifiers) || Modifier.isFinal(fieldModifiers)) {
                            continue;
                        }
                    } else {
                        String disallowedModifier = Modifier.isStatic(fieldModifiers) ? "STATIC" : (Modifier.isFinal(fieldModifiers) ? "FINAL" : null);
                        if (disallowedModifier != null) {
                            throw new JBBPMapperException("Detected @Bin marked " + disallowedModifier + " field", null, clazz, mappingField, null);
                        }
                    }
                    NullableTriple<Method, Method, Method> auxMethods = JBBPMapper.findAuxFieldMethods(clazz, mappingField);
                    Method fieldGenerator = auxMethods.getA();
                    Method fieldGetter = auxMethods.getB();
                    Method fieldSetter = auxMethods.getC();
                    if (mappingField.getType().isPrimitive() && fieldSetter == null && Modifier.isPrivate(mappingField.getModifiers())) {
                        throw new JBBPMapperException("Detected private primitive field, mapping requires setter", null, clazz, mappingField, null);
                    }
                    if (fieldGetter == null && fieldGenerator == null && !ReflectUtils.isPotentiallyAccessibleField(mappingField)) {
                        mappingField = ReflectUtils.makeAccessible(mappingField);
                    }
                    try {
                        result.add(new MappedFieldRecord(mappingField, fieldGenerator, fieldSetter, fieldGetter, mappingClass, mappedAnno));
                    }
                    catch (IllegalStateException ex) {
                        throw new JBBPMapperException(ex.getMessage(), null, mappingClass, mappingField, ex);
                    }
                }
            }
            Collections.sort(result);
            CACHED_FIELDS.put(mappingClass, result);
        }
        if (binFieldFilter != null) {
            ArrayList<MappedFieldRecord> filteredRecords = new ArrayList<MappedFieldRecord>();
            for (MappedFieldRecord r : result) {
                if (!binFieldFilter.isAllowed(r.binAnnotation, r.mappingField)) continue;
                filteredRecords.add(r);
            }
            result = filteredRecords;
        }
        return result;
    }

    private static NullableTriple<Method, Method, Method> findAuxFieldMethods(Class<?> klazz, Field field) {
        String lowerCasedFieldName = field.getName().toLowerCase(Locale.ENGLISH);
        String generatorName = "make" + lowerCasedFieldName;
        String getterName = "get" + lowerCasedFieldName;
        String setterName = "set" + lowerCasedFieldName;
        Method generator = null;
        Method setter = null;
        Method getter = null;
        for (Method m : klazz.getMethods()) {
            Class<?>[] args = m.getParameterTypes();
            String lcMethodName = m.getName().toLowerCase(Locale.ENGLISH);
            if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) continue;
            if (args.length == 0) {
                if (generator == null && lcMethodName.equals(generatorName)) {
                    generator = m;
                }
                if (getter == null && lcMethodName.equals(getterName)) {
                    getter = m;
                }
            }
            if (args.length == 1 && setter == null && lcMethodName.equals(setterName) && field.getType().isAssignableFrom(args[0])) {
                setter = m;
            }
            if (generator != null && setter != null && getter != null) break;
        }
        return new NullableTriple<Object, Object, Object>(generator, getter, setter);
    }
}

