/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.utils;

import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class JBBPDslBuilder {
    protected final List<Item> items = new ArrayList<Item>();
    protected JBBPByteOrder byteOrder = JBBPByteOrder.BIG_ENDIAN;
    protected int openedStructCounter;

    protected JBBPDslBuilder() {
    }

    public static JBBPDslBuilder Begin() {
        return new JBBPDslBuilder();
    }

    protected static String assertTextNotNullAndTrimmedNotEmpty(String text) {
        if (text == null) {
            throw new NullPointerException("Must not be null");
        }
        if (text.trim().isEmpty()) {
            throw new IllegalArgumentException("Must not be empty: " + text);
        }
        return text;
    }

    protected static String assertNameIfNotNull(String name) {
        if (name != null) {
            if (name.equals("_")) {
                throw new IllegalArgumentException("Only underscore is not allowed as name");
            }
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (i == 0 && Character.isDigit(c)) {
                    throw new IllegalArgumentException("Digit can't be first char");
                }
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                throw new IllegalArgumentException("Only letters, digits and underscore allowed: " + name);
            }
        }
        return name;
    }

    protected static String assertExpressionChars(String expression) {
        if (expression == null) {
            throw new NullPointerException("Expression is null");
        }
        if (expression.trim().isEmpty()) {
            throw new IllegalArgumentException("Expression is empty");
        }
        if (expression.contains("//")) {
            throw new IllegalArgumentException("Comment is not allowed");
        }
        for (char c : expression.toCharArray()) {
            switch (c) {
                case '\"': 
                case ':': 
                case ';': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    throw new IllegalArgumentException("Char is not allowed: " + c);
                }
            }
        }
        return expression;
    }

    protected static int assertNotNegativeAndZero(int value) {
        if (value == 0) {
            throw new IllegalArgumentException("must not be 0");
        }
        if (value < 0) {
            throw new IllegalArgumentException("must not be negative");
        }
        return value;
    }

    protected static StringBuilder doTabs(boolean enable, StringBuilder buffer, int tabs) {
        if (enable) {
            while (tabs > 0) {
                buffer.append('\t');
                --tabs;
            }
        }
        return buffer;
    }

    protected void addItem(Item item) {
        if (item instanceof ItemComment || item.name == null || item.name.isEmpty()) {
            this.items.add(item);
        } else {
            int structCounter = 0;
            for (int i = this.items.size() - 1; i >= 0; --i) {
                String thatName;
                Item itm = this.items.get(i);
                if (itm instanceof ItemComment) continue;
                if (itm.type == BinType.STRUCT || itm.type == BinType.STRUCT_ARRAY) {
                    if (structCounter == 0) break;
                    ++structCounter;
                } else if (itm instanceof ItemStructEnd) {
                    --structCounter;
                }
                if (structCounter != 0 || (thatName = itm.name) == null || thatName.isEmpty() || !item.name.equalsIgnoreCase(thatName)) continue;
                throw new IllegalArgumentException("Duplicated item name '" + item.name + "'");
            }
            this.items.add(item);
        }
    }

    public int size() {
        return this.items.size();
    }

    protected String arraySizeToString(int size) {
        return size < 0 ? "_" : Integer.toString(size);
    }

    public JBBPDslBuilder Align() {
        return this.Align(1);
    }

    public JBBPDslBuilder Align(int alignBytes) {
        this.Align(Integer.toString(JBBPDslBuilder.assertNotNegativeAndZero(alignBytes)));
        return this;
    }

    public JBBPDslBuilder Align(String sizeExpression) {
        this.addItem(new ItemAlign(JBBPDslBuilder.assertExpressionChars(sizeExpression)));
        return this;
    }

    public JBBPDslBuilder Skip() {
        return this.Skip(1);
    }

    public JBBPDslBuilder Skip(int bytesToSkip) {
        this.Skip(Integer.toString(JBBPDslBuilder.assertNotNegativeAndZero(bytesToSkip)));
        return this;
    }

    public JBBPDslBuilder Skip(String sizeExpression) {
        this.addItem(new ItemSkip(JBBPDslBuilder.assertExpressionChars(sizeExpression)));
        return this;
    }

    public JBBPDslBuilder Custom(String type) {
        return this.Custom(type, null, null);
    }

    public JBBPDslBuilder Var() {
        return this.Var(null);
    }

    public JBBPDslBuilder Var(String name) {
        return this.Var(name, null);
    }

    public JBBPDslBuilder Var(String name, String param) {
        return this.Custom("var", name, param);
    }

    public JBBPDslBuilder Custom(String type, String name) {
        return this.Custom(type, name, null);
    }

    public JBBPDslBuilder Custom(String type, String name, String param) {
        ItemCustom custom = new ItemCustom(type, name, this.byteOrder);
        custom.bitLenExpression = param == null ? null : JBBPDslBuilder.assertExpressionChars(param);
        this.addItem(custom);
        return this;
    }

    public JBBPDslBuilder Struct() {
        return this.Struct(null);
    }

    public JBBPDslBuilder Struct(String name) {
        Item item = new Item(BinType.STRUCT, name, this.byteOrder);
        this.addItem(item);
        ++this.openedStructCounter;
        return this;
    }

    public JBBPDslBuilder StructArray(String sizeExpression) {
        return this.StructArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder StructArray(int size) {
        return this.StructArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder StructArray(String name, int size) {
        return this.StructArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder StructArray(String name, String sizeExpression) {
        Item item = new Item(BinType.STRUCT_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        ++this.openedStructCounter;
        return this;
    }

    public JBBPDslBuilder Val(String name, String expression) {
        ItemVal item = new ItemVal(JBBPDslBuilder.assertTextNotNullAndTrimmedNotEmpty(name), JBBPDslBuilder.assertExpressionChars(JBBPDslBuilder.assertTextNotNullAndTrimmedNotEmpty(expression)).trim());
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder ResetCounter() {
        ItemResetCounter item = new ItemResetCounter();
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder VarArray(int size) {
        return this.VarArray(null, this.arraySizeToString(size), null);
    }

    public JBBPDslBuilder VarArray(String sizeExpression) {
        return this.VarArray(null, sizeExpression);
    }

    public JBBPDslBuilder VarArray(String name, int size) {
        return this.VarArray(name, this.arraySizeToString(size), null);
    }

    public JBBPDslBuilder VarArray(String name, String sizeExpression) {
        return this.VarArray(name, sizeExpression, null);
    }

    public JBBPDslBuilder VarArray(String name, int size, String param) {
        return this.VarArray(name, this.arraySizeToString(size), param);
    }

    public JBBPDslBuilder VarArray(String name, String sizeExpression, String param) {
        return this.CustomArray("var", name, sizeExpression, param);
    }

    public JBBPDslBuilder CustomArray(String type, int size) {
        return this.CustomArray(type, this.arraySizeToString(size));
    }

    public JBBPDslBuilder CustomArray(String type, String size) {
        return this.CustomArray(type, null, size, null);
    }

    public JBBPDslBuilder CustomArray(String type, String name, String size) {
        return this.CustomArray(type, name, size, null);
    }

    public JBBPDslBuilder CustomArray(String type, String name, int size) {
        return this.CustomArray(type, name, this.arraySizeToString(size), null);
    }

    public JBBPDslBuilder CustomArray(String type, String name, int size, String param) {
        return this.CustomArray(type, name, this.arraySizeToString(size), param);
    }

    public JBBPDslBuilder CustomArray(String type, String name, String sizeExpression, String param) {
        ItemCustom item = new ItemCustom(type, name, this.byteOrder);
        item.array = true;
        item.bitLenExpression = param == null ? null : JBBPDslBuilder.assertExpressionChars(param);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder CloseStruct() {
        return this.CloseStruct(false);
    }

    public JBBPDslBuilder CloseStruct(boolean closeAllOpened) {
        if (this.openedStructCounter == 0) {
            throw new IllegalStateException("There is not any opened struct");
        }
        this.addItem(new ItemStructEnd(closeAllOpened));
        this.openedStructCounter = closeAllOpened ? 0 : this.openedStructCounter - 1;
        return this;
    }

    public boolean hasOpenedStructs() {
        return this.openedStructCounter > 0;
    }

    public JBBPDslBuilder Bit() {
        return this.Bits(null, JBBPBitNumber.BITS_1);
    }

    public JBBPDslBuilder Bit(String name) {
        return this.Bits(name, JBBPBitNumber.BITS_1);
    }

    public JBBPDslBuilder Bits(int bits) {
        return this.Bits(null, JBBPBitNumber.decode(bits));
    }

    public JBBPDslBuilder Bits(JBBPBitNumber bits) {
        return this.Bits(null, bits);
    }

    public JBBPDslBuilder Bits(String name, JBBPBitNumber bits) {
        Item item = new Item(BinType.BIT, name, this.byteOrder);
        item.bitNumber = bits;
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder Bits(String name, String bitLenExpression) {
        Item item = new Item(BinType.BIT, name, this.byteOrder);
        item.bitLenExpression = JBBPDslBuilder.assertExpressionChars(bitLenExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder BitArray(JBBPBitNumber bits, int size) {
        return this.BitArray(null, bits, this.arraySizeToString(size));
    }

    public JBBPDslBuilder BitArray(String name, JBBPBitNumber bits, int size) {
        return this.BitArray(name, bits, this.arraySizeToString(size));
    }

    public JBBPDslBuilder BitArray(String name, String bitLenExpression, int size) {
        return this.BitArray(name, bitLenExpression, this.arraySizeToString(size));
    }

    public JBBPDslBuilder BitArray(JBBPBitNumber bits, String sizeExpression) {
        return this.BitArray(null, bits, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder BitArray(String bitLenExpression, String sizeExpression) {
        return this.BitArray(null, bitLenExpression, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder BitArray(String name, JBBPBitNumber bits, String sizeExpression) {
        Item item = new Item(BinType.BIT_ARRAY, name, this.byteOrder);
        item.bitNumber = bits;
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder BitArray(String name, String bitLenExpression, String sizeExpression) {
        Item item = new Item(BinType.BIT_ARRAY, name, this.byteOrder);
        item.bitLenExpression = JBBPDslBuilder.assertExpressionChars(bitLenExpression);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder BoolArray(String sizeExpression) {
        return this.BoolArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder BoolArray(String name, int size) {
        return this.BoolArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder BoolArray(int size) {
        return this.BoolArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder BoolArray(String name, String sizeExpression) {
        Item item = new Item(BinType.BOOL_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder Bool() {
        return this.Bool(null);
    }

    public JBBPDslBuilder Bool(String name) {
        Item item = new Item(BinType.BOOL, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder Byte() {
        return this.Byte(null);
    }

    public JBBPDslBuilder Byte(String name) {
        Item item = new Item(BinType.BYTE, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder ByteArray(String sizeExpression) {
        return this.ByteArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder ByteArray(int size) {
        return this.ByteArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder ByteArray(String name, int size) {
        return this.ByteArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder ByteArray(String name, String sizeExpression) {
        Item item = new Item(BinType.BYTE_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder UByte() {
        return this.UByte(null);
    }

    public JBBPDslBuilder UByte(String name) {
        Item item = new Item(BinType.UBYTE, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder UByteArray(String sizeExpression) {
        return this.UByteArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder UByteArray(int size) {
        return this.UByteArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder UByteArray(String name, int size) {
        return this.UByteArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder UByteArray(String name, String sizeExpression) {
        Item item = new Item(BinType.UBYTE_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder Short() {
        return this.Short(null);
    }

    public JBBPDslBuilder Short(String name) {
        Item item = new Item(BinType.SHORT, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder ShortArray(String sizeExpression) {
        return this.ShortArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder ShortArray(int size) {
        return this.ShortArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder ShortArray(String name, int size) {
        return this.ShortArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder ShortArray(String name, String sizeExpression) {
        Item item = new Item(BinType.SHORT_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder UShort() {
        return this.UShort(null);
    }

    public JBBPDslBuilder UShort(String name) {
        Item item = new Item(BinType.USHORT, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder UShortArray(String sizeExpression) {
        return this.UShortArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder UShortArray(int size) {
        return this.UShortArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder UShortArray(String name, String sizeExpression) {
        Item item = new Item(BinType.USHORT_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder UShortArray(String name, int size) {
        return this.UShortArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder Int() {
        return this.Int(null);
    }

    public JBBPDslBuilder Int(String name) {
        Item item = new Item(BinType.INT, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder IntArray(String sizeExpression) {
        return this.IntArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder IntArray(int size) {
        return this.IntArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder IntArray(String name, int size) {
        return this.IntArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder IntArray(String name, String sizeExpression) {
        Item item = new Item(BinType.INT_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder Long() {
        return this.Long(null);
    }

    public JBBPDslBuilder Long(String name) {
        Item item = new Item(BinType.LONG, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder LongArray(String sizeExpression) {
        return this.LongArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder LongArray(int size) {
        return this.LongArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder LongArray(String name, int size) {
        return this.LongArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder LongArray(String name, String sizeExpression) {
        Item item = new Item(BinType.LONG_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder Float() {
        return this.Float(null);
    }

    public JBBPDslBuilder Float(String name) {
        Item item = new Item(BinType.FLOAT, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder FloatArray(String sizeExpression) {
        return this.FloatArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder FloatArray(int size) {
        return this.FloatArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder FloatArray(String name, int size) {
        return this.FloatArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder FloatArray(String name, String sizeExpression) {
        Item item = new Item(BinType.FLOAT_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder Double() {
        return this.Double(null);
    }

    public JBBPDslBuilder UInt() {
        return this.UInt(null);
    }

    public JBBPDslBuilder Double(String name) {
        Item item = new Item(BinType.DOUBLE, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder UInt(String name) {
        Item item = new Item(BinType.UINT, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder Comment(String text) {
        this.addItem(new ItemComment(text == null ? "" : text, false));
        return this;
    }

    public JBBPDslBuilder NewLineComment(String text) {
        this.addItem(new ItemComment(text == null ? "" : text, true));
        return this;
    }

    public JBBPDslBuilder DoubleArray(String sizeExpression) {
        return this.DoubleArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder DoubleArray(int size) {
        return this.DoubleArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder UIntArray(int size) {
        return this.UIntArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder DoubleArray(String name, int size) {
        return this.DoubleArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder UIntArray(String name, String sizeExpression) {
        Item item = new Item(BinType.UINT_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder DoubleArray(String name, String sizeExpression) {
        Item item = new Item(BinType.DOUBLE_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder UIntArray(String name, int size) {
        return this.UIntArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder String() {
        return this.String(null);
    }

    public JBBPDslBuilder String(String name) {
        Item item = new Item(BinType.STRING, name, this.byteOrder);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder StringArray(String sizeExpression) {
        return this.StringArray(null, JBBPDslBuilder.assertExpressionChars(sizeExpression));
    }

    public JBBPDslBuilder StringArray(int size) {
        return this.StringArray(null, this.arraySizeToString(size));
    }

    public JBBPDslBuilder StringArray(String name, int size) {
        return this.StringArray(name, this.arraySizeToString(size));
    }

    public JBBPDslBuilder StringArray(String name, String sizeExpression) {
        Item item = new Item(BinType.STRING_ARRAY, name, this.byteOrder);
        item.sizeExpression = JBBPDslBuilder.assertExpressionChars(sizeExpression);
        this.addItem(item);
        return this;
    }

    public JBBPDslBuilder ByteOrder(JBBPByteOrder order) {
        this.byteOrder = order == null ? JBBPByteOrder.BIG_ENDIAN : order;
        return this;
    }

    public String End() {
        return this.End(false);
    }

    public String End(boolean format) {
        if (this.openedStructCounter != 0) {
            throw new IllegalStateException("Detected unclosed structs: " + this.openedStructCounter);
        }
        StringBuilder buffer = new StringBuilder(128);
        int structCounter = 0;
        for (Item item : this.items) {
            switch (item.type) {
                case STRUCT: {
                    JBBPDslBuilder.doTabs(format, buffer, structCounter).append(item.name == null ? "" : item.name).append('{');
                    ++structCounter;
                    break;
                }
                case STRUCT_ARRAY: {
                    JBBPDslBuilder.doTabs(format, buffer, structCounter).append(item.name == null ? "" : item.name).append('[').append(item.sizeExpression).append(']').append('{');
                    ++structCounter;
                    break;
                }
                case UNDEFINED: {
                    if (item instanceof ItemStructEnd) {
                        ItemStructEnd structEnd = (ItemStructEnd)item;
                        if (structEnd.endAll) {
                            while (structCounter > 0) {
                                JBBPDslBuilder.doTabs(format, buffer, --structCounter).append('}');
                                if (structCounter <= 0 || !format) continue;
                                buffer.append('\n');
                            }
                            break;
                        }
                        JBBPDslBuilder.doTabs(format, buffer, --structCounter).append('}');
                        break;
                    }
                    if (item instanceof ItemCustom) {
                        JBBPDslBuilder.doTabs(format, buffer, structCounter).append(item);
                        break;
                    }
                    if (item instanceof ItemAlign) {
                        JBBPDslBuilder.doTabs(format, buffer, structCounter).append("align").append((String)(item.sizeExpression == null ? "" : ":" + item.makeExpressionForExtraField(item.sizeExpression))).append(';');
                        break;
                    }
                    if (item instanceof ItemVal) {
                        JBBPDslBuilder.doTabs(format, buffer, structCounter).append("val").append(':').append(item.makeExpressionForExtraField(item.sizeExpression)).append(' ').append(item.name).append(';');
                        break;
                    }
                    if (item instanceof ItemResetCounter) {
                        JBBPDslBuilder.doTabs(format, buffer, structCounter).append("reset$$;");
                        break;
                    }
                    if (item instanceof ItemSkip) {
                        JBBPDslBuilder.doTabs(format, buffer, structCounter).append("skip").append((String)(item.sizeExpression == null ? "" : ":" + item.makeExpressionForExtraField(item.sizeExpression))).append(';');
                        break;
                    }
                    if (item instanceof ItemComment) {
                        int lastCommentIndex;
                        ItemComment comment = (ItemComment)item;
                        String commentText = comment.getComment().replace("\n", " ");
                        if (comment.isNewLine()) {
                            int lastNewLine;
                            if (!(buffer.length() <= 0 || (lastNewLine = buffer.lastIndexOf("\n")) >= 0 && buffer.substring(lastNewLine + 1).isEmpty())) {
                                buffer.append('\n');
                            }
                            JBBPDslBuilder.doTabs(format, buffer, structCounter).append("// ").append(commentText);
                            break;
                        }
                        String current = buffer.toString();
                        if (current.endsWith(";\n") || current.endsWith("}\n")) {
                            buffer.setLength(buffer.length() - 1);
                        }
                        if ((lastCommentIndex = buffer.lastIndexOf("//")) < 0) {
                            buffer.append("// ");
                        } else if (buffer.lastIndexOf("\n") > lastCommentIndex) {
                            buffer.append("// ");
                        } else {
                            buffer.append(' ');
                        }
                        buffer.append(commentText);
                        break;
                    }
                    throw new IllegalArgumentException("Unexpected item : " + item.getClass().getName());
                }
                default: {
                    JBBPDslBuilder.doTabs(format, buffer, structCounter).append(item);
                }
            }
            if (!format && !(item instanceof ItemComment)) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }

    protected BinFieldContainer collectAnnotatedFields(Class<?> annotatedClass) {
        Bin defaultBin = annotatedClass.getAnnotation(Bin.class);
        BinFieldContainer result = defaultBin != null ? new BinFieldContainer(annotatedClass, defaultBin, true, null) : new BinFieldContainer(annotatedClass, null);
        Class<?> superClass = annotatedClass.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            BinFieldContainer parentFields = this.collectAnnotatedFields(superClass);
            if (!parentFields.fields.isEmpty()) {
                result.addAllFromContainerExcludeEndStruct(parentFields);
            }
        }
        for (Field f : annotatedClass.getDeclaredFields()) {
            Class<?> type;
            Bin foundFieldBin;
            if ((f.getModifiers() & 0x19A) != 0 || (foundFieldBin = f.getAnnotation(Bin.class)) == null && defaultBin == null) continue;
            this.validateAnnotatedField(defaultBin, foundFieldBin, f);
            Class<?> clazz = type = f.getType().isArray() ? f.getType().getComponentType() : f.getType();
            if (type.isPrimitive() || type == String.class) {
                if (foundFieldBin != null) {
                    result.addBinField(foundFieldBin, true, f);
                    continue;
                }
                result.addBinField(defaultBin, false, f);
                continue;
            }
            BinFieldContainer container = this.collectAnnotatedFields(type);
            if (container.fields.isEmpty()) continue;
            if (foundFieldBin != null) {
                container.bin = foundFieldBin;
                container.fieldLocalAnnotation = true;
            }
            container.field = f;
            result.addContainer(container);
        }
        result.sort();
        if (!result.fields.isEmpty()) {
            result.addContainer(BinFieldContainer.END_STRUCT);
        }
        return result;
    }

    private void validateAnnotatedField(Bin defaultBin, Bin fieldBin, Field field) {
        Bin bin;
        Bin bin2 = bin = fieldBin == null ? defaultBin : fieldBin;
        if ((bin.type() == BinType.UNDEFINED && field.getType().isArray() || bin.type().name().endsWith("_ARRAY")) && bin.arraySizeExpr().isEmpty()) {
            throw new IllegalArgumentException(field.toString() + ": missing expression in Bin#arraySizeExpression");
        }
    }

    public JBBPDslBuilder AnnotatedClass(Class<?> annotatedClass) {
        return this.addAnnotatedClass(annotatedClass, false);
    }

    public JBBPDslBuilder AnnotatedClassFields(Class<?> annotatedClass) {
        return this.addAnnotatedClass(annotatedClass, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected JBBPDslBuilder addAnnotatedClass(Class<?> annotatedClass, boolean onlyFields) {
        BinFieldContainer collected = this.collectAnnotatedFields(annotatedClass);
        JBBPByteOrder old = this.byteOrder;
        this.byteOrder = JBBPByteOrder.BIG_ENDIAN;
        if (!onlyFields) {
            this.Struct(collected.getName());
        } else {
            int indexOfLastEndStruct = -1;
            for (int i = collected.fields.size() - 1; i >= 0; --i) {
                if (collected.fields.get(i) != BinFieldContainer.END_STRUCT) continue;
                indexOfLastEndStruct = i;
                break;
            }
            if (indexOfLastEndStruct < 0) {
                throw new IllegalStateException("Can't find end of structure");
            }
            collected.fields.remove(indexOfLastEndStruct);
        }
        ArrayList<Pair> stack = new ArrayList<Pair>();
        class Pair {
            final BinFieldContainer container;
            final Iterator<BinField> fieldIterator;

            Pair(BinFieldContainer container) {
                this.container = container;
                this.fieldIterator = container.fields.iterator();
            }
        }
        stack.add(new Pair(collected));
        block26: while (true) {
            if (stack.isEmpty()) {
                this.byteOrder = old;
                return this;
            }
            Pair pair = (Pair)stack.remove(0);
            while (true) {
                String comment;
                BinField field;
                block40: {
                    if (!pair.fieldIterator.hasNext()) continue block26;
                    field = pair.fieldIterator.next();
                    if (field instanceof BinFieldContainer) {
                        BinFieldContainer binFieldContainer = (BinFieldContainer)field;
                        if (binFieldContainer == BinFieldContainer.END_STRUCT) {
                            this.CloseStruct();
                            break block40;
                        } else {
                            if (field.isArrayField()) {
                                this.StructArray(binFieldContainer.getName(), binFieldContainer.bin.arraySizeExpr());
                            } else {
                                this.Struct(binFieldContainer.getName());
                            }
                            stack.add(0, pair);
                            stack.add(0, new Pair(binFieldContainer));
                            continue block26;
                        }
                    }
                    BinType type = field.findType();
                    this.ByteOrder(pair.container.getByteOrder(field));
                    switch (type) {
                        case BIT_ARRAY: {
                            if (field.bin.paramExpr().isEmpty()) {
                                this.BitArray(field.getName(), pair.container.getBitNumber(field), field.bin.arraySizeExpr());
                                break;
                            }
                            this.CustomArray("bit", field.getName(), field.bin.arraySizeExpr(), field.bin.paramExpr());
                            break;
                        }
                        case BIT: {
                            if (field.bin.paramExpr().isEmpty()) {
                                this.Bits(field.getName(), pair.container.getBitNumber(field));
                                break;
                            }
                            this.Custom("bit", field.getName(), field.bin.paramExpr());
                            break;
                        }
                        case BOOL: {
                            this.Bool(field.getName());
                            break;
                        }
                        case BOOL_ARRAY: {
                            this.BoolArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case BYTE: {
                            this.Byte(field.getName());
                            break;
                        }
                        case BYTE_ARRAY: {
                            this.ByteArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case UBYTE: {
                            this.UByte(field.getName());
                            break;
                        }
                        case UBYTE_ARRAY: {
                            this.UByteArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case SHORT: {
                            this.Short(field.getName());
                            break;
                        }
                        case SHORT_ARRAY: {
                            this.ShortArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case USHORT: {
                            this.UShort(field.getName());
                            break;
                        }
                        case USHORT_ARRAY: {
                            this.UShortArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case INT: {
                            this.Int(field.getName());
                            break;
                        }
                        case INT_ARRAY: {
                            this.IntArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case LONG: {
                            this.Long(field.getName());
                            break;
                        }
                        case LONG_ARRAY: {
                            this.LongArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case FLOAT: {
                            this.Float(field.getName());
                            break;
                        }
                        case FLOAT_ARRAY: {
                            this.FloatArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case DOUBLE: {
                            this.Double(field.getName());
                            break;
                        }
                        case DOUBLE_ARRAY: {
                            this.DoubleArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case STRING: {
                            this.String(field.getName());
                            break;
                        }
                        case STRING_ARRAY: {
                            this.StringArray(field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        case UNDEFINED: {
                            if (field.getCustomType().isEmpty()) break;
                            this.ByteOrder(pair.container.getByteOrder(field));
                            if (field.isArrayField() || !field.bin.arraySizeExpr().isEmpty()) {
                                this.CustomArray(field.bin.customType(), field.getName(), field.bin.arraySizeExpr(), field.bin.paramExpr());
                                break;
                            }
                            this.Custom(field.bin.customType(), field.getName(), field.bin.arraySizeExpr());
                            break;
                        }
                        default: {
                            throw new Error("Unexpected type:" + type);
                        }
                    }
                }
                if ((comment = field.getComment()).isEmpty()) continue;
                this.Comment(comment);
            }
            break;
        }
    }

    protected static class ItemSkip
    extends Item {
        ItemSkip(String sizeExpression) {
            super(BinType.UNDEFINED, null, JBBPByteOrder.BIG_ENDIAN);
            this.sizeExpression = sizeExpression;
        }
    }

    protected static class ItemStructEnd
    extends Item {
        private final boolean endAll;

        ItemStructEnd(boolean endAll) {
            super(BinType.UNDEFINED, null, JBBPByteOrder.BIG_ENDIAN);
            this.endAll = endAll;
        }
    }

    protected static class ItemResetCounter
    extends Item {
        ItemResetCounter() {
            super(BinType.UNDEFINED, null, JBBPByteOrder.BIG_ENDIAN);
        }
    }

    protected static class ItemVal
    extends Item {
        ItemVal(String name, String sizeExpression) {
            super(BinType.UNDEFINED, JBBPDslBuilder.assertTextNotNullAndTrimmedNotEmpty(name), JBBPByteOrder.BIG_ENDIAN);
            this.sizeExpression = JBBPDslBuilder.assertExpressionChars(JBBPDslBuilder.assertTextNotNullAndTrimmedNotEmpty(sizeExpression).trim());
        }
    }

    protected static class ItemAlign
    extends Item {
        ItemAlign(String sizeExpression) {
            super(BinType.UNDEFINED, null, JBBPByteOrder.BIG_ENDIAN);
            this.sizeExpression = sizeExpression;
        }
    }

    protected static class ItemComment
    extends Item {
        private final boolean newLine;
        private final String comment;

        ItemComment(String text, boolean newLine) {
            super(BinType.UNDEFINED, "_ignored_because_comment_", JBBPByteOrder.BIG_ENDIAN);
            this.comment = text;
            this.newLine = newLine;
        }

        String getComment() {
            return this.comment == null ? "" : this.comment;
        }

        boolean isNewLine() {
            return this.newLine;
        }
    }

    protected static class BinFieldContainer
    extends BinField {
        static final BinFieldContainer END_STRUCT = new BinFieldContainer(null, null);
        final List<BinField> fields = new ArrayList<BinField>();
        final Class<?> klazz;

        BinFieldContainer(Class<?> klazz, Bin bin, boolean fieldLocalAnnotation, Field field) {
            super(bin, fieldLocalAnnotation, field);
            this.klazz = klazz;
        }

        BinFieldContainer(Class<?> klazz, Field field) {
            super(null, false, field);
            this.klazz = klazz;
        }

        void sort() {
            Collections.sort(this.fields);
        }

        void addAllFromContainerExcludeEndStruct(BinFieldContainer container) {
            for (BinField field : container.fields) {
                if (field == END_STRUCT) continue;
                this.fields.add(field);
            }
        }

        void addContainer(BinFieldContainer container) {
            this.fields.add(container);
        }

        void addBinField(Bin bin, boolean fieldLocalAnnotation, Field field) {
            this.fields.add(new BinField(bin, fieldLocalAnnotation, field));
        }

        JBBPByteOrder getByteOrder(BinField field) {
            return field.bin.byteOrder();
        }

        @Override
        String getName() {
            String name = super.getName();
            return name == null ? this.klazz.getSimpleName() : name;
        }

        JBBPBitNumber getBitNumber(BinField field) {
            JBBPBitNumber result = field.bin.bitNumber() == JBBPBitNumber.BITS_8 ? (this.bin == null ? JBBPBitNumber.BITS_8 : this.bin.bitNumber()) : field.bin.bitNumber();
            return result;
        }
    }

    protected static class BinField
    implements Comparable<BinField> {
        Bin bin;
        Field field;
        boolean fieldLocalAnnotation;

        BinField(Bin bin, boolean fieldLocalAnnotation, Field field) {
            this.fieldLocalAnnotation = fieldLocalAnnotation;
            this.bin = bin;
            this.field = field;
        }

        String getComment() {
            String result = "";
            if (this.fieldLocalAnnotation && this.bin != null) {
                result = this.bin.comment();
            }
            return result;
        }

        boolean isArrayField() {
            return this.field != null && this.field.getType().isArray();
        }

        BinType findType() {
            if (this.field == null) {
                return BinType.STRUCT;
            }
            if (this.bin.type() == BinType.UNDEFINED) {
                return this.bin.customType().isEmpty() ? BinType.findCompatible(this.field.getType()) : this.bin.type();
            }
            return this.bin.type();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        String getName() {
            String result = null;
            if (this.field == null) return result;
            if (!this.fieldLocalAnnotation) return this.field.getName();
            if (this.bin == null) throw new Error("Unexpected");
            return this.bin.name().isEmpty() ? this.field.getName() : this.bin.name();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof BinField) {
                BinField that = (BinField)obj;
                return this.field.equals(that.field) && JBBPUtils.equals(this.bin, that.bin);
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        private int getOrder() {
            if (this.bin != null) {
                return this.bin.order();
            }
            return -1;
        }

        @Override
        public int compareTo(BinField that) {
            int thatOrder;
            int thisOrder = this.getOrder();
            if (thisOrder == (thatOrder = that.getOrder())) {
                return this.getName().compareTo(that.getName());
            }
            return thisOrder < thatOrder ? -1 : 1;
        }

        String getCustomType() {
            return this.bin.customType();
        }
    }

    protected static class Item {
        final BinType type;
        final String name;
        final JBBPByteOrder byteOrder;
        String sizeExpression;
        JBBPBitNumber bitNumber;
        String bitLenExpression;

        Item(BinType type, String name, JBBPByteOrder byteOrder) {
            this.type = type;
            this.name = name == null ? null : JBBPDslBuilder.assertNameIfNotNull(JBBPDslBuilder.assertTextNotNullAndTrimmedNotEmpty(name)).trim();
            this.byteOrder = byteOrder;
        }

        public String toString() {
            boolean isArray;
            Object type;
            boolean customType = this instanceof ItemCustom;
            if (customType) {
                type = ((ItemCustom)this).customType;
                isArray = ((ItemCustom)this).array;
            } else {
                type = this.type.name().toLowerCase(Locale.ENGLISH);
                isArray = ((String)type).endsWith("_array");
                if (isArray) {
                    type = ((String)type).substring(0, ((String)type).indexOf(95));
                }
                if (((String)type).equals("string") || ((String)type).equals("float") || ((String)type).equals("double")) {
                    type = (String)type + "j";
                }
            }
            StringBuilder result = new StringBuilder();
            if (this.byteOrder == JBBPByteOrder.LITTLE_ENDIAN) {
                result.append('<');
            }
            result.append((String)type);
            if (customType) {
                if (this.bitLenExpression != null) {
                    result.append(':').append(this.makeExpressionForExtraField(this.bitLenExpression));
                }
            } else if (this.type == BinType.BIT || this.type == BinType.BIT_ARRAY) {
                result.append(':');
                if (this.bitLenExpression == null) {
                    if (this.bitNumber == null) {
                        result.append('1');
                    } else {
                        result.append(this.bitNumber.getBitNumber());
                    }
                } else {
                    result.append(this.makeExpressionForExtraField(this.bitLenExpression));
                }
            }
            if (isArray) {
                result.append('[').append(this.sizeExpression).append(']');
            }
            if (this.name != null && !this.name.isEmpty()) {
                result.append(' ').append(this.name);
            }
            result.append(';');
            return result.toString();
        }

        protected String makeExpressionForExtraField(String expression) {
            try {
                Long.parseLong(expression);
                return expression;
            }
            catch (NumberFormatException ex) {
                return "(" + expression + ")";
            }
        }
    }

    protected static class ItemCustom
    extends Item {
        final String customType;
        boolean array;

        ItemCustom(String customType, String name, JBBPByteOrder byteOrder) {
            super(BinType.UNDEFINED, name, byteOrder);
            this.customType = customType;
        }
    }
}

