/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.z80.disasm;

import com.igormaznitsa.z80.MemoryAccessProvider;
import com.igormaznitsa.z80.Z80Instruction;
import java.util.ArrayList;
import java.util.List;

public final class Z80Disasm {
    private static final Z80Instruction[] NO_PREFIXED;
    private static final Z80Instruction[] CB_PREFIXED;
    private static final Z80Instruction[] DD_PREFIXED;
    private static final Z80Instruction[] FD_PREFIXED;
    private static final Z80Instruction[] DDCB_PREFIXED;
    private static final Z80Instruction[] FDCB_PREFIXED;

    private Z80Disasm() {
    }

    public static List<Z80Instruction> decodeList(MemoryAccessProvider memoryAccessProvider, List<Z80Instruction> container, int offset, int instructionsToDecode) {
        ArrayList<Z80Instruction> result = container == null ? new ArrayList<Z80Instruction>() : container;
        int off = offset;
        for (int instructionsCounter = instructionsToDecode; instructionsCounter > 0; --instructionsCounter) {
            Z80Instruction i = Z80Disasm.decodeInstruction(memoryAccessProvider, off);
            result.add(i);
            if (i == null) {
                ++off;
                continue;
            }
            off += i.getLength();
        }
        return result;
    }

    public static Z80Instruction decodeInstruction(MemoryAccessProvider memoryAccessProvider, int offset) {
        Z80Instruction[] arrayToFind;
        int off = offset;
        switch (memoryAccessProvider.readAddress(off++) & 0xFF) {
            case 203: {
                arrayToFind = CB_PREFIXED;
                break;
            }
            case 221: {
                arrayToFind = (memoryAccessProvider.readAddress(off) & 0xFF) == 203 ? DDCB_PREFIXED : DD_PREFIXED;
                break;
            }
            case 253: {
                arrayToFind = (memoryAccessProvider.readAddress(off) & 0xFF) == 203 ? FDCB_PREFIXED : FD_PREFIXED;
                break;
            }
            default: {
                arrayToFind = NO_PREFIXED;
            }
        }
        Z80Instruction result = null;
        for (Z80Instruction i : arrayToFind) {
            if (!i.matches(memoryAccessProvider, offset)) continue;
            result = i;
            break;
        }
        return result;
    }

    static {
        ArrayList<Z80Instruction> noPrefixed = new ArrayList<Z80Instruction>();
        ArrayList<Z80Instruction> cbPrefixed = new ArrayList<Z80Instruction>();
        ArrayList<Z80Instruction> ddPrefixed = new ArrayList<Z80Instruction>();
        ArrayList<Z80Instruction> fdPrefixed = new ArrayList<Z80Instruction>();
        ArrayList<Z80Instruction> ddcbPrefixed = new ArrayList<Z80Instruction>();
        ArrayList<Z80Instruction> fdcbPrefixed = new ArrayList<Z80Instruction>();
        block14: for (Z80Instruction i : Z80Instruction.getInstructions()) {
            int[] codes = i.getInstructionCodes();
            switch (i.getLength()) {
                case 1: {
                    noPrefixed.add(i);
                    continue block14;
                }
                case 2: {
                    switch (codes[0]) {
                        case 203: {
                            cbPrefixed.add(i);
                            continue block14;
                        }
                        case 221: {
                            ddPrefixed.add(i);
                            continue block14;
                        }
                        case 253: {
                            fdPrefixed.add(i);
                            continue block14;
                        }
                    }
                    noPrefixed.add(i);
                    continue block14;
                }
            }
            switch (codes[0]) {
                case 203: {
                    cbPrefixed.add(i);
                    continue block14;
                }
                case 221: {
                    if (codes[1] == 203) {
                        ddcbPrefixed.add(i);
                        continue block14;
                    }
                    ddPrefixed.add(i);
                    continue block14;
                }
                case 253: {
                    if (codes[1] == 203) {
                        fdcbPrefixed.add(i);
                        continue block14;
                    }
                    fdPrefixed.add(i);
                    continue block14;
                }
            }
            noPrefixed.add(i);
        }
        NO_PREFIXED = noPrefixed.toArray(new Z80Instruction[0]);
        CB_PREFIXED = cbPrefixed.toArray(new Z80Instruction[0]);
        DD_PREFIXED = ddPrefixed.toArray(new Z80Instruction[0]);
        FD_PREFIXED = fdPrefixed.toArray(new Z80Instruction[0]);
        DDCB_PREFIXED = ddcbPrefixed.toArray(new Z80Instruction[0]);
        FDCB_PREFIXED = fdcbPrefixed.toArray(new Z80Instruction[0]);
    }
}

