/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly;

import com.igormaznitsa.z80.Z80;
import com.igormaznitsa.zxpoly.Bounds;
import com.igormaznitsa.zxpoly.MainFormParameters;
import com.igormaznitsa.zxpoly.Version;
import com.igormaznitsa.zxpoly.animeencoders.AGifEncoder;
import com.igormaznitsa.zxpoly.animeencoders.AnimatedGifTunePanel;
import com.igormaznitsa.zxpoly.animeencoders.AnimationEncoder;
import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.KempstonMouse;
import com.igormaznitsa.zxpoly.components.KeyboardKempstonAndTapeIn;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.RomData;
import com.igormaznitsa.zxpoly.components.betadisk.TrDosDisk;
import com.igormaznitsa.zxpoly.components.sound.Beeper;
import com.igormaznitsa.zxpoly.components.sound.SourceSoundPort;
import com.igormaznitsa.zxpoly.components.sound.VolumeProfile;
import com.igormaznitsa.zxpoly.components.tapereader.TapeContext;
import com.igormaznitsa.zxpoly.components.tapereader.TapeSource;
import com.igormaznitsa.zxpoly.components.tapereader.TapeSourceFactory;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.components.video.VirtualKeyboardDecoration;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import com.igormaznitsa.zxpoly.components.video.tvfilters.TvFilterChain;
import com.igormaznitsa.zxpoly.formats.FormatPRom;
import com.igormaznitsa.zxpoly.formats.FormatRom;
import com.igormaznitsa.zxpoly.formats.FormatSNA;
import com.igormaznitsa.zxpoly.formats.FormatSZX;
import com.igormaznitsa.zxpoly.formats.FormatSpec256;
import com.igormaznitsa.zxpoly.formats.FormatZ80;
import com.igormaznitsa.zxpoly.formats.FormatZXP;
import com.igormaznitsa.zxpoly.formats.Snapshot;
import com.igormaznitsa.zxpoly.streamer.ZxVideoStreamer;
import com.igormaznitsa.zxpoly.tracer.TraceCpuForm;
import com.igormaznitsa.zxpoly.trainers.AbstractTrainer;
import com.igormaznitsa.zxpoly.trainers.TrainerPok;
import com.igormaznitsa.zxpoly.ui.AboutDialog;
import com.igormaznitsa.zxpoly.ui.AddressPanel;
import com.igormaznitsa.zxpoly.ui.CpuLoadIndicator;
import com.igormaznitsa.zxpoly.ui.FastButton;
import com.igormaznitsa.zxpoly.ui.GameControllerPanel;
import com.igormaznitsa.zxpoly.ui.JIndicatorLabel;
import com.igormaznitsa.zxpoly.ui.OptionsPanel;
import com.igormaznitsa.zxpoly.ui.SelectTapPosDialog;
import com.igormaznitsa.zxpoly.utils.AppOptions;
import com.igormaznitsa.zxpoly.utils.JHtmlLabel;
import com.igormaznitsa.zxpoly.utils.RomLoader;
import com.igormaznitsa.zxpoly.utils.RomSource;
import com.igormaznitsa.zxpoly.utils.Timer;
import com.igormaznitsa.zxpoly.utils.Utils;
import com.igormaznitsa.zxpspritecorrector.SpriteCorrectorMainFrame;
import com.igormaznitsa.zxpspritecorrector.files.plugins.AbstractFilePlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public final class MainForm
extends JFrame
implements ActionListener,
TapeContext {
    public static final Logger LOGGER = Logger.getLogger(MainForm.class.getName());
    public static final Duration TIMER_INT_DELAY_MILLISECONDS = Duration.ofMillis(20L);
    private static final Icon ICO_MOUSE = new ImageIcon(Utils.loadIcon("mouse.png"));
    private static final Icon ICO_MOUSE_DIS = UIManager.getLookAndFeel().getDisabledIcon(null, ICO_MOUSE);
    private static final Icon ICO_DISK = new ImageIcon(Utils.loadIcon("disk.png"));
    private static final Icon ICO_DISK_DIS = UIManager.getLookAndFeel().getDisabledIcon(null, ICO_DISK);
    private static final Icon ICO_AGIF_RECORD = new ImageIcon(Utils.loadIcon("record.png"));
    private static final Icon ICO_WAV_START = new ImageIcon(Utils.loadIcon("wav_start.png"));
    private static final Icon ICO_WAV_STOP = new ImageIcon(Utils.loadIcon("wav_stop.png"));
    private static final Icon ICO_AGIF_STOP = new ImageIcon(Utils.loadIcon("tape_stop.png"));
    private static final Icon ICO_TAPE = new ImageIcon(Utils.loadIcon("cassette.png"));
    private static final Icon ICO_MDISK = new ImageIcon(Utils.loadIcon("mdisk.png"));
    private static final Icon ICO_TAPE_DIS = UIManager.getLookAndFeel().getDisabledIcon(null, ICO_TAPE);
    private static final Icon ICO_TURBO = new ImageIcon(Utils.loadIcon("turbo.png"));
    private static final Icon ICO_TURBO_DIS = UIManager.getLookAndFeel().getDisabledIcon(null, ICO_TURBO);
    private static final Icon ICO_ZX128 = new ImageIcon(Utils.loadIcon("zx128.png"));
    private static final Icon ICO_ZX128_DIS = UIManager.getLookAndFeel().getDisabledIcon(null, ICO_ZX128);
    private static final Icon ICO_SPRITECORRECTOR = new ImageIcon(Utils.loadIcon("spritecorrector.png"));
    private static final String TEXT_START_ANIM_GIF = "Record AGIF";
    private static final String TEXT_START_WAV = "Record WAV";
    private static final String TEXT_STOP_ANIM_GIF = "Stop AGIF";
    private static final String TEXT_STOP_WAV = "Stop WAV";
    private static final long serialVersionUID = 7309959798344327441L;
    private static final String ROM_BOOTSTRAP_FILE_NAME = "bootstrap.rom";
    private final boolean tryConsumeLessSystemResources;
    private static final WavFileFilter FILTER_FORMAT_WAV = new WavFileFilter();
    private static final TzxFileFilter FILTER_FORMAT_TZX = new TzxFileFilter();
    private static final TapFileFilter FILTER_FORMAT_TAP = new TapFileFilter();
    private static final FileFilter FILTER_FORMAT_ALL_TAPE = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return FILTER_FORMAT_WAV.accept(f) || FILTER_FORMAT_TAP.accept(f) || FILTER_FORMAT_TZX.accept(f);
        }

        @Override
        public String getDescription() {
            return "All supported tape snapshots (*.wav,*.tzx,*.tap)";
        }
    };
    private static final SclFileFilter FILTER_FORMAT_SCL = new SclFileFilter();
    private static final TrdFileFilter FILTER_FORMAT_TRD = new TrdFileFilter();
    private static final FileFilter FILTER_FORMAT_ALL_DISK = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return FILTER_FORMAT_SCL.accept(f) || FILTER_FORMAT_TRD.accept(f);
        }

        @Override
        public String getDescription() {
            return "All supported disk images (*.scl,*.trd)";
        }
    };
    private static final Snapshot SNAPSHOT_FORMAT_Z80 = new FormatZ80();
    private static final Snapshot SNAPSHOT_FORMAT_SZX = new FormatSZX();
    private static final Snapshot SNAPSHOT_FORMAT_SNA = new FormatSNA();
    private static final Snapshot SNAPSHOT_FORMAT_ZXP = new FormatZXP();
    private static final Snapshot SNAPSHOT_FORMAT_ROM = new FormatRom();
    private static final Snapshot SNAPSHOT_FORMAT_PROM = new FormatPRom();
    private static final Snapshot SNAPSHOT_FORMAT_SPEC256 = new FormatSpec256();
    private static final FileFilter FILTER_FORMAT_ALL_SNAPSHOTS = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return SNAPSHOT_FORMAT_Z80.accept(f) || SNAPSHOT_FORMAT_SZX.accept(f) || SNAPSHOT_FORMAT_SPEC256.accept(f) || SNAPSHOT_FORMAT_SNA.accept(f) || SNAPSHOT_FORMAT_ZXP.accept(f) || SNAPSHOT_FORMAT_ROM.accept(f) || SNAPSHOT_FORMAT_PROM.accept(f);
        }

        @Override
        public String getDescription() {
            return "All snapshots (*.z80, *.sna, *.szx, *.zip, *.zxp, *.rom, *.prom)";
        }
    };
    public static RomData BASE_ROM;
    private final AtomicReference<JFrame> currentFullScreen = new AtomicReference();
    private final int intTicksBeforeFrameDraw;
    private final CpuLoadIndicator indicatorCpu0 = new CpuLoadIndicator(48, 14, 4, "CPU0", Color.GREEN, Color.DARK_GRAY, Color.WHITE);
    private final CpuLoadIndicator indicatorCpu1 = new CpuLoadIndicator(48, 14, 4, "CPU1", Color.GREEN, Color.DARK_GRAY, Color.WHITE);
    private final CpuLoadIndicator indicatorCpu2 = new CpuLoadIndicator(48, 14, 4, "CPU2", Color.GREEN, Color.DARK_GRAY, Color.WHITE);
    private final CpuLoadIndicator indicatorCpu3 = new CpuLoadIndicator(48, 14, 4, "CPU3", Color.GREEN, Color.DARK_GRAY, Color.WHITE);
    private final TraceCpuForm[] cpuTracers = new TraceCpuForm[4];
    private final AtomicInteger activeTracerWindowCounter = new AtomicInteger();
    private final AtomicReference<AnimationEncoder> currentAnimationEncoder = new AtomicReference();
    private final Motherboard board;
    private final ZxVideoStreamer videoStreamer;
    private final Timer wallClock;
    private final Runnable traceWindowsUpdater = new Runnable(){

        @Override
        public void run() {
            int index = 0;
            for (TraceCpuForm form : MainForm.this.cpuTracers) {
                Z80 cpu;
                if (form == null || (cpu = MainForm.this.board.getModules()[index++].getCpu()).getPrefixInProcessing() != 0) continue;
                form.refresh();
            }
        }
    };
    private final KeyboardKempstonAndTapeIn keyboardAndTapeModule;
    private final KempstonMouse kempstonMouse;
    private final boolean interlaceScan;
    private final ReentrantLock stepLocker = new ReentrantLock();
    private final Thread mainCpuThread;
    private final javax.swing.Timer infoBarUpdateTimer;
    private final AtomicReference<SpriteCorrectorMainFrame> spriteCorrectorMainFrame = new AtomicReference();
    private final ImageIcon sysIcon;
    private final TimingProfile timingProfile;
    private final AtomicBoolean magicButtonTrigger = new AtomicBoolean();
    private volatile long lastFullScreenEventTime = 0L;
    private volatile boolean turboMode = false;
    private volatile boolean zxKeyboardProcessingAllowed = true;
    private AnimatedGifTunePanel.AnimGifOptions lastAnimGifOptions = new AnimatedGifTunePanel.AnimGifOptions("./zxpoly.gif", 10, false);
    private File lastTapFolder;
    private File lastFloppyFolder;
    private File lastSnapshotFolder;
    private File lastScreenshotFolder;
    private Box.Filler filler1;
    private JPopupMenu.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JIndicatorLabel labelDiskUsage;
    private JIndicatorLabel labelMouseUsage;
    private JIndicatorLabel labelTapeUsage;
    private JIndicatorLabel labelTurbo;
    private JIndicatorLabel labelZX128;
    private JMenuItem menuActionAnimatedGIF;
    private JMenuItem menuActionRecordWav;
    private JMenuBar menuBar;
    private JMenu menuCatcher;
    private JMenu menuFile;
    private JMenu menuView;
    private JMenu menuViewZoom;
    private JMenu menuViewVideoFilter;
    private JMenuItem menuViewFullScreen;
    private JMenuItem menuViewZoomIn;
    private JMenuItem menuViewZoomOut;
    private JMenuItem menuFileExit;
    private JMenuItem menuFileFlushDiskChanges;
    private JMenuItem menuFileLoadSnapshot;
    private JMenuItem menuFileLoadPoke;
    private JMenuItem menuFileLoadTap;
    private JMenuItem menuFileCreateEmptyDisk;
    private JMenuItem menuFileOptions;
    private JMenuItem menuFileReset;
    private JMenuItem menuFileSelectDiskA;
    private JMenuItem menuFileSelectDiskB;
    private JMenuItem menuFileSelectDiskC;
    private JMenuItem menuFileSelectDiskD;
    private JMenu menuHelp;
    private JMenuItem menuHelpAbout;
    private JMenuItem menuHelpDonation;
    private JMenu menuLoadDrive;
    private JMenu menuOptions;
    private JCheckBoxMenuItem menuOptionsEnableTrapMouse;
    private JCheckBoxMenuItem menuOptionsEnableSpeaker;
    private JCheckBoxMenuItem menuOptionsEnableVideoStream;
    private JCheckBoxMenuItem menuOptionsShowIndicators;
    private JCheckBoxMenuItem menuOptionsTurbo;
    private JCheckBoxMenuItem menuOptionsOnlyJoystickEvents;
    private JMenu menuOptionsLookAndFeel;
    private JMenu menuOptionsJoystickSelect;
    private JRadioButtonMenuItem menuOptionsJoystickKempston;
    private JRadioButtonMenuItem menuOptionsJoystickProtek;
    private JCheckBoxMenuItem menuOptionsZX128Mode;
    private JMenu menuService;
    private JMenuItem menuServiceGameControllers;
    private JMenuItem menuServiceSaveScreen;
    private JMenuItem menuServiceMakeSnapshot;
    private JMenuItem menuServiceStartEditor;
    private JMenu menuTap;
    private JMenu menuTapExportAs;
    private JMenuItem menuTapExportAsWav;
    private JMenuItem menuTapGotoBlock;
    private JMenuItem menuTapNextBlock;
    private JMenuItem menuTapThreshold;
    private JCheckBoxMenuItem menuTapPlay;
    private JMenuItem menuTapPrevBlock;
    private JMenuItem menuTapeRewindToStart;
    private JCheckBoxMenuItem menuTraceCpu0;
    private JCheckBoxMenuItem menuTraceCpu1;
    private JCheckBoxMenuItem menuTraceCpu2;
    private JCheckBoxMenuItem menuTraceCpu3;
    private JMenu menuTracer;
    private JCheckBoxMenuItem menuTriggerDiffMem;
    private JCheckBoxMenuItem menuTriggerExeCodeDiff;
    private JCheckBoxMenuItem menuTriggerModuleCPUDesync;
    private JPanel panelIndicators;
    private JScrollPane scrollPanel;
    private File lastPokeFileFolder = null;
    private Optional<SourceSoundPort> preTurboSourceSoundPort = Optional.empty();
    private JMenu menuOptionsScaleUi;
    private JMenuItem menuFileMagic;
    private File lastWrittenWavFile = null;

    public MainForm(MainFormParameters parameters) {
        super(parameters.getTitle("ZX-Poly emulator " + Version.APP_VERSION));
        VirtualKeyboardDecoration vkbdContainer;
        AppOptions.setForceFile(parameters.getPreferencesFile(null));
        this.tryConsumeLessSystemResources = parameters.isTryUseLessSystemResources(AppOptions.getInstance().isTryLessResources());
        if (this.tryConsumeLessSystemResources) {
            LOGGER.info("Attempt to consume less system resources");
            this.wallClock = new Timer(TIMER_INT_DELAY_MILLISECONDS, Duration.ofNanos(50000L));
        } else {
            this.wallClock = new Timer(TIMER_INT_DELAY_MILLISECONDS);
        }
        this.setUndecorated(parameters.isUndecorated(false));
        Runtime.getRuntime().addShutdownHook(Thread.ofPlatform().unstarted(this::doOnShutdown));
        this.sysIcon = new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/sys.png")));
        this.timingProfile = parameters.getTimingProfile(AppOptions.getInstance().getTimingProfile());
        LOGGER.info("Timing profile: " + this.timingProfile.name());
        String ticks = System.getProperty("zxpoly.int.ticks", "");
        int intBetweenFrames = AppOptions.getInstance().getIntBetweenFrames();
        try {
            intBetweenFrames = ticks.isEmpty() ? intBetweenFrames : Integer.parseInt(ticks);
        }
        catch (NumberFormatException ex) {
            LOGGER.warning("Can't parse ticks: " + ticks);
        }
        this.intTicksBeforeFrameDraw = intBetweenFrames;
        LOGGER.log(Level.INFO, "INT ticks between frame render: " + this.intTicksBeforeFrameDraw);
        byte[] bootstrapRom = null;
        File bootstrapRomFile = new File(ROM_BOOTSTRAP_FILE_NAME);
        if (bootstrapRomFile.isFile()) {
            LOGGER.info("Detected bootstrap ROM file: " + bootstrapRomFile.getAbsolutePath());
            try {
                bootstrapRom = FileUtils.readFileToByteArray(bootstrapRomFile);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, ex, () -> "Can't load bootstrap rom: " + bootstrapRomFile.getAbsolutePath());
                JOptionPane.showMessageDialog(this, "Can't load bootstrap rom: " + Utils.extractMessage(ex));
                System.exit(-1);
            }
        }
        RomSource rom = RomSource.findForLink(parameters.getRomPath(null), RomSource.UNKNOWN);
        try {
            BASE_ROM = this.loadRom(parameters.getRomPath(null), rom.getRom48names(), rom.getRom128names(), rom.getTrDosNames(), bootstrapRom);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Can't load Spec128 ROM for error: " + ex.getMessage());
            try {
                BASE_ROM = this.loadRom(null, rom.getRom48names(), rom.getRom128names(), rom.getTrDosNames(), bootstrapRom);
            }
            catch (Exception exx) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Can't load TEST ROM: " + ex.getMessage());
                System.exit(-1);
            }
        }
        this.initComponents(BASE_ROM.isTrdosPresented(), parameters.isShowIndicatorPanel(AppOptions.getInstance().isShowIndicatorPanel()));
        this.interlaceScan = parameters.isInterlaceScan(AppOptions.getInstance().isInterlacedScan());
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuActionAnimatedGIF.setText(TEXT_START_ANIM_GIF);
        this.menuActionAnimatedGIF.setIcon(ICO_AGIF_RECORD);
        this.menuActionRecordWav.setText(TEXT_START_WAV);
        this.menuActionRecordWav.setIcon(ICO_WAV_START);
        this.getInputContext().selectInputMethod(Locale.ENGLISH);
        if (parameters.getAppIconPath(null) == null) {
            this.setIconImage(Utils.loadIcon("appico.png"));
        } else {
            try {
                this.setIconImage(ImageIO.read(new File(parameters.getAppIconPath(null))));
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Can't load application icon: " + parameters.getAppIconPath(null), ex);
                System.exit(34);
            }
        }
        boolean allowKempstonMouse = parameters.isAllowKempstonMouse(AppOptions.getInstance().isKempstonMouseAllowed());
        if (!allowKempstonMouse) {
            this.menuOptionsEnableTrapMouse.setEnabled(false);
            this.menuOptionsEnableTrapMouse.setVisible(false);
        }
        try {
            vkbdContainer = parameters.getVirtualKeyboardLook(AppOptions.getInstance().getKeyboardLook()).load();
            LOGGER.info("Virtual keyboard profile: " + vkbdContainer.getId());
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Can't load virtual keyboard: " + ex.getMessage(), ex);
            throw new Error("Can't load virtual keyboard");
        }
        VolumeProfile volumeProfile = parameters.getVolumeProfile(AppOptions.getInstance().getVolumeProfile());
        LOGGER.info("Selected volume profile: " + volumeProfile.name());
        Bounds parameterKeyboardBounds = parameters.getKeyboardBounds(null);
        this.board = new Motherboard(parameters.getBorderWidth(AppOptions.getInstance().getBorderWidth()), volumeProfile, this.timingProfile, BASE_ROM, parameterKeyboardBounds == null ? null : parameterKeyboardBounds.withPositionIfNot(this.getX(), this.getY()), parameters.getBoardMode(AppOptions.getInstance().getDefaultBoardMode()), parameters.isSyncRepaint(AppOptions.getInstance().isSyncPaint()), parameters.isForceAcbChannelSound(AppOptions.getInstance().isSoundChannelsACB()), parameters.isCovoxFb(AppOptions.getInstance().isCovoxFb()), parameters.isTurboSound(AppOptions.getInstance().isTurboSound()), allowKempstonMouse, parameters.isAttributePortFf(AppOptions.getInstance().isAttributePortFf()), vkbdContainer, parameters.isUlaPlus(AppOptions.getInstance().isUlaPlus()), this.tryConsumeLessSystemResources);
        this.board.reset();
        this.menuOptionsZX128Mode.setSelected(this.board.getBoardMode() != BoardMode.ZXPOLY);
        this.menuOptionsTurbo.setSelected(this.turboMode);
        LOGGER.info("Main form completed");
        this.board.reset();
        this.scrollPanel.getViewport().add(this.board.getVideoController());
        this.keyboardAndTapeModule = this.board.findIoDevice(KeyboardKempstonAndTapeIn.class);
        this.kempstonMouse = this.board.findIoDevice(KempstonMouse.class);
        this.menuOptionsOnlyJoystickEvents.setSelected(this.keyboardAndTapeModule.isOnlyJoystickEvents());
        if (this.keyboardAndTapeModule.isKempstonJoystickActivated()) {
            this.menuOptionsJoystickKempston.setSelected(true);
        } else {
            this.menuOptionsJoystickProtek.setSelected(true);
        }
        this.menuOptionsJoystickKempston.addActionListener(e -> this.keyboardAndTapeModule.setKempstonJoystickActivated(this.menuOptionsJoystickKempston.isSelected()));
        this.menuOptionsJoystickProtek.addActionListener(e -> this.keyboardAndTapeModule.setKempstonJoystickActivated(this.menuOptionsJoystickKempston.isSelected()));
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyboardDispatcher(this));
        GridBagConstraints cpuIndicatorConstraint = new GridBagConstraints();
        cpuIndicatorConstraint.ipadx = 5;
        this.panelIndicators.add(this.indicatorCpu0, cpuIndicatorConstraint, 0);
        this.panelIndicators.add(this.indicatorCpu1, cpuIndicatorConstraint, 1);
        this.panelIndicators.add(this.indicatorCpu2, cpuIndicatorConstraint, 2);
        this.panelIndicators.add(this.indicatorCpu3, cpuIndicatorConstraint, 3);
        this.menuOptionsEnableTrapMouse.setSelected(this.board.getVideoController().isMouseTrapEnabled());
        for (Component item : this.menuBar.getComponents()) {
            if (!(item instanceof JMenu)) continue;
            JMenu menuItem = (JMenu)item;
            menuItem.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    MainForm.this.suspendSteps();
                    MainForm.this.keyboardAndTapeModule.doReset();
                    if (e.getSource() == MainForm.this.menuOptions) {
                        MainForm.this.menuOptionsOnlyJoystickEvents.setState(MainForm.this.keyboardAndTapeModule.isOnlyJoystickEvents());
                        MainForm.this.menuOptionsEnableSpeaker.setEnabled(!MainForm.this.turboMode && !MainForm.this.menuOptionsEnableVideoStream.isSelected());
                        MainForm.this.menuOptionsEnableSpeaker.setState(MainForm.this.board.getBeeper().isActive());
                        MainForm.this.menuOptionsTurbo.setState(MainForm.this.isTurboMode());
                    }
                    MainForm.this.menuServiceGameControllers.setEnabled(MainForm.this.keyboardAndTapeModule.isControllerEngineAllowed());
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    MainForm.this.resumeSteps();
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                    MainForm.this.resumeSteps();
                }
            });
        }
        this.videoStreamer = new ZxVideoStreamer(this.board.getVideoController(), streamer -> {
            streamer.stop();
            SwingUtilities.invokeLater(() -> this.menuOptionsEnableVideoStream.setSelected(false));
        });
        if (parameters.isActivateSound(AppOptions.getInstance().isSoundTurnedOn())) {
            this.activateSoundIfPossible();
        }
        this.loadFastButtons();
        this.updateTapeMenu();
        this.pack();
        this.setLocationRelativeTo(null);
        this.mainCpuThread = this.tryConsumeLessSystemResources ? Thread.ofVirtual().name("zx-poly-main-cpu-thread-virtual").unstarted(this::mainLoop) : Thread.ofPlatform().name("zx-poly-main-cpu-thread").unstarted(this::mainLoop);
        this.mainCpuThread.setUncaughtExceptionHandler((t, e) -> {
            LOGGER.severe("Detected exception in main thread, stopping application, see logs");
            e.printStackTrace(System.err);
            System.exit(666);
        });
        this.infoBarUpdateTimer = new javax.swing.Timer(1000, action -> this.updateInfoBar());
        this.infoBarUpdateTimer.setRepeats(true);
        this.infoBarUpdateTimer.setInitialDelay(1000);
        SwingUtilities.invokeLater(() -> {
            this.mainCpuThread.start();
            this.infoBarUpdateTimer.start();
        });
        this.board.findIoDevices().forEach(io -> io.init(this.tryConsumeLessSystemResources));
        this.setDropTarget(new DropTarget(){

            @Override
            public void drop(DropTargetDropEvent e) {
                try {
                    e.acceptDrop(0x40000001);
                    List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    e.dropComplete(true);
                    LOGGER.info("Got drop for file list: " + String.valueOf(files));
                    block19: for (File f : files) {
                        String extension;
                        if (!f.isFile() || !f.canRead()) continue;
                        switch (extension = FilenameUtils.getExtension(f.getName()).toLowerCase(Locale.ENGLISH)) {
                            case "wav": 
                            case "tzx": 
                            case "tap": {
                                LOGGER.info("Activating TAP file: " + String.valueOf(f));
                                MainForm.this.setTapFile(f);
                                continue block19;
                            }
                            case "rom": 
                            case "z80": 
                            case "zip": 
                            case "sna": 
                            case "zxp": {
                                LOGGER.info("Activating snapshot file: " + String.valueOf(f));
                                MainForm.this.setSnapshotFile(f, FILTER_FORMAT_ALL_SNAPSHOTS);
                                continue block19;
                            }
                            case "trd": 
                            case "scl": {
                                if (!MainForm.this.board.isBetaDiskPresented()) continue block19;
                                LOGGER.info("Activating disk file into drive A: " + String.valueOf(f));
                                MainForm.this.setDisk(0, f, FILTER_FORMAT_ALL_DISK);
                                continue block19;
                            }
                        }
                        LOGGER.warning("Ignored dropped file for unknown extension or not file: " + String.valueOf(f));
                    }
                }
                catch (Exception ex) {
                    LOGGER.warning("Can't process drop: " + ex.getMessage());
                }
                SwingUtilities.invokeLater(MainForm.this::requestFocus);
            }
        });
        if (AppOptions.getInstance().isOldColorTvOnStart()) {
            this.board.getVideoController().setTvFilterChain(TvFilterChain.OLDTV);
        }
        this.keyboardAndTapeModule.addTapeStateChangeListener(e -> this.setFastButtonState(FastButton.TAPE_PLAY_STOP, e.getTap() != null && e.getTap().isPlaying()));
        if (parameters.getOpenSnapshot() != null) {
            SwingUtilities.invokeLater(() -> this.setSnapshotFile(parameters.getOpenSnapshot(), FILTER_FORMAT_ALL_SNAPSHOTS));
        }
        this.menuBar.setVisible(parameters.isShowMainMenu(true));
        Bounds forceBounds = parameters.getBounds(null);
        if (forceBounds != null) {
            SwingUtilities.invokeLater(() -> {
                if (forceBounds.hasCoordinates()) {
                    this.setBounds(new Rectangle(forceBounds.getX(), forceBounds.getY(), forceBounds.getWidth(), forceBounds.getHeight()));
                } else {
                    this.setSize(forceBounds.getWidth(), forceBounds.getHeight());
                }
            });
        }
        if (parameters.getKeyboardBounds(null) != null) {
            SwingUtilities.invokeLater(() -> this.showVirtualKeyboard(true));
        }
    }

    private static void setMenuEnable(JMenuItem item, boolean enable) {
        if (item instanceof JMenu) {
            JMenu menuItem = (JMenu)item;
            menuItem.setEnabled(enable);
            for (int i = 0; i < menuItem.getItemCount(); ++i) {
                MainForm.setMenuEnable(menuItem.getItem(i), enable);
            }
        } else if (item != null) {
            item.setEnabled(enable);
        }
    }

    private void loadFastButtons() {
        List<FastButton> fastButtonsInOptions = AppOptions.getInstance().getFastButtons();
        this.formFastButtons(this.menuBar, FastButton.VALUES.stream().filter(x -> !x.isOptional() || fastButtonsInOptions.contains(x)).collect(Collectors.toList()));
    }

    private void doOnShutdown() {
        this.videoStreamer.stop();
    }

    private Optional<SourceSoundPort> showSelectSoundLineDialog(List<SourceSoundPort> variants, String previouslySelected, boolean showDialog) {
        Utils.assertUiThread();
        JPanel panel = new JPanel(new FlowLayout(4));
        JComboBox<SourceSoundPort> comboBox = new JComboBox<SourceSoundPort>(variants.toArray(new SourceSoundPort[0]));
        comboBox.addActionListener(x -> comboBox.setToolTipText(comboBox.getSelectedItem().toString()));
        comboBox.setToolTipText(comboBox.getSelectedItem().toString());
        int maxStringLen = 0;
        int index = -1;
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            String str = comboBox.getItemAt(i).toString();
            if (str.equals(previouslySelected)) {
                index = i;
            }
            maxStringLen = Math.max(maxStringLen, str.length());
        }
        if (showDialog) {
            comboBox.setPrototypeDisplayValue(new SourceSoundPort(null, StringUtils.repeat('#', Math.min(40, maxStringLen)), null));
            comboBox.setSelectedIndex(Math.max(0, index));
            panel.add(new JLabel("Sound device:"));
            panel.add(comboBox);
            if (JOptionPane.showConfirmDialog(this, panel, "Select sound device", 2, -1) == 0) {
                SourceSoundPort selected = (SourceSoundPort)comboBox.getSelectedItem();
                return Optional.of(selected);
            }
            return Optional.empty();
        }
        return index < 0 ? Optional.empty() : Optional.of(comboBox.getItemAt(index));
    }

    private Optional<SourceSoundPort> findAudioLine(AudioFormat audioFormat, boolean interactive) {
        List<SourceSoundPort> foundPorts = SourceSoundPort.findForFormat(audioFormat);
        LOGGER.info("Detected audio source lines: " + String.valueOf(foundPorts));
        if (foundPorts.isEmpty()) {
            if (interactive) {
                JOptionPane.showMessageDialog(this, "There is no detected audio devices!", "Can't find audio device", 2);
            }
            return Optional.empty();
        }
        if (foundPorts.size() == 1) {
            return Optional.of(foundPorts.getFirst());
        }
        Optional<SourceSoundPort> result = this.showSelectSoundLineDialog(foundPorts, AppOptions.getInstance().getLastSelectedAudioDevice(), interactive);
        if (interactive) {
            result.ifPresent(sourceSoundPort -> AppOptions.getInstance().setLastSelectedAudioDevice(sourceSoundPort.toString()));
        }
        return result;
    }

    private RomData loadRom(String romPath, Set<String> rom48names, Set<String> rom128names, Set<String> trdosNames, byte[] predefinedRomData) throws Exception {
        if (predefinedRomData != null) {
            byte[] normalized;
            LOGGER.warning("Provided predefined ROM data, length " + predefinedRomData.length + " bytes");
            if (predefinedRomData.length < 49152) {
                LOGGER.warning("Extend predefined ROM binary data to 3 ROM pages");
                normalized = Arrays.copyOf(predefinedRomData, 49152);
            } else if (predefinedRomData.length > 49152) {
                LOGGER.warning("Cutting predefined ROM binary data to 3 ROM pages");
                normalized = Arrays.copyOf(predefinedRomData, 49152);
            } else {
                normalized = predefinedRomData;
            }
            return new RomData("Predefined ROM binary", normalized);
        }
        if (romPath != null) {
            RomData cacheFolder2;
            block32: {
                if (romPath.contains("://")) {
                    try {
                        String cached = "loadedrom_" + Integer.toHexString(romPath.hashCode()).toUpperCase(Locale.ENGLISH) + ".rom";
                        File cacheFolder2 = AppOptions.getInstance().getRomCacheFolder();
                        File cachedRom = new File(cacheFolder2, cached);
                        RomData result = null;
                        boolean load = true;
                        if (cachedRom.isFile()) {
                            LOGGER.log(Level.INFO, "Load cached ROM downloaded from '" + romPath + "' : " + String.valueOf(cachedRom));
                            result = new RomData(cachedRom.getName(), FileUtils.readFileToByteArray(cachedRom));
                            load = false;
                        }
                        if (load) {
                            LOGGER.log(Level.INFO, "Load ROM from external URL: " + romPath);
                            result = RomLoader.getROMFrom(romPath, rom48names, rom128names, trdosNames);
                            if (cacheFolder2.isDirectory() || cacheFolder2.mkdirs()) {
                                FileUtils.writeByteArrayToFile(cachedRom, result.getAsArray());
                                LOGGER.log(Level.INFO, "Loaded ROM saved in cache as file : " + romPath);
                            }
                        }
                        return result;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Can't load ROM from '" + romPath + "': " + ex.getMessage(), ex);
                        throw ex;
                    }
                }
                LOGGER.log(Level.INFO, "Load ROM from embedded resource '" + romPath + "'");
                InputStream in = Utils.findResourceOrError("com/igormaznitsa/zxpoly/rom/" + romPath);
                try {
                    cacheFolder2 = RomData.read(romPath, in);
                    if (in == null) break block32;
                }
                catch (Throwable cacheFolder2) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable cachedRom) {
                                cacheFolder2.addSuppressed(cachedRom);
                            }
                        }
                        throw cacheFolder2;
                    }
                    catch (IllegalArgumentException ex) {
                        File file = new File(romPath);
                        if (file.isFile()) {
                            try (FileInputStream in2 = new FileInputStream(file);){
                                RomData romData = RomData.read(file.getName(), in2);
                                return romData;
                            }
                        }
                        throw new IllegalArgumentException("Can't find ROM: " + romPath);
                    }
                }
                in.close();
            }
            return cacheFolder2;
        }
        String testRom = "zxpolytest.prom";
        LOGGER.info("Load ROM from embedded resource 'zxpolytest.prom'");
        try (InputStream in = Utils.findResourceOrError("com/igormaznitsa/zxpoly/rom/zxpolytest.prom");){
            RomData romData = RomData.read("zxpolytest.prom", in);
            return romData;
        }
    }

    private void updateTapeMenu() {
        boolean sensitivity;
        boolean navigable;
        TapeSource reader = this.keyboardAndTapeModule.getTap();
        if (reader == null) {
            this.setFastButtonState(FastButton.TAPE_PLAY_STOP, false);
            this.menuTap.setEnabled(false);
            this.menuTapPlay.setSelected(false);
            this.menuTapExportAs.setEnabled(false);
            navigable = false;
            sensitivity = false;
        } else {
            this.menuTap.setEnabled(true);
            this.menuTapPlay.setSelected(reader.isPlaying());
            this.setFastButtonState(FastButton.TAPE_PLAY_STOP, reader.isPlaying());
            this.menuTapExportAs.setEnabled(reader.canGenerateWav());
            navigable = reader.isNavigable();
            sensitivity = reader.isThresholdAllowed();
        }
        this.menuTapGotoBlock.setEnabled(navigable);
        this.menuTapNextBlock.setEnabled(navigable);
        this.menuTapPrevBlock.setEnabled(navigable);
        this.menuTapThreshold.setEnabled(sensitivity);
    }

    private void formFastButtons(JMenuBar menuBar, List<FastButton> fastButtons) {
        Arrays.stream(menuBar.getComponents()).filter(c -> FastButton.findForComponentName(c.getName()) != null).toList().forEach(menuBar::remove);
        JPopupMenu popupMenu = new JPopupMenu("Fast buttons");
        for (FastButton fb : FastButton.VALUES) {
            boolean selected = fastButtons.contains((Object)fb) || !fb.isOptional();
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(fb.getTitle(), selected);
            menuItem.setEnabled(fb.isOptional());
            if (fb.isOptional()) {
                menuItem.addActionListener(e -> {
                    ArrayList<FastButton> newList = new ArrayList<FastButton>(fastButtons);
                    newList.remove((Object)fb);
                    if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                        newList.add(fb);
                    }
                    AppOptions.getInstance().setFastButtons(newList);
                    this.loadFastButtons();
                });
            }
            popupMenu.add(menuItem);
        }
        menuBar.setComponentPopupMenu(popupMenu);
        fastButtons.forEach(b -> {
            AbstractButton abstractButton;
            if (b.getButtonClass().isAssignableFrom(JButton.class)) {
                abstractButton = new JButton();
                abstractButton.setRolloverEnabled(false);
            } else if (b.getButtonClass().isAssignableFrom(JToggleButton.class)) {
                abstractButton = new JToggleButton();
                abstractButton.setRolloverEnabled(false);
            } else {
                throw new Error("Unexpected button class: " + String.valueOf(b.getButtonClass()));
            }
            abstractButton.setName(b.getComponentName());
            abstractButton.setIcon(b.getIcon());
            abstractButton.setSelectedIcon(b.getIconSelected());
            abstractButton.setToolTipText(b.getToolTip());
            abstractButton.setFocusable(false);
            switch (b) {
                case SOUND_ON_OFF: {
                    abstractButton.setSelected(!this.board.getBeeper().isNullBeeper());
                    abstractButton.addActionListener(e -> {
                        if (((JToggleButton)e.getSource()).isSelected()) {
                            if (this.isTurboMode()) {
                                ((JToggleButton)e.getSource()).setSelected(false);
                            } else if (!this.tryFastSpeakerActivation()) {
                                this.setSoundActivate(true, new SourceSoundPort[0]);
                            }
                        } else {
                            this.setSoundActivate(false, new SourceSoundPort[0]);
                        }
                    });
                    break;
                }
                case RESET: {
                    abstractButton.addActionListener(e -> this.makeReset());
                    break;
                }
                case SCREENSHOT: {
                    abstractButton.addActionListener(this::menuServiceSaveScreenActionPerformed);
                    break;
                }
                case MAGIC: {
                    abstractButton.addActionListener(e -> this.makeMagic());
                    break;
                }
                case TAPE_PLAY_STOP: {
                    abstractButton.setSelected(this.keyboardAndTapeModule.getTap() != null && this.keyboardAndTapeModule.getTap().isPlaying());
                    abstractButton.addActionListener(e -> {
                        JToggleButton source = (JToggleButton)e.getSource();
                        if (source.isSelected()) {
                            if (!this.setTapePlay(true)) {
                                source.setSelected(false);
                            }
                        } else {
                            this.setTapePlay(false);
                        }
                    });
                    break;
                }
                case TURBO_MODE: {
                    abstractButton.setSelected(this.turboMode);
                    abstractButton.addActionListener(e -> {
                        JToggleButton source = (JToggleButton)e.getSource();
                        this.setTurboModeActive(source.isSelected());
                    });
                    break;
                }
                case ZX_KEYBOARD_OFF: {
                    abstractButton.setSelected(this.keyboardAndTapeModule.isOnlyJoystickEvents());
                    abstractButton.addActionListener(e -> {
                        JToggleButton source = (JToggleButton)e.getSource();
                        this.setDisableZxKeyboardEvents(source.isSelected());
                    });
                    break;
                }
                case START_PAUSE: {
                    abstractButton.setSelected(this.stepLocker.isHeldByCurrentThread());
                    abstractButton.addActionListener(e -> {
                        JToggleButton source = (JToggleButton)e.getSource();
                        if (source.isSelected()) {
                            this.stepLocker.lock();
                        } else {
                            this.stepLocker.unlock();
                        }
                    });
                    break;
                }
                case WRITE_WAV: {
                    abstractButton.setSelected(this.board.getBeeper().hasActiveWaFile());
                    abstractButton.addActionListener(e -> {
                        JToggleButton source = (JToggleButton)e.getSource();
                        this.setWavRecordForSound(source.isSelected());
                    });
                    break;
                }
                case VIRTUAL_KEYBOARD: {
                    abstractButton.setSelected(this.board.getVideoController().isVkbShow());
                    abstractButton.addActionListener(e -> {
                        JToggleButton source = (JToggleButton)e.getSource();
                        this.showVirtualKeyboard(source.isSelected());
                    });
                    break;
                }
                default: {
                    throw new Error("Unexpected fast button: " + String.valueOf(b));
                }
            }
            menuBar.add(abstractButton);
        });
        menuBar.revalidate();
        menuBar.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        boolean lessResources = this.tryConsumeLessSystemResources;
        this.wallClock.next();
        int countdownToNotifyRepaint = this.intTicksBeforeFrameDraw;
        int countdownToAnimationSave = 0;
        long sessionIntCounter = 0L;
        int nextBlinkLineTiStates = this.timingProfile.tstatesStartScreen + this.timingProfile.tstatesPerVideo;
        int blinkLineY = 0;
        while (!Thread.currentThread().isInterrupted()) {
            boolean notifyRepaintScreen = false;
            boolean doBlink = false;
            int frameTiStates = this.board.getFrameTiStates();
            boolean inTurboMode = this.turboMode;
            boolean tiStatesForIntExhausted = frameTiStates >= this.timingProfile.tstatesFrame;
            boolean intTickForWallClockReached = this.wallClock.completed();
            if (!inTurboMode && tiStatesForIntExhausted && !intTickForWallClockReached) {
                this.wallClock.sleep();
            }
            intTickForWallClockReached = this.wallClock.completed();
            if (this.stepLocker.tryLock()) {
                try {
                    boolean doCpuIntTick;
                    if (intTickForWallClockReached) {
                        if (tiStatesForIntExhausted) {
                            ++sessionIntCounter;
                            doCpuIntTick = true;
                            if (--countdownToNotifyRepaint <= 0) {
                                countdownToNotifyRepaint = this.intTicksBeforeFrameDraw;
                                notifyRepaintScreen = true;
                            }
                            --countdownToAnimationSave;
                            nextBlinkLineTiStates = this.timingProfile.tstatesStartScreen + this.timingProfile.tstatesPerVideo;
                            blinkLineY = 0;
                        } else {
                            doCpuIntTick = false;
                        }
                        this.wallClock.next();
                        if (!tiStatesForIntExhausted) {
                            this.onSlownessDetected(this.timingProfile.tstatesFrame - frameTiStates);
                        }
                    } else {
                        doCpuIntTick = false;
                    }
                    boolean executionEnabled = inTurboMode || !tiStatesForIntExhausted || doCpuIntTick;
                    boolean triggeredNmi = executionEnabled ? this.magicButtonTrigger.compareAndSet(true, false) : false;
                    int detectedTriggers = this.board.step(tiStatesForIntExhausted, intTickForWallClockReached, triggeredNmi, doCpuIntTick, executionEnabled);
                    frameTiStates = this.board.getFrameTiStates();
                    if (!tiStatesForIntExhausted && frameTiStates >= nextBlinkLineTiStates) {
                        doBlink = true;
                    }
                    if (intTickForWallClockReached) {
                        this.videoStreamer.onWallclockInt();
                    }
                    if (detectedTriggers != 0) {
                        Z80[] cpuStates = new Z80[4];
                        int lastM1Address = this.board.getModules()[0].getLastM1Address();
                        for (int i = 0; i < 4; ++i) {
                            cpuStates[i] = new Z80(this.board.getModules()[i].getCpu());
                        }
                        SwingUtilities.invokeLater(() -> this.onTrigger(detectedTriggers, lastM1Address, cpuStates));
                    }
                    if (countdownToAnimationSave <= 0) {
                        AnimationEncoder theAnimationEncoder = this.currentAnimationEncoder.get();
                        if (theAnimationEncoder == null) {
                            countdownToAnimationSave = 0;
                        } else {
                            countdownToAnimationSave = theAnimationEncoder.getIntsBetweenFrames();
                            try {
                                theAnimationEncoder.saveFrame(this.board.getVideoController().makeCopyOfVideoBuffer(true));
                            }
                            catch (IOException ex) {
                                LOGGER.warning("Can't write animation frame: " + ex.getMessage());
                            }
                        }
                    }
                }
                finally {
                    this.stepLocker.unlock();
                }
                if (doBlink) {
                    if (blinkLineY < 192) {
                        if (!lessResources) {
                            this.blinkScreen(sessionIntCounter, blinkLineY, blinkLineY + 1);
                        }
                        nextBlinkLineTiStates = ++blinkLineY * this.timingProfile.tstatesPerLine + this.timingProfile.tstatesStartScreen + this.timingProfile.tstatesPerVideo;
                    } else {
                        nextBlinkLineTiStates = this.timingProfile.tstatesFrame;
                    }
                }
                if (notifyRepaintScreen) {
                    if (lessResources) {
                        this.blinkWholeScreen();
                    }
                    this.repaintScreen();
                }
            } else if (this.wallClock.completed()) {
                this.wallClock.next();
                this.videoStreamer.onWallclockInt();
                this.board.dryIntTickOnWallClockTime(frameTiStates >= this.timingProfile.tstatesFrame, true, frameTiStates);
                this.board.startNewFrame();
            } else {
                if (frameTiStates < this.timingProfile.tstatesFrame) {
                    this.board.doNop();
                }
                this.board.dryIntTickOnWallClockTime(frameTiStates >= this.timingProfile.tstatesFrame, true, frameTiStates);
            }
            if (this.activeTracerWindowCounter.get() > 0) {
                this.updateTracerWindowsForStep();
            }
            if (lessResources) continue;
            Thread.onSpinWait();
        }
    }

    private void onSlownessDetected(long remainTstates) {
        LOGGER.warning(String.format("Slowness detected: %.02f%%", Float.valueOf((float)remainTstates / (float)this.timingProfile.tstatesFrame * 100.0f)));
    }

    private void updateTracerWindowsForStep() {
        try {
            SwingUtilities.invokeAndWait(this.traceWindowsUpdater);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, "Interrupted trace window updater");
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.SEVERE, "Error in trace window updater", ex);
        }
    }

    private String getCellContentForAddress(int address) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (!result.isEmpty()) {
                result.append("  ");
            }
            result.append(com.igormaznitsa.z80.Utils.toHexByte(this.board.getModules()[i].readAddress(address)));
            result.append(" (").append(i).append(')');
        }
        return result.toString();
    }

    private void logTrigger(int triggered, int lastAddress, Z80[] cpuModuleStates) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TRIGGER: ");
        if ((triggered & 1) != 0) {
            buffer.append("MODULE CPU DE-SYNCHRONIZATION");
        }
        if ((triggered & 2) != 0) {
            buffer.append("MEMORY CONTENT DIFFERENCE: ").append(com.igormaznitsa.z80.Utils.toHex(this.board.getMemTriggerAddress()));
            buffer.append('\n').append(this.getCellContentForAddress(lastAddress)).append('\n');
        }
        if ((triggered & 4) != 0) {
            buffer.append("EXE CODE DIFFERENCE");
        }
        buffer.append("\n\nDisasm since last executed address in CPU0 memory: ").append(com.igormaznitsa.z80.Utils.toHex(lastAddress)).append('\n');
        buffer.append(this.board.getModules()[0].toHexStringSinceAddress(lastAddress - 8, 8)).append("\n\n");
        this.board.getModules()[0].disasmSinceAddress(lastAddress, 5).forEach(l -> buffer.append(l.toString()).append('\n'));
        buffer.append('\n');
        for (int i = 0; i < cpuModuleStates.length; ++i) {
            buffer.append("CPU MODULE: ").append(i).append('\n');
            buffer.append(cpuModuleStates[i].getStateAsString());
            buffer.append("\n\n");
        }
        buffer.append('\n');
        LOGGER.info(buffer.toString());
    }

    private String makeInfoStringForRegister(Z80[] cpuModuleStates, int lastAddress, String extraString, int register, boolean alt) {
        StringBuilder result = new StringBuilder();
        if (extraString != null) {
            result.append(extraString).append('\n');
        }
        for (int i = 0; i < cpuModuleStates.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append("CPU#").append(i).append('=').append(com.igormaznitsa.z80.Utils.toHex(cpuModuleStates[i].getRegister(register, alt)));
        }
        result.append("\n\nLast executed address : ").append(com.igormaznitsa.z80.Utils.toHex(lastAddress)).append("\n--------------\n\n");
        result.append(this.board.getModules()[0].toHexStringSinceAddress(lastAddress - 8, 8)).append("\n\n");
        this.board.getModules()[0].disasmSinceAddress(lastAddress, 5).forEach(l -> result.append(l.toString()).append('\n'));
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTrigger(int triggered, int lastM1Address, Z80[] cpuModuleStates) {
        this.stepLocker.lock();
        try {
            this.logTrigger(triggered, lastM1Address, cpuModuleStates);
            if ((triggered & 1) != 0) {
                this.menuTriggerModuleCPUDesync.setSelected(false);
                JOptionPane.showMessageDialog(this, "Detected desync of module CPUs\n" + this.makeInfoStringForRegister(cpuModuleStates, lastM1Address, null, 11, false), "Triggered", 1);
            }
            if ((triggered & 2) != 0) {
                this.menuTriggerDiffMem.setSelected(false);
                JOptionPane.showMessageDialog(this, "Detected memory cell difference " + com.igormaznitsa.z80.Utils.toHex(this.board.getMemTriggerAddress()) + "\n" + this.makeInfoStringForRegister(cpuModuleStates, lastM1Address, this.getCellContentForAddress(this.board.getMemTriggerAddress()), 11, false), "Triggered", 1);
            }
            if ((triggered & 4) != 0) {
                this.menuTriggerExeCodeDiff.setSelected(false);
                JOptionPane.showMessageDialog(this, "Detected EXE code difference\n" + this.makeInfoStringForRegister(cpuModuleStates, lastM1Address, null, 11, false), "Triggered", 1);
            }
        }
        finally {
            this.stepLocker.unlock();
        }
    }

    public boolean isTurboMode() {
        return this.turboMode;
    }

    public void setTurboMode(boolean value) {
        this.setFastButtonState(FastButton.TURBO_MODE, value);
        this.turboMode = value;
        LOGGER.info("Turbo-mode: " + value);
    }

    private void blinkScreen(long sessionIntCounter, int lineFrom, int lineTo) {
        if (this.interlaceScan) {
            this.board.getVideoController().syncUpdateBuffer(lineFrom, lineTo, (sessionIntCounter & 1L) == 0L ? VideoController.LineRenderMode.EVEN : VideoController.LineRenderMode.ODD);
        } else {
            this.board.getVideoController().syncUpdateBuffer(lineFrom, lineTo, VideoController.LineRenderMode.ALL);
        }
        this.board.getVideoController().copyWorkScreenToOutputScreen(0, lineFrom, 256, lineTo);
    }

    private void blinkWholeScreen() {
        this.board.getVideoController().syncUpdateBuffer(0, 192, VideoController.LineRenderMode.ALL);
        this.board.getVideoController().copyWorkScreenToOutputScreen(0, 0, 256, 192);
    }

    private void repaintScreen() {
        this.board.getVideoController().notifyRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuOptionsEnableVideoStreamActionPerformed(ActionEvent actionEvent) {
        this.suspendSteps();
        try {
            if (this.menuOptionsEnableVideoStream.isSelected()) {
                if (AppOptions.getInstance().isGrabSound() && !this.board.getBeeper().isNullBeeper() && JOptionPane.showConfirmDialog(this, "Beeper should be turned off for video sound. Ok?", "Beeper deactivation", 2, 2) != 0) {
                    this.menuOptionsEnableVideoStream.setSelected(false);
                    return;
                }
                this.board.getBeeper().setSourceSoundPort(null);
                Beeper beeper = this.board.getBeeper().isNullBeeper() && AppOptions.getInstance().isGrabSound() ? this.board.getBeeper() : null;
                try {
                    InetAddress interfaceAddress = InetAddress.getByName(AppOptions.getInstance().getAddress());
                    this.videoStreamer.start(beeper, AppOptions.getInstance().getFfmpegPath(), interfaceAddress, AppOptions.getInstance().getPort(), AppOptions.getInstance().getFrameRate());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                    this.menuOptionsEnableVideoStream.setSelected(false);
                }
            } else {
                this.videoStreamer.stop();
            }
        }
        finally {
            this.resumeSteps();
        }
    }

    private boolean tryFastSpeakerActivation() {
        if (this.board.getBeeper().isNullBeeper()) {
            Optional<SourceSoundPort> port = this.findAudioLine(this.board.getBeeper().getAudioFormat(), false);
            port.ifPresent(sourceSoundPort -> this.board.getBeeper().setSourceSoundPort((SourceSoundPort)sourceSoundPort));
            return !this.board.getBeeper().isNullBeeper();
        }
        return true;
    }

    private void activateSoundIfPossible() {
        boolean activated = this.tryFastSpeakerActivation();
        this.menuOptionsEnableSpeaker.setSelected(activated);
        this.setFastButtonState(FastButton.SOUND_ON_OFF, activated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSoundActivate(boolean activate, SourceSoundPort ... port) {
        boolean activated = false;
        this.suspendSteps();
        try {
            if (activate) {
                if (port.length == 0) {
                    Optional<SourceSoundPort> optionalPort = this.findAudioLine(this.board.getBeeper().getAudioFormat(), true);
                    if (optionalPort.isPresent()) {
                        this.board.getBeeper().setSourceSoundPort(optionalPort.get());
                        if (!this.board.getBeeper().isNullBeeper()) {
                            activated = true;
                        }
                    }
                } else {
                    this.board.getBeeper().setSourceSoundPort(port[0]);
                    if (!this.board.getBeeper().isNullBeeper()) {
                        activated = true;
                    }
                }
            } else {
                this.board.getBeeper().setSourceSoundPort(null);
            }
        }
        finally {
            this.resumeSteps();
            this.menuOptionsEnableSpeaker.setSelected(activated);
            this.setFastButtonState(FastButton.SOUND_ON_OFF, activated);
        }
    }

    private void menuOptionsEnableSpeakerActionPerformed(ActionEvent actionEvent) {
        this.setSoundActivate(this.menuOptionsEnableSpeaker.isSelected(), new SourceSoundPort[0]);
    }

    private void menuServiceGameControllerActionPerformed(ActionEvent actionEvent) {
        this.suspendSteps();
        try {
            if (!this.keyboardAndTapeModule.isControllerEngineAllowed()) {
                JOptionPane.showMessageDialog(this, "Can't init game controller engine!", "Error", 0);
            } else if (this.keyboardAndTapeModule.getDetectedControllers().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Can't find any game controller. Try restart the emulator if controller already connected.", "Can't find game controllers", 2);
            } else {
                GameControllerPanel gameControllerPanel = new GameControllerPanel(this.keyboardAndTapeModule);
                if (JOptionPane.showConfirmDialog(this, gameControllerPanel, "Detected game controllers", 2, -1) == 0) {
                    this.keyboardAndTapeModule.setActiveGameControllerAdapters(gameControllerPanel.getSelected());
                }
            }
        }
        finally {
            this.resumeSteps();
        }
    }

    private void makeReset() {
        this.board.setBoardMode(this.menuOptionsZX128Mode.isSelected() ? BoardMode.ZX128 : BoardMode.ZXPOLY, false);
        this.board.resetAndRestoreRom(BASE_ROM);
    }

    private void makeMagic() {
        LOGGER.info("Pressed magic button");
        this.magicButtonTrigger.set(true);
    }

    private void menuFileResetActionPerformed(ActionEvent evt) {
        this.makeReset();
    }

    private void menuFileMagicActionPerformed(ActionEvent evt) {
        this.makeMagic();
    }

    private void menuOptionsShowIndicatorsActionPerformed(ActionEvent evt) {
        boolean showPanel = this.menuOptionsShowIndicators.isSelected();
        this.indicatorCpu0.clear();
        this.indicatorCpu1.clear();
        this.indicatorCpu2.clear();
        this.indicatorCpu3.clear();
        this.panelIndicators.setVisible(showPanel);
        AppOptions.getInstance().setShowIndicatorPanel(showPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisk(int drive, File selectedFile, FileFilter filter) {
        this.stepLocker.lock();
        try {
            char diskName;
            block16: {
                this.lastFloppyFolder = selectedFile.getParentFile();
                switch (drive) {
                    case 0: {
                        diskName = 'A';
                        break;
                    }
                    case 1: {
                        diskName = 'B';
                        break;
                    }
                    case 2: {
                        diskName = 'C';
                        break;
                    }
                    case 3: {
                        diskName = 'D';
                        break;
                    }
                    default: {
                        throw new Error("Unexpected drive index");
                    }
                }
                if (filter == FILTER_FORMAT_ALL_DISK) {
                    filter = FILTER_FORMAT_TRD.accept(selectedFile) ? FILTER_FORMAT_TRD : FILTER_FORMAT_SCL;
                }
                if (selectedFile.isFile() || filter.getClass() != TrdFileFilter.class) break block16;
                Object name = selectedFile.getName();
                if (!((String)name).contains(".")) {
                    name = (String)name + ".trd";
                }
                if ((selectedFile = new File(selectedFile.getParentFile(), (String)name)).isFile()) break block16;
                if (JOptionPane.showConfirmDialog(this, "Create TRD file: " + selectedFile.getName() + "?", "Create TRD file", 2) == 0) {
                    LOGGER.log(Level.INFO, "Creating TRD disk: " + selectedFile.getAbsolutePath());
                    FileUtils.writeByteArrayToFile(selectedFile, new TrDosDisk(FilenameUtils.getBaseName(selectedFile.getName())).getDiskData());
                    break block16;
                }
                return;
            }
            try {
                TrDosDisk floppy = new TrDosDisk(selectedFile, filter.getClass() == SclFileFilter.class ? TrDosDisk.SourceDataType.SCL : TrDosDisk.SourceDataType.TRD, FileUtils.readFileToByteArray(selectedFile), false);
                this.board.getBetaDiskInterface().insertDiskIntoDrive(drive, floppy);
                LOGGER.log(Level.INFO, "Loaded drive " + diskName + " by floppy image file " + String.valueOf(selectedFile));
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Can't read Floppy image file [" + String.valueOf(selectedFile) + "]", ex);
                JOptionPane.showMessageDialog(this, "Can't read Floppy image file", "Error", 0);
            }
        }
        finally {
            this.stepLocker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDiskIntoDrive(int drive) {
        this.suspendSteps();
        try {
            char diskName = switch (drive) {
                case 0 -> 'A';
                case 1 -> 'B';
                case 2 -> 'C';
                case 3 -> 'D';
                default -> throw new Error("Unexpected drive index");
            };
            AtomicReference<FileFilter> filter = new AtomicReference<FileFilter>();
            File selectedFile = this.chooseFileForOpen("Select Disk " + diskName, this.lastFloppyFolder, filter, FILTER_FORMAT_ALL_DISK, FILTER_FORMAT_SCL, FILTER_FORMAT_TRD);
            if (selectedFile != null) {
                this.setDisk(drive, selectedFile, filter.get());
            }
        }
        finally {
            this.resumeSteps();
        }
    }

    private void menuFileSelectDiskAActionPerformed(ActionEvent evt) {
        this.loadDiskIntoDrive(0);
    }

    private void formWindowLostFocus(WindowEvent evt) {
        this.stepLocker.lock();
        try {
            this.keyboardAndTapeModule.doReset();
        }
        finally {
            this.stepLocker.unlock();
        }
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.stepLocker.lock();
        try {
            this.getInputContext().selectInputMethod(Locale.ENGLISH);
            this.keyboardAndTapeModule.doReset();
        }
        finally {
            this.stepLocker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuFileLoadSnapshotActionPerformed(ActionEvent evt) {
        this.suspendSteps();
        try {
            if (AppOptions.getInstance().isTestRomActive()) {
                JHtmlLabel label = new JHtmlLabel("<html><body>ZX-Spectrum 128 ROM is required to load snapshots.<br>Go to menu <b><i><a href=\"rom\">File->Options</i></b></i> and choose ROM 128.</body></html>");
                label.addLinkListener((source, link) -> {
                    if ("rom".equals(link)) {
                        SwingUtilities.windowForComponent(source).setVisible(false);
                        SwingUtilities.invokeLater(() -> this.menuFileOptions.doClick());
                    }
                });
                JOptionPane.showMessageDialog(this, label, "ZX-Spectrum ROM 128 image is required", 2);
                return;
            }
            AtomicReference<FileFilter> theFilter = new AtomicReference<FileFilter>();
            File selected = this.chooseFileForOpen("Select snapshot", this.lastSnapshotFolder, theFilter, FILTER_FORMAT_ALL_SNAPSHOTS, SNAPSHOT_FORMAT_Z80, SNAPSHOT_FORMAT_SPEC256, SNAPSHOT_FORMAT_SNA, SNAPSHOT_FORMAT_ZXP, SNAPSHOT_FORMAT_SZX, SNAPSHOT_FORMAT_ROM, SNAPSHOT_FORMAT_PROM);
            if (selected != null) {
                this.setSnapshotFile(selected, theFilter.get());
            }
        }
        finally {
            this.resumeSteps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSnapshotFile(File selected, FileFilter theFilter) {
        this.stepLocker.lock();
        try {
            this.board.forceResetAllCpu();
            this.board.resetIoDevices();
            this.lastSnapshotFolder = selected.getParentFile();
            try {
                if (theFilter == FILTER_FORMAT_ALL_SNAPSHOTS) {
                    theFilter = SNAPSHOT_FORMAT_PROM.accept(selected) ? SNAPSHOT_FORMAT_PROM : (SNAPSHOT_FORMAT_ROM.accept(selected) ? SNAPSHOT_FORMAT_ROM : (SNAPSHOT_FORMAT_Z80.accept(selected) ? SNAPSHOT_FORMAT_Z80 : (SNAPSHOT_FORMAT_SZX.accept(selected) ? SNAPSHOT_FORMAT_SZX : (SNAPSHOT_FORMAT_SNA.accept(selected) ? SNAPSHOT_FORMAT_SNA : (SNAPSHOT_FORMAT_ZXP.accept(selected) ? SNAPSHOT_FORMAT_ZXP : SNAPSHOT_FORMAT_SPEC256)))));
                }
                Snapshot selectedFilter = (Snapshot)theFilter;
                Path selectedFile = selected.toPath();
                LOGGER.log(Level.INFO, "Loading snapshot " + String.valueOf(selectedFile.getFileName()) + " for filter " + selectedFilter.getName());
                byte[] readSnapshot = Files.readAllBytes(selected.toPath());
                if ((long)readSnapshot.length != Files.size(selectedFile)) {
                    throw new IOException("Detected unexpectedly wrong array length during read: " + String.valueOf(selectedFile.getFileName()));
                }
                LOGGER.log(Level.INFO, "Read " + readSnapshot.length + " byte(s) from " + selectedFilter.getName());
                selectedFilter.loadFromArray(selected, this.board, this.board.getVideoController(), readSnapshot);
                this.menuOptionsZX128Mode.setState(this.board.getBoardMode() != BoardMode.ZXPOLY);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOGGER.log(Level.WARNING, "Can't read snapshot file " + selected.getAbsolutePath() + " [" + ex.getMessage() + "]", ex);
                JOptionPane.showMessageDialog(this, "Can't read snapshot file [" + ex.getMessage() + "]", "Error", 0);
            }
        }
        finally {
            this.stepLocker.unlock();
        }
    }

    private void updateInfoBar() {
        Utils.assertUiThread();
        if (this.panelIndicators.isVisible()) {
            this.labelTurbo.setStatus(this.turboMode);
            TapeSource tapeFileReader = this.keyboardAndTapeModule.getTap();
            this.labelTapeUsage.setStatus(tapeFileReader != null && tapeFileReader.isPlaying());
            this.labelMouseUsage.setStatus(this.board.getVideoController().isMouseTrapActive());
            this.labelDiskUsage.setStatus(this.board.isBetaDiskPresented() && this.board.getBetaDiskInterface().isActive());
            this.labelZX128.setStatus(this.board.getBoardMode() != BoardMode.ZXPOLY);
            this.indicatorCpu0.updateForState(this.board.getCpuActivity(0));
            this.indicatorCpu1.updateForState(this.board.getCpuActivity(1));
            this.indicatorCpu2.updateForState(this.board.getCpuActivity(2));
            this.indicatorCpu3.updateForState(this.board.getCpuActivity(3));
        }
        this.updateTracerCheckBoxes();
    }

    private void setMenuEnable(boolean flag) {
        for (int i = 0; i < this.getJMenuBar().getMenuCount(); ++i) {
            MainForm.setMenuEnable(this.getJMenuBar().getMenu(i), flag);
        }
    }

    public void setFastButtonState(FastButton fastButton, boolean select) {
        Component component = null;
        for (Component c : this.menuBar.getComponents()) {
            if (c.getName() == null || !c.getName().equals(fastButton.getComponentName())) continue;
            component = c;
            break;
        }
        if (component != null) {
            if (fastButton.getButtonClass().isAssignableFrom(JToggleButton.class)) {
                ((JToggleButton)component).setSelected(select);
            } else if (fastButton.getButtonClass().isAssignableFrom(JButton.class) && select) {
                ((JButton)component).doClick();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFullScreen() {
        try {
            if (System.currentTimeMillis() - this.lastFullScreenEventTime > 1000L) {
                GraphicsDevice gDevice = this.getGraphicsConfiguration().getDevice();
                LOGGER.info("FULL SCREEN called, device=" + gDevice.getIDstring() + " displayMode=" + String.valueOf(gDevice.getDisplayMode()));
                JFrame lastFullScreen = this.currentFullScreen.getAndSet(null);
                if (lastFullScreen == null) {
                    if (!gDevice.isFullScreenSupported()) {
                        this.menuViewFullScreen.setEnabled(false);
                        LOGGER.warning("Device doesn't support full screen: " + gDevice.getIDstring());
                        return;
                    }
                    final VideoController vc = this.board.getVideoController();
                    this.scrollPanel.getViewport().remove(vc);
                    lastFullScreen = new JFrame("ZX-Poly FullScreen", gDevice.getDefaultConfiguration());
                    lastFullScreen.setDefaultCloseOperation(0);
                    lastFullScreen.addWindowFocusListener(new WindowAdapter(this){
                        final /* synthetic */ MainForm this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void windowGainedFocus(WindowEvent e) {
                            vc.requestFocus();
                            this.this$0.formWindowGainedFocus(e);
                        }

                        @Override
                        public void windowLostFocus(WindowEvent e) {
                            this.this$0.formWindowLostFocus(e);
                        }
                    });
                    lastFullScreen.getContentPane().add((Component)vc, "Center");
                    lastFullScreen.setUndecorated(true);
                    lastFullScreen.setResizable(false);
                    this.currentFullScreen.set(lastFullScreen);
                    this.setMenuEnable(false);
                    this.setVisible(false);
                    boolean mouseTrapOptionActive = this.menuOptionsEnableTrapMouse.isSelected();
                    vc.setEnableTrapMouse(mouseTrapOptionActive, false);
                    vc.setFullScreenMode(true);
                    gDevice.setFullScreenWindow(lastFullScreen);
                    lastFullScreen.revalidate();
                    lastFullScreen.doLayout();
                    vc.zoomForSize(this.scrollPanel.getViewportBorderBounds());
                    SwingUtilities.invokeLater(() -> {
                        this.doVcSize();
                        vc.setVkbShow(false);
                        vc.zoomForSize(gDevice.getDefaultConfiguration().getBounds());
                        this.setFastButtonState(FastButton.VIRTUAL_KEYBOARD, false);
                    });
                } else {
                    lastFullScreen.getContentPane().removeAll();
                    lastFullScreen.dispose();
                    VideoController vc = this.board.getVideoController();
                    boolean mouseTrapOptionActive = this.menuOptionsEnableTrapMouse.isSelected();
                    vc.setEnableTrapMouse(mouseTrapOptionActive, true);
                    this.scrollPanel.getViewport().setView(vc);
                    this.doVcSize();
                    vc.setFullScreenMode(false);
                    this.scrollPanel.revalidate();
                    this.setMenuEnable(true);
                    this.updateInfoBar();
                    this.updateTapeMenu();
                    this.updateTracerCheckBoxes();
                    this.setVisible(true);
                    this.pack();
                    this.repaint();
                    SwingUtilities.invokeLater(() -> {
                        this.doVcSize();
                        vc.setVkbShow(false);
                        this.setFastButtonState(FastButton.VIRTUAL_KEYBOARD, false);
                    });
                }
            } else {
                LOGGER.info("Ignoring FULL SCREEN because too often");
            }
        }
        finally {
            this.lastFullScreenEventTime = System.currentTimeMillis();
        }
    }

    private void doVcSize() {
        this.board.getVideoController().zoomForSize(this.scrollPanel.getBounds());
    }

    private void initComponents(boolean trdosEnabled, boolean showIndicatoPanel) {
        this.scrollPanel = new JScrollPane();
        this.jSeparator2 = new JSeparator();
        this.panelIndicators = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.labelTurbo = new JIndicatorLabel(ICO_TURBO, ICO_TURBO_DIS, "Turbo-mode is ON", "Turbo-mode is OFF");
        this.labelMouseUsage = new JIndicatorLabel(ICO_MOUSE, ICO_MOUSE_DIS, "Mouse is caught", "Mouse is not active");
        this.labelZX128 = new JIndicatorLabel(ICO_ZX128, ICO_ZX128_DIS, "ZX mode is ON", "ZX mode is OFF");
        this.labelTapeUsage = new JIndicatorLabel(ICO_TAPE, ICO_TAPE_DIS, "Reading", "None");
        this.labelDiskUsage = new JIndicatorLabel(ICO_DISK, ICO_DISK_DIS, "Some disk operation is active", "No IO disk operations");
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuFileLoadSnapshot = new JMenuItem();
        this.menuFileLoadPoke = new JMenuItem();
        this.menuFileLoadTap = new JMenuItem();
        this.menuFileCreateEmptyDisk = new JMenuItem();
        this.menuView = new JMenu();
        this.menuViewZoom = new JMenu();
        this.menuViewVideoFilter = new JMenu();
        this.menuViewFullScreen = new JMenuItem();
        this.menuViewZoomIn = new JMenuItem();
        this.menuViewZoomOut = new JMenuItem();
        this.menuLoadDrive = new JMenu();
        this.menuFileSelectDiskA = new JMenuItem();
        this.menuFileSelectDiskB = new JMenuItem();
        this.menuFileSelectDiskC = new JMenuItem();
        this.menuFileSelectDiskD = new JMenuItem();
        this.menuFileFlushDiskChanges = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.menuFileOptions = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.menuFileExit = new JMenuItem();
        this.menuTap = new JMenu();
        this.menuTapeRewindToStart = new JMenuItem();
        this.menuTapPrevBlock = new JMenuItem();
        this.menuTapPlay = new JCheckBoxMenuItem();
        this.menuTapNextBlock = new JMenuItem();
        this.menuTapThreshold = new JMenuItem();
        this.menuTapGotoBlock = new JMenuItem();
        this.menuService = new JMenu();
        this.menuFileReset = new JMenuItem();
        this.menuFileMagic = new JMenuItem();
        this.menuServiceSaveScreen = new JMenuItem();
        this.menuServiceGameControllers = new JMenuItem();
        this.menuActionAnimatedGIF = new JMenuItem();
        this.menuActionRecordWav = new JMenuItem();
        this.menuServiceMakeSnapshot = new JMenuItem();
        this.menuTapExportAs = new JMenu();
        this.menuTapExportAsWav = new JMenuItem();
        this.menuCatcher = new JMenu();
        this.menuTriggerDiffMem = new JCheckBoxMenuItem();
        this.menuTriggerModuleCPUDesync = new JCheckBoxMenuItem();
        this.menuTriggerExeCodeDiff = new JCheckBoxMenuItem();
        this.menuTracer = new JMenu();
        this.menuTraceCpu0 = new JCheckBoxMenuItem();
        this.menuTraceCpu1 = new JCheckBoxMenuItem();
        this.menuTraceCpu2 = new JCheckBoxMenuItem();
        this.menuTraceCpu3 = new JCheckBoxMenuItem();
        this.menuOptions = new JMenu();
        this.menuOptionsShowIndicators = new JCheckBoxMenuItem();
        this.menuOptionsZX128Mode = new JCheckBoxMenuItem();
        this.menuOptionsTurbo = new JCheckBoxMenuItem();
        this.menuOptionsOnlyJoystickEvents = new JCheckBoxMenuItem();
        this.menuOptionsJoystickSelect = new JMenu();
        this.menuOptionsLookAndFeel = new JMenu();
        this.menuOptionsScaleUi = new JMenu();
        this.menuOptionsJoystickKempston = new JRadioButtonMenuItem();
        this.menuOptionsJoystickProtek = new JRadioButtonMenuItem();
        this.menuOptionsEnableTrapMouse = new JCheckBoxMenuItem();
        this.menuOptionsEnableSpeaker = new JCheckBoxMenuItem();
        this.menuOptionsEnableVideoStream = new JCheckBoxMenuItem();
        this.menuHelp = new JMenu();
        this.menuHelpAbout = new JMenuItem();
        this.menuHelpDonation = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setLocationByPlatform(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MainForm.this.menuBar.repaint();
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                MainForm.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
                MainForm.this.formWindowLostFocus(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (MainForm.this.currentFullScreen.get() == null) {
                    MainForm.this.menuViewFullScreen.setEnabled(MainForm.this.getGraphicsConfiguration().getDevice().isFullScreenSupported());
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Window virtualKeyboard = MainForm.this.board.getVideoController().getVirtualKeboardWindow();
                if (virtualKeyboard != null) {
                    virtualKeyboard.toFront();
                }
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                MainForm.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                MainForm.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MainForm.this.getState() == 6 || MainForm.this.getState() == 0) {
                    Rectangle rectangle = e.getComponent().getBounds();
                    MainForm.this.doVcSize();
                    MainForm.this.scrollPanel.revalidate();
                    MainForm.this.repaint();
                }
            }
        });
        this.menuServiceStartEditor = new JMenuItem("ZX-Sprite corrector", ICO_SPRITECORRECTOR);
        this.menuServiceStartEditor.addActionListener(e -> {
            block8: {
                this.suspendSteps();
                try {
                    SpriteCorrectorMainFrame spriteCorrector = this.spriteCorrectorMainFrame.get();
                    if (spriteCorrector != null && spriteCorrector.isDisplayable()) {
                        spriteCorrector.toFront();
                        spriteCorrector.requestFocus();
                        break block8;
                    }
                    if (spriteCorrector != null) {
                        spriteCorrector.dispose();
                    }
                    spriteCorrector = new SpriteCorrectorMainFrame(this.getGraphicsConfiguration(), false);
                    spriteCorrector.setVisible(true);
                    spriteCorrector.setLocation(this.getLocation());
                    spriteCorrector.toFront();
                    spriteCorrector.requestFocus();
                    this.spriteCorrectorMainFrame.set(spriteCorrector);
                    try {
                        byte[] data = new FormatZ80().saveToArray(this.board, this.board.getVideoController());
                        Optional<AbstractFilePlugin> plugin = spriteCorrector.findImportFilePlugin("z80");
                        if (data != null && plugin.isPresent()) {
                            spriteCorrector.loadFileWithPlugin(plugin.get(), null, "emulator-data", data, -1);
                            spriteCorrector.updateAndResetEditMenu();
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.severe("Error during snapshot creation: " + ex.getMessage());
                    }
                }
                finally {
                    this.resumeSteps();
                }
            }
        });
        this.getContentPane().add((Component)this.scrollPanel, "Center");
        this.panelIndicators.setVisible(showIndicatoPanel);
        this.panelIndicators.setBorder(BorderFactory.createEtchedBorder());
        this.panelIndicators.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1000.0;
        this.panelIndicators.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.panelIndicators.add((Component)this.labelTurbo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.panelIndicators.add((Component)this.labelMouseUsage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.panelIndicators.add((Component)this.labelZX128, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        this.panelIndicators.add((Component)this.labelTapeUsage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        this.panelIndicators.add((Component)this.labelDiskUsage, gridBagConstraints);
        this.getContentPane().add((Component)this.panelIndicators, "South");
        this.menuFile.setText("File");
        this.menuFile.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainForm.this.menuFileMenuSelected(evt);
            }
        });
        this.menuService.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                MainForm.this.refreshServiceMenuState();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.menuView.setText("View");
        this.menuViewFullScreen.setText("Full Screen");
        this.menuViewFullScreen.addActionListener(e -> this.doFullScreen());
        this.menuViewFullScreen.setAccelerator(KeyStroke.getKeyStroke(122, SystemUtils.IS_OS_MAC ? 0x80 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 0));
        this.menuView.add(this.menuViewFullScreen);
        this.menuViewZoomIn.setText("Zoom In");
        this.menuViewZoomIn.addActionListener(e -> this.board.getVideoController().zoomIn());
        this.menuViewZoomIn.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.menuViewZoomOut.setText("Zoom Out");
        this.menuViewZoomOut.addActionListener(e -> this.board.getVideoController().zoomOut());
        this.menuViewZoomOut.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.menuViewZoom.setText("Zoom");
        this.menuViewZoom.add(this.menuViewZoomIn);
        this.menuViewZoom.add(this.menuViewZoomOut);
        this.menuView.add(this.menuViewZoom);
        this.menuViewVideoFilter.setText("Video filter");
        ButtonGroup tvFilterGroup = new ButtonGroup();
        boolean oldTvFilterActivating = AppOptions.getInstance().isOldColorTvOnStart();
        for (TvFilterChain chain : TvFilterChain.values()) {
            JRadioButtonMenuItem tvFilterMenuItem = new JRadioButtonMenuItem(chain.getText(), oldTvFilterActivating ? chain == TvFilterChain.OLDTV : chain == TvFilterChain.NONE);
            tvFilterGroup.add(tvFilterMenuItem);
            tvFilterMenuItem.addActionListener(e -> {
                this.menuActionAnimatedGIF.setEnabled(chain.isGifCompatible());
                if (tvFilterMenuItem.isSelected()) {
                    this.board.getVideoController().setTvFilterChain(chain);
                }
            });
            this.menuViewVideoFilter.add(tvFilterMenuItem);
        }
        this.menuView.add(this.menuViewVideoFilter);
        this.menuFileLoadSnapshot.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/snapshot.png"))));
        this.menuFileLoadSnapshot.setText("Load Snapshot");
        this.menuFileLoadSnapshot.addActionListener(this::menuFileLoadSnapshotActionPerformed);
        this.menuFile.add(this.menuFileLoadSnapshot);
        this.menuFileLoadPoke.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/poke.png"))));
        this.menuFileLoadPoke.setText("Load Poke");
        this.menuFileLoadPoke.addActionListener(this::menuFileLoadPokeActionPerformed);
        this.menuFile.add(this.menuFileLoadPoke);
        this.menuFileLoadTap.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/cassette.png"))));
        this.menuFileLoadTap.setText("Load TAPE");
        this.menuFileLoadTap.addActionListener(this::menuFileLoadTapActionPerformed);
        this.menuFile.add(this.menuFileLoadTap);
        this.menuLoadDrive.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/disk.png"))));
        this.menuLoadDrive.setText("Load Disk..");
        this.menuLoadDrive.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainForm.this.menuLoadDriveMenuSelected(evt);
            }
        });
        if (trdosEnabled) {
            this.menuFileSelectDiskA.setText("Drive A");
            this.menuFileSelectDiskA.addActionListener(this::menuFileSelectDiskAActionPerformed);
            this.menuLoadDrive.add(this.menuFileSelectDiskA);
            this.menuFileSelectDiskB.setText("Drive B");
            this.menuFileSelectDiskB.addActionListener(this::menuFileSelectDiskBActionPerformed);
            this.menuLoadDrive.add(this.menuFileSelectDiskB);
            this.menuFileSelectDiskC.setText("Drive C");
            this.menuFileSelectDiskC.addActionListener(this::menuFileSelectDiskCActionPerformed);
            this.menuLoadDrive.add(this.menuFileSelectDiskC);
            this.menuFileSelectDiskD.setText("Drive D");
            this.menuFileSelectDiskD.addActionListener(this::menuFileSelectDiskDActionPerformed);
            this.menuLoadDrive.add(this.menuFileSelectDiskD);
            this.menuFile.add(this.menuLoadDrive);
            this.menuFileFlushDiskChanges.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/diskflush.png"))));
            this.menuFileFlushDiskChanges.setText("Flush disk changes");
            this.menuFileFlushDiskChanges.addActionListener(this::menuFileFlushDiskChangesActionPerformed);
            this.menuFileCreateEmptyDisk.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/disk_new.png"))));
            this.menuFileCreateEmptyDisk.setText("Create empty disk");
            this.menuFileCreateEmptyDisk.addActionListener(this::menuFileCreateEmptyDiskFileActionPerformed);
            this.menuFile.add(this.menuFileCreateEmptyDisk);
            this.menuFile.add(this.menuFileFlushDiskChanges);
        }
        this.menuFile.add(this.jSeparator1);
        this.menuFileOptions.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/settings.png"))));
        this.menuFileOptions.setText("Preferences");
        this.menuFileOptions.addActionListener(this::menuFileOptionsActionPerformed);
        this.menuFile.add(this.menuFileOptions);
        this.menuFile.add(this.jSeparator3);
        this.menuFileExit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.menuFileExit.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/reset.png"))));
        this.menuFileExit.setText("Exit");
        this.menuFileExit.addActionListener(this::menuFileExitActionPerformed);
        this.menuFile.add(this.menuFileExit);
        this.menuBar.add(this.menuFile);
        this.menuTap.setText("Tape");
        this.menuTapeRewindToStart.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/tape_previous.png"))));
        this.menuTapeRewindToStart.setText("Rewind to start");
        this.menuTapeRewindToStart.addActionListener(this::menuTapeRewindToStartActionPerformed);
        this.menuTap.add(this.menuTapeRewindToStart);
        this.menuTapPrevBlock.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/tape_backward.png"))));
        this.menuTapPrevBlock.setText("Prev block");
        this.menuTapPrevBlock.addActionListener(this::menuTapPrevBlockActionPerformed);
        this.menuTap.add(this.menuTapPrevBlock);
        this.menuTapPlay.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.menuTapPlay.setText("Play");
        this.menuTapPlay.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/tape_play.png"))));
        this.menuTapPlay.setInheritsPopupMenu(true);
        this.menuTapPlay.addActionListener(this::menuTapPlayActionPerformed);
        this.menuTap.add(this.menuTapPlay);
        this.menuTapNextBlock.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/tape_forward.png"))));
        this.menuTapNextBlock.setText("Next block");
        this.menuTapNextBlock.addActionListener(this::menuTapNextBlockActionPerformed);
        this.menuTap.add(this.menuTapNextBlock);
        this.menuTapGotoBlock.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/tape_pos.png"))));
        this.menuTapGotoBlock.setText("Go to block");
        this.menuTapGotoBlock.addActionListener(this::menuTapGotoBlockActionPerformed);
        this.menuTap.add(this.menuTapGotoBlock);
        this.menuTapThreshold.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/tape_sens.png"))));
        this.menuTapThreshold.setText("Signal threshold");
        this.menuTapThreshold.addActionListener(this::menuTapThresholdActionPerformed);
        this.menuTap.add(this.menuTapThreshold);
        this.menuBar.add(this.menuTap);
        this.menuBar.add(this.menuView);
        this.menuService.setText("Service");
        this.menuFileReset.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        this.menuFileReset.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/reset2.png"))));
        this.menuFileReset.setText("Reset");
        this.menuFileReset.addActionListener(this::menuFileResetActionPerformed);
        this.menuService.add(this.menuFileReset);
        this.menuFileMagic.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.menuFileMagic.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/magic.png"))));
        this.menuFileMagic.setText("Magic button");
        this.menuFileMagic.addActionListener(this::menuFileMagicActionPerformed);
        this.menuService.add(this.menuFileMagic);
        this.menuServiceSaveScreen.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.menuServiceSaveScreen.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/photo.png"))));
        this.menuServiceSaveScreen.setText("Make Screenshot");
        this.menuServiceSaveScreen.addActionListener(this::menuServiceSaveScreenActionPerformed);
        this.menuService.add(this.menuServiceSaveScreen);
        this.menuActionAnimatedGIF.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/file_gif.png"))));
        this.menuActionAnimatedGIF.setText(TEXT_START_ANIM_GIF);
        this.menuActionAnimatedGIF.setToolTipText("Can be disabled for some video filters");
        this.menuActionAnimatedGIF.addActionListener(this::menuActionAnimatedGIFActionPerformed);
        this.menuService.add(this.menuActionAnimatedGIF);
        this.menuActionRecordWav.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/wav_start.png"))));
        this.menuActionRecordWav.setText(TEXT_START_ANIM_GIF);
        this.menuActionRecordWav.addActionListener(this::menuActionRecordWavActionPerformed);
        this.menuService.add(this.menuActionRecordWav);
        this.menuServiceMakeSnapshot.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/save_snapshot.png"))));
        this.menuServiceMakeSnapshot.setText("Save snapshot");
        this.menuServiceMakeSnapshot.addActionListener(this::menuServiceMakeSnapshotActionPerformed);
        this.menuService.add(this.menuServiceMakeSnapshot);
        this.menuTapExportAs.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/tape_record.png"))));
        this.menuTapExportAs.setText("Export TAPE as..");
        this.menuTapExportAsWav.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/file_wav.png"))));
        this.menuTapExportAsWav.setText("WAV file");
        this.menuTapExportAsWav.addActionListener(this::menuTapExportAsWavActionPerformed);
        this.menuTapExportAs.add(this.menuTapExportAsWav);
        this.menuService.add(this.menuTapExportAs);
        this.menuServiceGameControllers.setText("Game controllers");
        this.menuServiceGameControllers.setToolTipText("Turn on game controller");
        this.menuServiceGameControllers.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/gcontroller.png"))));
        this.menuServiceGameControllers.addActionListener(this::menuServiceGameControllerActionPerformed);
        this.menuService.add(this.menuServiceGameControllers);
        this.menuService.add(this.menuServiceStartEditor);
        this.menuCatcher.setText("Test triggers");
        this.menuTriggerDiffMem.setText("Diff mem.content");
        this.menuTriggerDiffMem.addActionListener(this::menuTriggerDiffMemActionPerformed);
        this.menuCatcher.add(this.menuTriggerDiffMem);
        this.menuTriggerModuleCPUDesync.setText("CPUs state desync");
        this.menuTriggerModuleCPUDesync.addActionListener(this::menuTriggerModuleCPUDesyncActionPerformed);
        this.menuCatcher.add(this.menuTriggerModuleCPUDesync);
        this.menuTriggerExeCodeDiff.setText("Exe code difference");
        this.menuTriggerExeCodeDiff.addActionListener(this::menuTriggerExeCodeDiffActionPerformed);
        this.menuCatcher.add(this.menuTriggerExeCodeDiff);
        this.menuService.add(this.menuCatcher);
        this.menuTracer.setText("Trace");
        this.menuTraceCpu0.setText("CPU0");
        this.menuTraceCpu0.addActionListener(this::menuTraceCpu0ActionPerformed);
        this.menuTracer.add(this.menuTraceCpu0);
        this.menuTraceCpu1.setText("CPU1");
        this.menuTraceCpu1.addActionListener(this::menuTraceCpu1ActionPerformed);
        this.menuTracer.add(this.menuTraceCpu1);
        this.menuTraceCpu2.setText("CPU2");
        this.menuTraceCpu2.addActionListener(this::menuTraceCpu2ActionPerformed);
        this.menuTracer.add(this.menuTraceCpu2);
        this.menuTraceCpu3.setText("CPU3");
        this.menuTraceCpu3.addActionListener(this::menuTraceCpu3ActionPerformed);
        this.menuTracer.add(this.menuTraceCpu3);
        this.menuService.add(this.menuTracer);
        this.menuBar.add(this.menuService);
        this.menuOptions.setText("Options");
        this.menuOptionsJoystickSelect.setText("Joystick");
        this.menuOptionsJoystickSelect.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/protek.png"))));
        this.menuOptionsJoystickSelect.setToolTipText("Select active joystick type");
        this.menuOptionsJoystickKempston.setText("Kempston");
        this.menuOptionsJoystickProtek.setText("Protek");
        this.menuOptionsJoystickSelect.add(this.menuOptionsJoystickKempston);
        this.menuOptionsJoystickSelect.add(this.menuOptionsJoystickProtek);
        ButtonGroup joystickButtonGroup = new ButtonGroup();
        joystickButtonGroup.add(this.menuOptionsJoystickKempston);
        joystickButtonGroup.add(this.menuOptionsJoystickProtek);
        this.menuOptions.add(this.menuOptionsJoystickSelect);
        this.menuOptionsOnlyJoystickEvents.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.menuOptionsOnlyJoystickEvents.setText("ZX-Keyboard Off");
        this.menuOptionsOnlyJoystickEvents.setToolTipText("Disable events from keyboard and allow events only from joystick");
        this.menuOptionsOnlyJoystickEvents.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/onlykempston.png"))));
        this.menuOptionsOnlyJoystickEvents.addActionListener(this::menuOptionsOnlyKempstonEvents);
        this.menuOptions.add(this.menuOptionsOnlyJoystickEvents);
        this.menuOptionsShowIndicators.setSelected(showIndicatoPanel);
        this.menuOptionsShowIndicators.setText("Indicator panel");
        this.menuOptionsShowIndicators.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/indicator.png"))));
        this.menuOptionsShowIndicators.addActionListener(this::menuOptionsShowIndicatorsActionPerformed);
        this.menuOptions.add(this.menuOptionsShowIndicators);
        this.menuOptionsZX128Mode.setSelected(true);
        this.menuOptionsZX128Mode.setText("ZX Mode");
        this.menuOptionsZX128Mode.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/zx128.png"))));
        this.menuOptionsZX128Mode.addActionListener(this::menuOptionsZX128ModeActionPerformed);
        this.menuOptions.add(this.menuOptionsZX128Mode);
        this.menuOptionsTurbo.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.menuOptionsTurbo.setText("Turbo");
        this.menuOptionsTurbo.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/turbo.png"))));
        this.menuOptionsTurbo.addActionListener(this::menuOptionsTurboActionPerformed);
        this.menuOptions.add(this.menuOptionsTurbo);
        this.menuOptionsEnableTrapMouse.setText("Trap mouse");
        this.menuOptionsEnableTrapMouse.setToolTipText("Trap mouse as Kempston-mouse");
        this.menuOptionsEnableTrapMouse.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/pointer.png"))));
        this.menuOptionsEnableTrapMouse.addActionListener(this::menuOptionsEnableTrapMouseActionPerformed);
        this.menuOptions.add(this.menuOptionsEnableTrapMouse);
        this.menuOptionsEnableSpeaker.setText("Sound");
        this.menuOptionsEnableSpeaker.setToolTipText("Turn on beeper sound");
        this.menuOptionsEnableSpeaker.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/speaker.png"))));
        this.menuOptionsEnableSpeaker.addActionListener(this::menuOptionsEnableSpeakerActionPerformed);
        this.menuOptions.add(this.menuOptionsEnableSpeaker);
        this.menuOptionsEnableVideoStream.setText("Video stream (beta)");
        this.menuOptionsEnableVideoStream.setToolTipText("Turn on video streaming");
        this.menuOptionsEnableVideoStream.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/streaming.png"))));
        this.menuOptionsEnableVideoStream.addActionListener(this::menuOptionsEnableVideoStreamActionPerformed);
        this.menuOptions.add(this.menuOptionsEnableVideoStream);
        this.menuOptionsLookAndFeel.setText("Look & Feel");
        this.menuOptionsLookAndFeel.setIcon(this.sysIcon);
        this.fillLookAndFeelMenu(this.menuOptionsLookAndFeel);
        this.menuOptionsScaleUi.setText("App. UI scale");
        this.menuOptionsScaleUi.setIcon(this.sysIcon);
        this.fillUiScale(this.menuOptionsScaleUi);
        this.menuOptions.addSeparator();
        this.menuOptions.add(this.menuOptionsLookAndFeel);
        this.menuOptions.add(this.menuOptionsScaleUi);
        this.menuBar.add(this.menuOptions);
        this.menuHelp.setText("Help");
        this.menuHelpAbout.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.menuHelpAbout.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/info.png"))));
        this.menuHelpAbout.setText("Help");
        this.menuHelpAbout.addActionListener(this::menuHelpAboutActionPerformed);
        this.menuHelp.add(this.menuHelpAbout);
        this.menuHelpDonation.setText("Make donation");
        this.menuHelpDonation.addActionListener(e -> {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=AHWJHJFBAWGL2"));
                }
                catch (Exception ex) {
                    LOGGER.warning("Can't open link: " + ex.getMessage());
                }
            }
        });
        this.menuHelpDonation.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/donate.png"))));
        this.menuHelp.add(this.menuHelpDonation);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void refreshServiceMenuState() {
        if (this.board.getBeeper().hasActiveWaFile()) {
            this.menuActionRecordWav.setIcon(ICO_WAV_STOP);
            this.menuActionRecordWav.setText(TEXT_STOP_WAV);
            this.setFastButtonState(FastButton.WRITE_WAV, true);
        } else {
            this.menuActionRecordWav.setIcon(ICO_WAV_START);
            this.menuActionRecordWav.setText(TEXT_START_WAV);
            this.setFastButtonState(FastButton.WRITE_WAV, false);
        }
        if (this.currentAnimationEncoder.get() == null) {
            this.menuActionAnimatedGIF.setIcon(ICO_AGIF_RECORD);
            this.menuActionAnimatedGIF.setText(TEXT_START_ANIM_GIF);
        } else {
            this.menuActionAnimatedGIF.setIcon(ICO_AGIF_STOP);
            this.menuActionAnimatedGIF.setText(TEXT_STOP_ANIM_GIF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWavRecordForSound(boolean enable) {
        this.suspendSteps();
        try {
            this.board.getBeeper().setSilentlyTargetWav(null);
            if (enable) {
                JFileChooser selectFileDialog = new JFileChooser(this.lastWrittenWavFile);
                selectFileDialog.setDialogTitle("Record beeper as WAV");
                selectFileDialog.addChoosableFileFilter(FILTER_FORMAT_WAV);
                selectFileDialog.setMultiSelectionEnabled(false);
                selectFileDialog.setFileSelectionMode(0);
                if (selectFileDialog.showSaveDialog(this) == 0) {
                    File selectedWavFile = selectFileDialog.getSelectedFile();
                    if (!selectedWavFile.getName().contains(".")) {
                        selectedWavFile = new File(selectedWavFile.getParentFile(), selectedWavFile.getName() + ".wav");
                    }
                    this.lastWrittenWavFile = selectedWavFile;
                    if (selectedWavFile.isFile() && JOptionPane.showConfirmDialog(this, "Do you want override file " + selectedWavFile.getName() + "?", "File exists", 2) == 2) {
                        return;
                    }
                    try {
                        this.board.getBeeper().setTargetWav(selectedWavFile);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, "Can't start WAV recording", ex);
                        JOptionPane.showMessageDialog(this, "Can't start write WAV file", "Error", 0);
                    }
                }
            }
        }
        finally {
            this.refreshServiceMenuState();
            this.resumeSteps();
        }
    }

    private void menuActionRecordWavActionPerformed(ActionEvent actionEvent) {
        this.setWavRecordForSound(!this.board.getBeeper().hasActiveWaFile());
    }

    private void menuFileCreateEmptyDiskFileActionPerformed(ActionEvent actionEvent) {
        File file = this.chooseFileForSave("Create empty TRD disk file", this.lastFloppyFolder, null, false, FILTER_FORMAT_TRD);
        if (file != null) {
            if (!file.getName().contains(".")) {
                file = new File(file.getParentFile(), file.getName() + ".trd");
            }
            this.lastFloppyFolder = file.getParentFile();
            if (file.isFile() && JOptionPane.showConfirmDialog(this, "File " + file.getName() + " exists! Do you want overwrite it?", "File exists", 2, 2) == 2) {
                return;
            }
            LOGGER.info("Creating empty TRD disk as file: " + String.valueOf(file));
            try {
                FileUtils.writeByteArrayToFile(file, new TrDosDisk(FilenameUtils.getBaseName(file.getName())).getDiskData());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Can't create empty disk file: " + String.valueOf(file), ex);
                JOptionPane.showMessageDialog(this, "Can't save disk file: " + ex.getMessage(), "Error", 0);
            }
        }
    }

    private void fillUiScale(JMenu menu) {
        String selectedScale = AppOptions.getInstance().getUiScale();
        ButtonGroup buttonGroup = new ButtonGroup();
        Stream.of("None", "1", "1.5", "2", "2.5", "3", "3.5", "4", "4.5", "5").forEach(scale -> {
            boolean none = scale.equalsIgnoreCase("none");
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem((String)(none ? scale : "x" + scale), selectedScale == null && none || scale.equalsIgnoreCase(selectedScale));
            menuItem.addItemListener(e -> {
                LOGGER.info("Select UI scale: " + scale);
                if (e.getStateChange() == 1) {
                    if (none) {
                        AppOptions.getInstance().setUiScale(null);
                    } else {
                        AppOptions.getInstance().setUiScale((String)scale);
                    }
                    JOptionPane.showMessageDialog(this, "Application restart required!", "Restart required", 2);
                }
            });
            buttonGroup.add(menuItem);
            menu.add(menuItem);
        });
    }

    private void fillLookAndFeelMenu(JMenu menu) {
        String selectedClass = AppOptions.getInstance().getUiLfClass();
        ButtonGroup buttonGroup = new ButtonGroup();
        ArrayList<UIManager.LookAndFeelInfo> installedLookAndFeels = new ArrayList<UIManager.LookAndFeelInfo>(List.of(UIManager.getInstalledLookAndFeels()));
        installedLookAndFeels.sort(Comparator.comparing(UIManager.LookAndFeelInfo::getName));
        installedLookAndFeels.forEach(lf -> {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(lf.getName(), lf.getClassName().equals(selectedClass));
            menuItem.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    try {
                        UIManager.setLookAndFeel(lf.getClassName());
                        SwingUtilities.invokeLater(() -> SwingUtilities.updateComponentTreeUI(this));
                        AppOptions.getInstance().setUiLfClass(lf.getClassName());
                        AppOptions.getInstance().flush();
                    }
                    catch (Exception ex) {
                        LOGGER.warning("Can't change L&F: " + ex.getMessage());
                    }
                }
            });
            buttonGroup.add(menuItem);
            menu.add(menuItem);
        });
    }

    private void setDisableZxKeyboardEvents(boolean disable) {
        this.keyboardAndTapeModule.setOnlyJoystickEvents(disable);
        this.setFastButtonState(FastButton.ZX_KEYBOARD_OFF, disable);
        LOGGER.info("Only Kempston events: " + disable);
    }

    private void menuOptionsOnlyKempstonEvents(ActionEvent actionEvent) {
        this.setDisableZxKeyboardEvents(this.menuOptionsOnlyJoystickEvents.isSelected());
    }

    private void menuTapThresholdActionPerformed(ActionEvent actionEvent) {
        TapeSource source = this.keyboardAndTapeModule.getTap();
        if (source != null) {
            JSlider slider = new JSlider();
            slider.setMajorTickSpacing(100);
            slider.setMinorTickSpacing(10);
            slider.setPaintLabels(false);
            slider.setPaintTrack(true);
            slider.setSnapToTicks(true);
            slider.setPaintTicks(true);
            slider.setModel(new DefaultBoundedRangeModel((int)(source.getThreshold() * 1000.0f), 0, 0, 1000));
            if (JOptionPane.showConfirmDialog(this, slider, "Tape signal threshold", 2, -1) == 0) {
                int threshold = slider.getValue();
                LOGGER.info("Selected TAP threshold: " + threshold);
                source.setThreshold((float)threshold / 1000.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuFileLoadPokeActionPerformed(ActionEvent evt) {
        this.suspendSteps();
        try {
            JFileChooser trainerFileChooser = new JFileChooser(this.lastPokeFileFolder);
            trainerFileChooser.setDialogTitle("Select trainer");
            trainerFileChooser.setMultiSelectionEnabled(false);
            trainerFileChooser.setFileSelectionMode(0);
            trainerFileChooser.setAcceptAllFileFilterUsed(false);
            TrainerPok pokTrainer = new TrainerPok();
            trainerFileChooser.addChoosableFileFilter(pokTrainer);
            if (trainerFileChooser.showOpenDialog(this) == 0) {
                AbstractTrainer selectedTrainer = (AbstractTrainer)trainerFileChooser.getFileFilter();
                File selectedFile = trainerFileChooser.getSelectedFile();
                this.lastPokeFileFolder = selectedFile.getParentFile();
                try {
                    selectedTrainer.apply(this, selectedFile, this.board);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Error during trainer processing: " + ex.getMessage(), ex);
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Can't read or parse file", 0);
                }
            }
        }
        finally {
            this.resumeSteps();
        }
    }

    private void menuOptionsZX128ModeActionPerformed(ActionEvent evt) {
        this.stepLocker.lock();
        try {
            this.board.resetAndRestoreRom(BASE_ROM);
            this.board.setBoardMode(this.menuOptionsZX128Mode.isSelected() ? BoardMode.ZX128 : BoardMode.ZXPOLY, true);
        }
        finally {
            this.stepLocker.unlock();
        }
    }

    public void showVirtualKeyboard(boolean show) {
        this.board.getVideoController().setVkbShow(show);
        this.setFastButtonState(FastButton.VIRTUAL_KEYBOARD, show);
    }

    private void setTurboModeActive(boolean active) {
        if (active) {
            this.preTurboSourceSoundPort = this.board.getBeeper().setSourceSoundPort(null);
            LOGGER.info("Saved sound port: " + String.valueOf(this.preTurboSourceSoundPort));
            this.setSoundActivate(false, new SourceSoundPort[0]);
            this.setTurboMode(true);
        } else {
            this.setTurboMode(false);
            this.preTurboSourceSoundPort.ifPresentOrElse(savedPort -> this.setSoundActivate(true, (SourceSoundPort)savedPort), () -> this.setSoundActivate(true, new SourceSoundPort[0]));
            LOGGER.info("Restored sound port: " + this.preTurboSourceSoundPort.map(SourceSoundPort::getName).orElse("NONE"));
            this.preTurboSourceSoundPort = Optional.empty();
        }
    }

    private void menuOptionsTurboActionPerformed(ActionEvent evt) {
        this.setTurboModeActive(this.menuOptionsTurbo.isSelected());
    }

    private void menuFileSelectDiskCActionPerformed(ActionEvent evt) {
        this.loadDiskIntoDrive(2);
    }

    private void menuFileSelectDiskBActionPerformed(ActionEvent evt) {
        this.loadDiskIntoDrive(1);
    }

    private void menuFileSelectDiskDActionPerformed(ActionEvent evt) {
        this.loadDiskIntoDrive(3);
    }

    private void menuFileExitActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
    }

    private void menuTapGotoBlockActionPerformed(ActionEvent evt) {
        TapeSource currentReader = this.keyboardAndTapeModule.getTap();
        if (currentReader != null) {
            currentReader.stopPlay();
            this.updateTapeMenu();
            SelectTapPosDialog dialog = new SelectTapPosDialog((Frame)this, currentReader);
            dialog.setVisible(true);
            int selected = dialog.getSelectedIndex();
            if (selected >= 0) {
                currentReader.setCurrent(selected);
            }
        }
    }

    private void setTapFile(File tapFile) {
        this.lastTapFolder = tapFile.getParentFile();
        this.stepLocker.lock();
        try {
            if (this.keyboardAndTapeModule.getTap() != null) {
                this.keyboardAndTapeModule.getTap().removeActionListener(this);
            }
            TapeSource source = TapeSourceFactory.makeSource(this, this.timingProfile, tapFile);
            source.addActionListener(this);
            this.keyboardAndTapeModule.setTap(source);
            LOGGER.info("Loaded TAP, total data size " + source.size() + " bytes");
            this.labelTapeUsage.setTooltips("Reading " + source.getName(), source.getName());
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Can't read " + String.valueOf(tapFile) + ": " + ex.getMessage(), ex);
            JOptionPane.showMessageDialog(this, Utils.extractMessage(ex), "Error TAP loading", 0);
        }
        finally {
            this.updateTapeMenu();
            this.stepLocker.unlock();
        }
    }

    private void menuFileLoadTapActionPerformed(ActionEvent evt) {
        this.suspendSteps();
        try {
            File selectedTapFile = this.chooseFileForOpen("Load Tape", this.lastTapFolder, null, FILTER_FORMAT_ALL_TAPE, FILTER_FORMAT_TZX, FILTER_FORMAT_TAP, FILTER_FORMAT_WAV);
            if (selectedTapFile != null) {
                this.setTapFile(selectedTapFile);
            }
        }
        finally {
            this.resumeSteps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuTapExportAsWavActionPerformed(ActionEvent evt) {
        this.suspendSteps();
        try {
            byte[] wav = this.keyboardAndTapeModule.getTap().getAsWAV();
            File fileToSave = this.chooseFileForSave("Select WAV file", null, null, true, new WavFileFilter());
            if (fileToSave != null) {
                String name = fileToSave.getName();
                if (!name.contains(".")) {
                    fileToSave = new File(fileToSave.getParentFile(), name + ".wav");
                }
                FileUtils.writeByteArrayToFile(fileToSave, wav);
                LOGGER.log(Level.INFO, "Exported current TAP file as WAV file " + String.valueOf(fileToSave) + " size " + wav.length + " bytes");
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't export as WAV", ex);
            JOptionPane.showMessageDialog(this, "Can't export as WAV", ex.getMessage(), 0);
        }
        finally {
            this.resumeSteps();
        }
    }

    @Override
    public void onTapeSignal(TapeSource tapeSource, TapeContext.ControlSignal controlSignal) {
        switch (controlSignal) {
            case STOP_TAPE: {
                this.keyboardAndTapeModule.getTap().stopPlay();
                break;
            }
            case STOP_TAPE_IF_ZX48: {
                if (!this.board.isMode48k()) break;
                this.keyboardAndTapeModule.getTap().stopPlay();
            }
        }
    }

    private boolean setTapePlay(boolean play) {
        if (this.keyboardAndTapeModule.getTap() == null) {
            return false;
        }
        if (play && this.keyboardAndTapeModule.getTap().isPlaying()) {
            return true;
        }
        if (play) {
            this.keyboardAndTapeModule.getTap().startPlay();
        } else {
            this.keyboardAndTapeModule.getTap().stopPlay();
        }
        this.updateTapeMenu();
        return true;
    }

    private void menuTapPlayActionPerformed(ActionEvent evt) {
        this.setTapePlay(this.menuTapPlay.isSelected());
    }

    private void menuTapPrevBlockActionPerformed(ActionEvent evt) {
        TapeSource tap = this.keyboardAndTapeModule.getTap();
        if (tap != null) {
            tap.rewindToPrevBlock();
        }
        this.updateTapeMenu();
    }

    private void menuTapNextBlockActionPerformed(ActionEvent evt) {
        TapeSource tap = this.keyboardAndTapeModule.getTap();
        if (tap != null) {
            tap.rewindToNextBlock();
        }
        this.updateTapeMenu();
    }

    private void menuTapeRewindToStartActionPerformed(ActionEvent evt) {
        TapeSource tap = this.keyboardAndTapeModule.getTap();
        if (tap != null) {
            tap.rewindToStart();
        }
        this.updateTapeMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuServiceSaveScreenActionPerformed(ActionEvent evt) {
        this.suspendSteps();
        try {
            RenderedImage img = this.board.getVideoController().makeCopyOfCurrentPicture();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ImageIO.write(img, "png", buffer);
            File pngFile = this.chooseFileForSave("Save screenshot", this.lastScreenshotFolder, null, true, new PngFileFilter());
            if (pngFile != null) {
                String fileName = pngFile.getName();
                if (!fileName.contains(".")) {
                    pngFile = new File(pngFile.getParentFile(), fileName + ".png");
                }
                this.lastScreenshotFolder = pngFile.getParentFile();
                FileUtils.writeByteArrayToFile(pngFile, buffer.toByteArray());
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Can't save screenshot for error, see the log!", "Error", 0);
            LOGGER.log(Level.SEVERE, "Can't make screenshot", ex);
        }
        finally {
            this.resumeSteps();
        }
    }

    private void menuFileOptionsActionPerformed(ActionEvent evt) {
        this.suspendSteps();
        try {
            OptionsPanel optionsPanel = new OptionsPanel(null);
            Utils.makeOwningDialogResizable(optionsPanel, new Runnable[0]);
            if (JOptionPane.showConfirmDialog(this, new JScrollPane(optionsPanel), "Preferences", 2, -1) == 0) {
                optionsPanel.getData().store();
                JOptionPane.showMessageDialog(this, "Restart the emulator for new options!", "Restart may required!", 2);
            }
        }
        finally {
            this.resumeSteps();
        }
    }

    private void menuHelpAboutActionPerformed(ActionEvent evt) {
        this.suspendSteps();
        try {
            new AboutDialog(this).setVisible(true);
        }
        finally {
            this.resumeSteps();
        }
    }

    private void menuTraceCpu0ActionPerformed(ActionEvent evt) {
        if (this.menuTraceCpu0.isSelected()) {
            this.activateTracerForCPUModule(0);
            this.setSoundActivate(false, new SourceSoundPort[0]);
        } else {
            this.deactivateTracerForCPUModule(0);
        }
    }

    private void menuTraceCpu1ActionPerformed(ActionEvent evt) {
        if (this.menuTraceCpu1.isSelected()) {
            this.activateTracerForCPUModule(1);
            this.setSoundActivate(false, new SourceSoundPort[0]);
        } else {
            this.deactivateTracerForCPUModule(1);
        }
    }

    private void menuTraceCpu2ActionPerformed(ActionEvent evt) {
        if (this.menuTraceCpu2.isSelected()) {
            this.activateTracerForCPUModule(2);
            this.setSoundActivate(false, new SourceSoundPort[0]);
        } else {
            this.deactivateTracerForCPUModule(2);
        }
    }

    private void menuTraceCpu3ActionPerformed(ActionEvent evt) {
        if (this.menuTraceCpu3.isSelected()) {
            this.activateTracerForCPUModule(3);
            this.setSoundActivate(false, new SourceSoundPort[0]);
        } else {
            this.deactivateTracerForCPUModule(3);
        }
    }

    private void turnZxKeyboardOff() {
        this.zxKeyboardProcessingAllowed = false;
    }

    private void turnZxKeyboardOn() {
        this.keyboardAndTapeModule.doReset();
        this.zxKeyboardProcessingAllowed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuActionAnimatedGIFActionPerformed(ActionEvent evt) {
        block11: {
            this.suspendSteps();
            try {
                AnimationEncoder encoder = this.currentAnimationEncoder.get();
                if (encoder == null) {
                    AnimatedGifTunePanel panel = new AnimatedGifTunePanel(this.lastAnimGifOptions);
                    int result = JOptionPane.showConfirmDialog(this, panel, "Options for Animated GIF", 2);
                    if (result != 0) {
                        return;
                    }
                    this.menuViewVideoFilter.setEnabled(false);
                    this.lastAnimGifOptions = panel.getValue();
                    try {
                        encoder = new AGifEncoder(new File(this.lastAnimGifOptions.filePath), this.board.getVideoController().findCurrentPalette(), this.lastAnimGifOptions.frameRate, this.lastAnimGifOptions.repeat);
                    }
                    catch (IOException ex) {
                        this.menuViewVideoFilter.setEnabled(true);
                        LOGGER.log(Level.SEVERE, "Can't create GIF encoder: " + ex.getMessage(), ex);
                        JOptionPane.showMessageDialog(this, "Can't make GIF encoder: " + ex.getMessage(), "Error!", 0);
                        this.refreshServiceMenuState();
                        this.resumeSteps();
                        return;
                    }
                    if (this.currentAnimationEncoder.compareAndSet(null, encoder)) {
                        LOGGER.info("Animated GIF recording has been started");
                    }
                    break block11;
                }
                this.menuViewVideoFilter.setEnabled(true);
                this.closeAnimationSave();
                if (this.currentAnimationEncoder.compareAndSet(encoder, null)) {
                    LOGGER.info("Animated GIF recording has been stopped");
                }
            }
            finally {
                this.refreshServiceMenuState();
                this.resumeSteps();
            }
        }
    }

    private void closeAnimationSave() {
        AnimationEncoder encoder = this.currentAnimationEncoder.get();
        if (encoder != null) {
            try {
                encoder.close();
            }
            catch (IOException ex) {
                LOGGER.warning("Error during animation file close");
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        this.closeAnimationSave();
    }

    private void menuTriggerModuleCPUDesyncActionPerformed(ActionEvent evt) {
        this.suspendSteps();
        try {
            if (this.menuTriggerModuleCPUDesync.isSelected()) {
                this.board.setTrigger(1);
            } else {
                this.board.resetTrigger(1);
            }
        }
        finally {
            this.resumeSteps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuTriggerDiffMemActionPerformed(ActionEvent evt) {
        block7: {
            this.suspendSteps();
            try {
                if (this.menuTriggerDiffMem.isSelected()) {
                    AddressPanel panel = new AddressPanel(this.board.getMemTriggerAddress());
                    if (JOptionPane.showConfirmDialog(this, panel, "Triggering address", 2, 3) != 0) break block7;
                    try {
                        int address = panel.extractAddressFromText();
                        if (address < 0 || address > 65535) {
                            JOptionPane.showMessageDialog(this, "Error address must be in #0000...#FFFF", "Error address", 0);
                            break block7;
                        }
                        this.board.setMemTriggerAddress(address);
                        this.board.setTrigger(2);
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(this, "Error address format, use # for hexadecimal address (example #AA00)", "Error address", 0);
                    }
                    break block7;
                }
                this.board.resetTrigger(2);
            }
            finally {
                this.resumeSteps();
            }
        }
    }

    private void menuTriggerExeCodeDiffActionPerformed(ActionEvent evt) {
        this.suspendSteps();
        try {
            if (this.menuTriggerExeCodeDiff.isSelected()) {
                this.board.setTrigger(4);
            } else {
                this.board.resetTrigger(4);
            }
        }
        finally {
            this.resumeSteps();
        }
    }

    private void suspendSteps() {
        this.turnZxKeyboardOff();
        this.stepLocker.lock();
    }

    private void resumeSteps() {
        this.turnZxKeyboardOn();
        this.stepLocker.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuServiceMakeSnapshotActionPerformed(ActionEvent evt) {
        block8: {
            this.suspendSteps();
            try {
                Snapshot selectedFilter;
                File selected;
                block9: {
                    AtomicReference<FileFilter> theFilter = new AtomicReference<FileFilter>();
                    selected = this.chooseFileForSave("Save snapshot", this.lastSnapshotFolder, theFilter, false, (FileFilter[])Stream.of(SNAPSHOT_FORMAT_SPEC256, SNAPSHOT_FORMAT_ZXP, SNAPSHOT_FORMAT_Z80, SNAPSHOT_FORMAT_SNA, SNAPSHOT_FORMAT_ROM, SNAPSHOT_FORMAT_SZX).filter(x -> !this.board.getVideoController().getUlaPlus().isActive() || x.isAllowUlaPlus()).filter(x -> x.canMakeSnapshotForBoardMode(this.board.getBoardMode())).toArray(Snapshot[]::new));
                    if (selected == null) break block8;
                    this.lastSnapshotFolder = selected.getParentFile();
                    selectedFilter = (Snapshot)theFilter.get();
                    if (!selectedFilter.getExtension().equals(FilenameUtils.getExtension(selected.getName()).toLowerCase(Locale.ENGLISH))) {
                        selected = new File(selected.getParentFile(), selected.getName() + "." + selectedFilter.getExtension());
                    }
                    if (!selected.isFile() || JOptionPane.showConfirmDialog(this, String.format("Do you want override file '%s'?", selected.getName()), "Found existing file", 2) != 2) break block9;
                    return;
                }
                try {
                    LOGGER.info("Saving snapshot " + selectedFilter.getName() + " as file " + selected.getName());
                    byte[] preparedSnapshotData = selectedFilter.saveToArray(this.board, this.board.getVideoController());
                    LOGGER.info("Prepared snapshot data, size " + preparedSnapshotData.length + " bytes");
                    FileUtils.writeByteArrayToFile(selected, preparedSnapshotData);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    LOGGER.log(Level.WARNING, "Can't save snapshot file [" + ex.getMessage() + "]", ex);
                    JOptionPane.showMessageDialog(this, "Can't save snapshot file [" + ex.getMessage() + "]", "Error", 0);
                }
            }
            finally {
                this.resumeSteps();
            }
        }
    }

    private void menuFileMenuSelected(MenuEvent evt) {
        if (this.board.isBetaDiskPresented()) {
            boolean hasChangedDisk = false;
            for (int i = 0; i < 4; ++i) {
                TrDosDisk disk = this.board.getBetaDiskInterface().getDiskInDrive(i);
                hasChangedDisk |= disk != null && disk.isChanged();
            }
            this.menuFileFlushDiskChanges.setEnabled(hasChangedDisk);
        }
    }

    private void menuFileFlushDiskChangesActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 4; ++i) {
            File destFile;
            TrDosDisk disk = this.board.getBetaDiskInterface().getDiskInDrive(i);
            if (disk == null || !disk.isChanged()) continue;
            int result = JOptionPane.showConfirmDialog(this, "Do you want flush disk data '" + disk.getSrcFile().getName() + "' ?", "Disk changed", 1);
            if (result == 2) break;
            if (result != 0) continue;
            if (disk.getType() != TrDosDisk.SourceDataType.TRD) {
                JFileChooser fileChooser = new JFileChooser(disk.getSrcFile().getParentFile());
                fileChooser.setFileFilter(new TrdFileFilter());
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.setDialogTitle("Save disk as TRD file");
                fileChooser.setFileSelectionMode(0);
                fileChooser.setSelectedFile(new File(disk.getSrcFile().getParentFile(), FilenameUtils.getBaseName(disk.getSrcFile().getName()) + ".trd"));
                destFile = fileChooser.showSaveDialog(this) == 0 ? fileChooser.getSelectedFile() : null;
            } else {
                destFile = disk.getSrcFile();
            }
            if (destFile == null) continue;
            try {
                FileUtils.writeByteArrayToFile(destFile, disk.getDiskData());
                disk.replaceSrcFile(destFile, TrDosDisk.SourceDataType.TRD, true);
                LOGGER.info("Changes for disk " + (65 + i) + " is saved as file: " + destFile.getAbsolutePath());
                continue;
            }
            catch (IOException ex) {
                LOGGER.warning("Can't write disk for error: " + ex.getMessage());
                JOptionPane.showMessageDialog(this, "Can't save disk for IO error: " + ex.getMessage(), "Error", 0);
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.currentFullScreen.get() != null) {
            this.doFullScreen();
        }
        boolean hasChangedDisk = false;
        if (this.board.isBetaDiskPresented()) {
            for (int i = 0; i < 4; ++i) {
                TrDosDisk disk = this.board.getBetaDiskInterface().getDiskInDrive(i);
                hasChangedDisk |= disk != null && disk.isChanged();
            }
        }
        boolean close = false;
        if (hasChangedDisk) {
            if (JOptionPane.showConfirmDialog(this, "Emulator has unsaved disks, do you realy want to close it?", "Detected unsaved data", 2) == 0) {
                close = true;
            }
        } else {
            close = true;
        }
        AppOptions.getInstance().setSoundTurnedOn(!this.board.getBeeper().isNullBeeper());
        this.board.dispose();
        if (close) {
            SpriteCorrectorMainFrame spriteCorrector = this.spriteCorrectorMainFrame.get();
            if (spriteCorrector != null && spriteCorrector.isDisplayable()) {
                LOGGER.info("Detected active ZXPoly Sprite corrector");
                spriteCorrector.toFront();
                spriteCorrector.requestFocus();
                this.infoBarUpdateTimer.stop();
                this.board.dispose();
                this.mainCpuThread.interrupt();
                this.dispose();
            } else {
                System.exit(0);
            }
        }
    }

    private void menuLoadDriveMenuSelected(MenuEvent evt) {
        JMenuItem[] menuItems = new JMenuItem[]{this.menuFileSelectDiskA, this.menuFileSelectDiskB, this.menuFileSelectDiskC, this.menuFileSelectDiskD};
        IntStream.range(0, 4).forEach(index -> {
            TrDosDisk diskInDrive = this.board.getBetaDiskInterface().getDiskInDrive(index);
            JMenuItem diskMenuItem = menuItems[index];
            if (diskInDrive == null) {
                diskMenuItem.setIcon(null);
                diskMenuItem.setToolTipText(null);
            } else {
                diskMenuItem.setIcon(ICO_MDISK);
                diskMenuItem.setToolTipText(diskInDrive.getSrcFile() == null ? null : diskInDrive.getSrcFile().getAbsolutePath());
            }
        });
    }

    private void menuOptionsEnableTrapMouseActionPerformed(ActionEvent evt) {
        this.board.getVideoController().setEnableTrapMouse(this.menuOptionsEnableTrapMouse.isSelected(), true);
    }

    private void activateTracerForCPUModule(int index) {
        TraceCpuForm form = this.cpuTracers[index];
        if (form == null) {
            form = new TraceCpuForm(this, this.board, index);
            form.setVisible(true);
        }
        form.toFront();
        form.requestFocus();
    }

    private void deactivateTracerForCPUModule(int index) {
        Arrays.stream(this.cpuTracers).filter(Objects::nonNull).forEach(Window::dispose);
    }

    private void updateTracerCheckBoxes() {
        this.menuTraceCpu0.setSelected(this.cpuTracers[0] != null);
        this.menuTraceCpu1.setSelected(this.cpuTracers[1] != null);
        this.menuTraceCpu2.setSelected(this.cpuTracers[2] != null);
        this.menuTraceCpu3.setSelected(this.cpuTracers[3] != null);
    }

    public void onTracerActivated(TraceCpuForm tracer) {
        int index = tracer.getModuleIndex();
        this.cpuTracers[index] = tracer;
        this.updateTracerCheckBoxes();
        this.activeTracerWindowCounter.incrementAndGet();
    }

    public void onTracerDeactivated(TraceCpuForm tracer) {
        int index = tracer.getModuleIndex();
        this.cpuTracers[index] = null;
        this.updateTracerCheckBoxes();
        this.activeTracerWindowCounter.decrementAndGet();
    }

    private File chooseFileForOpen(String title, File initial, AtomicReference<FileFilter> returnSelectedFilter, FileFilter ... filter) {
        File result;
        JFileChooser chooser = new JFileChooser(initial);
        for (FileFilter f : filter) {
            chooser.addChoosableFileFilter(f);
        }
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(title);
        chooser.setFileFilter(filter[0]);
        chooser.setFileSelectionMode(0);
        if (chooser.showOpenDialog(this) == 0) {
            result = chooser.getSelectedFile();
            if (returnSelectedFilter != null) {
                returnSelectedFilter.set(chooser.getFileFilter());
            }
        } else {
            result = null;
        }
        return result;
    }

    private File chooseFileForSave(String title, File initial, AtomicReference<FileFilter> selectedFilter, boolean allowAcceptAll, FileFilter ... filters) {
        File result;
        JFileChooser chooser = new JFileChooser(initial);
        for (FileFilter f : filters) {
            chooser.addChoosableFileFilter(f);
        }
        chooser.setAcceptAllFileFilterUsed(allowAcceptAll);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(title);
        if (filters.length != 0 && !allowAcceptAll) {
            chooser.setFileFilter(filters[0]);
        }
        chooser.setFileSelectionMode(0);
        if (chooser.showSaveDialog(this) == 0) {
            result = chooser.getSelectedFile();
            if (selectedFilter != null) {
                selectedFilter.set(chooser.getFileFilter());
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof TapeSource) {
            this.updateTapeMenu();
        }
    }

    private final class KeyboardDispatcher
    implements KeyEventDispatcher {
        private final VideoController videoController;
        private final KeyboardKempstonAndTapeIn keyboard;
        private final MainForm mainForm;

        KeyboardDispatcher(MainForm mainForm2) {
            this.mainForm = mainForm2;
            this.keyboard = mainForm2.keyboardAndTapeModule;
            this.videoController = mainForm2.board.getVideoController();
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            boolean consumed = false;
            if (this.mainForm.menuBar.isVisible() && !e.isConsumed() && MainForm.this.zxKeyboardProcessingAllowed) {
                if (e.getKeyCode() == 116) {
                    if (e.getID() == 401) {
                        this.mainForm.showVirtualKeyboard(!this.videoController.isVkbShow());
                    }
                    e.consume();
                    consumed = true;
                }
                if (MainForm.this.currentFullScreen.get() != null && e.getID() == 402) {
                    switch (e.getKeyCode()) {
                        case 27: 
                        case 122: {
                            e.consume();
                            consumed = true;
                            MainForm.this.doFullScreen();
                            break;
                        }
                        case 123: {
                            e.consume();
                            consumed = true;
                            MainForm.this.menuFileResetActionPerformed(new ActionEvent(this, 0, "reset"));
                        }
                    }
                }
                if (!consumed && (consumed = this.keyboard.onKeyEvent(e))) {
                    e.consume();
                }
            }
            return consumed;
        }
    }

    private static class TrdFileFilter
    extends FileFilter {
        private TrdFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".trd");
        }

        @Override
        public String getDescription() {
            return "TR-DOS image (*.trd)";
        }
    }

    private static class SclFileFilter
    extends FileFilter {
        private SclFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".scl");
        }

        @Override
        public String getDescription() {
            return "SCL image (*.scl)";
        }
    }

    private static class WavFileFilter
    extends FileFilter {
        private WavFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".wav");
        }

        @Override
        public String getDescription() {
            return "WAV file (*.wav)";
        }
    }

    private static class TzxFileFilter
    extends FileFilter {
        private TzxFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".tzx");
        }

        @Override
        public String getDescription() {
            return "TZX file (*.tzx)";
        }
    }

    private static class TapFileFilter
    extends FileFilter {
        private TapFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".tap");
        }

        @Override
        public String getDescription() {
            return "TAP file (*.tap)";
        }
    }

    private static class PngFileFilter
    extends FileFilter {
        private PngFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".png");
        }

        @Override
        public String getDescription() {
            return "PNG image (*.png)";
        }
    }
}

