/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.animeencoders;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;

public class AnimatedGifTunePanel
extends JPanel {
    private static final long serialVersionUID = -5725762636857034093L;
    private JButton buttonChooseFile;
    private JCheckBox checkBoxRepeat;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JLabel labelFrameRate;
    private JLabel labelRepeat;
    private JSpinner spinnerFrameRate;
    private JTextField textFieldFile;

    public AnimatedGifTunePanel(AnimGifOptions options) {
        this.initComponents();
        this.textFieldFile.setText(options.filePath);
        this.checkBoxRepeat.setSelected(options.repeat);
        this.spinnerFrameRate.setValue(options.frameRate);
    }

    public AnimGifOptions getValue() {
        return new AnimGifOptions(this.textFieldFile.getText(), (Integer)this.spinnerFrameRate.getValue(), this.checkBoxRepeat.isSelected());
    }

    private void initComponents() {
        this.labelFrameRate = new JLabel();
        this.checkBoxRepeat = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.buttonChooseFile = new JButton();
        this.textFieldFile = new JTextField();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.spinnerFrameRate = new JSpinner();
        this.labelRepeat = new JLabel();
        this.setLayout(new GridBagLayout());
        this.labelFrameRate.setHorizontalAlignment(4);
        this.labelFrameRate.setText("Frame rate: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.labelFrameRate, gridBagConstraints);
        this.checkBoxRepeat.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1000.0;
        this.add((Component)this.checkBoxRepeat, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("File: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.buttonChooseFile.setIcon(new ImageIcon(this.getClass().getResource("/com/igormaznitsa/zxpoly/icons/disk.png")));
        this.buttonChooseFile.addActionListener(this::buttonChooseFileActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.buttonChooseFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.textFieldFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1000.0;
        this.add((Component)this.filler1, gridBagConstraints);
        this.spinnerFrameRate.setModel(new SpinnerNumberModel(10, 1, 20, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.spinnerFrameRate, gridBagConstraints);
        this.labelRepeat.setHorizontalAlignment(4);
        this.labelRepeat.setText("Repeat: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.labelRepeat, gridBagConstraints);
    }

    private void buttonChooseFileActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.textFieldFile.getText());
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(new FileFilter(this){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".gif");
            }

            @Override
            public String getDescription() {
                return "Animated GIF files (*.gif)";
            }
        });
        if (fileChooser.showSaveDialog(this) == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.getName().contains(".")) {
                selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName() + ".gif");
            }
            this.textFieldFile.setText(selectedFile.getAbsolutePath());
        }
    }

    public static final class AnimGifOptions {
        public final String filePath;
        public final int frameRate;
        public final boolean repeat;

        public AnimGifOptions(String filePath, int frameRate, boolean repeat) {
            this.filePath = filePath;
            this.frameRate = frameRate;
            this.repeat = repeat;
        }
    }
}

