/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components;

import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.IoDevice;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.gadapter.GameControllerAdapter;
import com.igormaznitsa.zxpoly.components.gadapter.GameControllerAdapterInterface2;
import com.igormaznitsa.zxpoly.components.gadapter.GameControllerAdapterKempston;
import com.igormaznitsa.zxpoly.components.gadapter.GameControllerAdapterType;
import com.igormaznitsa.zxpoly.components.tapereader.TapeSource;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import com.igormaznitsa.zxpoly.utils.AppOptions;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.ControllerEvent;
import net.java.games.input.ControllerListener;

public final class KeyboardKempstonAndTapeIn
implements IoDevice {
    public static final long ZXKEY_CS = 1L;
    public static final long ZXKEY_Z = 2L;
    public static final long ZXKEY_X = 4L;
    public static final long ZXKEY_C = 8L;
    public static final long ZXKEY_V = 16L;
    public static final long ZXKEY_A = 256L;
    public static final long ZXKEY_S = 512L;
    public static final long ZXKEY_D = 1024L;
    public static final long ZXKEY_F = 2048L;
    public static final long ZXKEY_G = 4096L;
    public static final long ZXKEY_Q = 65536L;
    public static final long ZXKEY_W = 131072L;
    public static final long ZXKEY_E = 262144L;
    public static final long ZXKEY_R = 524288L;
    public static final long ZXKEY_T = 0x100000L;
    public static final long ZXKEY_1 = 0x1000000L;
    public static final long ZXKEY_2 = 0x2000000L;
    public static final long ZXKEY_3 = 0x4000000L;
    public static final long ZXKEY_4 = 0x8000000L;
    public static final long ZXKEY_5 = 0x10000000L;
    public static final long ZXKEY_0 = 0x100000000L;
    public static final long ZXKEY_9 = 0x200000000L;
    public static final long ZXKEY_8 = 0x400000000L;
    public static final long ZXKEY_7 = 0x800000000L;
    public static final long ZXKEY_6 = 0x1000000000L;
    public static final long ZXKEY_P = 0x10000000000L;
    public static final long ZXKEY_O = 0x20000000000L;
    public static final long ZXKEY_I = 0x40000000000L;
    public static final long ZXKEY_U = 0x80000000000L;
    public static final long ZXKEY_Y = 0x100000000000L;
    public static final long ZXKEY_EN = 0x1000000000000L;
    public static final long ZXKEY_L = 0x2000000000000L;
    public static final long ZXKEY_K = 0x4000000000000L;
    public static final long ZXKEY_J = 0x8000000000000L;
    public static final long ZXKEY_H = 0x10000000000000L;
    public static final long ZXKEY_SP = 0x100000000000000L;
    public static final long ZXKEY_SS = 0x200000000000000L;
    public static final long ZXKEY_M = 0x400000000000000L;
    public static final long ZXKEY_N = 0x800000000000000L;
    public static final long ZXKEY_B = 0x1000000000000000L;
    public static final long ZXKEY_NONE = 0x1F1F1F1F1F1F1F1FL;
    private static final Logger LOGGER = Logger.getLogger(KeyboardKempstonAndTapeIn.class.getName());
    private static final int KEMPSTON_RIGHT = 1;
    private static final int KEMPSTON_LEFT = 2;
    private static final int KEMPSTON_DOWN = 4;
    private static final int KEMPSTON_UP = 8;
    private static final int KEMPSTON_FIRE = 16;
    private static final int MIC_BIT = 64;
    private final Motherboard board;
    private final AtomicReference<TapeSource> tap = new AtomicReference();
    private final List<Controller> detectedControllers;
    private final List<GameControllerAdapter> activeGameControllerAdapters = new CopyOnWriteArrayList<GameControllerAdapter>();
    private final int cursorJoystickVkLeft;
    private final boolean kempstonMouseAllowed;
    private final int kempstonVkLeft;
    private final int kempstonVkRight;
    private final int kempstonVkUp;
    private final int kempstonVkDown;
    private final int kempstonVkFire;
    private final int cursorJoystickVkRight;
    private final int cursorJoystickVkUp;
    private final int cursorJoystickVkDown;
    private final int cursorJoystickVkFire;
    private final long cursorCsMask = AppOptions.getInstance().getAutoCsForCursorKeys() ? 1L : 0L;
    private final TimingProfile timingProfile;
    private final List<TapeStateChangeListener> tapeStateChangeListeners = new CopyOnWriteArrayList<TapeStateChangeListener>();
    private volatile long keyboardLines = 0x1F1F1F1F1F1F1F1FL;
    private volatile long bufferKeyboardLines = 0L;
    private volatile int kempstonSignals = 0;
    private volatile int kempstonBuffer = 0;
    private volatile boolean onlyJoystickEvents = false;
    private volatile boolean activatedKempstonJoystick = true;

    public KeyboardKempstonAndTapeIn(TimingProfile timingProfile, Motherboard board, boolean kempstonMouseAllowed) {
        this.timingProfile = timingProfile;
        this.board = board;
        this.kempstonMouseAllowed = kempstonMouseAllowed;
        this.kempstonVkLeft = AppOptions.getInstance().getKempstonVkLeft();
        this.kempstonVkRight = AppOptions.getInstance().getKempstonVkRight();
        this.kempstonVkUp = AppOptions.getInstance().getKempstonVkUp();
        this.kempstonVkDown = AppOptions.getInstance().getKempstonVkDown();
        this.kempstonVkFire = AppOptions.getInstance().getKempstonVkFire();
        this.cursorJoystickVkDown = AppOptions.getInstance().getCursorJoystickDown();
        this.cursorJoystickVkFire = AppOptions.getInstance().getProtekJoystickFire();
        this.cursorJoystickVkLeft = AppOptions.getInstance().getProtekJoystickLeft();
        this.cursorJoystickVkRight = AppOptions.getInstance().getProtekJoystickRight();
        this.cursorJoystickVkUp = AppOptions.getInstance().getProtekJoystickUp();
        if (ControllerEnvironment.getDefaultEnvironment().isSupported()) {
            this.detectedControllers = Arrays.stream(ControllerEnvironment.getDefaultEnvironment().getControllers()).filter(x -> this.isControllerTypeAllowed(x.getType())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
            ControllerEnvironment.getDefaultEnvironment().addControllerListener(new ControllerListener(){

                @Override
                public void controllerRemoved(ControllerEvent controllerEvent) {
                    if (KeyboardKempstonAndTapeIn.this.isControllerTypeAllowed(controllerEvent.getController().getType())) {
                        LOGGER.info("Removed controller: " + controllerEvent.getController().getName());
                        KeyboardKempstonAndTapeIn.this.detectedControllers.remove(controllerEvent.getController());
                    }
                }

                @Override
                public void controllerAdded(ControllerEvent controllerEvent) {
                    if (KeyboardKempstonAndTapeIn.this.isControllerTypeAllowed(controllerEvent.getController().getType())) {
                        LOGGER.info("Added controller: " + controllerEvent.getController().getName());
                        KeyboardKempstonAndTapeIn.this.detectedControllers.add(controllerEvent.getController());
                    }
                }
            });
        } else {
            this.detectedControllers = null;
        }
    }

    public void addTapeStateChangeListener(TapeStateChangeListener listener) {
        this.tapeStateChangeListeners.add(listener);
    }

    public void removeTapeStateChangeListener(TapeStateChangeListener listener) {
        this.tapeStateChangeListeners.remove(listener);
    }

    public boolean isKempstonJoystickActivated() {
        return this.activatedKempstonJoystick;
    }

    public void setKempstonJoystickActivated(boolean activated) {
        LOGGER.info("Activated joystick: " + (activated ? "KEMPSTON" : "CURSOR"));
        this.activatedKempstonJoystick = activated;
        this.kempstonSignals = 0;
    }

    public boolean isOnlyJoystickEvents() {
        return this.onlyJoystickEvents;
    }

    public void setOnlyJoystickEvents(boolean flag) {
        this.onlyJoystickEvents = flag;
        this.keyboardLines = 0x1F1F1F1F1F1F1F1FL;
    }

    public void disposeAllActiveGameControllerAdapters() {
        this.activeGameControllerAdapters.forEach(GameControllerAdapter::dispose);
        this.activeGameControllerAdapters.clear();
    }

    public GameControllerAdapter makeGameControllerAdapter(Controller controller, GameControllerAdapterType type) {
        switch (type) {
            case KEMPSTON: {
                return new GameControllerAdapterKempston(this, controller);
            }
            case INTERFACEII_PLAYER1: {
                return new GameControllerAdapterInterface2(0, this, controller);
            }
            case INTERFACEII_PLAYER2: {
                return new GameControllerAdapterInterface2(1, this, controller);
            }
        }
        throw new Error("Unexpected destination: " + String.valueOf((Object)type));
    }

    public List<GameControllerAdapter> getActiveGadapters() {
        return new ArrayList<GameControllerAdapter>(this.activeGameControllerAdapters);
    }

    public void setActiveGameControllerAdapters(List<GameControllerAdapter> adapters) {
        this.activeGameControllerAdapters.forEach(GameControllerAdapter::dispose);
        if (!this.activeGameControllerAdapters.isEmpty()) {
            throw new Error("Detected non-disposed controller");
        }
        adapters.forEach(x -> {
            LOGGER.info("Registering adapter: " + String.valueOf(x));
            this.activeGameControllerAdapters.addAll(adapters);
        });
        this.activeGameControllerAdapters.forEach(GameControllerAdapter::start);
    }

    private boolean isControllerTypeAllowed(Controller.Type type) {
        return type == Controller.Type.FINGERSTICK || type == Controller.Type.STICK || type == Controller.Type.RUDDER || type == Controller.Type.GAMEPAD;
    }

    public List<Controller> getDetectedControllers() {
        return this.detectedControllers == null ? Collections.emptyList() : this.detectedControllers;
    }

    public boolean isControllerEngineAllowed() {
        return this.detectedControllers != null;
    }

    private int getKbdValueForLines(int scanLinePort) {
        long vkbKeyState = this.board.getVideoController().getVkbState();
        long state = vkbKeyState & this.bufferKeyboardLines;
        scanLinePort ^= 0xFF;
        int result = 31;
        int shift = 0;
        while (scanLinePort != 0) {
            if ((scanLinePort & 1) != 0) {
                result &= (int)(state >>> shift);
            }
            shift += 8;
            scanLinePort >>= 1;
        }
        return result & 0x1F;
    }

    private int readKeyboardAndTap(int scanLinePort, TapeSource tapeFileReader) {
        int result = 255;
        result &= this.getKbdValueForLines(scanLinePort >>> 8 & 0xFF);
        if (this.isTapeIn()) {
            result ^= 0x40;
        }
        return result | 0xA0;
    }

    @Override
    public int readIo(ZxPolyModule module, int port) {
        int result = -1;
        if (!module.isTrdosActive()) {
            boolean inZxPolyMode = module.getMotherboard().getBoardMode() == BoardMode.ZXPOLY;
            int lowPortAddress = port & 0xFF;
            if ((lowPortAddress & 1) == 0) {
                if (!inZxPolyMode || lowPortAddress == 254) {
                    result = this.readKeyboardAndTap(port, this.getTap());
                }
            } else if (inZxPolyMode) {
                if (lowPortAddress == 31) {
                    result = this.kempstonBuffer;
                }
            } else if (this.kempstonMouseAllowed) {
                if (lowPortAddress == 31) {
                    result = this.kempstonBuffer;
                }
            } else if ((lowPortAddress & 0x20) == 0) {
                result = this.kempstonBuffer;
            }
        }
        return result;
    }

    @Override
    public void writeIo(ZxPolyModule module, int port, int value) {
    }

    @Override
    public Motherboard getMotherboard() {
        return this.board;
    }

    @Override
    public void doReset() {
        this.keyboardLines = 0x1F1F1F1F1F1F1F1FL;
        this.kempstonSignals = 0;
    }

    @Override
    public int getNotificationFlags() {
        return 3;
    }

    @Override
    public void preStep(int frameTiStates, boolean signalReset, boolean tstatesIntReached, boolean wallclockInt) {
        if (signalReset) {
            this.doReset();
        }
        this.bufferKeyboardLines = this.keyboardLines;
        this.kempstonBuffer = this.kempstonSignals;
    }

    @Override
    public String getName() {
        return "Keyboard";
    }

    public TapeSource getTap() {
        return this.tap.get();
    }

    public void setTap(TapeSource tap) {
        this.tap.set(tap);
        this.fireTapeStateChangeListeners();
    }

    private void fireTapeStateChangeListeners() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.tapeStateChangeListeners.forEach(x -> x.onTapeStateChanged(this));
        } else {
            SwingUtilities.invokeLater(() -> this.tapeStateChangeListeners.forEach(x -> x.onTapeStateChanged(this)));
        }
    }

    @Override
    public void postStep(int spentTstates) {
        TapeSource currentTap = this.getTap();
        if (currentTap != null) {
            boolean playing = currentTap.isPlaying();
            currentTap.updateForSpentMachineCycles(spentTstates);
            if (playing != currentTap.isPlaying()) {
                this.fireTapeStateChangeListeners();
            }
        }
    }

    public boolean onKeyEvent(KeyEvent evt) {
        boolean pressed;
        if (evt.isControlDown() && evt.getKeyCode() != 32 && !this.onlyJoystickEvents) {
            return false;
        }
        switch (evt.getID()) {
            case 401: {
                pressed = true;
                break;
            }
            case 402: {
                pressed = false;
                break;
            }
            default: {
                return false;
            }
        }
        long zxKeyCode = 0L;
        int kempstonCode = 0;
        int keyCode = evt.getKeyCode();
        boolean kempsonJoystickActivated = this.activatedKempstonJoystick;
        if (kempsonJoystickActivated) {
            if (keyCode == this.kempstonVkLeft) {
                kempstonCode = 2;
            } else if (keyCode == this.kempstonVkRight) {
                kempstonCode = 1;
            } else if (keyCode == this.kempstonVkUp) {
                kempstonCode = 8;
            } else if (keyCode == this.kempstonVkDown) {
                kempstonCode = 4;
            } else if (keyCode == this.kempstonVkFire) {
                kempstonCode = 16;
            }
        } else if (keyCode == this.cursorJoystickVkLeft) {
            zxKeyCode = 0x10000000L;
        } else if (keyCode == this.cursorJoystickVkRight) {
            zxKeyCode = 0x400000000L;
        } else if (keyCode == this.cursorJoystickVkUp) {
            zxKeyCode = 0x800000000L;
        } else if (keyCode == this.cursorJoystickVkDown) {
            zxKeyCode = 0x1000000000L;
        } else if (keyCode == this.cursorJoystickVkFire) {
            zxKeyCode = 0x100000000L;
        }
        if (!this.onlyJoystickEvents || (evt.getModifiersEx() & 0x80) != 0) {
            switch (keyCode) {
                case 27: {
                    if (!this.board.getVideoController().isMouseTrapActive()) break;
                    this.board.getVideoController().setTrapMouseActive(false);
                    break;
                }
                case 49: {
                    zxKeyCode = 0x1000000L;
                    break;
                }
                case 50: {
                    zxKeyCode = 0x2000000L;
                    break;
                }
                case 51: {
                    zxKeyCode = 0x4000000L;
                    break;
                }
                case 52: {
                    zxKeyCode = 0x8000000L;
                    break;
                }
                case 53: {
                    zxKeyCode = 0x10000000L;
                    break;
                }
                case 54: {
                    zxKeyCode = 0x1000000000L;
                    break;
                }
                case 55: {
                    zxKeyCode = 0x800000000L;
                    break;
                }
                case 56: {
                    zxKeyCode = 0x400000000L;
                    break;
                }
                case 57: {
                    zxKeyCode = 0x200000000L;
                    break;
                }
                case 48: {
                    zxKeyCode = 0x100000000L;
                    break;
                }
                case 81: {
                    zxKeyCode = 65536L;
                    break;
                }
                case 87: {
                    zxKeyCode = 131072L;
                    break;
                }
                case 69: {
                    zxKeyCode = 262144L;
                    break;
                }
                case 82: {
                    zxKeyCode = 524288L;
                    break;
                }
                case 84: {
                    zxKeyCode = 0x100000L;
                    break;
                }
                case 89: {
                    zxKeyCode = 0x100000000000L;
                    break;
                }
                case 85: {
                    zxKeyCode = 0x80000000000L;
                    break;
                }
                case 73: {
                    zxKeyCode = 0x40000000000L;
                    break;
                }
                case 79: {
                    zxKeyCode = 0x20000000000L;
                    break;
                }
                case 80: {
                    zxKeyCode = 0x10000000000L;
                    break;
                }
                case 65: {
                    zxKeyCode = 256L;
                    break;
                }
                case 83: {
                    zxKeyCode = 512L;
                    break;
                }
                case 68: {
                    zxKeyCode = 1024L;
                    break;
                }
                case 70: {
                    zxKeyCode = 2048L;
                    break;
                }
                case 71: {
                    zxKeyCode = 4096L;
                    break;
                }
                case 72: {
                    zxKeyCode = 0x10000000000000L;
                    break;
                }
                case 74: {
                    zxKeyCode = 0x8000000000000L;
                    break;
                }
                case 75: {
                    zxKeyCode = 0x4000000000000L;
                    break;
                }
                case 76: {
                    zxKeyCode = 0x2000000000000L;
                    break;
                }
                case 10: {
                    zxKeyCode = 0x1000000000000L;
                    break;
                }
                case 90: {
                    zxKeyCode = 2L;
                    break;
                }
                case 88: {
                    zxKeyCode = 4L;
                    break;
                }
                case 67: {
                    zxKeyCode = 8L;
                    break;
                }
                case 86: {
                    zxKeyCode = 16L;
                    break;
                }
                case 66: {
                    zxKeyCode = 0x1000000000000000L;
                    break;
                }
                case 78: {
                    zxKeyCode = 0x800000000000000L;
                    break;
                }
                case 77: {
                    zxKeyCode = 0x400000000000000L;
                    break;
                }
                case 32: {
                    zxKeyCode = 0x100000000000000L;
                    break;
                }
                case 16: {
                    zxKeyCode = 1L;
                    break;
                }
                case 18: {
                    zxKeyCode = 0x200000000000000L;
                    break;
                }
                case 8: {
                    zxKeyCode = 0x100000001L;
                    break;
                }
                case 37: {
                    if (!kempsonJoystickActivated) break;
                    zxKeyCode = this.cursorCsMask | 0x10000000L;
                    break;
                }
                case 39: {
                    if (!kempsonJoystickActivated) break;
                    zxKeyCode = this.cursorCsMask | 0x400000000L;
                    break;
                }
                case 38: {
                    if (!kempsonJoystickActivated) break;
                    zxKeyCode = this.cursorCsMask | 0x800000000L;
                    break;
                }
                case 40: {
                    if (!kempsonJoystickActivated) break;
                    zxKeyCode = this.cursorCsMask | 0x1000000000L;
                    break;
                }
                case 44: {
                    zxKeyCode = 0xA00000000000000L;
                    break;
                }
                case 46: {
                    zxKeyCode = 0x600000000000000L;
                    break;
                }
                case 61: {
                    zxKeyCode = 0x202000000000000L;
                    break;
                }
                case 47: {
                    zxKeyCode = 0x200000000000010L;
                    break;
                }
                case 222: {
                    zxKeyCode = 0x200000800000000L;
                    break;
                }
                case 45: {
                    zxKeyCode = 0x208000000000000L;
                }
            }
        }
        boolean consumed = false;
        if (zxKeyCode != 0L) {
            long theLinesState = this.keyboardLines;
            theLinesState = pressed ? (theLinesState &= 0x1F1F1F1F1F1F1F1FL ^ zxKeyCode) : (theLinesState |= 0x1F1F1F1F1F1F1F1FL & zxKeyCode);
            this.keyboardLines = theLinesState;
            consumed = true;
        }
        if (kempstonCode != 0) {
            int theSignal = this.kempstonSignals;
            theSignal = pressed ? (theSignal |= kempstonCode) : ~kempstonCode & theSignal & 0xFF;
            this.kempstonSignals = theSignal;
            consumed = true;
        }
        return consumed;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isTapeIn() {
        TapeSource reader = this.tap.get();
        if (reader == null) {
            return false;
        }
        return reader.isHi();
    }

    public void doKempstonCenterX() {
        int state = this.kempstonSignals;
        this.kempstonSignals = state &= 0xFFFFFFFC;
    }

    public void doKempstonCenterY() {
        int state = this.kempstonSignals;
        this.kempstonSignals = state &= 0xFFFFFFF3;
    }

    public void doKempstonLeft() {
        int state = this.kempstonSignals;
        this.kempstonSignals = state = 2 | state & 0xFFFFFFFE;
    }

    public void doKempstonUp() {
        int state = this.kempstonSignals;
        this.kempstonSignals = state = 8 | state & 0xFFFFFFFB;
    }

    public void doKempstonRight() {
        int state = this.kempstonSignals;
        this.kempstonSignals = state = 1 | state & 0xFFFFFFFD;
    }

    public void doKempstonDown() {
        int state = this.kempstonSignals;
        this.kempstonSignals = state = 4 | state & 0xFFFFFFF7;
    }

    public void doKempstonFire(boolean pressed) {
        int state = this.kempstonSignals;
        state = pressed ? (state |= 0x10) : (state &= 0xFFFFFFEF);
        this.kempstonSignals = state;
    }

    public void doInterface2Fire(int player, boolean pressed) {
        long state = this.keyboardLines;
        state = player == 0 ? (pressed ? (state &= 0x1F1F1F1F0F1F1F1FL) : (state |= 0x10000000L)) : (pressed ? (state &= 0x1F1F1F1E1F1F1F1FL) : (state |= 0x100000000L));
        this.keyboardLines = state;
    }

    public void doInterface2Down(int player) {
        long state = this.keyboardLines;
        state = player == 0 ? (state | 0x8000000L) & 0x1F1F1F1F1B1F1F1FL : (state | 0x200000000L) & 0x1F1F1F1B1F1F1F1FL;
        this.keyboardLines = state;
    }

    public void doInterface2Up(int player) {
        long state = this.keyboardLines;
        state = player == 0 ? (state | 0x4000000L) & 0x1F1F1F1F171F1F1FL : (state | 0x400000000L) & 0x1F1F1F1D1F1F1F1FL;
        this.keyboardLines = state;
    }

    public void doInterface2Left(int player) {
        long state = this.keyboardLines;
        state = player == 0 ? (state | 0x2000000L) & 0x1F1F1F1F1E1F1F1FL : (state | 0x800000000L) & 0x1F1F1F0F1F1F1F1FL;
        this.keyboardLines = state;
    }

    public void doInterface2Right(int player) {
        long state = this.keyboardLines;
        state = player == 0 ? (state | 0x1000000L) & 0x1F1F1F1F1D1F1F1FL : (state | 0x1000000000L) & 0x1F1F1F171F1F1F1FL;
        this.keyboardLines = state;
    }

    public void doInterface2CenterX(int player) {
        long state = this.keyboardLines;
        state = player == 0 ? (state |= 0x3000000L) : (state |= 0x1800000000L);
        this.keyboardLines = state;
    }

    public void doInterface2CenterY(int player) {
        long state = this.keyboardLines;
        state = player == 0 ? (state |= 0xC000000L) : (state |= 0x600000000L);
        this.keyboardLines = state;
    }

    public void notifyUnregisterGadapter(GameControllerAdapter adapter) {
        LOGGER.info("Unregistering adapter: " + String.valueOf(adapter));
        this.activeGameControllerAdapters.remove(adapter);
    }

    public long getKeyState() {
        return this.keyboardLines;
    }

    @FunctionalInterface
    public static interface TapeStateChangeListener {
        public void onTapeStateChanged(KeyboardKempstonAndTapeIn var1);
    }
}

