/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.betadisk;

import com.igormaznitsa.zxpoly.components.betadisk.TrDosDisk;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class K1818VG93 {
    public static final int STATUS_BUSY = 1;
    public static final int STATUS_INDEXMARK_DRQ = 2;
    public static final int STATUS_TR00_DATALOST = 4;
    public static final int STATUS_CRCERROR = 8;
    public static final int STATUS_SEEKERROR_NOTFOUNF = 16;
    public static final int STATUS_HEADLOADED_RECTYPE_WRITEFAULT = 32;
    public static final int STATUS_WRITE_PROTECT = 64;
    public static final int STATUS_NOT_READY = 128;
    static final int ADDR_COMMAND_STATE = 0;
    static final int ADDR_TRACK = 1;
    static final int ADDR_SECTOR = 2;
    static final int ADDR_DATA = 3;
    private static final long DELAY_FDD_MOTOR_ON_MS = 2000L;
    private static final int REG_COMMAND = 0;
    private static final int REG_STATUS = 1;
    private static final int REG_TRACK = 2;
    private static final int REG_SECTOR = 3;
    private static final int REG_DATA_WR = 4;
    private static final int REG_DATA_RD = 5;
    private static final int COMMAND_FLAG_MULTIPLE_RECORDS = 16;
    private final long tstatesDiskTurn;
    private final long[] tstatesPerTrackChange;
    private final long tstatesPerSector;
    private final long tstatesPerSectorBe;
    private final long tstatesIndexMarkLength;
    private final int[] registers = new int[6];
    private final AtomicReference<TrDosDisk> trdosDisk = new AtomicReference();
    private final Logger logger;
    private TrDosDisk.Sector sector;
    private int counter;
    private int extraCounter;
    private boolean flagWaitDataRd;
    private boolean flagWaitDataWr;
    private boolean resetIn;
    private boolean firstCommandStep;
    private boolean outwardStepDirection;
    private boolean trackIndexMarkerActive;
    private boolean mfmModulation;
    private long sectorPositioningCycles;
    private long operationTimeOutCycles;
    private volatile long lastBusyOnTime;
    private Object tempAuxiliaryObject;
    private long timeIndexMarkChange = -1L;
    private static final Level LOG_LEVEL = Level.FINE;

    public K1818VG93(TimingProfile profile, Logger logger) {
        this.logger = logger;
        this.tstatesDiskTurn = (long)profile.tstatesFrame * 4L;
        this.tstatesPerTrackChange = new long[]{profile.tstatesFrame / 4, profile.tstatesFrame / 2, profile.tstatesFrame, profile.tstatesFrame + profile.tstatesFrame / 3};
        this.tstatesPerSector = this.tstatesDiskTurn / 16L;
        this.tstatesPerSectorBe = profile.tstatesFrame / 640;
        this.tstatesIndexMarkLength = (long)profile.tstatesFrame * 80L / 1000L;
        this.reset();
    }

    public void reset() {
        Arrays.fill(this.registers, 0);
        this.trackIndexMarkerActive = false;
        this.timeIndexMarkChange = -1L;
        this.flagWaitDataRd = false;
        this.flagWaitDataWr = false;
        this.resetIn = false;
        this.firstCommandStep = false;
        this.counter = 0;
    }

    public void activateDisk(int index, TrDosDisk disk) {
        this.trdosDisk.set(disk);
        if (disk == null) {
            this.sector = null;
        } else {
            this.timeIndexMarkChange = -1L;
            this.trackIndexMarkerActive = false;
            this.sector = disk.findFirstSector(this.registers[2]);
        }
    }

    private TrDosDisk getDisk() {
        return this.trdosDisk.get();
    }

    private void resetStatus(boolean preventDataLostFlag) {
        this.registers[1] = preventDataLostFlag ? this.registers[1] & 4 : 0;
    }

    private void setInternalFlag(int flags) {
        if ((flags & 1) != 0) {
            this.lastBusyOnTime = System.currentTimeMillis();
        }
        this.registers[1] = this.registers[1] | flags;
    }

    private void resetInternalFlag(int flags) {
        this.registers[1] = this.registers[1] & ~flags & 0xFF;
    }

    private boolean isFlag(int flags) {
        return (this.registers[1] & flags) != 0;
    }

    public void setResetIn(boolean signal) {
        if (!this.resetIn && signal) {
            this.reset();
        }
        this.resetIn = signal;
    }

    public boolean isMFMModulation() {
        return this.mfmModulation;
    }

    public void setMFMModulation(boolean flag) {
        this.mfmModulation = flag;
    }

    private void updateStatusForCommandsTypeI() {
        if (this.registers[2] == 0) {
            this.setInternalFlag(4);
        } else {
            this.resetInternalFlag(4);
        }
        if (this.trdosDisk.get() == null) {
            this.setInternalFlag(2);
        } else {
            if (this.sector != null && !this.sector.isCrcOk()) {
                this.setInternalFlag(8);
            }
            if (this.trackIndexMarkerActive) {
                this.setInternalFlag(2);
            } else {
                this.resetInternalFlag(2);
            }
        }
    }

    public int read(int address) {
        switch (address & 3) {
            case 0: {
                return this.registers[1] & 0xFF;
            }
            case 1: {
                return this.registers[2] & 0xFF;
            }
            case 2: {
                return this.registers[3] & 0xFF;
            }
            case 3: {
                if (this.flagWaitDataRd) {
                    this.flagWaitDataRd = false;
                    this.resetInternalFlag(2);
                }
                return this.registers[5] & 0xFF;
            }
        }
        throw new Error("Unexpected value");
    }

    public void write(int addr, int value) {
        int normValue = value & 0xFF;
        switch (addr & 3) {
            case 0: {
                if (this.isFlag(1)) {
                    if (normValue >>> 4 == 13) {
                        this.registers[0] = normValue;
                        this.firstCommandStep = true;
                        this.flagWaitDataRd = false;
                        this.flagWaitDataWr = false;
                        this.operationTimeOutCycles = 0L;
                        this.setInternalFlag(1);
                    }
                } else {
                    switch (normValue >>> 4) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 14: 
                        case 15: {
                            this.resetStatus(false);
                        }
                    }
                    this.operationTimeOutCycles = 0L;
                    this.registers[0] = normValue;
                    this.firstCommandStep = true;
                    this.flagWaitDataRd = false;
                    this.flagWaitDataWr = false;
                    this.setInternalFlag(1);
                }
                if (!this.firstCommandStep) break;
                this.logger.log(LOG_LEVEL, "FDD cmd (" + this.toBinByte(normValue) + "): " + this.commandAsText(normValue));
                break;
            }
            case 1: {
                if (this.isFlag(1)) break;
                this.registers[2] = normValue;
                break;
            }
            case 2: {
                if (this.isFlag(1)) break;
                this.registers[3] = normValue;
                break;
            }
            case 3: {
                if (this.flagWaitDataWr) {
                    this.flagWaitDataWr = false;
                    this.resetInternalFlag(2);
                }
                this.registers[4] = normValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value");
            }
        }
    }

    private String toBinByte(int value) {
        StringBuilder buffer = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            buffer.append((value & 0x80) == 0 ? (char)'0' : '1');
            value <<= 1;
        }
        return buffer.toString();
    }

    private String commandAsText(int command) {
        int addressTrack = this.registers[2];
        int addressSector = this.registers[3];
        TrDosDisk disk = this.trdosDisk.get();
        String address = String.format("current(track=%d, head=%d, sector=%d, dataReg=%d)", addressTrack, disk == null ? -1 : disk.getHeadIndex(), addressSector, this.registers[4]);
        int high = command >>> 4;
        switch (high) {
            case 0: {
                return "RESTORE (" + address + ")";
            }
            case 1: {
                return "SEEK (" + address + ")";
            }
            case 2: 
            case 3: {
                return "STEP (" + address + ")";
            }
            case 4: 
            case 5: {
                return "STEP_IN (" + address + ")";
            }
            case 6: 
            case 7: {
                return "STEP_OUT (" + address + ")";
            }
            case 8: 
            case 9: {
                return "RD.SECTOR" + ((high & 1) == 0 ? "(S)" : "(M)") + " " + address;
            }
            case 10: 
            case 11: {
                return "WR.SECTOR" + ((high & 1) == 0 ? "(S)" : "(M)") + " " + address;
            }
            case 12: {
                return "RD.ADDR";
            }
            case 14: {
                return "RD.TRACK (track=" + addressTrack + ")";
            }
            case 15: {
                return "WR.TRACK (track=" + addressTrack + ")";
            }
            case 13: {
                return "FRC.INTERRUPT";
            }
        }
        return "UNKNOWN " + Integer.toBinaryString(high);
    }

    public void step(long tstatesCounter) {
        TrDosDisk thefloppy = this.trdosDisk.get();
        if (thefloppy == null) {
            this.setInternalFlag(128);
        } else {
            this.resetInternalFlag(128);
            if (tstatesCounter >= this.timeIndexMarkChange) {
                this.timeIndexMarkChange = tstatesCounter + (this.trackIndexMarkerActive ? this.tstatesDiskTurn - this.tstatesIndexMarkLength : this.tstatesIndexMarkLength);
                this.trackIndexMarkerActive = !this.trackIndexMarkerActive;
            }
        }
        int command = this.registers[0];
        if ((command & 0x80) == 0) {
            this.updateStatusForCommandsTypeI();
        }
        if (this.isFlag(1)) {
            boolean first = this.firstCommandStep;
            this.firstCommandStep = false;
            switch (command >>> 4) {
                case 0: {
                    this.cmdRestore(tstatesCounter, command, first);
                    break;
                }
                case 1: {
                    this.cmdSeek(tstatesCounter, command, first);
                    break;
                }
                case 2: 
                case 3: {
                    this.cmdStep(tstatesCounter, command, first);
                    break;
                }
                case 4: 
                case 5: {
                    this.cmdStepIn(tstatesCounter, command, first);
                    break;
                }
                case 6: 
                case 7: {
                    this.cmdStepOut(tstatesCounter, command, first);
                    break;
                }
                case 8: 
                case 9: {
                    this.cmdReadSector(tstatesCounter, command, first);
                    break;
                }
                case 10: 
                case 11: {
                    this.cmdWriteSector(tstatesCounter, command, first);
                    break;
                }
                case 12: {
                    this.cmdReadAddress(tstatesCounter, command, first);
                    break;
                }
                case 13: {
                    this.cmdForceInterrupt(tstatesCounter, command, first);
                    break;
                }
                case 14: {
                    this.cmdReadTrack(tstatesCounter, command, first);
                    break;
                }
                case 15: {
                    this.cmdWriteTrack(tstatesCounter, command, first);
                    break;
                }
                default: {
                    throw new Error("Unexpected value");
                }
            }
        }
    }

    private void loadSector(int track, int sector) {
        TrDosDisk floppy = this.trdosDisk.get();
        TrDosDisk.Sector foundSector = floppy == null ? null : floppy.findSector(track, sector);
        this.sector = foundSector;
    }

    private void provideReadData(int data) {
        this.registers[5] = data & 0xFF;
        this.flagWaitDataRd = true;
    }

    private void resetDataRegisters() {
        this.registers[5] = 0;
        this.registers[4] = 0;
        this.flagWaitDataRd = false;
        this.flagWaitDataWr = false;
    }

    private void cmdForceInterrupt(long tstatesCounter, int command, boolean start) {
        this.logger.log(LOG_LEVEL, "INTERRUPT (counter=" + this.counter + ")");
        this.operationTimeOutCycles = -1L;
        this.resetInternalFlag(1);
    }

    private void cmdRestore(long tstatesCounter, int command, boolean start) {
        TrDosDisk currentDisk = this.trdosDisk.get();
        this.resetStatus(false);
        if (start) {
            this.counter = 0;
        }
        if (currentDisk == null) {
            this.setInternalFlag(128);
        } else {
            if ((command & 8) != 0) {
                this.setInternalFlag(32);
            }
            if (currentDisk.isWriteProtect()) {
                this.setInternalFlag(64);
            }
            if (this.counter < 255 && this.registers[2] > 0) {
                this.registers[2] = this.registers[2] - 1;
                this.sector = currentDisk.findFirstSector(this.registers[2]);
                if (this.sector == null) {
                    this.setInternalFlag(16);
                } else {
                    this.registers[3] = 1;
                    this.setInternalFlag(1);
                }
            } else if (this.registers[2] != 0) {
                this.sector = currentDisk.findFirstSector(this.registers[2]);
                if (this.sector != null) {
                    this.registers[3] = 1;
                }
                this.setInternalFlag(16);
            }
        }
    }

    private void cmdSeek(long tstatesCounter, int command, boolean start) {
        this.resetStatus(false);
        TrDosDisk currentDisk = this.trdosDisk.get();
        if ((command & 8) != 0) {
            this.setInternalFlag(32);
        }
        if (currentDisk == null) {
            this.setInternalFlag(128);
        } else {
            if (start) {
                this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
            }
            if (currentDisk.isWriteProtect()) {
                this.setInternalFlag(64);
            }
            boolean completed = false;
            if (tstatesCounter >= this.operationTimeOutCycles) {
                if (this.registers[2] != this.registers[4]) {
                    this.registers[2] = this.registers[2] < this.registers[4] ? this.registers[2] + 1 : this.registers[2] - 1;
                    this.registers[3] = 1;
                    this.loadSector(this.registers[2], this.registers[3]);
                    this.logger.log(LOG_LEVEL, "FDD head moved to track " + this.registers[2] + ", target track is " + this.registers[4]);
                    this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerTrackChange[command & 2]);
                }
                boolean bl = completed = this.registers[2] == this.registers[4];
                if (this.sector == null) {
                    this.setInternalFlag(16);
                    completed = true;
                } else {
                    this.loadSector(this.registers[2], this.registers[3]);
                    if (this.sector != null && !this.sector.isCrcOk()) {
                        this.setInternalFlag(8);
                    }
                }
            }
            if (completed) {
                this.logger.log(LOG_LEVEL, "SEEK completed on track=" + this.registers[2]);
            } else {
                this.setInternalFlag(1);
            }
        }
    }

    private void cmdReadAddress(long tstatesCounter, int command, boolean start) {
        this.resetStatus(true);
        TrDosDisk currentDisk = this.trdosDisk.get();
        if (currentDisk == null) {
            this.setInternalFlag(128);
        } else {
            if (start) {
                if (this.sector == null) {
                    this.sector = currentDisk.findFirstSector(this.registers[2]);
                }
                this.counter = 6;
                this.sectorPositioningCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                this.extraCounter = 0;
            }
            if (this.sector == null) {
                this.sector = currentDisk.findFirstSector(this.registers[2]);
            }
            if (this.sector == null) {
                this.setInternalFlag(16);
                this.resetDataRegisters();
            } else if (tstatesCounter < this.sectorPositioningCycles) {
                this.setInternalFlag(1);
            } else {
                if (this.sectorPositioningCycles >= 0L) {
                    this.sectorPositioningCycles = -1L;
                    this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                }
                if (!this.sector.isCrcOk()) {
                    this.setInternalFlag(8);
                } else if (!this.flagWaitDataRd) {
                    this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                    if (this.counter > 0) {
                        switch (this.counter) {
                            case 6: {
                                int trackNum = this.sector.getTrackNumber();
                                this.provideReadData(trackNum);
                                this.setInternalFlag(2);
                                this.extraCounter |= trackNum << 16;
                                break;
                            }
                            case 5: {
                                int side = this.sector.getSide();
                                this.provideReadData(side);
                                this.setInternalFlag(2);
                                this.extraCounter |= side << 8;
                                break;
                            }
                            case 4: {
                                int sectorId = this.sector.getPhysicalIndex();
                                this.provideReadData(sectorId);
                                this.setInternalFlag(2);
                                this.extraCounter |= sectorId;
                                break;
                            }
                            case 3: {
                                int sectorLen = this.sector.size();
                                int type = sectorLen <= 128 ? 0 : (sectorLen <= 256 ? 1 : (sectorLen <= 512 ? 2 : 3));
                                this.provideReadData(type);
                                this.setInternalFlag(2);
                                break;
                            }
                            case 2: {
                                int crc = this.sector.getCrc() >>> 8;
                                this.provideReadData(crc);
                                this.setInternalFlag(2);
                                break;
                            }
                            case 1: {
                                int crc = this.sector.getCrc() & 0xFF;
                                this.provideReadData(crc);
                                this.setInternalFlag(2);
                                break;
                            }
                            default: {
                                throw new Error("Unexpected counter state");
                            }
                        }
                        --this.counter;
                        if (this.counter > 0) {
                            this.setInternalFlag(1);
                        } else {
                            int track = this.extraCounter >> 16 & 0xFF;
                            int side = this.extraCounter >> 8 & 0xFF;
                            int sector = this.extraCounter & 0xFF;
                            this.logger.log(LOG_LEVEL, "FOUND.ADDR t=" + track + ";h=" + side + ":s=" + sector);
                        }
                    }
                } else if (tstatesCounter > this.operationTimeOutCycles) {
                    this.setInternalFlag(4);
                } else {
                    this.setInternalFlag(3);
                }
            }
        }
    }

    private void cmdStep(long tstatesCounter, int command, boolean start) {
        TrDosDisk thedisk = this.trdosDisk.get();
        this.resetStatus(false);
        if (thedisk == null) {
            this.resetDataRegisters();
            this.setInternalFlag(128);
        } else {
            if (start) {
                this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
            }
            if ((command & 8) != 0) {
                this.setInternalFlag(32);
            }
            if (thedisk.isWriteProtect()) {
                this.setInternalFlag(64);
            }
            if (!this.sector.isCrcOk()) {
                this.setInternalFlag(8);
            }
            if (tstatesCounter < this.operationTimeOutCycles) {
                this.setInternalFlag(1);
            } else {
                int currentTrack = this.registers[2];
                currentTrack = this.outwardStepDirection ? currentTrack + 1 & 0xFF : currentTrack - 1 & 0xFF;
                this.sector = thedisk.findRandomSector(currentTrack);
                if ((command & 0x10) != 0) {
                    this.registers[2] = currentTrack;
                }
                if (this.sector == null) {
                    this.setInternalFlag(16);
                }
            }
        }
    }

    private void cmdStepIn(long tstatesCounter, int command, boolean start) {
        this.outwardStepDirection = false;
        this.cmdStep(tstatesCounter, command, start);
    }

    private void cmdStepOut(long tstatesCounter, int command, boolean start) {
        this.outwardStepDirection = true;
        this.cmdStep(tstatesCounter, command, start);
    }

    private void cmdReadSector(long tstatesCounter, int command, boolean start) {
        boolean multiSectors = (command & 0x10) != 0;
        int sideNumber = command >>> 3 & 1;
        boolean doCheckSide = (command & 2) != 0;
        this.resetStatus(true);
        TrDosDisk currentDisk = this.trdosDisk.get();
        if (currentDisk == null) {
            this.setInternalFlag(128);
        } else {
            this.loadSector(this.registers[2], this.registers[3]);
            if (this.sector != null && doCheckSide && this.sector.getSide() != sideNumber) {
                this.sector = null;
            }
            if (this.sector == null) {
                this.resetDataRegisters();
                this.setInternalFlag(16);
            } else {
                if (start) {
                    this.counter = 0;
                    this.sectorPositioningCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                }
                if (tstatesCounter < this.sectorPositioningCycles) {
                    this.setInternalFlag(1);
                    this.resetInternalFlag(2);
                } else {
                    if (this.sectorPositioningCycles >= 0L) {
                        this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                        this.sectorPositioningCycles = -1L;
                    }
                    if (this.flagWaitDataRd) {
                        if (tstatesCounter > this.operationTimeOutCycles) {
                            this.setInternalFlag(4);
                        } else {
                            this.setInternalFlag(3);
                        }
                    } else if (this.counter >= this.sector.size()) {
                        this.sectorPositioningCycles = Math.abs(tstatesCounter + this.tstatesPerSector);
                        if (multiSectors) {
                            if (!this.sector.isLastOnTrack()) {
                                this.logger.log(LOG_LEVEL, "RD.SECTOR completed, start next sector in multi-sec");
                                this.registers[3] = this.registers[3] + 1 & 0xFF;
                                this.loadSector(this.registers[2], this.registers[3]);
                                this.counter = 0;
                                this.setInternalFlag(1);
                                this.resetInternalFlag(2);
                            }
                        } else {
                            this.logger.log(LOG_LEVEL, "RD.SECTOR completed");
                        }
                    } else {
                        int data = this.sector.readByte(this.counter++);
                        this.sectorPositioningCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                        if (data < 0) {
                            this.setInternalFlag(4);
                            this.resetInternalFlag(2);
                        } else if (tstatesCounter > this.operationTimeOutCycles) {
                            this.setInternalFlag(4);
                        } else {
                            this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                            this.provideReadData(data);
                            this.setInternalFlag(3);
                        }
                    }
                }
            }
        }
    }

    private void cmdWriteSector(long tstatesCounter, int command, boolean start) {
        boolean multiOp = (command & 0x10) != 0;
        int softSide = command >>> 3 & 1;
        boolean doCheckSide = (command & 1) != 0;
        this.resetStatus(true);
        TrDosDisk thedisk = this.trdosDisk.get();
        if (thedisk == null) {
            this.setInternalFlag(128);
        } else if (thedisk.isWriteProtect()) {
            this.setInternalFlag(64);
        }
        this.loadSector(this.registers[2], this.registers[3]);
        if (this.sector != null && doCheckSide && this.sector.getSide() != softSide) {
            this.sector = null;
        }
        if (this.sector == null) {
            this.resetDataRegisters();
            this.setInternalFlag(16);
        } else {
            if (start) {
                this.counter = 0;
                this.flagWaitDataWr = true;
                this.sectorPositioningCycles = Math.abs(tstatesCounter + this.tstatesPerSector);
            }
            if (tstatesCounter < this.sectorPositioningCycles) {
                this.setInternalFlag(1);
            } else {
                if (this.sectorPositioningCycles >= 0L) {
                    this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                    this.sectorPositioningCycles = -1L;
                }
                if (!this.flagWaitDataWr) {
                    this.flagWaitDataWr = true;
                    if (this.counter >= this.sector.size()) {
                        this.registers[3] = this.registers[3] + 1 & 0xFF;
                        this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                        if (multiOp && !this.sector.isLastOnTrack()) {
                            this.counter = 0;
                            this.setInternalFlag(1);
                        }
                    } else if (tstatesCounter > this.operationTimeOutCycles) {
                        this.resetDataRegisters();
                        this.setInternalFlag(16);
                    } else {
                        this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                        if (!this.sector.writeByte(this.counter++, this.registers[4])) {
                            this.setInternalFlag(32);
                        } else if (this.counter < this.sector.size()) {
                            this.setInternalFlag(3);
                        }
                    }
                } else {
                    if (tstatesCounter > this.operationTimeOutCycles) {
                        this.setInternalFlag(4);
                    }
                    this.setInternalFlag(3);
                }
            }
        }
    }

    private void cmdReadTrack(long tstatesCounter, int command, boolean start) {
        this.resetStatus(true);
        TrDosDisk currentDisk = this.trdosDisk.get();
        if (currentDisk == null) {
            this.setInternalFlag(128);
        } else {
            TrackHelper helper;
            if (start) {
                this.counter = 0;
                helper = this.mfmModulation ? new MFMTrackHelper(this.getDisk()) : new FMTracHelper(this.getDisk());
                helper.prepareTrackForRead(this.registers[2]);
                this.tempAuxiliaryObject = helper;
                this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
            }
            if (!this.flagWaitDataRd) {
                int data;
                this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                helper = (TrackHelper)this.tempAuxiliaryObject;
                if (!helper.isCompleted() && (data = helper.readNextTrackData()) >= 0) {
                    this.provideReadData(data);
                    this.setInternalFlag(1);
                }
            } else {
                if (tstatesCounter > this.operationTimeOutCycles) {
                    this.setInternalFlag(4);
                }
                this.setInternalFlag(3);
            }
        }
    }

    private void cmdWriteTrack(long tstatesCounter, int command, boolean start) {
        this.resetStatus(false);
        TrDosDisk currentDisk = this.trdosDisk.get();
        if (currentDisk == null) {
            this.setInternalFlag(128);
        } else {
            if (start) {
                this.counter = 0;
                this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                this.flagWaitDataWr = true;
                Object object = this.tempAuxiliaryObject = this.mfmModulation ? new MFMTrackHelper(this.getDisk()) : new FMTracHelper(this.getDisk());
            }
            if (!this.flagWaitDataWr) {
                this.operationTimeOutCycles = Math.abs(tstatesCounter + this.tstatesPerSectorBe);
                this.flagWaitDataWr = true;
                int data = this.registers[4] & 0xFF;
                TrackHelper helper = (TrackHelper)this.tempAuxiliaryObject;
                if (!helper.isCompleted()) {
                    try {
                        helper.writeNextDataByte(data);
                        this.setInternalFlag(3);
                    }
                    catch (IOException ex) {
                        this.setInternalFlag(32);
                    }
                }
            } else {
                if (tstatesCounter > this.operationTimeOutCycles) {
                    this.setInternalFlag(4);
                }
                this.setInternalFlag(3);
            }
        }
    }

    public boolean isMotorOn() {
        return System.currentTimeMillis() - this.lastBusyOnTime < 2000L;
    }

    private static class MFMTrackHelper
    extends TrackHelper {
        MFMTrackHelper(TrDosDisk disk) {
            super(disk, true);
        }

        @Override
        void prepareTrackForRead(int trackIndex) {
            int i;
            TrDosDisk.Sector sector = this.disk.findFirstSector(trackIndex);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (i = 0; i < 80; ++i) {
                buffer.write(78);
            }
            for (i = 0; i < 12; ++i) {
                buffer.write(0);
            }
            for (i = 0; i < 3; ++i) {
                buffer.write(246);
            }
            buffer.write(252);
            for (i = 0; i < 50; ++i) {
                buffer.write(78);
            }
            while (sector != null) {
                int i2;
                for (i = 0; i < 12; ++i) {
                    buffer.write(0);
                }
                for (i = 0; i < 3; ++i) {
                    buffer.write(245);
                }
                int crc = this.writeCrc(sector, buffer);
                for (i2 = 0; i2 < 22; ++i2) {
                    buffer.write(78);
                }
                for (i2 = 0; i2 < 12; ++i2) {
                    buffer.write(0);
                }
                for (i2 = 0; i2 < 3; ++i2) {
                    buffer.write(245);
                }
                buffer.write(251);
                for (i2 = 0; i2 < sector.size(); ++i2) {
                    buffer.write(sector.readByte(i2));
                }
                buffer.write(crc);
                buffer.write(crc >>> 8);
                for (i2 = 0; i2 < 54; ++i2) {
                    buffer.write(78);
                }
                sector = this.disk.findNextSector(sector);
            }
            for (i = 0; i < 598; ++i) {
                buffer.write(78);
            }
            this.trackReadBuffer = buffer.toByteArray();
            this.trackTotalBytes = this.trackReadBuffer.length;
        }
    }

    private static class FMTracHelper
    extends TrackHelper {
        FMTracHelper(TrDosDisk disk) {
            super(disk, false);
        }

        @Override
        void prepareTrackForRead(int trackIndex) {
            int i;
            TrDosDisk.Sector sector = this.disk.findFirstSector(trackIndex);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (i = 0; i < 40; ++i) {
                buffer.write(255);
            }
            for (i = 0; i < 40; ++i) {
                buffer.write(0);
            }
            buffer.write(252);
            for (i = 0; i < 26; ++i) {
                buffer.write(255);
            }
            while (sector != null) {
                int i2;
                for (i = 0; i < 6; ++i) {
                    buffer.write(0);
                }
                int crc = this.writeCrc(sector, buffer);
                for (i2 = 0; i2 < 11; ++i2) {
                    buffer.write(255);
                }
                for (i2 = 0; i2 < 6; ++i2) {
                    buffer.write(0);
                }
                buffer.write(251);
                for (i2 = 0; i2 < sector.size(); ++i2) {
                    buffer.write(sector.readByte(i2));
                }
                buffer.write(crc);
                buffer.write(crc >>> 8);
                for (i2 = 0; i2 < 27; ++i2) {
                    buffer.write(255);
                }
                sector = this.disk.findNextSector(sector);
            }
            for (i = 0; i < 247; ++i) {
                buffer.write(255);
            }
            this.trackReadBuffer = buffer.toByteArray();
            this.trackTotalBytes = this.trackReadBuffer.length;
        }
    }

    private static abstract class TrackHelper {
        final boolean mfm;
        final TrDosDisk disk;
        State state;
        int trackIndex;
        int sectorIndex;
        int sectorSize;
        int expectedData;
        int dataByteIndex;
        int trackBytePosition;
        int trackTotalBytes;
        byte[] trackReadBuffer;

        TrackHelper(TrDosDisk disk, boolean mfm) {
            this.disk = disk;
            this.state = State.WAIT_ADDRESS;
            this.mfm = mfm;
            this.trackBytePosition = 0;
            this.trackTotalBytes = mfm ? 6450 : 6450;
        }

        protected int writeCrc(TrDosDisk.Sector sector, ByteArrayOutputStream buffer) {
            buffer.write(254);
            buffer.write(sector.getTrackNumber());
            buffer.write(sector.getSide());
            buffer.write(sector.getPhysicalIndex());
            buffer.write(this.getSectorSizeCode(sector.size()));
            int crc = sector.getCrc();
            buffer.write(crc);
            buffer.write(crc >>> 8);
            return crc;
        }

        final boolean writeNextDataByte(int dataByte) throws IOException {
            switch (this.state.ordinal()) {
                case 0: {
                    if (dataByte != 254) break;
                    this.state = State.ADDR_TRACK;
                    break;
                }
                case 1: {
                    this.trackIndex = dataByte;
                    this.state = State.ADDR_HEAD;
                    break;
                }
                case 2: {
                    this.state = State.ADDR_SECTOR;
                    break;
                }
                case 3: {
                    this.sectorIndex = dataByte;
                    this.state = State.ADDR_SIZE;
                    break;
                }
                case 4: {
                    this.sectorSize = dataByte;
                    switch (this.sectorSize) {
                        case 0: {
                            this.expectedData = 128;
                            break;
                        }
                        case 1: {
                            this.expectedData = 256;
                            break;
                        }
                        case 2: {
                            this.expectedData = 512;
                            break;
                        }
                        case 3: {
                            this.expectedData = 1024;
                        }
                    }
                    this.state = State.WAIT_DATA;
                    break;
                }
                case 5: {
                    if (dataByte != 251) break;
                    this.state = State.DATA;
                    this.dataByteIndex = 0;
                    break;
                }
                case 6: {
                    TrDosDisk.Sector sector = this.disk.findSector(this.trackIndex, this.sectorIndex);
                    if (sector == null) {
                        throw new IOException("Can't find sector: " + this.trackIndex + ":" + this.sectorIndex);
                    }
                    if (!sector.writeByte(this.dataByteIndex, dataByte)) {
                        throw new IOException("Can't write " + this.dataByteIndex + " byte to sector: " + this.trackIndex + ":" + this.sectorIndex);
                    }
                    --this.expectedData;
                    ++this.dataByteIndex;
                    if (this.expectedData != 0) break;
                    this.state = State.WAIT_ADDRESS;
                }
            }
            ++this.trackBytePosition;
            return this.trackBytePosition < this.trackTotalBytes;
        }

        int getSectorSizeCode(int size) {
            if (size <= 128) {
                return 0;
            }
            if (size <= 256) {
                return 1;
            }
            if (size <= 512) {
                return 2;
            }
            return 3;
        }

        abstract void prepareTrackForRead(int var1);

        int readNextTrackData() {
            return this.trackBytePosition < this.trackTotalBytes ? this.trackReadBuffer[this.trackBytePosition++] : -1;
        }

        boolean isCompleted() {
            return this.trackBytePosition >= this.trackTotalBytes;
        }

        static enum State {
            WAIT_ADDRESS,
            ADDR_TRACK,
            ADDR_HEAD,
            ADDR_SECTOR,
            ADDR_SIZE,
            WAIT_DATA,
            DATA;

        }
    }
}

