/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.gadapter;

import com.igormaznitsa.zxpoly.components.KeyboardKempstonAndTapeIn;
import com.igormaznitsa.zxpoly.components.gadapter.GameControllerAdapterType;
import java.util.concurrent.atomic.AtomicReference;
import net.java.games.input.Component;
import net.java.games.input.Controller;

public abstract class GameControllerAdapter
implements Runnable {
    protected final KeyboardKempstonAndTapeIn parent;
    private final Controller controller;
    private final GameControllerAdapterType destination;
    private final AtomicReference<Thread> controllerThread = new AtomicReference();

    GameControllerAdapter(KeyboardKempstonAndTapeIn keyboardModule, Controller controller, GameControllerAdapterType destination) {
        this.parent = keyboardModule;
        this.controller = controller;
        this.destination = destination;
    }

    public Controller getController() {
        return this.controller;
    }

    public GameControllerAdapterType getType() {
        return this.destination;
    }

    public void dispose() {
        Thread thread = this.controllerThread.getAndSet(null);
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void start() {
        Thread thread = Thread.ofVirtual().name("zxp-game-controller-virtual" + this.controller.getName()).unstarted(this);
        if (!this.controllerThread.compareAndSet(null, thread)) {
            throw new Error("Detected attempt to restart already started controller!");
        }
        thread.start();
    }

    protected abstract void doLeft();

    protected abstract void doRight();

    protected abstract void doCenterX();

    protected abstract void doUp();

    protected abstract void doDown();

    protected abstract void doCenterY();

    protected abstract void doFire(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block16: {
            block5: while (true) {
                while (!Thread.currentThread().isInterrupted() && this.controllerThread.get() != null) {
                    if (!this.controller.poll()) {
                        break block16;
                    }
                    float buttonAccum = 0.0f;
                    boolean buttonDetected = false;
                    for (Component c : this.controller.getComponents()) {
                        boolean plusOne;
                        Component.Identifier identifier = c.getIdentifier();
                        float pollData = c.getPollData();
                        boolean minusOne = Float.compare(pollData, -1.0f) == 0;
                        boolean bl = plusOne = Float.compare(pollData, 1.0f) == 0;
                        if (identifier == Component.Identifier.Axis.X) {
                            if (minusOne) {
                                this.doLeft();
                                continue;
                            }
                            if (plusOne) {
                                this.doRight();
                                continue;
                            }
                            this.doCenterX();
                            continue;
                        }
                        if (identifier == Component.Identifier.Axis.Y) {
                            if (minusOne) {
                                this.doUp();
                                continue;
                            }
                            if (plusOne) {
                                this.doDown();
                                continue;
                            }
                            this.doCenterY();
                            continue;
                        }
                        if (!(identifier instanceof Component.Identifier.Button)) continue;
                        buttonAccum += Math.abs(pollData);
                        buttonDetected = true;
                    }
                    if (buttonDetected) {
                        this.doFire(buttonAccum != 0.0f);
                    }
                    try {
                        Thread.sleep(10L);
                        continue block5;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                break block16;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.parent.notifyUnregisterGadapter(this);
            }
        }
    }

    public String toString() {
        return this.controller.getName();
    }
}

