/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.sound;

import java.util.Objects;

public final class Ay8910Chip {
    private static final int MACHINE_CYCLES_PER_ATICK = 16;
    private static final int REG_TONE_PERIOD_A_FINE = 0;
    private static final int REG_TONE_PERIOD_A_ROUGH = 1;
    private static final int REG_TONE_PERIOD_B_FINE = 2;
    private static final int REG_TONE_PERIOD_B_ROUGH = 3;
    private static final int REG_TONE_PERIOD_C_FINE = 4;
    private static final int REG_TONE_PERIOD_C_ROUGH = 5;
    private static final int REG_NOISE_PERIOD = 6;
    private static final int REG_MIXER_CTRL = 7;
    private static final int REG_AMPL_A = 8;
    private static final int REG_AMPL_B = 9;
    private static final int REG_AMPL_C = 10;
    private static final int REG_ENV_PERIOD_FINE = 11;
    private static final int REG_ENV_PERIOD_ROUGH = 12;
    private static final int REG_ENV_SHAPE = 13;
    private static final int REG_IO_A = 14;
    private static final int REG_IO_B = 15;
    private static final int SIGNAL_N = 8;
    private static final int SIGNAL_C = 4;
    private static final int SIGNAL_B = 2;
    private static final int SIGNAL_A = 1;
    private static final int ENV_MIN = 0;
    private static final int ENV_MAX = 15;
    private static final int ENV_FLAG_HOLD = 1;
    private static final int ENV_FLAG_ALTR = 2;
    private static final int ENV_FLAG_ATTACK = 4;
    private static final int ENV_FLAG_CONT = 8;
    private static final int[] REG_DATA_MASK = new int[]{255, 15, 255, 15, 255, 15, 31, 255, 31, 31, 31, 255, 255, 15, 255, 255};
    private final Ay8910SignalConsumer signalConsumer;
    private boolean enfAttack = false;
    private boolean enfAlter = false;
    private boolean enfCont = false;
    private boolean enfHold = false;
    private int addressLatch;
    private int tonePeriodA;
    private int amplitudeA;
    private int tonePeriodB;
    private int amplitudeB;
    private int tonePeriodC;
    private int amplitudeC;
    private int noisePeriod;
    private int mixerControl;
    private int envelopePeriod;
    private int envelopeMode;
    private int ioPortA;
    private int ioPortB;
    private int counterA;
    private int counterB;
    private int counterC;
    private int counterN;
    private int signalNcba;
    private long machineCycleCounter;
    private int counterE;
    private int envIndexCounter;
    private int envelopeVolume;
    private int rngReg = 1;

    public Ay8910Chip(Ay8910SignalConsumer signalConsumer) {
        this.signalConsumer = Objects.requireNonNull(signalConsumer);
    }

    public int readAddress() {
        return this.addressLatch;
    }

    public void writeAddress(int address) {
        this.addressLatch = address & 0xF;
    }

    public int readData() {
        return this.readData(this.addressLatch);
    }

    public int readData(int address) {
        switch (address & 0xF) {
            case 0: {
                return this.tonePeriodA & 0xFF;
            }
            case 1: {
                return this.tonePeriodA >> 8 & 0xF;
            }
            case 2: {
                return this.tonePeriodB & 0xFF;
            }
            case 3: {
                return this.tonePeriodB >> 8 & 0xF;
            }
            case 4: {
                return this.tonePeriodC & 0xFF;
            }
            case 5: {
                return this.tonePeriodC >> 8 & 0xF;
            }
            case 6: {
                return this.noisePeriod;
            }
            case 7: {
                return this.mixerControl;
            }
            case 8: {
                return this.amplitudeA;
            }
            case 9: {
                return this.amplitudeB;
            }
            case 10: {
                return this.amplitudeC;
            }
            case 11: {
                return this.envelopePeriod & 0xFF;
            }
            case 12: {
                return this.envelopePeriod >> 8 & 0xFF;
            }
            case 13: {
                return this.envelopeMode & 0xF | (this.enfAlter ? 2 : 0) | (this.enfAttack ? 4 : 0) | (this.enfHold ? 1 : 0) | (this.enfCont ? 8 : 0);
            }
            case 14: {
                return this.ioPortA;
            }
            case 15: {
                return this.ioPortB;
            }
        }
        return -1;
    }

    public void writeData(int value) {
        this.writeData(this.addressLatch, value);
    }

    public void writeData(int address, int value) {
        value &= REG_DATA_MASK[address & 0xF];
        switch (address & 0xF) {
            case 0: {
                this.tonePeriodA = this.tonePeriodA & 0xF00 | value;
                break;
            }
            case 1: {
                this.tonePeriodA = this.tonePeriodA & 0xFF | value << 8;
                break;
            }
            case 2: {
                this.tonePeriodB = this.tonePeriodB & 0xF00 | value;
                break;
            }
            case 3: {
                this.tonePeriodB = this.tonePeriodB & 0xFF | value << 8;
                break;
            }
            case 4: {
                this.tonePeriodC = this.tonePeriodC & 0xF00 | value;
                break;
            }
            case 5: {
                this.tonePeriodC = this.tonePeriodC & 0xFF | value << 8;
                break;
            }
            case 6: {
                this.noisePeriod = value;
                break;
            }
            case 7: {
                this.mixerControl = value;
                break;
            }
            case 8: {
                this.amplitudeA = value;
                break;
            }
            case 9: {
                this.amplitudeB = value;
                break;
            }
            case 10: {
                this.amplitudeC = value;
                break;
            }
            case 11: {
                this.envelopePeriod = this.envelopePeriod & 0xFF00 | value;
                break;
            }
            case 12: {
                this.envelopePeriod = this.envelopePeriod & 0xFF | value << 8;
                break;
            }
            case 13: {
                this.envelopeMode = value & 0xF;
                this.enfAlter = (value & 2) != 0;
                this.enfAttack = (value & 4) != 0;
                this.enfHold = (value & 1) != 0;
                this.enfCont = (value & 8) != 0;
                this.envIndexCounter = 0;
                this.envelopeVolume = this.enfAttack ? 0 : 15;
                break;
            }
            case 14: {
                this.ioPortA = value;
                break;
            }
            case 15: {
                this.ioPortB = value;
                break;
            }
        }
    }

    private void doRndNoise() {
        this.rngReg ^= (this.rngReg & 1 ^ this.rngReg >> 3 & 1) << 17;
        this.rngReg >>= 1;
        this.signalNcba = (this.rngReg & 1) == 0 ? this.signalNcba & 0xFFFFFFF7 : this.signalNcba | 8;
    }

    private void processNoiseGen(int audioTicks) {
        this.counterN += audioTicks;
        if (this.counterN >= (this.noisePeriod == 0 ? 1 : this.noisePeriod)) {
            this.counterN = 0;
            this.doRndNoise();
        }
    }

    private void updateEnvelopeVolume(int audioTicks) {
        this.counterE += audioTicks;
        if (this.counterE >= (this.envelopePeriod == 0 ? 2 : this.envelopePeriod << 1)) {
            this.counterE = 0;
            if (this.envIndexCounter >= 0) {
                int envIndex;
                int count = this.envIndexCounter;
                ++count;
                if ((count &= 0x1F) < 16) {
                    envIndex = this.enfAttack ? count : 15 - count;
                } else if (count == 16 && (!this.enfCont || this.enfHold)) {
                    envIndex = this.enfCont && this.enfAttack ^ this.enfAlter ? 15 : 0;
                    count = -1;
                } else if (count == 16 && !this.enfAlter) {
                    count = 0;
                    envIndex = this.enfAttack ? 0 : 15;
                } else {
                    envIndex = this.enfAttack ? 15 - count : count;
                }
                this.envIndexCounter = count;
                this.envelopeVolume = envIndex & 0xF;
            }
        }
    }

    private void processPeriods(int audioTicks) {
        this.processNoiseGen(audioTicks);
        this.counterA += audioTicks;
        if (this.counterA >= (this.tonePeriodA == 0 ? 1 : this.tonePeriodA)) {
            this.counterA = 0;
            this.signalNcba ^= 1;
        }
        this.counterB += audioTicks;
        if (this.counterB >= (this.tonePeriodB == 0 ? 1 : this.tonePeriodB)) {
            this.counterB = 0;
            this.signalNcba ^= 2;
        }
        this.counterC += audioTicks;
        if (this.counterC >= (this.tonePeriodC == 0 ? 1 : this.tonePeriodC)) {
            this.counterC = 0;
            this.signalNcba ^= 4;
        }
    }

    private void mixOutputSignals() {
        int vb;
        int va;
        int mixer = this.mixerControl;
        int ncba = this.signalNcba;
        int n = ncba >> 3;
        int nmask = mixer >> 3;
        int mixedCba = ncba | mixer;
        int a = mixedCba & (n | nmask) & 1;
        int b = mixedCba >> 1 & (n | nmask >> 1) & 1;
        int c = mixedCba >> 2 & (n | nmask >> 2) & 1;
        int n2 = a == 0 ? 0 : (va = (this.amplitudeA & 0x10) == 0 ? this.amplitudeA : this.envelopeVolume);
        int n3 = b == 0 ? 0 : (vb = (this.amplitudeB & 0x10) == 0 ? this.amplitudeB : this.envelopeVolume);
        int vc = c == 0 ? 0 : ((this.amplitudeC & 0x10) == 0 ? this.amplitudeC : this.envelopeVolume);
        this.signalConsumer.onAy8910Levels(this, va, vb, vc);
    }

    public void step(long spentMachineCyclesForStep) {
        this.machineCycleCounter += spentMachineCyclesForStep;
        if (this.machineCycleCounter >= 16L) {
            int audioTicks = (int)(this.machineCycleCounter / 16L);
            this.machineCycleCounter %= 16L;
            this.processPeriods(audioTicks);
            this.updateEnvelopeVolume(audioTicks);
        }
        this.mixOutputSignals();
    }

    public void reset() {
        int ctrOffset;
        this.addressLatch = 0;
        this.rngReg = 1;
        this.counterA = ctrOffset = (int)(System.nanoTime() & 0xFL);
        this.counterB = ctrOffset;
        this.counterC = ctrOffset;
        this.counterE = ctrOffset;
        this.counterN = ctrOffset;
        this.signalNcba = 0;
        this.tonePeriodA = 0;
        this.tonePeriodB = 0;
        this.tonePeriodC = 0;
        this.envelopePeriod = 0;
        this.amplitudeA = 0;
        this.amplitudeB = 0;
        this.amplitudeC = 0;
        this.ioPortA = 0;
        this.ioPortB = 0;
        this.noisePeriod = 0;
        this.envelopeMode = 0;
        this.envIndexCounter = 0;
        this.enfAlter = false;
        this.enfAttack = false;
        this.enfCont = false;
        this.enfHold = false;
        this.envelopeVolume = 0;
        this.mixerControl = 0;
    }

    @FunctionalInterface
    public static interface Ay8910SignalConsumer {
        public void onAy8910Levels(Ay8910Chip var1, int var2, int var3, int var4);
    }
}

