/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.sound;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class SourceSoundPort
implements Comparable<SourceSoundPort> {
    private final UUID uuid = UUID.randomUUID();
    private final String name;
    private final Mixer mixer;
    private final Line line;

    public SourceSoundPort(Mixer mixer, String name, Line line) {
        this.mixer = mixer;
        this.name = name;
        this.line = line;
    }

    public static List<SourceSoundPort> findForFormat(AudioFormat format) {
        Mixer.Info[] mixers;
        ArrayList<SourceSoundPort> result = new ArrayList<SourceSoundPort>();
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            try {
                mixer.open();
            }
            catch (LineUnavailableException ex) {
                if (mixer == null) continue;
                mixer.close();
                continue;
            }
            try {
                Line.Info[] sourceLineInfo;
                for (Line.Info lineInfo : sourceLineInfo = mixer.getSourceLineInfo()) {
                    try {
                        Line line = mixer.getLine(lineInfo);
                        if (!(line instanceof SourceDataLine)) continue;
                        result.add(new SourceSoundPort(mixer, mixerInfo.getName() + ":" + line.getLineInfo().toString(), line));
                    }
                    catch (LineUnavailableException lineUnavailableException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (mixer != null) {
                    mixer.close();
                }
            }
        }
        return result.stream().sorted().filter(x -> x.doesSupport(format)).collect(Collectors.toList());
    }

    public boolean doesSupport(AudioFormat format) {
        Line.Info info = this.line.getLineInfo();
        boolean result = false;
        if (info instanceof DataLine.Info) {
            result = Stream.of(((DataLine.Info)info).getFormats()).anyMatch(format::matches);
        }
        return result;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public Mixer getMixer() {
        return this.mixer;
    }

    public Line getLine() {
        return this.line;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(SourceSoundPort o) {
        return this.name.compareTo(o.name);
    }

    public SourceDataLine asSourceDataLine() {
        return (SourceDataLine)this.line;
    }
}

