/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.sound;

import com.igormaznitsa.zxpoly.components.IoDevice;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.sound.Ay8910Chip;
import com.igormaznitsa.zxpoly.components.sound.AyBasedSoundDevice;
import com.igormaznitsa.zxpoly.components.sound.Beeper;

public final class TurboSoundNedoPc
implements IoDevice,
AyBasedSoundDevice {
    private final Motherboard motherboard;
    private final Beeper beeper;
    private final Ay8910Chip chipAy0;
    private final Ay8910Chip chipAy1;
    private final int[] audioLevels;
    private Ay8910Chip selectedChip;

    public TurboSoundNedoPc(Motherboard motherboard) {
        this.audioLevels = motherboard.getSoundLevels().getLevels();
        this.motherboard = motherboard;
        this.beeper = this.motherboard.getBeeper();
        this.chipAy0 = new Ay8910Chip(this::onLevels0);
        this.chipAy1 = new Ay8910Chip(this::onLevels1);
        this.doReset();
    }

    @Override
    public int getAyAddress() {
        return this.selectedChip.readAddress();
    }

    @Override
    public void setAyAddress(int address) {
        this.selectedChip.writeAddress(address);
    }

    @Override
    public int getAyRegister(int address) {
        return this.selectedChip.readData(address);
    }

    @Override
    public void setAyRegister(int address, int value) {
        this.chipAy0.writeData(address, value);
    }

    private void onLevels0(Ay8910Chip ay, int levelA, int levelB, int levelC) {
        this.beeper.setChannelValue(2, this.audioLevels[levelA]);
        this.beeper.setChannelValue(3, this.audioLevels[levelB]);
        this.beeper.setChannelValue(4, this.audioLevels[levelC]);
    }

    private void onLevels1(Ay8910Chip ay, int levelA, int levelB, int levelC) {
        this.beeper.setChannelValue(5, this.audioLevels[levelA]);
        this.beeper.setChannelValue(6, this.audioLevels[levelB]);
        this.beeper.setChannelValue(7, this.audioLevels[levelC]);
    }

    @Override
    public Motherboard getMotherboard() {
        return this.motherboard;
    }

    @Override
    public int readIo(ZxPolyModule module, int port) {
        if (!module.isTrdosActive() && (port & 2) == 0 && (port & 0x8000) == 32768) {
            return this.selectedChip.readData();
        }
        return -1;
    }

    @Override
    public void writeIo(ZxPolyModule module, int port, int value) {
        if (!module.isTrdosActive() && (port & 2) == 0) {
            if ((port & 0xC000) == 49152) {
                if (value == 255) {
                    this.selectedChip = this.chipAy0;
                } else if (value == 254) {
                    this.selectedChip = this.chipAy1;
                }
                this.selectedChip.writeAddress(value);
            } else if ((port & 0xC000) == 32768) {
                this.selectedChip.writeData(value);
            }
        }
    }

    @Override
    public void preStep(int frameTiStates, boolean signalReset, boolean tstatesIntReached, boolean wallclockInt) {
        if (signalReset) {
            this.doReset();
        }
    }

    @Override
    public void postStep(int spentTstates) {
        this.chipAy0.step(spentTstates);
        this.chipAy1.step(spentTstates);
    }

    @Override
    public String getName() {
        return "TurboSound-NedoPc";
    }

    @Override
    public void doReset() {
        this.selectedChip = this.chipAy0;
        this.chipAy0.reset();
        this.chipAy1.reset();
    }

    @Override
    public int getNotificationFlags() {
        return 3;
    }
}

