/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.sound;

import com.igormaznitsa.zxpoly.components.IoDevice;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.sound.Ay8910Chip;
import com.igormaznitsa.zxpoly.components.sound.AyBasedSoundDevice;
import com.igormaznitsa.zxpoly.components.sound.Beeper;

public final class Zx128Ay8910
implements IoDevice,
AyBasedSoundDevice {
    private final Motherboard motherboard;
    private final Ay8910Chip ay8910;
    private final Beeper beeper;
    private final int[] audioLevels;

    public Zx128Ay8910(Motherboard motherboard) {
        this.audioLevels = motherboard.getSoundLevels().getLevels();
        this.motherboard = motherboard;
        this.ay8910 = new Ay8910Chip(this::onAyLevels);
        this.beeper = this.motherboard.getBeeper();
    }

    @Override
    public void setAyAddress(int address) {
        this.ay8910.writeAddress(address);
    }

    @Override
    public int getAyAddress() {
        return this.ay8910.readAddress();
    }

    @Override
    public int getAyRegister(int address) {
        return this.ay8910.readData(address);
    }

    @Override
    public void setAyRegister(int address, int value) {
        this.ay8910.writeData(address, value);
    }

    private void onAyLevels(Ay8910Chip ay, int levelA, int levelB, int levelC) {
        this.beeper.setChannelValue(2, this.audioLevels[levelA]);
        this.beeper.setChannelValue(3, this.audioLevels[levelB]);
        this.beeper.setChannelValue(4, this.audioLevels[levelC]);
    }

    @Override
    public Motherboard getMotherboard() {
        return this.motherboard;
    }

    @Override
    public int readIo(ZxPolyModule module, int port) {
        if (!module.isTrdosActive() && (port & 2) == 0 && (port & 0x8000) == 32768) {
            return this.ay8910.readData();
        }
        return -1;
    }

    @Override
    public void writeIo(ZxPolyModule module, int port, int value) {
        if (!module.isTrdosActive() && (port & 2) == 0) {
            if ((port & 0xC000) == 49152) {
                this.ay8910.writeAddress(value);
            } else if ((port & 0xC000) == 32768) {
                this.ay8910.writeData(value);
            }
        }
    }

    @Override
    public void preStep(int frameTiStates, boolean signalReset, boolean tstatesIntReached, boolean wallClockInt) {
        if (signalReset) {
            this.doReset();
        }
    }

    @Override
    public void postStep(int spentTstates) {
        this.ay8910.step(spentTstates);
    }

    @Override
    public String getName() {
        return "Zx128AY-8910";
    }

    @Override
    public void doReset() {
        this.ay8910.reset();
    }

    @Override
    public int getNotificationFlags() {
        return 3;
    }
}

