/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.zxpoly.components.tapereader.TapFormatParser;
import com.igormaznitsa.zxpoly.components.tapereader.TapeContext;
import com.igormaznitsa.zxpoly.components.tapereader.TapeSource;
import com.igormaznitsa.zxpoly.utils.SpectrumUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;

final class ReaderTap
implements ListModel<TapBlock>,
TapeSource<TapBlock> {
    private static final Logger LOGGER = Logger.getLogger(ReaderTap.class.getName());
    private static final long PULSELEN_PILOT = 2168L;
    private static final long PULSELEN_SYNC1 = 667L;
    private static final long PULSELEN_SYNC2 = 735L;
    private static final long PULSELEN_ZERO = 855L;
    private static final long PULSELEN_SYNC3 = 954L;
    private static final long PULSELEN_ONE = 1710L;
    private static final long IMPULSNUMBER_PILOT_HEADER = 8063L;
    private static final long IMPULSNUMBER_PILOT_DATA = 3223L;
    private static final long PAUSE_BETWEEN = 7000000L;
    private final List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();
    private final String name;
    private final List<TapBlock> tapBlockList = new ArrayList<TapBlock>();
    private final TapeContext tapeContext;
    private final AtomicBoolean signalInState = new AtomicBoolean();
    private final Lock locker = new ReentrantLock();
    private TapBlock current;
    private long counterMain;
    private long counterEx;
    private int mask;
    private int buffered;
    private int controlChecksum;
    private State state = State.STOPPED;

    public ReaderTap(TapeContext tapeContext, String name, InputStream tap) throws IOException {
        this.tapeContext = tapeContext;
        this.name = name;
        TapFormatParser tapParser = new TapFormatParser().read(new JBBPBitInputStream(tap));
        if (tapParser.getTapBlocks().length == 0) {
            this.current = null;
            LOGGER.warning("Can't find blocks in TAP file");
        } else {
            this.current = new TapBlock(tapParser.getTapBlocks()[0]);
            this.current.index = 0;
            this.tapBlockList.add(this.current);
            this.current.prev = null;
            TapBlock item = this.current;
            int i = 1;
            while (i < tapParser.getTapBlocks().length) {
                TapBlock newItem = new TapBlock(tapParser.getTapBlocks()[i]);
                newItem.index = i++;
                newItem.prev = item;
                item.next = newItem;
                item = newItem;
                this.tapBlockList.add(item);
            }
            item.next = null;
            LOGGER.log(Level.INFO, "Pointer to " + this.makeDescription(this.current));
        }
    }

    @Override
    public boolean isNavigable() {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    public void fireAction(int id, String command) {
        ActionEvent event = new ActionEvent(this, id, command);
        Runnable run = () -> this.listeners.forEach(l -> l.actionPerformed(event));
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TapBlock getCurrent() {
        this.locker.lock();
        try {
            TapBlock tapBlock = this.current;
            return tapBlock;
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void setCurrent(int index) {
        this.locker.lock();
        try {
            this.rewindToStart();
            while (index > 0) {
                this.rewindToNextBlock();
                --index;
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public boolean canGenerateWav() {
        return true;
    }

    @Override
    public boolean isPlaying() {
        this.locker.lock();
        try {
            boolean bl = this.state != State.STOPPED;
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public boolean startPlay() {
        this.locker.lock();
        try {
            if (this.state != State.STOPPED && this.current == null) {
                this.state = State.STOPPED;
                this.fireStop();
                boolean bl = false;
                return bl;
            }
            this.state = State.INBETWEEN;
            this.counterMain = -1L;
            this.firePlay();
            boolean bl = true;
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public void stopPlay() {
        this.locker.lock();
        try {
            this.counterMain = -1L;
            this.state = State.STOPPED;
            this.fireStop();
        }
        finally {
            this.locker.unlock();
        }
    }

    private void fireStop() {
        this.fireAction(0, "stop");
    }

    private void firePlay() {
        this.fireAction(1, "play");
    }

    @Override
    public void rewindToStart() {
        this.locker.lock();
        try {
            this.stopPlay();
            if (this.current != null) {
                while (this.current.prev != null) {
                    this.current = this.current.prev;
                }
                LOGGER.log(Level.INFO, "Pointer to " + this.makeDescription(this.current));
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    private boolean toNextBlock() {
        if (this.current == null) {
            return false;
        }
        if (this.current.isLast()) {
            return false;
        }
        this.current = this.current.next;
        LOGGER.log(Level.INFO, "Pointer to " + this.makeDescription(this.current));
        return true;
    }

    @Override
    public boolean rewindToNextBlock() {
        this.locker.lock();
        try {
            this.stopPlay();
            boolean bl = this.toNextBlock();
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public boolean rewindToPrevBlock() {
        this.locker.lock();
        try {
            this.stopPlay();
            if (this.current == null) {
                boolean bl = false;
                return bl;
            }
            if (!this.current.isFirst()) {
                this.current = this.current.prev;
                LOGGER.log(Level.INFO, "Pointer to " + this.makeDescription(this.current));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public boolean isHi() {
        return this.signalInState.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getAsWAV() throws IOException {
        this.locker.lock();
        try {
            int FREQ = 22050;
            int CYCLESPERSAMPLE = 158;
            ByteArrayOutputStream data = new ByteArrayOutputStream(0x100000);
            this.rewindToStart();
            this.signalInState.set(false);
            this.counterMain = -1L;
            this.state = State.INBETWEEN;
            while (this.state != State.STOPPED) {
                data.write(this.signalInState.get() ? 255 : 0);
                this.updateForSpentMachineCycles(158L);
            }
            JBBPOut out = JBBPOut.BeginBin(JBBPByteOrder.LITTLE_ENDIAN);
            byte[] byArray = out.Byte("RIFF").Int(data.size() + 40).Byte("WAVE").Byte("fmt ").Int(16).Short(1).Short(1).Int(22050).Int(22050).Short(1).Short(8).Byte("data").Int(data.size()).Byte(data.toByteArray()).End().toByteArray();
            return byArray;
        }
        finally {
            this.locker.unlock();
        }
    }

    private String makeDescription(TapBlock block) {
        if (block == null) {
            return "No block";
        }
        if (block.isHeader() && block.data.length == 17) {
            StringBuilder buffer = new StringBuilder();
            switch (block.data[0] & 0xFF) {
                case 0: {
                    buffer.append("BASIC");
                    break;
                }
                case 1: {
                    buffer.append("NUM.ARRAY");
                    break;
                }
                case 2: {
                    buffer.append("CHR.ARRAY");
                    break;
                }
                case 3: {
                    buffer.append("CODE");
                    break;
                }
                default: {
                    buffer.append("UNKNOWN");
                }
            }
            buffer.append(" \"");
            for (int i = 1; i < 11; ++i) {
                buffer.append((char)(block.data[i] & 0xFF));
            }
            buffer.append("\"");
            return buffer.toString();
        }
        return "CODE_BLOCK len=#" + Integer.toHexString(block.data.length).toUpperCase(Locale.ENGLISH);
    }

    private void loadDataByteToRead(int data) {
        this.controlChecksum ^= data;
        this.mask = 128;
        this.buffered = data;
        this.counterEx = (data & this.mask) == 0 ? 855L : 1710L;
        this.signalInState.set(!this.signalInState.get());
    }

    private boolean processDataByte(long machineCycles) {
        boolean result = false;
        long counter = this.counterEx & Long.MIN_VALUE;
        this.counterEx = (this.counterEx & Long.MAX_VALUE) - machineCycles;
        if (this.counterEx <= 0L) {
            if (counter != 0L) {
                this.mask >>>= 1;
                if (this.mask == 0) {
                    result = true;
                } else {
                    this.counterEx = (this.buffered & this.mask) == 0 ? 855L : 1710L;
                    this.signalInState.set(!this.signalInState.get());
                    counter = 0L;
                }
            } else {
                this.counterEx = (this.buffered & this.mask) == 0 ? 855L : 1710L;
                counter = Long.MIN_VALUE;
                this.signalInState.set(!this.signalInState.get());
            }
        }
        this.counterEx |= counter;
        return result;
    }

    @Override
    public int getCurrentBlockIndex() {
        return this.current == null ? -1 : this.current.index;
    }

    @Override
    public ListModel<TapBlock> getBlockListModel() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateForSpentMachineCycles(long machineCycles) {
        this.locker.lock();
        try {
            if (this.state == State.STOPPED) return;
            TapBlock block = this.current;
            switch (this.state.ordinal()) {
                case 1: {
                    if (this.counterMain < 0L) {
                        LOGGER.info("PAUSE");
                        this.signalInState.set(false);
                        this.counterMain = 7000000L;
                        return;
                    } else {
                        this.counterMain -= machineCycles;
                        if (this.counterMain > 0L) return;
                        this.state = State.PILOT;
                        this.counterMain = -1L;
                        return;
                    }
                }
                case 2: {
                    if (this.counterMain < 0L) {
                        LOGGER.log(Level.INFO, "PILOT (" + (block.isHeader() ? "header" : "data") + ")");
                        this.counterMain = block.isHeader() ? 8063L : 3223L;
                        this.signalInState.set(!this.signalInState.get());
                        this.counterEx = 2168L;
                        return;
                    } else {
                        this.counterEx -= machineCycles;
                        if (this.counterEx > 0L) return;
                        --this.counterMain;
                        if (this.counterMain <= 0L) {
                            this.state = State.SYNC1;
                            this.counterMain = -1L;
                            return;
                        } else {
                            this.signalInState.set(!this.signalInState.get());
                            this.counterEx = 2168L;
                            return;
                        }
                    }
                }
                case 3: {
                    if (this.counterMain < 0L) {
                        LOGGER.info("SYNC1");
                        this.counterEx = 667L;
                        this.signalInState.set(!this.signalInState.get());
                        this.counterMain = 0L;
                        return;
                    } else {
                        this.counterEx -= machineCycles;
                        if (this.counterEx > 0L) return;
                        this.counterMain = -1L;
                        this.state = State.SYNC2;
                        return;
                    }
                }
                case 4: {
                    if (this.counterMain < 0L) {
                        LOGGER.info("SYNC2");
                        this.counterEx = 735L;
                        this.signalInState.set(!this.signalInState.get());
                        this.counterMain = 0L;
                        return;
                    } else {
                        this.counterEx -= machineCycles;
                        if (this.counterEx > 0L) return;
                        this.counterMain = -1L;
                        this.state = State.FLAG;
                        return;
                    }
                }
                case 6: {
                    if (this.counterMain < 0L) {
                        LOGGER.log(Level.INFO, "FLAG (#" + Integer.toHexString(block.flag & 0xFF).toUpperCase(Locale.ENGLISH) + ")");
                        this.controlChecksum = 0;
                        this.counterMain = 0L;
                        this.loadDataByteToRead(block.flag & 0xFF);
                        return;
                    } else {
                        if (!this.processDataByte(machineCycles)) return;
                        this.counterMain = -1L;
                        this.state = State.DATA;
                        return;
                    }
                }
                case 7: {
                    if (this.counterMain < 0L) {
                        LOGGER.log(Level.INFO, "DATA (len=#" + Integer.toHexString(block.data.length & 0xFFFF).toUpperCase(Locale.ENGLISH) + ")");
                        this.counterMain = 0L;
                        this.loadDataByteToRead(block.data[(int)this.counterMain++]);
                        return;
                    } else {
                        if (!this.processDataByte(machineCycles)) return;
                        if (this.counterMain < (long)block.data.length) {
                            this.loadDataByteToRead(block.data[(int)this.counterMain++]);
                            return;
                        } else {
                            this.counterMain = -1L;
                            this.state = State.CHECKSUM;
                            return;
                        }
                    }
                }
                case 8: {
                    if (this.counterMain < 0L) {
                        LOGGER.log(Level.INFO, "CHK (xor=#" + Integer.toHexString(block.checksum & 0xFF).toUpperCase(Locale.ENGLISH) + ")");
                        if ((block.checksum & 0xFF) != (this.controlChecksum & 0xFF)) {
                            LOGGER.log(Level.WARNING, "Different XOR sum : at file #" + Integer.toHexString(block.checksum & 0xFF).toUpperCase(Locale.ENGLISH) + ", calculated #" + Integer.toHexString(this.controlChecksum & 0xFF).toUpperCase(Locale.ENGLISH));
                        }
                        this.counterMain = 0L;
                        this.loadDataByteToRead(block.checksum & 0xFF);
                        return;
                    } else {
                        if (!this.processDataByte(machineCycles)) return;
                        this.counterMain = -1L;
                        this.state = State.SYNC3;
                        return;
                    }
                }
                case 5: {
                    if (this.counterMain < 0L) {
                        LOGGER.info("SYNC3");
                        this.counterEx = 954L;
                        this.signalInState.set(!this.signalInState.get());
                        this.counterMain = 0L;
                        return;
                    } else {
                        this.counterEx -= machineCycles;
                        if (this.counterEx > 0L) return;
                        this.counterMain = -1L;
                        if (!this.toNextBlock()) {
                            this.stopPlay();
                            return;
                        } else {
                            this.state = State.INBETWEEN;
                            return;
                        }
                    }
                }
                default: {
                    throw new Error("Unexpected state [" + String.valueOf((Object)this.state) + "]");
                }
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    @Override
    public boolean isThresholdAllowed() {
        return false;
    }

    @Override
    public float getThreshold() {
        return 0.0f;
    }

    @Override
    public void setThreshold(float threshold) {
    }

    @Override
    public int size() {
        return this.tapBlockList.stream().mapToInt(TapBlock::size).sum();
    }

    @Override
    public int getSize() {
        return this.tapBlockList.size();
    }

    @Override
    public TapBlock getElementAt(int index) {
        return this.tapBlockList.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }

    private static enum State {
        STOPPED,
        INBETWEEN,
        PILOT,
        SYNC1,
        SYNC2,
        SYNC3,
        FLAG,
        DATA,
        CHECKSUM;

    }

    public static final class TapBlock {
        byte flag;
        byte[] data;
        byte checksum;
        transient TapBlock prev;
        transient TapBlock next;
        transient int index;
        transient String name;

        public TapBlock(TapFormatParser.TapBlock block) {
            this.flag = block.getFlag();
            this.checksum = block.getChecksum();
            this.data = (byte[])block.getData().clone();
        }

        public boolean isFirst() {
            return this.prev == null;
        }

        public boolean isLast() {
            return this.next == null;
        }

        public boolean isHeader() {
            return (this.flag & 0xFF) < 128;
        }

        public String getName() {
            if (this.name == null) {
                if (this.isHeader()) {
                    this.name = this.data.length < 11 ? "<NONSTANDARD HEADER LENGTH>" : SpectrumUtils.fromZxString(new String(this.data, 1, 10, StandardCharsets.ISO_8859_1));
                    this.name = String.format("%s: %s (flag=%d)", switch (this.data[0]) {
                        case 0 -> "BAS";
                        case 1 -> "###";
                        case 2 -> "TXT";
                        case 3 -> "COD";
                        default -> "???";
                    }, this.name, this.flag & 0xFF);
                } else {
                    this.name = String.format("===: .......... (flag=%d)", this.flag & 0xFF);
                }
            }
            return this.name;
        }

        public int size() {
            return this.data.length;
        }

        public TapBlock findFirst() {
            TapBlock result = this;
            while (!result.isFirst()) {
                result = result.prev;
            }
            return result;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.getName() + " (" + this.data.length + " bytes)";
        }
    }
}

