/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxDeprecatedBlock;
import java.io.IOException;

public class TzxBlockC64Rom
extends AbstractTzxSoundDataBlock
implements TzxDeprecatedBlock {
    private final long blockLength;
    private final int pilotTonePulseEndAddress;
    private final int numberOfWavesInPilotTone;
    private final int syncFirstWavePulseEndAddress;
    private final int syncSecondWavePulseEndAddress;
    private final int zeroBitFirstWavePulseEndAddress;
    private final int zeroBitSecondWavePulseEndAddress;
    private final int oneBitFirstWavePulseEndAddress;
    private final int oneBitSecondWavePulseEndAddress;
    private final int xorChecksumForDataByte;
    private final int finishByteFirstWavePulseEnndAddress;
    private final int finishByteSecondWavePulseEnndAddress;
    private final int finishDataFirstWavePulseEnndAddress;
    private final int finishDataSecondWavePulseEnndAddress;
    private final int trailingTonePulseEndAddress;
    private final int usedBitsInLastByte;
    private final int generalPurpose;
    private final int pauseAfterBlockInMs;
    private final byte[] data;

    public TzxBlockC64Rom(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.C64ROM.getId());
        this.blockLength = TzxBlockC64Rom.readDWord(inputStream);
        this.pilotTonePulseEndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.numberOfWavesInPilotTone = TzxBlockC64Rom.readWord(inputStream);
        this.syncFirstWavePulseEndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.syncSecondWavePulseEndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.zeroBitFirstWavePulseEndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.zeroBitSecondWavePulseEndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.oneBitFirstWavePulseEndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.oneBitSecondWavePulseEndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.xorChecksumForDataByte = inputStream.readByte();
        this.finishByteFirstWavePulseEnndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.finishByteSecondWavePulseEnndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.finishDataFirstWavePulseEnndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.finishDataSecondWavePulseEnndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.trailingTonePulseEndAddress = TzxBlockC64Rom.readWord(inputStream);
        this.usedBitsInLastByte = inputStream.readByte();
        this.generalPurpose = inputStream.readByte();
        this.pauseAfterBlockInMs = TzxBlockC64Rom.readWord(inputStream);
        int length = TzxBlockC64Rom.readThreeByteValue(inputStream);
        this.data = inputStream.readByteArray(length);
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public int getPilotTonePulseEndAddress() {
        return this.pilotTonePulseEndAddress;
    }

    public int getNumberOfWavesInPilotTone() {
        return this.numberOfWavesInPilotTone;
    }

    public int getSyncFirstWavePulseEndAddress() {
        return this.syncFirstWavePulseEndAddress;
    }

    public int getSyncSecondWavePulseEndAddress() {
        return this.syncSecondWavePulseEndAddress;
    }

    public int getZeroBitFirstWavePulseEndAddress() {
        return this.zeroBitFirstWavePulseEndAddress;
    }

    public int getZeroBitSecondWavePulseEndAddress() {
        return this.zeroBitSecondWavePulseEndAddress;
    }

    public int getOneBitFirstWavePulseEndAddress() {
        return this.oneBitFirstWavePulseEndAddress;
    }

    public int getOneBitSecondWavePulseEndAddress() {
        return this.oneBitSecondWavePulseEndAddress;
    }

    public int getXorChecksumForDataByte() {
        return this.xorChecksumForDataByte;
    }

    public int getFinishByteFirstWavePulseEnndAddress() {
        return this.finishByteFirstWavePulseEnndAddress;
    }

    public int getFinishByteSecondWavePulseEnndAddress() {
        return this.finishByteSecondWavePulseEnndAddress;
    }

    public int getFinishDataFirstWavePulseEnndAddress() {
        return this.finishDataFirstWavePulseEnndAddress;
    }

    public int getFinishDataSecondWavePulseEnndAddress() {
        return this.finishDataSecondWavePulseEnndAddress;
    }

    public int getTrailingTonePulseEndAddress() {
        return this.trailingTonePulseEndAddress;
    }

    public int getUsedBitsInLastByte() {
        return this.usedBitsInLastByte;
    }

    public int getGeneralPurpose() {
        return this.generalPurpose;
    }

    public int getPauseAfterBlockInMs() {
        return this.pauseAfterBlockInMs;
    }

    @Override
    public int getDataLength() {
        return this.data.length;
    }

    @Override
    public byte[] extractData() throws IOException {
        return this.data;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockC64Rom.writeDWord(outputStream, this.blockLength);
        TzxBlockC64Rom.writeWord(outputStream, this.pilotTonePulseEndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.numberOfWavesInPilotTone);
        TzxBlockC64Rom.writeWord(outputStream, this.syncFirstWavePulseEndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.syncSecondWavePulseEndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.zeroBitFirstWavePulseEndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.zeroBitSecondWavePulseEndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.oneBitFirstWavePulseEndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.oneBitSecondWavePulseEndAddress);
        outputStream.write(this.xorChecksumForDataByte);
        TzxBlockC64Rom.writeWord(outputStream, this.finishByteFirstWavePulseEnndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.finishByteSecondWavePulseEnndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.finishDataFirstWavePulseEnndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.finishDataSecondWavePulseEnndAddress);
        TzxBlockC64Rom.writeWord(outputStream, this.trailingTonePulseEndAddress);
        outputStream.write(this.usedBitsInLastByte);
        outputStream.write(this.generalPurpose);
        TzxBlockC64Rom.writeWord(outputStream, this.pauseAfterBlockInMs);
        TzxBlockC64Rom.writeThreeByteValue(outputStream, this.data.length);
        outputStream.write(this.data);
    }
}

