/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxDeprecatedBlock;
import java.io.IOException;

public class TzxBlockC64Turbo
extends AbstractTzxSoundDataBlock
implements TzxDeprecatedBlock {
    private final long blockLength;
    private final int zeroBitPulse;
    private final int oneBitPulse;
    private final int additionalBitsInBytes;
    private final int numberOfLeadInBytes;
    private final int leadInByte;
    private final int usedBitsInLastByte;
    private final int generalPurpose;
    private final int numberOfTrailingBytes;
    private final int trailingByte;
    private final int pauseAfterBlockInMs;
    private final byte[] data;

    public TzxBlockC64Turbo(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.C64TURBO.getId());
        this.blockLength = TzxBlockC64Turbo.readDWord(inputStream);
        this.zeroBitPulse = TzxBlockC64Turbo.readWord(inputStream);
        this.oneBitPulse = TzxBlockC64Turbo.readWord(inputStream);
        this.additionalBitsInBytes = inputStream.readByte();
        this.numberOfLeadInBytes = TzxBlockC64Turbo.readWord(inputStream);
        this.leadInByte = inputStream.readByte();
        this.usedBitsInLastByte = inputStream.readByte();
        this.generalPurpose = inputStream.readByte();
        this.numberOfTrailingBytes = TzxBlockC64Turbo.readWord(inputStream);
        this.trailingByte = inputStream.readByte();
        this.pauseAfterBlockInMs = TzxBlockC64Turbo.readWord(inputStream);
        int length = TzxBlockC64Turbo.readThreeByteValue(inputStream);
        this.data = inputStream.readByteArray(length);
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockC64Turbo.writeDWord(outputStream, this.blockLength);
        TzxBlockC64Turbo.writeWord(outputStream, this.zeroBitPulse);
        TzxBlockC64Turbo.writeWord(outputStream, this.oneBitPulse);
        outputStream.write(this.additionalBitsInBytes);
        TzxBlockC64Turbo.writeWord(outputStream, this.numberOfLeadInBytes);
        outputStream.write(this.leadInByte);
        outputStream.write(this.usedBitsInLastByte);
        outputStream.write(this.generalPurpose);
        TzxBlockC64Turbo.writeWord(outputStream, this.numberOfTrailingBytes);
        outputStream.write(this.trailingByte);
        TzxBlockC64Turbo.writeWord(outputStream, this.pauseAfterBlockInMs);
        TzxBlockC64Turbo.writeThreeByteValue(outputStream, this.data.length);
        outputStream.write(this.data);
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public int getZeroBitPulse() {
        return this.zeroBitPulse;
    }

    public int getOneBitPulse() {
        return this.oneBitPulse;
    }

    public int getAdditionalBitsInBytes() {
        return this.additionalBitsInBytes;
    }

    public int getNumberOfLeadInBytes() {
        return this.numberOfLeadInBytes;
    }

    public int getLeadInByte() {
        return this.leadInByte;
    }

    public int getUsedBitsInLastByte() {
        return this.usedBitsInLastByte;
    }

    public int getGeneralPurpose() {
        return this.generalPurpose;
    }

    public int getNumberOfTrailingBytes() {
        return this.numberOfTrailingBytes;
    }

    public int getTrailingByte() {
        return this.trailingByte;
    }

    public int getPauseAfterBlockInMs() {
        return this.pauseAfterBlockInMs;
    }

    @Override
    public int getDataLength() {
        return this.data.length;
    }

    @Override
    public byte[] extractData() throws IOException {
        return this.data;
    }
}

