/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class TzxBlockCSWRecording
extends AbstractTzxSoundDataBlock {
    public static final int COMPRESSION_RLE = 1;
    public static final int COMPRESSION_ZRLE = 2;
    private final long blockLength;
    private final int pauseAfterBlockMs;
    private final int samplingRate;
    private final int compressionType;
    private final long numberStoredPulses;
    private final byte[] data;

    public TzxBlockCSWRecording(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.CSW_RECORDING_BLOCK.getId());
        this.blockLength = TzxBlockCSWRecording.readDWord(inputStream);
        this.pauseAfterBlockMs = TzxBlockCSWRecording.readWord(inputStream);
        this.samplingRate = TzxBlockCSWRecording.readThreeByteValue(inputStream);
        this.compressionType = inputStream.readByte();
        this.numberStoredPulses = TzxBlockCSWRecording.readDWord(inputStream);
        this.data = inputStream.readByteArray((int)(this.blockLength - 10L));
    }

    @Override
    public byte[] extractData() throws IOException {
        switch (this.compressionType) {
            case 1: {
                return this.decompressRle();
            }
            case 2: {
                return this.decompressZRle();
            }
        }
        throw new IllegalStateException("Unsupported compression: " + this.compressionType);
    }

    private byte[] decompressRle() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int pos = 0;
        while (pos < this.data.length) {
            int count;
            if ((count = this.data[pos++] & 0xFF) == 193) {
                outputStream.write(count);
                continue;
            }
            if (count <= 192) {
                outputStream.write(count);
                continue;
            }
            int next = this.data[pos++] & 0xFF;
            for (int i = 0; i < count - 192; ++i) {
                outputStream.write(next);
            }
        }
        return outputStream.toByteArray();
    }

    private byte[] decompressZRle() throws IOException {
        Inflater decompressor = new Inflater(false);
        decompressor.setInput(this.data);
        byte[] buffer = new byte[(int)this.numberStoredPulses * 2];
        try {
            int length = decompressor.inflate(buffer);
            decompressor.end();
            return Arrays.copyOf(buffer, length);
        }
        catch (DataFormatException ex) {
            throw new IOException("Data format exception", ex);
        }
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockCSWRecording.writeDWord(outputStream, this.blockLength);
        TzxBlockCSWRecording.writeWord(outputStream, this.pauseAfterBlockMs);
        TzxBlockCSWRecording.writeThreeByteValue(outputStream, this.samplingRate);
        outputStream.write(this.compressionType);
        TzxBlockCSWRecording.writeDWord(outputStream, this.numberStoredPulses);
        outputStream.write(this.data);
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public int getPauseAfterBlockMs() {
        return this.pauseAfterBlockMs;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public int getCompressionType() {
        return this.compressionType;
    }

    public long getNumberStoredPulses() {
        return this.numberStoredPulses;
    }

    @Override
    public int getDataLength() {
        return this.data.length;
    }
}

