/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxFlowManagementBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;

public class TzxBlockCallSequence
extends AbstractTzxFlowManagementBlock {
    private final short[] offsets;

    public TzxBlockCallSequence(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.CALL_SEQUENCE.getId());
        int number = TzxBlockCallSequence.readWord(inputStream);
        this.offsets = new short[number];
        for (int i = 0; i < number; ++i) {
            this.offsets[i] = (short)TzxBlockCallSequence.readWord(inputStream);
        }
    }

    @Override
    public short[] getOffsets() {
        return this.offsets;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockCallSequence.writeWord(outputStream, this.offsets.length);
        for (short s : this.offsets) {
            outputStream.writeShort(s, JBBPByteOrder.LITTLE_ENDIAN);
        }
    }
}

