/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxInformationBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class TzxBlockCustomInfo
extends AbstractTzxInformationBlock {
    private final String idString;
    private final byte[] customInfo;

    public TzxBlockCustomInfo(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.CUSTOM_INFO.getId());
        this.idString = new String(inputStream.readByteArray(16), StandardCharsets.ISO_8859_1);
        long length = TzxBlockCustomInfo.readDWord(inputStream);
        this.customInfo = inputStream.readByteArray((int)length);
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        outputStream.write(Arrays.copyOf(this.idString.getBytes(StandardCharsets.ISO_8859_1), 16));
        TzxBlockCustomInfo.writeDWord(outputStream, this.customInfo.length);
        outputStream.write(this.customInfo);
    }

    public String getIdString() {
        return this.idString;
    }

    public byte[] getCustomInfo() {
        return this.customInfo;
    }
}

